/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.util.GuiUtils;

public class ParamField
extends JPanel {
    private JTextField field;
    private JButton popupButton;
    private String delimiter;
    private boolean includeAliases;

    public ParamField() {
        this((String)null, true);
    }

    public ParamField(String delimiter) {
        this(delimiter, true);
    }

    public ParamField(String delimiter, boolean includeAliases) {
        this.includeAliases = includeAliases;
        this.delimiter = delimiter;
        this.field = IdvUIManager.doMakeParamField(delimiter, includeAliases);
        this.setLayout(new BorderLayout());
        this.add("Center", this.field);
        this.popupButton = GuiUtils.makeImageButton("/auxdata/ui/icons/DownDown.gif", this, "showPopup");
        if (includeAliases) {
            this.popupButton.setToolTipText("Click to seelct current parameters and aliases");
        } else {
            this.popupButton.setToolTipText("Click to seelct current parameters");
        }
        this.add("East", this.popupButton);
    }

    public void showPopup() {
        List items = IdvUIManager.getParamsMenuItems(this.field, this.delimiter, this.includeAliases);
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        popup.show(this.popupButton, 0, this.popupButton.getBounds().height);
    }

    public void addActionListener(ActionListener listener) {
        this.field.addActionListener(listener);
    }

    @Override
    public void setToolTipText(String tooltip) {
        this.field.setToolTipText(tooltip);
    }

    public void setText(String value) {
        this.field.setText(value);
    }

    public String getText() {
        return this.field.getText();
    }
}

