/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public class MultiFrame {
    private static JDesktopPane desktopPane;
    private static Window dummyWindow;
    private JFrame frame;
    private JInternalFrame internalFrame;
    private Hashtable listeners = new Hashtable();
    private List<WindowListener> frameListeners = new ArrayList<WindowListener>();

    public static void useDesktopPane(JDesktopPane desktopPane) {
        MultiFrame.desktopPane = desktopPane;
    }

    public MultiFrame() {
        this("");
    }

    public MultiFrame(String title) {
        if (desktopPane != null) {
            this.internalFrame = new JInternalFrame(title, true, true, true, true);
            desktopPane.add(this.internalFrame);
        } else {
            this.frame = new JFrame(title);
        }
    }

    public MultiFrame(JFrame frame) {
        this.frame = frame;
    }

    public MultiFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    public void show() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setVisible(true);
        } else if (this.internalFrame != null) {
            this.internalFrame.show();
        }
    }

    public void dispose() {
        if (this.frame == null && this.internalFrame == null) {
            return;
        }
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            if (this.frameListeners != null) {
                for (WindowListener listener : this.frameListeners) {
                    theFrame.removeWindowListener(listener);
                }
            }
            theFrame.dispose();
        } else if (this.internalFrame != null) {
            this.internalFrame.dispose();
        }
        desktopPane = null;
        this.frame = null;
        this.internalFrame = null;
        this.listeners = null;
        this.frameListeners = null;
    }

    public void setVisible(boolean visible) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setVisible(visible);
        } else if (this.internalFrame != null) {
            this.internalFrame.setVisible(visible);
        }
    }

    public Container getContentPane() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            return theFrame.getContentPane();
        }
        if (this.internalFrame != null) {
            return this.internalFrame.getContentPane();
        }
        return null;
    }

    public Container getContainer() {
        if (this.frame != null) {
            return this.frame;
        }
        return this.internalFrame;
    }

    public void setCursor(Cursor cursor) {
        Window window = this.getWindow();
        if (window != null) {
            window.setCursor(cursor);
        }
    }

    public void setState(int state) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setState(state);
        } else if (this.internalFrame != null) {
            try {
                if (state == 0) {
                    this.internalFrame.setIcon(false);
                } else {
                    this.internalFrame.setIcon(true);
                }
            }
            catch (Exception exc) {
                LogUtil.logException("MultiFrame", exc);
            }
        }
    }

    public void setTitle(String title) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setTitle(title);
        } else if (this.internalFrame != null) {
            this.internalFrame.setTitle(title);
        }
    }

    public String getTitle() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            return theFrame.getTitle();
        }
        if (this.internalFrame != null) {
            return this.internalFrame.getTitle();
        }
        return "";
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public Window getWindow() {
        if (this.frame != null) {
            return this.frame;
        }
        if (this.internalFrame != null) {
            return GuiUtils.getWindow(this.getComponent());
        }
        return null;
    }

    public void pack() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.pack();
        } else if (this.internalFrame != null) {
            this.internalFrame.pack();
        }
    }

    public void setDefaultCloseOperation(int operation) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setDefaultCloseOperation(operation);
        } else if (this.internalFrame != null) {
            this.internalFrame.setDefaultCloseOperation(operation);
        }
    }

    public void addWindowListener(final WindowListener l) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            this.frameListeners.add(l);
            theFrame.addWindowListener(l);
        } else if (this.internalFrame != null) {
            if (dummyWindow == null) {
                dummyWindow = new JFrame();
            }
            InternalFrameListener listener = new InternalFrameListener(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    l.windowActivated(new WindowEvent(dummyWindow, 0));
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    l.windowClosed(new WindowEvent(dummyWindow, 0));
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    l.windowClosing(new WindowEvent(dummyWindow, 0));
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent e) {
                    l.windowDeactivated(new WindowEvent(dummyWindow, 0));
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent e) {
                    l.windowDeiconified(new WindowEvent(dummyWindow, 0));
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent e) {
                    l.windowIconified(new WindowEvent(dummyWindow, 0));
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                    l.windowOpened(new WindowEvent(dummyWindow, 0));
                }
            };
            this.internalFrame.addInternalFrameListener(listener);
            this.listeners.put(l, listener);
        }
    }

    public void removeWindowListener(WindowListener l) {
        InternalFrameListener listener;
        JFrame theFrame = this.frame;
        if (theFrame != null && this.frameListeners != null) {
            theFrame.removeWindowListener(l);
            this.frameListeners.remove(l);
        } else if (this.listeners != null && this.internalFrame != null && (listener = (InternalFrameListener)this.listeners.get(l)) != null) {
            this.listeners.remove(l);
            this.internalFrame.removeInternalFrameListener(listener);
        }
    }

    public void setJMenuBar(JMenuBar menuBar) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setJMenuBar(menuBar);
        } else if (this.internalFrame != null) {
            this.internalFrame.setJMenuBar(menuBar);
        }
    }

    public Rectangle getBounds() {
        return this.getComponent().getBounds();
    }

    public void setBounds(Rectangle bounds) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            if (bounds != null) {
                GuiUtils.positionAndFitToScreen(theFrame, bounds);
            }
        } else if (this.internalFrame != null) {
            this.internalFrame.setBounds(bounds);
        }
    }

    public void setIconImage(Image icon) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setIconImage(icon);
        } else if (this.internalFrame != null) {
            // empty if block
        }
    }

    public void toFront() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            GuiUtils.toFront(theFrame);
        } else if (this.internalFrame != null) {
            GuiUtils.toFront(this.getWindow());
            this.internalFrame.toFront();
        }
    }

    public Component getComponent() {
        if (this.frame != null) {
            return this.frame;
        }
        if (this.internalFrame != null) {
            return this.internalFrame;
        }
        return new JPanel();
    }

    public boolean isVisible() {
        return this.getComponent().isVisible();
    }

    public boolean isShowing() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            return theFrame.isShowing();
        }
        if (this.internalFrame != null) {
            return this.getWindow().isShowing() && !this.internalFrame.isIcon();
        }
        return false;
    }

    public Point getLocation() {
        return this.getComponent().getLocation();
    }

    public void setLocation(int x, int y) {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            theFrame.setLocation(x, y);
        } else if (this.internalFrame != null) {
            // empty if block
        }
    }

    public void setSize(Dimension size) {
        this.getComponent().setSize(size);
    }

    public Dimension getSize() {
        return this.getComponent().getSize();
    }

    public int getState() {
        JFrame theFrame = this.frame;
        if (theFrame != null) {
            return theFrame.getState();
        }
        if (this.internalFrame != null && this.internalFrame.isIcon()) {
            return 1;
        }
        return 0;
    }
}

