/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.gis.maps.MapData;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.StringUtil;

public class MapPanel
extends JPanel {
    private MapData mapData;
    private JCheckBox shownCbx;
    private JComboBox widthBox;
    private JComboBox styleBox;
    private GuiUtils.ColorSwatch colorButton;
    private JCheckBox fastRenderingCbx;
    private boolean ignoreAction = false;
    private boolean updatingUI = false;
    private static final int MAP_LABEL_MAX_LENGTH = 35;

    public MapPanel(MapData data) {
        this.mapData = data;
        this.init();
    }

    public void setVisibility(boolean visiblity) {
        this.ignoreAction = true;
        this.shownCbx.setSelected(visiblity);
        this.ignoreAction = false;
    }

    private void init() {
        String name;
        this.setLayout(new GridLayout(1, 2));
        this.setAlignmentY(0.5f);
        String longName = name = this.mapData.getDescription();
        boolean truncatedName = false;
        if (name.length() > 35) {
            name = name.substring(0, 32);
            name = StringUtil.padRight(name, 35, ".");
            truncatedName = true;
        }
        this.shownCbx = new JCheckBox(name, this.mapData.getVisible());
        Font lblFont = this.shownCbx.getFont();
        Font monoFont = new Font("Monospaced", lblFont.getStyle(), lblFont.getSize());
        this.shownCbx.setFont(monoFont);
        this.shownCbx.setToolTipText("Toggle visibility");
        if (truncatedName) {
            this.shownCbx.setToolTipText(longName);
        }
        this.shownCbx.setHorizontalAlignment(2);
        this.add(this.shownCbx);
        this.shownCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (MapPanel.this.updatingUI) {
                    return;
                }
                if (!MapPanel.this.ignoreAction) {
                    MapPanel.this.mapData.setVisible(MapPanel.this.shownCbx.isSelected());
                }
            }
        });
        JPanel p = new JPanel();
        p.setAlignmentX(1.0f);
        p.setAlignmentY(0.0f);
        this.widthBox = new JComboBox<String>(new String[]{"1.0", "1.5", "2.0", "2.5", "3.0"});
        this.widthBox.setToolTipText("Set the line width");
        this.widthBox.setPreferredSize(new Dimension(60, 16));
        this.widthBox.setEditable(true);
        this.widthBox.setSelectedItem(String.valueOf(this.mapData.getLineWidth()));
        this.widthBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.mapData.setLineWidth(Float.parseFloat((String)MapPanel.this.widthBox.getSelectedItem()));
            }
        });
        p.add(GuiUtils.wrap(this.widthBox));
        this.styleBox = new JComboBox<String>(new String[]{"_____", "_ _ _", ".....", "_._._"});
        this.styleBox.setMaximumSize(new Dimension(30, 16));
        this.styleBox.setToolTipText("Set the line style");
        this.styleBox.setSelectedIndex(this.mapData.getLineStyle());
        Font f = Font.decode("monospaced-BOLD");
        if (f != null) {
            this.styleBox.setFont(f);
        }
        this.styleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.mapData.setLineStyle(MapPanel.this.styleBox.getSelectedIndex());
            }
        });
        p.add(this.styleBox);
        this.colorButton = new GuiUtils.ColorSwatch(this.mapData.getColor(), "Set Map Line Color");
        this.colorButton.setToolTipText("Set the line color");
        this.colorButton.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color c = MapPanel.this.colorButton.getBackground();
                if (c != null) {
                    MapPanel.this.mapData.setColor(c);
                }
            }
        });
        p.add(this.colorButton);
        this.fastRenderingCbx = new JCheckBox("Fast rendering", this.mapData.getFastRendering());
        this.fastRenderingCbx.setToolTipText("Toggle fast rendering");
        this.fastRenderingCbx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                MapPanel.this.mapData.setFastRendering(MapPanel.this.fastRenderingCbx.isSelected());
            }
        });
        p.add(this.fastRenderingCbx);
        this.add(p);
    }

    @Override
    public void updateUI() {
        if (this.updatingUI || this.colorButton == null) {
            return;
        }
        this.updatingUI = true;
        this.colorButton.setBackground(this.mapData.getColor());
        this.fastRenderingCbx.setSelected(this.mapData.getFastRendering());
        this.shownCbx.setSelected(this.mapData.getVisible());
        this.styleBox.setSelectedIndex(this.mapData.getLineStyle());
        this.widthBox.setSelectedItem(String.valueOf(this.mapData.getLineWidth()));
        this.updatingUI = false;
    }

    public List getGuiComponents() {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(this.shownCbx);
        comps.add(this.widthBox);
        comps.add(this.styleBox);
        comps.add(this.colorButton);
        comps.add(this.fastRenderingCbx);
        return comps;
    }

    public MapData getMapData() {
        return this.mapData;
    }
}

