/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class LatLonWidget
extends JPanel {
    private boolean doFormat = true;
    private JTextField latFld = new JTextField(" ", 5);
    private JTextField lonFld = new JTextField(" ", 5);
    private JTextField altFld;

    public LatLonWidget(ActionListener actionListener) {
        this("Latitude: ", "Longitude: ", actionListener);
    }

    public LatLonWidget() {
        this("Latitude: ", "Longitude: ", null);
    }

    public LatLonWidget(String latLabel, String lonLabel, ActionListener actionListener) {
        this(latLabel, lonLabel, null, actionListener);
    }

    public LatLonWidget(String latLabel, String lonLabel, String altLabel, ActionListener actionListener) {
        super(new FlowLayout(0, 0, 0));
        this.latFld.setToolTipText("<html> ddd, ddd:mm:ss, etc.</html>");
        this.lonFld.setToolTipText("<html> ddd, ddd:mm:ss, etc.</html>");
        this.latFld.setHorizontalAlignment(2);
        this.lonFld.setHorizontalAlignment(2);
        if (altLabel != null) {
            this.altFld = new JTextField(" ", 5);
            this.altFld.setHorizontalAlignment(2);
        }
        if (actionListener != null) {
            this.latFld.addActionListener(actionListener);
            this.lonFld.addActionListener(actionListener);
            if (this.altFld != null) {
                this.altFld.addActionListener(actionListener);
            }
        }
        this.add(GuiUtils.rLabel(latLabel));
        this.add(this.latFld);
        this.add(GuiUtils.rLabel("  " + lonLabel));
        this.add(this.lonFld);
        if (altLabel != null) {
            this.add(GuiUtils.rLabel("  " + altLabel));
            this.add(this.altFld);
        }
    }

    public LatLonWidget(double lat, double lon) {
        this();
        this.setLatLon(lat, lon);
    }

    public void setLatLon(double lat, double lon) {
        this.setLat(lat);
        this.setLon(lon);
    }

    public void setLatLon(String lat, String lon) {
        this.setLat(lat);
        this.setLon(lon);
    }

    public void setLat(String latString) {
        latString = this.formatLatLonString(latString);
        this.latFld.setText(latString);
        if (latString != null && latString.length() > 0) {
            this.latFld.setCaretPosition(0);
        }
    }

    public void setLon(String lonString) {
        lonString = this.formatLatLonString(lonString);
        this.lonFld.setText(lonString);
        if (lonString != null && lonString.length() > 0) {
            this.lonFld.setCaretPosition(0);
        }
    }

    public void setAlt(String altString) {
        this.altFld.setText(altString);
        if (altString != null && altString.length() > 0) {
            this.altFld.setCaretPosition(0);
        }
    }

    public void setLat(double lat) {
        this.setLat("" + lat);
    }

    public void setLon(double lon) {
        this.setLon("" + lon);
    }

    public void setAlt(double alt) {
        this.setAlt("" + alt);
    }

    public void clear() {
        this.latFld.setText("");
        this.lonFld.setText("");
        if (this.altFld != null) {
            this.altFld.setText("");
        }
    }

    public boolean isDefined(String s) {
        if ((s = s.trim()).length() == 0) {
            return false;
        }
        return !Double.isNaN(Misc.decodeLatLon(s));
    }

    public boolean isLatDefined() {
        return this.isDefined(this.latFld.getText()) && this.latFld.isEnabled();
    }

    public boolean isLonDefined() {
        return this.isDefined(this.lonFld.getText()) && this.lonFld.isEnabled();
    }

    public boolean isAltDefined() {
        return this.altFld != null && this.isDefined(this.altFld.getText()) && this.altFld.isEnabled();
    }

    public boolean isLatLonDefined() {
        return this.isLatDefined() && this.isLonDefined();
    }

    public String isValidValues() {
        String lat = this.latFld.getText().trim();
        String lon = this.lonFld.getText().trim();
        String msg = "";
        if (lat.length() == 0 && lon.length() == 0) {
            return "";
        }
        if (lat.length() != 0 && lon.length() == 0) {
            return "You must enter a longitude";
        }
        if (lon.length() != 0 && lat.length() == 0) {
            return "You must enter a latitude";
        }
        try {
            double latV = Misc.decodeLatLon(lat);
            if (Double.isNaN(latV)) {
                msg = msg + "Bad latitude value:" + lat + "\n";
            } else if (latV < -90.0 || latV > 90.0) {
                msg = msg + "Latitude not within -90,90\n";
            }
        }
        catch (NumberFormatException nfe) {
            msg = msg + "Bad latitude value:" + lat + "\n";
        }
        try {
            double lonV = Misc.decodeLatLon(lon);
            if (Double.isNaN(lonV)) {
                msg = msg + "Bad longitude value:" + lon + "\n";
            } else if (lonV < -180.0 || lonV > 180.0) {
                msg = msg + "Longitude not within -180,180\n";
            }
        }
        catch (NumberFormatException nfe) {
            msg = msg + "Bad longitude value:" + lon + "\n";
        }
        if (msg.length() > 0) {
            return msg;
        }
        return null;
    }

    public double getLat() throws NumberFormatException {
        return Misc.decodeLatLon(this.latFld.getText().trim());
    }

    public double getLon() throws NumberFormatException {
        return Misc.decodeLatLon(this.lonFld.getText().trim());
    }

    public double getAlt() throws NumberFormatException {
        return Misc.parseNumber(this.altFld.getText().trim());
    }

    public JTextField getLatField() {
        return this.latFld;
    }

    public JTextField getLonField() {
        return this.lonFld;
    }

    public JTextField getAltField() {
        return this.altFld;
    }

    protected String formatLatLonString(String latOrLon) {
        if (!this.doFormat) {
            return latOrLon;
        }
        if (latOrLon == null || latOrLon.length() == 0) {
            return latOrLon;
        }
        String formatted = latOrLon.trim();
        try {
            formatted = Misc.format(Misc.parseDouble(formatted));
        }
        catch (Exception e) {
            return latOrLon;
        }
        return formatted;
    }

    public void setDoFormat(boolean value) {
        this.doFormat = value;
    }

    public boolean getDoFormat() {
        return this.doFormat;
    }
}

