/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.gis.maps.LatLonData;
import ucar.unidata.util.GuiUtils;

public class LatLonPanel
extends JPanel {
    private boolean ignoreEvents = false;
    private LatLonData latLonData;
    JCheckBox onOffCbx;
    JTextField spacingField;
    JTextField baseField;
    GuiUtils.ColorSwatch colorButton;
    JComboBox widthBox;
    JComboBox styleBox;
    JCheckBox fastRenderCbx;

    public LatLonPanel(LatLonData lld) {
        this.latLonData = lld;
        this.ignoreEvents = true;
        this.onOffCbx = new JCheckBox("", this.latLonData.getVisible());
        this.onOffCbx.setToolTipText("Turn on/off lines");
        this.onOffCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LatLonPanel.this.ignoreEvents) {
                    LatLonPanel.this.latLonData.setVisible(LatLonPanel.this.onOffCbx.isSelected());
                }
            }
        });
        this.spacingField = new JTextField(String.valueOf(this.latLonData.getSpacing()), 6);
        this.spacingField.setToolTipText("Set the interval (degrees) between lines");
        this.spacingField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonPanel.this.ignoreEvents) {
                    return;
                }
                LatLonPanel.this.latLonData.setSpacing(new Float(LatLonPanel.this.spacingField.getText()).floatValue());
            }
        });
        this.baseField = new JTextField(String.valueOf(this.latLonData.getBase()), 6);
        this.baseField.setToolTipText("Set the base value for the interval");
        this.baseField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonPanel.this.ignoreEvents) {
                    return;
                }
                LatLonPanel.this.latLonData.setBase(new Float(LatLonPanel.this.baseField.getText()).floatValue());
            }
        });
        this.widthBox = new JComboBox<String>(new String[]{"1.0", "1.5", "2.0", "2.5", "3.0"});
        this.widthBox.setMaximumSize(new Dimension(30, 16));
        this.widthBox.setEditable(true);
        this.widthBox.setSelectedItem(String.valueOf(this.latLonData.getLineWidth()));
        this.widthBox.setToolTipText("Set the width of the lines");
        this.widthBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonPanel.this.ignoreEvents) {
                    return;
                }
                LatLonPanel.this.latLonData.setLineWidth(Float.parseFloat((String)((JComboBox)e.getSource()).getSelectedItem()));
            }
        });
        this.styleBox = new JComboBox<String>(new String[]{"_____", "_ _ _", ".....", "_._._"});
        this.styleBox.setMaximumSize(new Dimension(30, 16));
        this.styleBox.setSelectedIndex(this.latLonData.getLineStyle());
        this.styleBox.setToolTipText("Set the line style");
        Font f = Font.decode("monospaced-BOLD");
        if (f != null) {
            this.styleBox.setFont(f);
        }
        this.styleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonPanel.this.ignoreEvents) {
                    return;
                }
                LatLonPanel.this.latLonData.setLineStyle(((JComboBox)e.getSource()).getSelectedIndex());
            }
        });
        this.colorButton = new GuiUtils.ColorSwatch(this.latLonData.getColor(), "Set " + (this.latLonData.getIsLatitude() ? "Latitude" : "Longitude") + " Color");
        this.colorButton.setToolTipText("Set the line color");
        this.colorButton.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LatLonPanel.this.ignoreEvents) {
                    return;
                }
                Color c = ((JPanel)evt.getSource()).getBackground();
                if (c != null) {
                    LatLonPanel.this.latLonData.setColor(c);
                }
            }
        });
        this.fastRenderCbx = new JCheckBox("", this.latLonData.getFastRendering());
        this.fastRenderCbx.setToolTipText("Set if lines don't render correctly");
        this.fastRenderCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LatLonPanel.this.ignoreEvents) {
                    LatLonPanel.this.latLonData.setFastRendering(LatLonPanel.this.fastRenderCbx.isSelected());
                }
            }
        });
        this.ignoreEvents = false;
    }

    public void setLatLonData(LatLonData lld) {
        this.latLonData = lld;
        if (this.onOffCbx != null) {
            this.ignoreEvents = true;
            this.onOffCbx.setSelected(lld.getVisible());
            this.spacingField.setText("" + lld.getSpacing());
            this.baseField.setText("" + lld.getBase());
            this.widthBox.setSelectedItem("" + lld.getLineWidth());
            this.styleBox.setSelectedIndex(lld.getLineStyle());
            this.colorButton.setBackground(lld.getColor());
            this.fastRenderCbx.setSelected(lld.getFastRendering());
            this.ignoreEvents = false;
        }
    }

    public static JPanel layoutPanels(LatLonPanel latPanel, LatLonPanel lonPanel) {
        Component[] comps = new Component[]{GuiUtils.lLabel("<html><b>Lines</b></html"), GuiUtils.filler(), GuiUtils.cLabel("Interval"), GuiUtils.cLabel("Relative to"), GuiUtils.cLabel("Width"), GuiUtils.cLabel("Style"), GuiUtils.cLabel("Color"), GuiUtils.cLabel("Fast Render"), latPanel.onOffCbx, GuiUtils.rLabel("Latitude:"), latPanel.spacingField, latPanel.baseField, latPanel.widthBox, latPanel.styleBox, latPanel.colorButton, latPanel.fastRenderCbx, lonPanel.onOffCbx, GuiUtils.rLabel("Longitude:"), lonPanel.spacingField, lonPanel.baseField, lonPanel.widthBox, lonPanel.styleBox, lonPanel.colorButton, lonPanel.fastRenderCbx};
        GuiUtils.tmpInsets = new Insets(2, 4, 2, 4);
        return GuiUtils.doLayout(comps, 8, GuiUtils.WT_N, GuiUtils.WT_N);
    }

    public void applyStateToData() {
        this.latLonData.setSpacing(new Float(this.spacingField.getText()).floatValue());
        this.latLonData.setBase(new Float(this.baseField.getText()).floatValue());
    }

    public LatLonData getLatLonData() {
        return this.latLonData;
    }
}

