/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.gis.maps.LatLonLabelData;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.TwoFacedObject;

public class LatLonLabelPanel
extends JPanel {
    private boolean ignoreEvents = false;
    private LatLonLabelData latLonLabelData;
    JCheckBox onOffCbx;
    JTextField spacingField;
    JTextField baseField;
    JTextField labelLinesField;
    GuiUtils.ColorSwatch colorButton;
    JCheckBox fastRenderCbx;
    FontSelector fontSelector;
    JComboBox alignSelector;
    JComboBox formatSelector;
    private List<TwoFacedObject> alignPoints;
    private JCheckBox use360Cbx;
    private static final String[] RECTPOINTNAMES = new String[]{"Top Left", "Top Center", "Top Right", "Left", "Center", "Right", "Bottom Left", "Bottom Center", "Bottom Right"};
    private static final String[] LABEL_FORMATS = new String[]{"DD", "DD.d", "DD:MM", "DD:MM:SS", "DDH", "DD.dH", "DD:MMH", "DD:MM:SSH"};

    public LatLonLabelPanel(LatLonLabelData lld) {
        this.latLonLabelData = lld;
        this.ignoreEvents = true;
        this.onOffCbx = new JCheckBox("", this.latLonLabelData.getVisible());
        this.onOffCbx.setToolTipText("Turn on/off labels");
        this.onOffCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LatLonLabelPanel.this.ignoreEvents) {
                    LatLonLabelPanel.this.latLonLabelData.setVisible(LatLonLabelPanel.this.onOffCbx.isSelected());
                }
            }
        });
        this.spacingField = new JTextField(String.valueOf(this.latLonLabelData.getInterval()), 6);
        this.spacingField.setToolTipText("Set the interval (degrees) between labels");
        this.spacingField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonLabelPanel.this.ignoreEvents) {
                    return;
                }
                LatLonLabelPanel.this.latLonLabelData.setInterval(new Float(LatLonLabelPanel.this.spacingField.getText()).floatValue());
            }
        });
        this.baseField = new JTextField(String.valueOf(this.latLonLabelData.getBaseValue()), 6);
        this.baseField.setToolTipText("Set the base value for the interval");
        this.baseField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonLabelPanel.this.ignoreEvents) {
                    return;
                }
                LatLonLabelPanel.this.latLonLabelData.setBaseValue(new Float(LatLonLabelPanel.this.baseField.getText()).floatValue());
            }
        });
        this.labelLinesField = new JTextField(LatLonLabelData.formatLabelLines(this.latLonLabelData.getLabelLines()), 6);
        this.labelLinesField.setToolTipText("Set the lines to place labels separated by a semicolon (;)");
        this.labelLinesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LatLonLabelPanel.this.ignoreEvents) {
                    return;
                }
                try {
                    LatLonLabelPanel.this.latLonLabelData.setLabelsLineString(LatLonLabelPanel.this.labelLinesField.getText());
                }
                catch (NumberFormatException nfe) {
                    LogUtil.userErrorMessage("Bad format for label lines");
                }
            }
        });
        this.colorButton = new GuiUtils.ColorSwatch(this.latLonLabelData.getColor(), "Set " + (this.latLonLabelData.getIsLatitude() ? "Latitude" : "Longitude") + " Color");
        this.colorButton.setToolTipText("Set the label color");
        this.colorButton.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LatLonLabelPanel.this.ignoreEvents) {
                    return;
                }
                Color c = ((JPanel)evt.getSource()).getBackground();
                if (c != null) {
                    LatLonLabelPanel.this.latLonLabelData.setColor(c);
                }
            }
        });
        this.fastRenderCbx = new JCheckBox("", this.latLonLabelData.getFastRendering());
        this.fastRenderCbx.setToolTipText("Set if labels don't render correctly");
        this.fastRenderCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LatLonLabelPanel.this.ignoreEvents) {
                    LatLonLabelPanel.this.latLonLabelData.setFastRendering(LatLonLabelPanel.this.fastRenderCbx.isSelected());
                }
            }
        });
        this.fontSelector = new FontSelector(0, false, false);
        this.fontSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!LatLonLabelPanel.this.ignoreEvents) {
                    LatLonLabelPanel.this.latLonLabelData.setFont(LatLonLabelPanel.this.fontSelector.getFont());
                }
            }
        });
        this.fontSelector.setFont((Font)this.latLonLabelData.getFont());
        this.alignPoints = TwoFacedObject.createList(Glyph.RECTPOINTS, Glyph.RECTPOINTNAMES);
        this.alignSelector = new JComboBox();
        this.alignSelector.setToolTipText("Set the positioning of the label relative to the location");
        this.alignSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!LatLonLabelPanel.this.ignoreEvents) {
                    LatLonLabelPanel.this.latLonLabelData.setAlignment(TwoFacedObject.getIdString(LatLonLabelPanel.this.alignSelector.getSelectedItem()));
                }
            }
        });
        GuiUtils.setListData(this.alignSelector, this.alignPoints);
        this.alignSelector.setSelectedItem(this.getAlignSelectorItem(this.latLonLabelData.getAlignment()));
        this.formatSelector = new JComboBox<String>(LABEL_FORMATS);
        this.formatSelector.setEditable(true);
        this.formatSelector.setToolTipText("Set the label format");
        this.formatSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!LatLonLabelPanel.this.ignoreEvents) {
                    LatLonLabelPanel.this.latLonLabelData.setLabelFormat(LatLonLabelPanel.this.formatSelector.getSelectedItem().toString());
                }
            }
        });
        this.formatSelector.setSelectedItem(this.latLonLabelData.getLabelFormat());
        this.ignoreEvents = false;
        this.use360Cbx = new JCheckBox("0-360", this.latLonLabelData.getUse360());
        this.use360Cbx.setToolTipText("Use 0 to 360 vs. -180 to 180 convention for longitude labels");
        this.use360Cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LatLonLabelPanel.this.ignoreEvents) {
                    LatLonLabelPanel.this.latLonLabelData.setUse360(LatLonLabelPanel.this.use360Cbx.isSelected());
                }
            }
        });
    }

    public void setLatLonLabelData(LatLonLabelData lld) {
        this.latLonLabelData = lld;
        if (this.onOffCbx != null) {
            this.ignoreEvents = true;
            this.onOffCbx.setSelected(lld.getVisible());
            this.spacingField.setText("" + lld.getInterval());
            this.baseField.setText("" + lld.getBaseValue());
            this.labelLinesField.setText("" + LatLonLabelData.formatLabelLines(lld.getLabelLines()));
            this.colorButton.setBackground(lld.getColor());
            this.fastRenderCbx.setSelected(lld.getFastRendering());
            this.alignSelector.setSelectedItem(this.getAlignSelectorItem(lld.getAlignment()));
            if (lld.getFont() != null) {
                this.fontSelector.setFont((Font)lld.getFont());
            }
            this.formatSelector.setSelectedItem(lld.getLabelFormat());
            this.use360Cbx.setSelected(lld.getUse360());
            this.ignoreEvents = false;
        }
    }

    public static JPanel layoutPanels(LatLonLabelPanel latPanel, LatLonLabelPanel lonPanel) {
        Component[] comps = new Component[]{GuiUtils.lLabel("<html><b>Labels</b></html>"), GuiUtils.filler(), GuiUtils.cLabel("Interval"), GuiUtils.cLabel("Relative to"), GuiUtils.filler(), GuiUtils.filler(), GuiUtils.cLabel("Color"), GuiUtils.cLabel("Alignment"), latPanel.onOffCbx, GuiUtils.rLabel("Latitude:"), latPanel.spacingField, latPanel.baseField, GuiUtils.rLabel("At Longitudes:"), latPanel.labelLinesField, latPanel.colorButton, latPanel.alignSelector, lonPanel.onOffCbx, GuiUtils.rLabel("Longitude:"), lonPanel.spacingField, lonPanel.baseField, GuiUtils.rLabel("At Latitudes:"), lonPanel.labelLinesField, lonPanel.colorButton, lonPanel.alignSelector};
        GuiUtils.tmpInsets = new Insets(2, 4, 2, 4);
        JPanel settings = GuiUtils.doLayout(comps, 8, GuiUtils.WT_N, GuiUtils.WT_N);
        Component[] extraComps = new Component[]{GuiUtils.rLabel("Font:"), latPanel.fontSelector.getComponent(), GuiUtils.rLabel("Format:"), latPanel.formatSelector, lonPanel.use360Cbx, GuiUtils.filler()};
        GuiUtils.tmpInsets = new Insets(2, 4, 2, 4);
        JPanel extra = GuiUtils.doLayout(extraComps, 5, GuiUtils.WT_N, GuiUtils.WT_N);
        return GuiUtils.vbox((Component)GuiUtils.left(settings), GuiUtils.left(extra));
    }

    public void applyStateToData() {
        this.latLonLabelData.setInterval(new Float(this.spacingField.getText()).floatValue());
        this.latLonLabelData.setBaseValue(new Float(this.baseField.getText()).floatValue());
        this.latLonLabelData.setLabelsLineString(this.labelLinesField.getText());
    }

    public LatLonLabelData getLatLonLabelData() {
        return this.latLonLabelData;
    }

    private TwoFacedObject getAlignSelectorItem(String id) {
        if (this.alignPoints == null) {
            return null;
        }
        return TwoFacedObject.findId(id, this.alignPoints);
    }
}

