/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.LogUtil;

public class JpegImagesToMovie
implements ControllerListener,
DataSinkListener {
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public boolean doIt(int width, int height, int frameRate, Vector inFiles, MediaLocator outML) {
        Processor processor;
        ImageDataSource ids = new ImageDataSource(width, height, frameRate, inFiles);
        try {
            processor = Manager.createProcessor((DataSource)ids);
        }
        catch (Exception e) {
            LogUtil.logException("Yikes!  Cannot create a processor from the data source.", e);
            return false;
        }
        processor.addControllerListener((ControllerListener)this);
        processor.configure();
        if (!this.waitForState(processor, 180)) {
            LogUtil.userErrorMessage("Failed to configure the processor.");
            return false;
        }
        processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] tcs = processor.getTrackControls();
        Format[] f = tcs[0].getSupportedFormats();
        if (f == null || f.length <= 0) {
            LogUtil.userErrorMessage("The mux does not support the input format: " + tcs[0].getFormat());
            return false;
        }
        tcs[0].setFormat(f[0]);
        processor.realize();
        if (!this.waitForState(processor, 300)) {
            LogUtil.userErrorMessage("Failed to realize the processor.");
            return false;
        }
        DataSink dsink = this.createDataSink(processor, outML);
        if (dsink == null) {
            return false;
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        try {
            processor.start();
            dsink.start();
        }
        catch (IOException e) {
            LogUtil.logException("IO error during processing", e);
            return false;
        }
        this.waitForFileDone();
        try {
            dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        processor.removeControllerListener((ControllerListener)this);
        return true;
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            LogUtil.userErrorMessage("Something is really wrong: the processor does not have an output DataSource");
            return null;
        }
        try {
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            LogUtil.logException("Cannot create the DataSink: ", e);
            return null;
        }
        return dsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    public static void createMovie(String movieFile, int width, int height, int frameRate, Vector images) {
        MediaLocator oml = JpegImagesToMovie.createMediaLocator(movieFile);
        if (oml == null) {
            LogUtil.userErrorMessage("Cannot build media locator from: " + movieFile);
            return;
        }
        JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
        imageToMovie.doIt(width, height, frameRate, images, oml);
    }

    public static void main(String[] args) {
        MediaLocator oml;
        if (args.length == 0) {
            JpegImagesToMovie.prUsage();
        }
        int width = -1;
        int height = -1;
        int frameRate = 1;
        Vector<String> inputFiles = new Vector<String>();
        String outputURL = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-w")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                width = new Integer(args[i]);
                continue;
            }
            if (args[i].equals("-h")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                height = new Integer(args[i]);
                continue;
            }
            if (args[i].equals("-f")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                frameRate = new Integer(args[i]);
                continue;
            }
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    JpegImagesToMovie.prUsage();
                }
                outputURL = args[i];
                continue;
            }
            inputFiles.addElement(args[i]);
        }
        if (outputURL == null || inputFiles.size() == 0) {
            JpegImagesToMovie.prUsage();
        }
        if (!outputURL.endsWith(".mov") && !outputURL.endsWith(".MOV")) {
            LogUtil.userErrorMessage("The output file extension should end with a .mov extension");
            JpegImagesToMovie.prUsage();
        }
        if (width < 0 || height < 0) {
            LogUtil.userErrorMessage("Please specify the correct image size.");
            JpegImagesToMovie.prUsage();
        }
        if (frameRate < 1) {
            frameRate = 1;
        }
        if ((oml = JpegImagesToMovie.createMediaLocator(outputURL)) == null) {
            LogUtil.userErrorMessage("Cannot build media locator from: " + outputURL);
            System.exit(0);
        }
        JpegImagesToMovie imageToMovie = new JpegImagesToMovie();
        imageToMovie.doIt(width, height, frameRate, inputFiles, oml);
        System.exit(0);
    }

    static void prUsage() {
        System.err.println("Usage: java JpegImagesToMovie -w <width> -h <height> -f <frame rate> -o <output URL> <input JPEG file 1> <input JPEG file 2> ...");
        System.exit(-1);
    }

    static MediaLocator createMediaLocator(String url) {
        String fileName;
        MediaLocator ml;
        File file = new File(url);
        File parent = file.getParentFile();
        if (parent != null && parent.isDirectory() && (ml = new MediaLocator("file:" + url)) != null) {
            return ml;
        }
        if (url.indexOf(":") > 0 && (ml = new MediaLocator(url)) != null) {
            return ml;
        }
        if (url.startsWith(File.separator) ? (ml = new MediaLocator("file:" + url)) != null : (ml = new MediaLocator(fileName = "file:" + System.getProperty("user.dir") + File.separator + url)) != null) {
            return ml;
        }
        return null;
    }

    class ImageSourceStream
    implements PullBufferStream {
        Vector images;
        int width;
        int height;
        VideoFormat format;
        int nextImage = 0;
        boolean ended = false;

        public ImageSourceStream(int width, int height, int frameRate, Vector images) {
            this.width = width;
            this.height = height;
            this.images = images;
            this.format = new VideoFormat("jpeg", new Dimension(width, height), -1, Format.byteArray, (float)frameRate);
        }

        public boolean willReadBlock() {
            return false;
        }

        public void read(Buffer buf) throws IOException {
            if (this.nextImage >= this.images.size()) {
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.ended = true;
                return;
            }
            String imageFile = (String)this.images.elementAt(this.nextImage);
            boolean convertedToJpg = false;
            if (!imageFile.endsWith("jpg") && !imageFile.endsWith("jpeg")) {
                imageFile = ImageUtils.convertImageTo(imageFile, "jpg");
                convertedToJpg = true;
            }
            ++this.nextImage;
            RandomAccessFile raFile = new RandomAccessFile(imageFile, "r");
            byte[] data = null;
            if (buf.getData() instanceof byte[]) {
                data = (byte[])buf.getData();
            }
            if (data == null || (long)data.length < raFile.length()) {
                data = new byte[(int)raFile.length()];
                buf.setData((Object)data);
            }
            raFile.readFully(data, 0, (int)raFile.length());
            buf.setOffset(0);
            buf.setLength((int)raFile.length());
            buf.setFormat((Format)this.format);
            buf.setFlags(buf.getFlags() | 0x10);
            raFile.close();
            if (convertedToJpg) {
                new File(imageFile).delete();
            }
        }

        public Format getFormat() {
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            return 0L;
        }

        public boolean endOfStream() {
            return this.ended;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }

    class PngImageSourceStream
    extends ImageSourceStream {
        public PngImageSourceStream(int width, int height, int frameRate, Vector<String> images) {
            super(width, height, frameRate, images);
            this.format = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, (float)frameRate, 24, 1, 2, 3);
        }

        @Override
        public void read(Buffer buf) throws IOException {
            if (this.nextImage >= this.images.size()) {
                System.err.println("Done reading all images.");
                buf.setEOM(true);
                buf.setOffset(0);
                buf.setLength(0);
                this.ended = true;
                return;
            }
            String imageFile = (String)this.images.elementAt(this.nextImage);
            ++this.nextImage;
            System.err.println("  - reading image file: " + imageFile);
            BufferedImage image = ImageIO.read(new File(imageFile));
            boolean hasAlpha = image.getColorModel().hasAlpha();
            Dimension size = this.format.getSize();
            byte[] imageData = this.convertTo24Bit(hasAlpha, image.getRaster().getPixels(0, 0, size.width, size.height, (int[])null));
            buf.setData((Object)imageData);
            System.err.println("    read " + imageData.length + " bytes.");
            buf.setOffset(0);
            buf.setLength(imageData.length);
            buf.setFormat((Format)this.format);
            buf.setFlags(buf.getFlags() | 0x10);
        }

        private void convertIntByteToByte(int[] src, int srcIndex, byte[] out, int outIndex) {
            int r = src[srcIndex];
            int g = src[srcIndex + 1];
            int b = src[srcIndex + 2];
            out[outIndex] = (byte)(r & 0xFF);
            out[outIndex + 1] = (byte)(g & 0xFF);
            out[outIndex + 2] = (byte)(b & 0xFF);
        }

        private byte[] convertTo24Bit(boolean hasAlpha, int[] input) {
            int dataLength = input.length;
            int newSize = hasAlpha ? dataLength * 3 / 4 : dataLength;
            byte[] convertedData = new byte[newSize];
            int i = 0;
            int j = 0;
            while (i < dataLength) {
                this.convertIntByteToByte(input, i, convertedData, j);
                if (hasAlpha) {
                    ++i;
                }
                i += 3;
                j += 3;
            }
            return convertedData;
        }
    }

    class ImageDataSource
    extends PullBufferDataSource {
        ImageSourceStream[] streams = new ImageSourceStream[1];

        ImageDataSource(int width, int height, int frameRate, Vector images) {
            this.streams[0] = new ImageSourceStream(width, height, frameRate, images);
        }

        public void setLocator(MediaLocator source) {
        }

        public MediaLocator getLocator() {
            return null;
        }

        public String getContentType() {
            return "raw";
        }

        public void connect() {
        }

        public void disconnect() {
        }

        public void start() {
        }

        public void stop() {
        }

        public PullBufferStream[] getStreams() {
            return this.streams;
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }
}

