/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public class InteractiveShell
implements HyperlinkListener {
    private static Object MUTEX = new Object();
    protected JFrame frame;
    protected JTextField commandFld;
    protected JTextArea commandArea;
    private JButton flipBtn;
    private GuiUtils.CardLayoutPanel cardLayoutPanel;
    protected JEditorPane editorPane;
    protected StringBuffer sb = new StringBuffer();
    private boolean bufferOutput = false;
    protected List history = new ArrayList();
    protected int historyIdx = -1;
    private String title;
    protected JComponent contents;

    public InteractiveShell(String title) {
        this.title = title;
    }

    protected void makeFrame() {
        this.frame = new JFrame(this.title);
        this.frame.getContentPane().add(this.contents);
        this.frame.pack();
        this.frame.setLocation(100, 100);
        this.frame.setVisible(true);
        LogUtil.registerWindow(this.frame);
    }

    public void close() {
        this.frame.dispose();
    }

    public void show() {
        this.frame.setVisible(true);
    }

    protected String getHref(String text, String label) {
        String encoded = new String(XmlUtil.encodeBase64(("text:" + text).getBytes()));
        return "<a href=\"" + encoded + "\">" + label + "</a>";
    }

    protected void showWaitCursor() {
        this.frame.setCursor(GuiUtils.waitCursor);
    }

    protected void showNormalCursor() {
        this.frame.setCursor(GuiUtils.normalCursor);
    }

    protected void init() {
        this.contents = this.doMakeContents();
        this.makeFrame();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
        if ((url = new String(XmlUtil.decodeBase64(url))).startsWith("eval:")) {
            Misc.run(this, "eval", url.substring(5));
        } else if (url.startsWith("text:")) {
            this.setText(url.substring(5));
        }
    }

    public void setText(String text) {
        this.getCommandFld().setText(text);
        this.getCommandFld().requestFocus();
    }

    protected JComponent doMakeContents() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.addHyperlinkListener(this);
        JScrollPane scroller = GuiUtils.makeScrollPane(this.editorPane, 400, 300);
        scroller.setPreferredSize(new Dimension(400, 300));
        this.commandFld = new JTextField();
        GuiUtils.setFixedWidthFont(this.commandFld);
        GuiUtils.addKeyBindings(this.commandFld);
        this.commandFld.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                InteractiveShell.this.handleKeyPress(e, InteractiveShell.this.commandFld);
            }
        });
        this.commandFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                InteractiveShell.this.eval();
            }
        });
        this.commandFld.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    InteractiveShell.this.handleRightMouseClick(InteractiveShell.this.commandFld, e);
                }
            }
        });
        this.commandArea = new JTextArea("", 4, 30);
        GuiUtils.setFixedWidthFont(this.commandArea);
        GuiUtils.addKeyBindings(this.commandArea);
        this.commandArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                InteractiveShell.this.handleKeyPress(e, InteractiveShell.this.commandArea);
            }
        });
        this.commandArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    InteractiveShell.this.handleRightMouseClick(InteractiveShell.this.commandArea, e);
                }
            }
        });
        this.cardLayoutPanel = new GuiUtils.CardLayoutPanel();
        this.cardLayoutPanel.addCard(GuiUtils.top(this.commandFld));
        this.cardLayoutPanel.addCard(GuiUtils.makeScrollPane(this.commandArea, 200, 100));
        this.flipBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/DownDown.gif", this, "flipField");
        JButton evalBtn = GuiUtils.makeButton("Evaluate:", this, "eval");
        JPanel bottom = GuiUtils.leftCenterRight(GuiUtils.top(evalBtn), GuiUtils.inset((Component)this.cardLayoutPanel, 2), GuiUtils.top(this.flipBtn));
        JComponent contents = GuiUtils.vsplit((Component)scroller, (Component)bottom, 300);
        contents = GuiUtils.inset((Component)contents, 5);
        JMenuBar menuBar = this.doMakeMenuBar();
        if (menuBar != null) {
            contents = GuiUtils.topCenter(menuBar, contents);
        }
        return contents;
    }

    protected void handleRightMouseClick(JTextComponent commandFld, MouseEvent e) {
    }

    protected JMenuBar doMakeMenuBar() {
        return null;
    }

    public void toFront() {
        GuiUtils.toFront(this.frame);
    }

    public void flipField() {
        this.cardLayoutPanel.flip();
        if (this.getCommandFld() instanceof JTextArea) {
            this.flipBtn.setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/UpUp.gif"));
        } else {
            this.flipBtn.setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/DownDown.gif"));
        }
    }

    public void insertText(String t) {
        GuiUtils.insertText(this.getCommandFld(), t);
    }

    protected void handleKeyPress(KeyEvent e, JTextComponent cmdFld) {
        block21: {
            block20: {
                block19: {
                    boolean isArea;
                    block18: {
                        block17: {
                            block16: {
                                isArea = cmdFld instanceof JTextArea;
                                if (isArea) break block16;
                                if (e.getKeyCode() == 38) break block17;
                            }
                            if (e.getKeyCode() != 80 || !e.isControlDown()) break block18;
                        }
                        if (this.history.size() > 0) {
                            if (this.historyIdx < 0 || this.historyIdx >= this.history.size()) {
                                this.historyIdx = this.history.size() - 1;
                            } else {
                                --this.historyIdx;
                                if (this.historyIdx < 0) {
                                    this.historyIdx = 0;
                                }
                            }
                            if (this.historyIdx >= 0 && this.historyIdx < this.history.size()) {
                                cmdFld.setText((String)this.history.get(this.historyIdx));
                            }
                        }
                    }
                    if (isArea) break block19;
                    if (e.getKeyCode() == 40) break block20;
                }
                if (e.getKeyCode() != 78 || !e.isControlDown()) break block21;
            }
            if (this.history.size() > 0) {
                if (this.historyIdx < 0 || this.historyIdx >= this.history.size()) {
                    this.historyIdx = this.history.size() - 1;
                } else {
                    ++this.historyIdx;
                    if (this.historyIdx >= this.history.size()) {
                        this.historyIdx = this.history.size() - 1;
                    }
                }
                if (this.historyIdx >= 0 && this.historyIdx < this.history.size()) {
                    cmdFld.setText((String)this.history.get(this.historyIdx));
                }
            }
        }
    }

    public void insert(String s) {
        String t = this.getCommandFld().getText();
        int pos = this.getCommandFld().getCaretPosition();
        t = t.substring(0, pos) + s + t.substring(pos);
        this.getCommandFld().setText(t);
        this.getCommandFld().setCaretPosition(pos + s.length());
    }

    public void clear() {
        this.historyIdx = -1;
        this.history = new ArrayList();
        this.clearOutput();
    }

    public void clearOutput() {
        this.sb = new StringBuffer();
        this.editorPane.setText("");
    }

    private JTextComponent getCommandFld() {
        if (this.cardLayoutPanel.getVisibleIndex() == 0) {
            return this.commandFld;
        }
        return this.commandArea;
    }

    public void eval() {
        JTextComponent cmdFld = this.getCommandFld();
        String cmd = cmdFld.getText();
        if (cmd.trim().equals("!!")) {
            if (this.history.size() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            cmd = (String)this.history.get(this.history.size() - 1);
        } else if (cmd.trim().startsWith("!")) {
            if (this.history.size() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String prefix = cmd.substring(1);
            cmd = null;
            for (int i = this.history.size() - 1; i >= 0; --i) {
                String tmp = (String)this.history.get(i);
                if (!tmp.startsWith(prefix)) continue;
                cmd = tmp;
                break;
            }
            if (cmd == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        cmdFld.setText("");
        this.history.add(cmd);
        this.historyIdx = -1;
        Misc.run(this, "eval", cmd);
    }

    protected void startBufferingOutput() {
        this.bufferOutput = true;
    }

    protected void endBufferingOutput() {
        this.bufferOutput = false;
        this.updateText();
    }

    private void updateText() {
        this.editorPane.setText(this.sb.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    InteractiveShell.this.editorPane.scrollRectToVisible(new Rectangle(0, 10000, 1, 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void output(String m) {
        this.sb.append(m);
        if (!this.bufferOutput) {
            this.updateText();
        }
    }

    public void eval(String code) {
        String evalCode = "eval:" + code;
        String encoded1 = new String(XmlUtil.encodeBase64(evalCode.getBytes()));
        String textCode = "text:" + code;
        String encoded2 = new String(XmlUtil.encodeBase64(textCode.getBytes()));
        this.output("<div style=\"margin:0; margin-bottom:1; background-color:#cccccc; \"><table width=\"100%\"><tr><td>" + this.formatCode(code) + "</td><td align=\"right\" valign=\"top\"><a href=\"" + encoded2 + "\"><img src=\"idvresource:/auxdata/ui/icons/Down16.gif\" border=0></a>" + "<a href=\"" + encoded1 + "\"><img alt=\"Reload\" src=\"idvresource:/auxdata/ui/icons/Refresh16.gif\" border=0></a></td></tr></table></div>");
    }

    protected String formatCode(String code) {
        return code;
    }
}

