/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import gov.noaa.ncdc.nexradiv.AVIWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import ucar.unidata.ui.AnimatedGifEncoder;
import ucar.unidata.ui.drawing.Glyph;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WrapperException;

public class ImageUtils {
    public static boolean debug = false;

    public static BufferedImage matte(BufferedImage image, int top, int bottom, int left, int right, Color bg) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        BufferedImage newImage = new BufferedImage(imageWidth + left + right, imageHeight + top + bottom, ImageUtils.getImageType(image));
        Graphics newG = newImage.getGraphics();
        newG.setColor(bg);
        newG.fillRect(0, 0, newImage.getWidth(null), newImage.getHeight(null));
        newG.drawImage(image, left, top, null);
        return newImage;
    }

    private static int getImageType(Image image) {
        if (ImageUtils.hasAlpha(image)) {
            return 2;
        }
        return 1;
    }

    public static BufferedImage clip(BufferedImage image, int[] ul, int[] lr) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int w = lr[0] - ul[0];
        int h = lr[1] - ul[1];
        if (ul[0] + w <= imageWidth && ul[1] + h <= imageHeight && w > 0 && h > 0) {
            return image.getSubimage(ul[0], ul[1], w, h);
        }
        System.err.println("Specified clip width/height:" + w + "/" + h + " outside of image width/height:" + imageWidth + "/" + imageHeight);
        return image;
    }

    public static Image readImage(String imagePath) {
        return ImageUtils.readImage(imagePath, true);
    }

    public static Image readImage(String imagePath, boolean cache) {
        return ImageUtils.readImage(imagePath, cache, false);
    }

    public static Image readImage(String imagePath, boolean cache, boolean returnNullIfNotFound) {
        Image image = GuiUtils.getImage(imagePath, ImageUtils.class, cache, returnNullIfNotFound);
        image = ImageUtils.waitOnImage(image);
        return image;
    }

    public static Image waitOnImage(Image image) {
        if (image == null) {
            return null;
        }
        MyImageObserver mio = new MyImageObserver();
        mio.setImage(image);
        int heightOkCnt = 0;
        while (!mio.badImage && !mio.allBits && heightOkCnt < 20) {
            Misc.sleep(5L);
            if (mio.receivedUpdate || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) continue;
            ++heightOkCnt;
        }
        if (mio.badImage) {
            return null;
        }
        return image;
    }

    public static BufferedImage makeColorTransparent(Image im, Color c) {
        int[] redRange = new int[]{0, 0};
        int[] greenRange = new int[]{0, 0};
        int[] blueRange = new int[]{0, 0};
        if (c != null) {
            redRange[0] = redRange[1] = c.getRed();
            greenRange[0] = greenRange[1] = c.getGreen();
            blueRange[0] = blueRange[1] = c.getBlue();
        }
        return ImageUtils.makeColorTransparent(im, redRange, greenRange, blueRange);
    }

    public static BufferedImage makeColorTransparent(Image im, final int[] redRange, final int[] greenRange, final int[] blueRange) {
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (red >= redRange[0] && red <= redRange[1] && green >= greenRange[0] && green <= greenRange[1] && blue >= blueRange[0] && blue <= blueRange[1]) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        im = Toolkit.getDefaultToolkit().createImage(ip);
        BufferedImage bim = ImageUtils.toBufferedImage(im);
        return bim;
    }

    public static BufferedImage removeRedeye(Image im, final int x1, final int y1, final int x2, final int y2) {
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if (x < x1 || x > x2 || y < y1 || y > y2) {
                    return rgb;
                }
                boolean threshold = false;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                double rbrite = (double)r * 0.5133333;
                double gbrite = g;
                double bbrite = (double)b * 0.1933333;
                if (rbrite >= gbrite - (double)threshold && rbrite >= bbrite - (double)threshold) {
                    rbrite = (gbrite + bbrite) / 2.0;
                    r = (int)(rbrite / 0.51333333);
                    return 0xFF00FFFF & rgb | r << 16;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        im = Toolkit.getDefaultToolkit().createImage(ip);
        BufferedImage bim = ImageUtils.toBufferedImage(im);
        return bim;
    }

    public static int toAlpha(double percent) {
        percent = 1.0 - percent;
        return (int)(255.0 * percent);
    }

    public static BufferedImage setAlpha(Image im, double percent) {
        int t = ImageUtils.toAlpha(percent);
        int mask = 0xFFFFFF | t << 24;
        if (im == null) {
            return null;
        }
        BufferedImage image = ImageUtils.toBufferedImage(im, 2);
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgb = image.getRGB(x, y);
                image.setRGB(x, y, rgb &= mask);
            }
        }
        return image;
    }

    public static Point toPoint(Point2D p) {
        return new Point((int)p.getX(), (int)p.getY());
    }

    public static Point parsePoint(String s, Rectangle r) {
        s = s.toLowerCase();
        List<String> places = StringUtil.split(s, ",");
        int dx = 0;
        int dy = 0;
        String place = places.get(0);
        if (place.isEmpty()) {
            place = "ll";
        }
        if (places.size() > 1) {
            dx = new Integer(places.get(1).toString());
        }
        if (places.size() > 2) {
            dy = new Integer(places.get(2).toString());
        }
        Point2D placePoint = Glyph.getPointOnRect(place, r);
        placePoint.setLocation(placePoint.getX() + (double)dx, placePoint.getY() + (double)dy);
        return ImageUtils.toPoint(placePoint);
    }

    public static BufferedImage toBufferedImage(Image image) {
        return ImageUtils.toBufferedImage(image, false);
    }

    public static BufferedImage toBufferedImage(Image image, boolean force) {
        if (!force && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static Image mergeImages(List images, int space, Color bg) {
        return ImageUtils.gridImages(images, space, bg, 1);
    }

    public static Image gridImages(List images, int space, Color bg, int columns) {
        if (images.size() == 1) {
            return (Image)images.get(0);
        }
        int maxHeight = 0;
        int maxWidth = 0;
        int rows = (int)((double)images.size() / (double)columns + 1.0);
        if (rows == 0) {
            rows = 1;
        }
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.get(i);
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            maxHeight = Math.max(maxHeight, imageHeight);
            maxWidth = Math.max(maxWidth, imageWidth);
        }
        if (columns > images.size()) {
            columns = images.size();
        }
        BufferedImage bImage = new BufferedImage(maxWidth * columns + (columns - 1) * space, maxHeight * rows + (rows - 1) * space, 1);
        Graphics g = bImage.getGraphics();
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(0, 0, bImage.getWidth(null), bImage.getHeight(null));
        }
        int colCnt = 0;
        int rowCnt = 0;
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.get(i);
            g.drawImage(image, colCnt * (maxWidth + space), rowCnt * (maxHeight + space), null);
            if (++colCnt < columns) continue;
            colCnt = 0;
            ++rowCnt;
        }
        return bImage;
    }

    public static Image gridImages2(List<? extends Image> images, int space, Color bg, int columns) {
        if (images.size() == 1) {
            return images.get(0);
        }
        LinkedList<Image> griddedImages = new LinkedList<Image>();
        int i = 0;
        while ((double)i < Math.ceil(1.0 * (double)images.size() / (double)columns)) {
            LinkedList<Image> row = new LinkedList<Image>();
            for (int j = 0; j < columns; ++j) {
                if (i * columns + j >= images.size()) continue;
                row.add(ImageUtils.padImage(images.get(i * columns + j), space, bg));
            }
            griddedImages.add(ImageUtils.mergeHorizontal(row));
            ++i;
        }
        return ImageUtils.mergeVertical(griddedImages);
    }

    public static Image padImage(Image image, int space, Color color) {
        BufferedImage newImage = new BufferedImage(image.getWidth(null) + 2 * space, image.getHeight(null) + 2 * space, 1);
        Graphics g = newImage.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, newImage.getWidth(null), newImage.getHeight(null));
        g.drawImage(image, space, space, null);
        return newImage;
    }

    public static Image mergeHorizontal(List<? extends Image> images) {
        int w = 0;
        int h = Integer.MIN_VALUE;
        int[] ws = new int[images.size()];
        for (int i = 0; i < images.size(); ++i) {
            Image im = images.get(i);
            if (im.getHeight(null) > h) {
                h = im.getHeight(null);
            }
            ws[i] = w;
            w += im.getWidth(null);
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics g = bi.getGraphics();
        for (int i = 0; i < images.size(); ++i) {
            Image im = images.get(i);
            g.drawImage(im, ws[i], 0, null);
        }
        return bi;
    }

    public static Image mergeVertical(List<? extends Image> images) {
        int w = Integer.MIN_VALUE;
        int h = 0;
        int[] hs = new int[images.size()];
        for (int i = 0; i < images.size(); ++i) {
            Image im = images.get(i);
            if (im.getWidth(null) > w) {
                w = im.getWidth(null);
            }
            hs[i] = h;
            h += im.getHeight(null);
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics g = bi.getGraphics();
        for (int i = 0; i < images.size(); ++i) {
            Image im = images.get(i);
            g.drawImage(im, 0, hs[i], null);
        }
        return bi;
    }

    public static BufferedImage toBufferedImage(Image image, int type) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        BufferedImage bImage = new BufferedImage(w, h, type);
        bImage.getGraphics().drawImage(image, 0, 0, null);
        return bImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static Image getImage(Component component) throws Exception {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        double w = component.getWidth();
        double h = component.getHeight();
        if (w == 0.0 || h == 0.0) {
            return null;
        }
        BufferedImage image = new BufferedImage((int)w, (int)h, 2);
        repaintManager.setDoubleBufferingEnabled(false);
        Graphics2D g = (Graphics2D)image.getGraphics();
        component.paint(g);
        repaintManager.setDoubleBufferingEnabled(true);
        return image;
    }

    public static void writeImageToFile(Image image, File saveFile) throws Exception {
        ImageUtils.writeImageToFile(image, saveFile.toString());
    }

    public static void writeImageToFile(Image image, String saveFile) throws Exception {
        ImageUtils.writeImageToFile(image, saveFile, 1.0f);
    }

    public static BufferedImage horizontalflip(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(w, h, img.getType());
        Graphics2D g = dimg.createGraphics();
        g.drawImage(img, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage verticalflip(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(w, h, img.getColorModel().getTransparency());
        Graphics2D g = dimg.createGraphics();
        g.drawImage(img, 0, 0, w, h, 0, h, w, 0, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage rotate90(BufferedImage img, boolean left) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        double angle = left ? -90 : 90;
        BufferedImage rotatedImage = new BufferedImage(h, w, 1);
        AffineTransform trans = new AffineTransform();
        trans.rotate(Math.toRadians(angle));
        if (left) {
            trans.translate(-w, 0.0);
        } else {
            trans.translate(0.0, -h);
        }
        Graphics2D g = rotatedImage.createGraphics();
        g.drawImage(img, trans, null);
        return rotatedImage;
    }

    public static String convertImageTo(String file, String newType) {
        try {
            String newFile = IOUtil.stripExtension(file) + "." + newType;
            Image image = ImageUtils.readImage(file, false);
            ImageUtils.writeImageToFile(image, newFile);
            return newFile;
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
    }

    public static void writeImageToFile(Image image, String saveFile, float quality) throws Exception {
        ImageUtils.writeImageToFile(image, saveFile, null, quality);
    }

    public static void writeImageToFile(Image image, String saveFile, OutputStream os, float quality) throws Exception {
        RenderedImage renderedImage = null;
        File file = new File(saveFile);
        ImageWriter writer = null;
        String fileSuffix = file.getName();
        fileSuffix = fileSuffix.replaceFirst(".*\\.(\\w*)$", "$1");
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix(fileSuffix);
        if (file.exists()) {
            boolean bl = file.delete();
        }
        if (!iter.hasNext()) {
            if (fileSuffix.equals("gif")) {
                AnimatedGifEncoder.createGif(saveFile, image);
                return;
            }
            throw new Exception("unknown suffix: " + fileSuffix);
        }
        writer = iter.next();
        ImageOutputStream ios = os != null ? ImageIO.createImageOutputStream(os) : ImageIO.createImageOutputStream(file);
        writer.setOutput(ios);
        ImageWriteParam iwparam = writer.getDefaultWriteParam();
        if (iwparam.canWriteCompressed()) {
            String[] types = iwparam.getCompressionTypes();
            iwparam.setCompressionMode(2);
            iwparam.setCompressionType(types[0]);
            if (!iwparam.isCompressionLossless()) {
                iwparam.setCompressionQuality(quality);
            }
        }
        if ((saveFile.toLowerCase().endsWith(".jpg") || saveFile.toLowerCase().endsWith(".jpeg")) && ImageUtils.hasAlpha(image)) {
            renderedImage = ImageUtils.toBufferedImage(image, 1);
            image = renderedImage;
        }
        if (renderedImage == null) {
            renderedImage = image instanceof RenderedImage ? (RenderedImage)((Object)image) : ImageUtils.toBufferedImage(image);
        }
        writer.write(null, new IIOImage(renderedImage, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static boolean isImage(String file) {
        return (file = file.toLowerCase()).endsWith(".jpg") || file.endsWith(".jpeg") || file.endsWith(".gif") || file.endsWith(".png");
    }

    public static boolean writeImage(JDialog window, String file) throws Exception {
        if (window == null || !window.isShowing()) {
            return false;
        }
        ImageUtils.writeImageToFile(window.getContentPane(), file);
        return true;
    }

    public static boolean writeImage(JFrame window, String file) throws Exception {
        if (window == null || !window.isShowing()) {
            return false;
        }
        ImageUtils.writeImageToFile(window.getContentPane(), file);
        return true;
    }

    public static void writeImageToFile(Component component, String saveFile) throws Exception {
        if (saveFile.endsWith(".pdf")) {
            FileOutputStream fos = new FileOutputStream(saveFile);
            ImageUtils.writePDF(fos, (JComponent)component);
            ((OutputStream)fos).close();
            return;
        }
        RepaintManager manager = RepaintManager.currentManager(component);
        double w = component.getWidth();
        double h = component.getHeight();
        BufferedImage image = new BufferedImage((int)w, (int)h, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        component.paint(g);
        ImageUtils.writeImageToFile((Image)image, saveFile);
    }

    public static void writeAvi(List imageFiles, double frameRateInFPS, File outFile) throws IOException {
        AVIWriter aviWriter = null;
        for (int n = 0; n < imageFiles.size(); ++n) {
            BufferedImage image = ImageUtils.toBufferedImage(ImageUtils.readImage(imageFiles.get(n).toString()));
            ImageUtils.waitOnImage(image);
            if (aviWriter == null) {
                aviWriter = new AVIWriter();
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                aviWriter.init(outFile, width, height, imageFiles.size(), frameRateInFPS);
            }
            aviWriter.addFrame(image);
        }
        if (aviWriter != null) {
            aviWriter.close();
        }
    }

    public static Image resize(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 16);
    }

    public static Image getImage(JEditorPane editor, Color transparentColor) throws Exception {
        editor.setBackground(transparentColor);
        Image i = ImageUtils.getImage(editor);
        if (transparentColor != null) {
            i = ImageUtils.makeColorTransparent(i, transparentColor);
        }
        return i;
    }

    public static Image renderHtml(String html, int width, Color transparentColor, Font font) throws Exception {
        JEditorPane editor = ImageUtils.getEditor(html, width, transparentColor, font);
        editor.updateUI();
        editor.invalidate();
        editor.validate();
        return ImageUtils.getImage(editor, transparentColor);
    }

    public static JEditorPane getEditor(String html, int width, Color transparentColor, Font font) throws Exception {
        return ImageUtils.getEditor(null, html, width, transparentColor, font);
    }

    public static JEditorPane getEditor(JEditorPane editor, String html, int width, Color transparentColor, Font font) throws Exception {
        if (editor == null) {
            editor = new JEditorPane();
            editor.setContentType("text/html");
        }
        JEditorPane theEditor = editor;
        theEditor.setBackground(transparentColor);
        theEditor.setEditable(false);
        if (font != null) {
            theEditor.setFont(font);
        }
        theEditor.setText(html);
        Dimension dim = theEditor.getPreferredSize();
        if (width > 0 && width < dim.width) {
            theEditor.setSize(new Dimension(width, 100));
            dim.width = width;
        }
        theEditor.setSize(dim);
        theEditor.setSize(theEditor.getSize().width, theEditor.getPreferredSize().height);
        return theEditor;
    }

    public static void writePDF(OutputStream out, JComponent comp) throws IOException {
    }

    public static void main(String[] args) throws Exception {
        int width = 400;
        System.err.println("reading");
        Image image = ImageUtils.readImage(args[0]);
        ImageUtils.removeRedeye(image, 10, 10, 1000, 1000);
    }

    public static Image getImageFile(String file) throws Exception {
        if (IOUtil.isHttpProtocol("http:")) {
            byte[] imageBytes = IOUtil.readBytesAndCache(file, "ImageMovieControl");
            if (imageBytes == null) {
                return null;
            }
            return Toolkit.getDefaultToolkit().createImage(imageBytes);
        }
        return Toolkit.getDefaultToolkit().createImage(file);
    }

    public static int getColumnCountFromComps(List<? extends Component> views) {
        HashSet<Integer> s = new HashSet<Integer>();
        for (Component component : views) {
            s.add(component.getLocationOnScreen().x);
        }
        return s.size();
    }

    private static class MyImageObserver
    implements ImageObserver {
        boolean badImage = false;
        boolean allBits = false;
        boolean gotWidth = false;
        boolean gotHeight = false;
        boolean receivedUpdate = false;

        public void setImage(Image i) {
            if (i.getWidth(null) > 0 && i.getHeight(null) > 0) {
                this.allBits = true;
            } else {
                i.getWidth(this);
            }
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            boolean debug = false;
            if (debug) {
                System.err.println("imageUpdate " + flags + " " + width + "X" + height);
            }
            this.receivedUpdate = true;
            if ((flags & 1) != 0) {
                if (debug) {
                    System.err.println("got width");
                }
                this.gotWidth = true;
            }
            if ((flags & 2) != 0) {
                if (debug) {
                    System.err.println("got height");
                }
                this.gotHeight = true;
            }
            if (!this.allBits) {
                // empty if block
            }
            if (flags == 0) {
                this.allBits = true;
            }
            if ((flags & 0x10) != 0) {
                if (debug) {
                    System.err.println("got FRAMEBITS");
                }
                this.allBits = true;
            }
            if ((flags & 0x20) != 0) {
                if (debug) {
                    System.err.println("got ALLBITS");
                }
                this.allBits = true;
            }
            if ((flags & 8) != 0 && debug) {
                System.err.println("got SOMEBITS");
            }
            if ((flags & 0x40) != 0) {
                if (debug) {
                    System.err.println("got ERROR");
                }
                this.badImage = true;
            }
            if ((flags & 0x80) != 0) {
                if (debug) {
                    System.err.println("got ABORT");
                }
                this.badImage = true;
            }
            if (debug) {
                // empty if block
            }
            return !this.allBits && !this.badImage;
        }
    }
}

