/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.LogUtil;

public class ImagePanel
extends JPanel
implements ImageObserver,
MouseListener,
MouseMotionListener,
KeyListener {
    private int currentIndex = 0;
    private List files = new ArrayList();
    private Image currentImage;
    private Image loadingImage;
    private double scaleFactor = 1.0;
    private int translateX = 0;
    private int translateY = 0;
    private int mouseX;
    private int mouseY;
    int baseTransX = 0;
    int baseTransY = 0;
    int currentTransX = 0;
    int currentTransY = 0;

    public ImagePanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                int notches = event.getWheelRotation();
                if (notches < 0) {
                    ImagePanel.this.doZoomIn();
                } else {
                    ImagePanel.this.doZoomOut();
                }
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isControlDown() && e.getKeyCode() == 82) {
            this.scaleFactor = 1.0;
            this.translateX = 0;
            this.translateY = 0;
            this.currentTransX = 0;
            this.currentTransY = 0;
            this.repaint();
        } else if (e.isControlDown() && e.getKeyCode() == 38) {
            this.doZoomIn();
        } else if (e.isControlDown() && e.getKeyCode() == 40) {
            this.doZoomOut();
        } else if (e.getKeyCode() == 40) {
            this.translateY += 20;
            this.repaint();
        } else if (e.getKeyCode() == 38) {
            this.translateY -= 20;
            this.repaint();
        } else if (e.getKeyCode() == 39) {
            this.translateX += 20;
            this.repaint();
        } else if (e.getKeyCode() == 37) {
            this.translateX -= 20;
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.requestFocus();
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        this.currentTransX = 0;
        this.currentTransY = 0;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.translateX += this.currentTransX;
        this.translateY += this.currentTransY;
        this.currentTransX = 0;
        this.currentTransY = 0;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.currentTransX = (int)((double)(event.getX() - this.mouseX) / this.scaleFactor);
        this.currentTransY = (int)((double)(event.getY() - this.mouseY) / this.scaleFactor);
        this.repaint();
    }

    public void setSelectedFile(int theIndex) {
        if (theIndex < 0) {
            theIndex = 0;
        } else if (theIndex >= this.files.size()) {
            theIndex = this.files.size() - 1;
        }
        this.currentIndex = theIndex;
        String theFile = null;
        if (theIndex >= 0 && theIndex < this.files.size()) {
            theFile = (String)this.files.get(theIndex);
        }
        if (theFile == null) {
            this.loadingImage = null;
            this.setImage(null);
        } else {
            this.loadFile(theFile);
        }
    }

    public void loadFile(String theFile) {
        long t1 = System.currentTimeMillis();
        try {
            this.loadingImage = ImageUtils.getImageFile(theFile);
            this.loadingImage.getWidth(this);
        }
        catch (Exception exc) {
            LogUtil.logException("Error loading image", exc);
        }
        long t2 = System.currentTimeMillis();
    }

    public void setFiles(List list) {
        this.files = new ArrayList(list);
    }

    public List getFiles() {
        return this.files;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        boolean all;
        if (img == this.currentImage) {
            this.repaint();
            return true;
        }
        boolean bl = all = (flags & 0x20) != 0;
        if (all && img == this.loadingImage) {
            this.loadingImageDone(this.loadingImage);
            return true;
        }
        return true;
    }

    public void loadingImageDone(Image image) {
        this.setImage(image);
    }

    protected void doZoomIn() {
        this.scaleFactor += 0.1;
        this.repaint();
    }

    protected void doZoomOut() {
        this.scaleFactor -= 0.1;
        if (this.scaleFactor < 0.1) {
            this.scaleFactor = 0.1;
        }
        this.repaint();
    }

    private void paintImage(Graphics2D g) {
        g.scale(this.scaleFactor, this.scaleFactor);
        g.translate(this.translateX + this.currentTransX, this.translateY + this.currentTransY);
        if (this.currentImage == null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        int imageWidth = this.currentImage.getWidth(this);
        if (imageWidth <= 0) {
            return;
        }
        int imageHeight = this.currentImage.getHeight(this);
        if (imageHeight <= 0) {
            return;
        }
        if (imageWidth < bounds.width && imageHeight < bounds.height) {
            g.drawImage(this.currentImage, 0, 0, null);
            return;
        }
        if ((double)imageWidth / (double)bounds.width > (double)imageHeight / (double)bounds.height) {
            imageHeight = (int)((double)imageHeight * ((double)bounds.width / (double)imageWidth));
            imageWidth = bounds.width;
        } else {
            imageWidth = (int)((double)imageWidth * ((double)bounds.height / (double)imageHeight));
            imageHeight = bounds.height;
        }
        g.drawImage(this.currentImage, 0, 0, imageWidth, imageHeight, null);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintImage((Graphics2D)g);
    }

    public void setImage(Image image) {
        this.currentImage = image;
        this.repaint();
    }

    public Image getImage() {
        return this.currentImage;
    }
}

