/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPFormBuilder;
import ucar.httpservices.HTTPMethod;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.WrapperException;

public class HttpFormEntry {
    public static final int TYPE_HIDDEN = 0;
    public static final int TYPE_INPUT = 1;
    public static final int TYPE_AREA = 2;
    public static final int TYPE_LABEL = 3;
    public static final int TYPE_FILE = 4;
    private int type;
    private String name;
    private String label;
    private String value;
    private int rows;
    private int cols;
    private JComponent component;
    private boolean required = true;
    private byte[] filePartSource;

    public HttpFormEntry(String name, String fileName, byte[] bytes) {
        this.name = name;
        this.type = 4;
        this.filePartSource = bytes;
        this.value = fileName;
    }

    public HttpFormEntry(String name, String label, String value) {
        this(1, name, label, value);
    }

    public static HttpFormEntry hidden(String name, String value) {
        return new HttpFormEntry(0, name, "", value);
    }

    public HttpFormEntry(String name, String label) {
        this(1, name, label);
    }

    public HttpFormEntry(int type, String name, String label) {
        this(type, name, label, "", 1, 30);
    }

    public HttpFormEntry(int type, String name, String label, String value) {
        this(type, name, label, value, 1, 30, true);
    }

    public HttpFormEntry(int type, String name, String label, String value, boolean required) {
        this(type, name, label, value, 1, 30, required);
    }

    public HttpFormEntry(int type, String name, String label, int rows, int cols) {
        this(type, name, label, "", rows, cols);
    }

    public HttpFormEntry(int type, String name, String label, String value, int rows, int cols) {
        this(type, name, label, value, rows, cols, true);
    }

    public HttpFormEntry(int type, String name, String label, String value, int rows, int cols, boolean required) {
        this.type = type;
        this.name = name;
        this.label = label;
        this.value = value;
        this.rows = rows;
        this.cols = cols;
        this.required = required;
    }

    public boolean ok() {
        if (this.type == 3) {
            return true;
        }
        return !this.required || this.getValue().trim().length() > 0;
    }

    public void addToGui(List guiComps) {
        if (this.type == 0) {
            return;
        }
        if (this.type == 2) {
            guiComps.add(GuiUtils.top(GuiUtils.rLabel(this.label)));
            if (this.component == null) {
                this.component = new JTextArea(this.value, this.rows, this.cols);
                ((JTextArea)this.component).setLineWrap(true);
            }
            JScrollPane sp = new JScrollPane(this.component);
            sp.setPreferredSize(new Dimension(500, 200));
            guiComps.add(sp);
        } else if (this.type == 1) {
            guiComps.add(GuiUtils.rLabel(this.label));
            if (this.component == null) {
                this.component = new JTextField(this.value, this.cols);
            }
            guiComps.add(this.component);
        } else if (this.type == 3) {
            guiComps.add(new JLabel(""));
            guiComps.add(new JLabel(this.label));
        } else if (this.type == 4 && this.filePartSource == null) {
            guiComps.add(GuiUtils.rLabel(this.label));
            if (this.component == null) {
                this.component = new JTextField(this.value);
            }
            JButton btn = GuiUtils.makeButton("Browse...", this, "browse", this.component);
            GuiUtils.setHFill();
            guiComps.add(GuiUtils.doLayout(new Component[]{this.component, btn}, 2, GuiUtils.WT_YN, GuiUtils.WT_N));
        }
    }

    public void browse(JTextField fld) {
        String f = fld.getText();
        FileManager.MyFileChooser chooser = new FileManager.MyFileChooser(f);
        if (chooser.showOpenDialog(fld) == 0) {
            fld.setText(chooser.getSelectedFile().toString());
        }
    }

    public String getValue() {
        if (this.type == 0) {
            return this.value;
        }
        if (this.type == 3) {
            return null;
        }
        if (this.component != null) {
            return ((JTextComponent)this.component).getText();
        }
        return this.value;
    }

    public void setValue(String newValue) {
        if (this.type == 0) {
            this.value = newValue;
        }
        if (this.type != 3 && this.component != null) {
            ((JTextComponent)this.component).setText(newValue);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getBytes() {
        return this.filePartSource;
    }

    public static JComponent makeUI(List<HttpFormEntry> entries) {
        ArrayList guiComps = new ArrayList();
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).addToGui(guiComps);
        }
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        return GuiUtils.doLayout(guiComps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
    }

    public static boolean checkEntries(List<HttpFormEntry> entries) {
        for (int i = 0; i < entries.size(); ++i) {
            HttpFormEntry formEntry = entries.get(i);
            if (formEntry.ok()) continue;
            LogUtil.userMessage("The entry: \"" + formEntry.getLabel() + "\" is required");
            return false;
        }
        return true;
    }

    public static boolean showUI(List<HttpFormEntry> entries, String title, Window window, JComponent extraTop) {
        return HttpFormEntry.showUI(entries, title, window, extraTop, null);
    }

    public static boolean showUI(List<HttpFormEntry> entries, String title, Window parent, JComponent extraTop, JComponent extraBottom) {
        JDialog dialog = GuiUtils.createDialog(parent, title, true);
        boolean ok = HttpFormEntry.showUI(entries, extraTop, extraBottom, dialog, false);
        dialog.dispose();
        return ok;
    }

    public static boolean showUI(final List<HttpFormEntry> entries, JComponent extraTop, JComponent extraBottom, final JDialog dialog, final boolean shouldDoBusyWait) {
        dialog.getContentPane().removeAll();
        JComponent contents = HttpFormEntry.makeUI(entries);
        if (extraTop != null) {
            contents = GuiUtils.topCenter(extraTop, contents);
        }
        if (extraBottom != null) {
            contents = GuiUtils.centerBottom(contents, extraBottom);
        }
        final boolean[] done = new boolean[]{false};
        final boolean[] ok = new boolean[]{false};
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_CANCEL)) {
                    done[0] = true;
                }
                if (cmd.equals(GuiUtils.CMD_SUBMIT) && HttpFormEntry.checkEntries(entries)) {
                    done[0] = true;
                    ok[0] = true;
                }
                if (done[0] && !shouldDoBusyWait) {
                    dialog.dispose();
                }
            }
        };
        JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_SUBMIT, GuiUtils.CMD_CANCEL});
        contents = GuiUtils.centerBottom(contents, buttons);
        dialog.getContentPane().add(contents);
        dialog.pack();
        GuiUtils.showInCenter(dialog);
        if (shouldDoBusyWait) {
            while (!done[0]) {
                Misc.sleep(100L);
            }
        }
        return ok[0];
    }

    private InputStream getFilePart() {
        if (this.filePartSource == null) {
            String file = this.getValue();
            try {
                return IOUtil.getInputStream(file);
            }
            catch (Exception exc) {
                throw new WrapperException("Reading file:" + file, exc);
            }
        }
        return new ByteArrayInputStream(this.filePartSource);
    }

    public boolean okToPost() {
        if (this.type == 3) {
            return false;
        }
        if (this.type == 4 && this.filePartSource == null) {
            return new File(this.getValue()).exists();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] doPost(List<HttpFormEntry> entries, String urlPath) {
        try (HTTPMethod postMethod = HttpFormEntry.getMethod(entries, urlPath);){
            postMethod.execute();
            String result = IOUtil.readContents(postMethod.getResponseBodyAsStream());
            if (postMethod.getStatusCode() >= 300) {
                String[] stringArray = new String[]{result, null};
                return stringArray;
            }
            String[] stringArray = new String[]{null, result};
            return stringArray;
        }
        catch (Exception exc) {
            throw new WrapperException("doing post", exc);
        }
    }

    private static HTTPMethod getMethod(List<HttpFormEntry> entries, String urlPath) throws Exception {
        HTTPMethod postMethod = HTTPFactory.Post(urlPath);
        ArrayList<HttpFormEntry> goodEntries = new ArrayList<HttpFormEntry>();
        for (int i = 0; i < entries.size(); ++i) {
            HttpFormEntry formEntry = entries.get(i);
            if (!formEntry.okToPost()) continue;
            goodEntries.add(entries.get(i));
        }
        HTTPFormBuilder builder = new HTTPFormBuilder();
        for (int i = 0; i < goodEntries.size(); ++i) {
            HttpFormEntry formEntry = (HttpFormEntry)goodEntries.get(i);
            if (formEntry.type == 4) {
                InputStream stream = formEntry.getFilePart();
                builder.add(formEntry.getName(), stream, formEntry.getValue());
                System.err.printf("%s %s\n", formEntry.getName(), formEntry.getValue());
                continue;
            }
            builder.add(formEntry.getName(), formEntry.getValue());
        }
        postMethod.setRequestContent(builder.build());
        return postMethod;
    }
}

