/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.ui.ComponentHolder;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.xml.XmlUtil;

public class HtmlComponent
extends ComponentHolder {
    public static final String ATTR_TEXT = "text";
    private String text;
    protected JTextArea textArea;
    protected JLabel label;

    public HtmlComponent() {
    }

    public HtmlComponent(String name, String text) {
        super(name);
        this.text = text;
    }

    @Override
    public void initWith(Element node) {
        if (XmlUtil.hasAttribute(node, ATTR_TEXT)) {
            this.setText(XmlUtil.getAttribute((Node)node, ATTR_TEXT, ""));
        } else {
            this.setText(XmlUtil.getChildText(node));
        }
    }

    @Override
    public JComponent doMakeContents() {
        this.label = new JLabel("");
        this.label.setText("<html>" + this.text + "</html>");
        return this.label;
    }

    @Override
    public String getTypeName() {
        return "Text Component";
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        comps.add(GuiUtils.top(GuiUtils.rLabel("Text:")));
        this.textArea = new JTextArea(this.text, 5, 30);
        comps.add(GuiUtils.makeScrollPane(this.textArea, 200, 100));
    }

    @Override
    protected boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.text = this.textArea.getText();
        this.label.setText("<html>" + this.text + "</html>");
        return true;
    }

    public void setText(String value) {
        this.text = value;
    }

    public String getText() {
        return this.text;
    }
}

