/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.xml.XmlObjectStore;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class HelpTipDialog
extends JDialog
implements HyperlinkListener {
    public static final String PREF_HELPTIPSHOW = "help.helptip.Show";
    public static final String PREF_HELPTIPIDX = "help.helptip.Index";
    private List helpTips = new ArrayList();
    private XmlResourceCollection resources;
    private int idx = 0;
    private JPanel labelPanel;
    private JPanel bottom;
    private JPanel right;
    private JCheckBox cbx;
    private String currentAction;
    private String helpTarget;
    private JEditorPane editor;
    private XmlObjectStore store;
    private ActionListener actionListener;

    public HelpTipDialog(XmlResourceCollection resources, ActionListener actionListener, XmlObjectStore store, Class origin, boolean showByDefault) {
        this.actionListener = actionListener;
        this.resources = resources;
        if (resources == null || resources.size() == 0) {
            return;
        }
        this.store = store;
        this.idx = this.getStore().get(PREF_HELPTIPIDX, -1) + 1;
        this.getStore().put(PREF_HELPTIPIDX, this.idx);
        this.getStore().save();
        String title = null;
        String icon = null;
        for (int i = 0; i < resources.size(); ++i) {
            Element helpTipRoot = resources.getRoot(i);
            if (helpTipRoot == null) continue;
            if (title == null) {
                title = XmlUtil.getAttribute((Node)helpTipRoot, "title", (String)null);
            }
            if (icon == null) {
                icon = XmlUtil.getAttribute((Node)helpTipRoot, "icon", (String)null);
            }
            this.helpTips.addAll(XmlUtil.findChildren(helpTipRoot, "helptip"));
        }
        if (title == null) {
            title = "Help tips";
        }
        this.setTitle(title);
        if (icon == null) {
            icon = "logo.gif";
        }
        JLabel imageLabel = GuiUtils.getImageLabel(icon, origin);
        JMenu topMenu = new JMenu("Tips");
        Hashtable<String, JMenu> menus = new Hashtable<String, JMenu>();
        menus.put("top", topMenu);
        for (int i = 0; i < this.helpTips.size(); ++i) {
            Element helpTip = (Element)this.helpTips.get(i);
            String tipTitle = XmlUtil.getAttribute((Node)helpTip, "title", (String)null);
            if (tipTitle == null) {
                String message = this.getMessage(helpTip);
                tipTitle = message.substring(0, 20);
            }
            if (tipTitle.trim().length() == 0) continue;
            String category = XmlUtil.getAttribute((Node)helpTip, "category", "top");
            JMenu m = (JMenu)menus.get(category);
            if (m == null) {
                m = new JMenu(category);
                menus.put(category, m);
                topMenu.add(m);
            }
            JMenuItem mi = new JMenuItem(tipTitle);
            mi.addActionListener(new ObjectListener(new Integer(i)){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    HelpTipDialog.this.idx = (Integer)this.theObject;
                    HelpTipDialog.this.showTip();
                }
            });
            m.add(mi);
        }
        this.labelPanel = new JPanel();
        this.editor = new JEditorPane();
        int height = 250;
        this.editor.setMinimumSize(new Dimension(350, height));
        this.editor.setPreferredSize(new Dimension(350, height));
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(this);
        this.editor.setContentType("text/html");
        JScrollPane scroller = GuiUtils.makeScrollPane(this.editor, 350, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(350, height));
        scroller.setMinimumSize(new Dimension(350, height));
        this.right = GuiUtils.doLayout(new Component[]{imageLabel, GuiUtils.hspace(10, 20)}, 1, GuiUtils.WT_Y, GuiUtils.WT_NY);
        JPanel contents = GuiUtils.centerRight(GuiUtils.inset((Component)scroller, 8), this.right);
        contents.add("North", GuiUtils.hspace(500, 10));
        JButton prevBtn = new JButton("Previous");
        prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpTipDialog.this.idx--;
                HelpTipDialog.this.showTip();
                HelpTipDialog.this.getStore().put(HelpTipDialog.PREF_HELPTIPIDX, HelpTipDialog.this.idx);
            }
        });
        JButton nextBtn = new JButton("Next");
        nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpTipDialog.this.next();
            }
        });
        this.cbx = new JCheckBox("Show tips on startup", showByDefault);
        this.cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpTipDialog.this.writeShowNextTime();
            }
        });
        JButton closeBtn = new JButton("Close");
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpTipDialog.this.close();
            }
        });
        JPanel buttons = GuiUtils.wrap(GuiUtils.hgrid(Misc.newList(prevBtn, nextBtn, closeBtn), 2));
        this.bottom = GuiUtils.leftCenterRight(this.cbx, null, buttons);
        JMenuBar bar = new JMenuBar();
        bar.add(topMenu);
        contents.add("North", bar);
        contents.add("South", this.bottom);
        contents.setBorder(BorderFactory.createBevelBorder(0));
        GuiUtils.packDialog(this, contents);
        this.showTip();
        Dimension size = this.getSize();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(ss.width / 2 - size.width / 2, ss.height / 2 - size.height / 2);
        this.setVisible(true);
    }

    public void writeShowNextTime() {
        if (this.getStore().get(PREF_HELPTIPSHOW, true) != this.cbx.isSelected()) {
            this.getStore().put(PREF_HELPTIPSHOW, this.cbx.isSelected());
            this.getStore().save();
        }
    }

    public void close() {
        this.writeShowNextTime();
        this.setVisible(false);
    }

    public XmlObjectStore getStore() {
        return this.store;
    }

    private void next() {
        ++this.idx;
        this.showTip();
        this.getStore().put(PREF_HELPTIPIDX, this.idx);
    }

    public void click(String url) {
        if (url.trim().equals("next")) {
            this.next();
        } else {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, url));
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e.getURL() == null) {
                this.click(e.getDescription());
            } else {
                this.click(e.getURL().toString());
            }
        }
    }

    private String getMessage(Node helpTip) {
        String message = XmlUtil.getAttribute(helpTip, "message", (String)null);
        if (message == null) {
            message = XmlUtil.getChildText(helpTip);
        }
        return message;
    }

    private void showTip() {
        if (this.helpTips.size() == 0) {
            return;
        }
        if (this.idx >= this.helpTips.size()) {
            this.idx = 0;
            this.getStore().put(PREF_HELPTIPIDX, this.idx);
        } else if (this.idx < 0) {
            this.idx = this.helpTips.size() - 1;
        }
        Node helpTip = (Node)this.helpTips.get(this.idx);
        String title = XmlUtil.getAttribute(helpTip, "title", (String)null);
        String message = this.getMessage(helpTip);
        if (title != null) {
            message = "<h2>" + title + "</h2>" + message;
        }
        this.currentAction = XmlUtil.getAttribute(helpTip, "action", (String)null);
        String actionLabel = XmlUtil.getAttribute(helpTip, "actionlabel", "More...");
        this.right.invalidate();
        this.helpTarget = XmlUtil.getAttribute(helpTip, "target", (String)null);
        ArrayList l = new ArrayList();
        this.labelPanel.removeAll();
        this.editor.setText(message);
        this.labelPanel.repaint();
        GuiUtils.vbox(this.labelPanel, l);
        this.labelPanel.validate();
    }

    private void showHelpTip(int idx) {
        if (this.helpTips == null) {
            return;
        }
        if (idx >= this.helpTips.size()) {
            idx = 0;
        }
        Node helpTip = (Node)this.helpTips.get(idx);
        String message = XmlUtil.getAttribute(helpTip, "message");
    }
}

