/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import ucar.unidata.util.GuiUtils;

public class HelpActionLabel
extends JButton
implements ActionListener {
    private static ActionListener actionListener;
    String helpAction = null;
    String helpText = "";
    private static final Cursor handCursor;
    private Cursor origCursor;

    public HelpActionLabel() {
        this.addActionListener(this);
        this.origCursor = this.getCursor();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                HelpActionLabel.this.setCursor(handCursor);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HelpActionLabel.this.setCursor(HelpActionLabel.this.origCursor);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public static void setActionListener(ActionListener actionListener) {
        HelpActionLabel.actionListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (actionListener != null && this.helpAction != null) {
            actionListener.actionPerformed(new ActionEvent(this, 0, this.helpAction));
        }
    }

    private void setStyle() {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setBackground(UIManager.getColor("EditorPane.background"));
        this.setForeground(Color.blue);
        this.invalidate();
    }

    private void setIconStyle() {
        this.setAlignmentY(this.getPreferredLabelAlignment());
        this.setStyle();
    }

    private void setTextStyle() {
        this.setAlignmentY(0.8f);
        this.setForeground(Color.blue);
        this.setStyle();
    }

    private float getPreferredLabelAlignment() {
        Icon icon = this.getIcon();
        String text = this.getText();
        Font font = this.getFont();
        FontMetrics fm = this.getToolkit().getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(this, fm, text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : ((BasicButtonUI)this.ui).getDefaultTextIconGap(this));
        Rectangle r = iconR.union(textR);
        Insets insets = this.getInsets();
        r.height += insets.top + insets.bottom;
        if (r.height % 2 == 0) {
            ++r.height;
        }
        float offAmt = fm.getMaxAscent() + insets.top;
        return offAmt / (float)r.height;
    }

    public void setHelpTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setHelpText(String s) {
        this.helpText = s;
        super.setText(s);
        this.setTextStyle();
    }

    public void setHelpIcon(String s) {
        this.setIconStyle();
        this.setIcon(GuiUtils.getImageIcon(s, this.getClass()));
    }

    public void setHelpAction(String value) {
        this.helpAction = value;
    }

    static {
        handCursor = Cursor.getPredefinedCursor(12);
    }
}

