/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.net.URL;
import java.util.List;
import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.UnsupportedOperationException;

public class Help {
    private static String defaultTopDir = null;
    private static Help defaultHelp = null;
    private static boolean debug = false;
    private String helpsetName;
    private HelpSet helpSet = null;
    private HelpBroker helpBroker = null;
    private boolean makeBroker = true;
    JHelp jHelp;

    public static Help getDefaultHelp() {
        if (defaultHelp == null) {
            defaultHelp = new Help();
        }
        return defaultHelp;
    }

    public static void setTopDir(String topDir) {
        if (!topDir.equals(defaultTopDir)) {
            defaultTopDir = topDir;
            defaultHelp = null;
            if (debug) {
                System.out.println("Help topDir changed to =" + topDir);
            }
        }
    }

    public Help() {
        this(defaultTopDir + "/HelpSet.hs", true);
    }

    public Help(String helpSetName, boolean makeBroker) {
        this.helpsetName = helpSetName;
        this.makeBroker = makeBroker;
    }

    private void makeHelp() {
        URL url = null;
        Class<?> cl = this.getClass();
        url = HelpSet.findHelpSet((ClassLoader)cl.getClassLoader(), (String)this.helpsetName);
        if (null == url) {
            try {
                url = cl.getResource(this.helpsetName);
            }
            catch (Exception ee) {
                System.out.println("HelpSet exception" + this.helpsetName + " not found");
                return;
            }
        }
        if (url == null) {
            System.out.println("HelpSet URL " + this.helpsetName + " not found");
            return;
        }
        if (debug) {
            System.out.println("URL ok " + url);
        }
        try {
            this.helpSet = new HelpSet(cl.getClassLoader(), url);
        }
        catch (HelpSetException ee) {
            System.out.println("API Help Set not found");
            return;
        }
        if (this.makeBroker) {
            this.helpBroker = this.helpSet.createHelpBroker();
        }
    }

    public JHelp getJHelp() {
        if (this.jHelp == null) {
            this.jHelp = new JHelp(this.helpSet);
        }
        return this.jHelp;
    }

    public boolean gotoTarget(List ids) {
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            if (id == null || !this.isValidID(id)) continue;
            this.gotoTarget(id, true);
            return true;
        }
        return false;
    }

    public void gotoTarget(String id) {
        this.gotoTarget(id, true);
    }

    public boolean isValidID(String id) {
        if (null == this.helpSet) {
            this.makeHelp();
        }
        if (null == this.helpSet) {
            return false;
        }
        return this.helpSet.getCombinedMap().isValidID(id, this.helpSet);
    }

    public void gotoTarget(String id, boolean setVisible) {
        if (null == this.helpSet) {
            this.makeHelp();
        }
        if (null == this.helpSet) {
            return;
        }
        try {
            if (this.helpBroker != null) {
                this.helpBroker.setCurrentID(id);
            }
            if (this.jHelp != null) {
                this.jHelp.setCurrentID(id);
            }
            if (debug) {
                System.out.println("Help Id set " + id);
            }
        }
        catch (BadIDException e) {
            System.out.println("Bad Help ID = " + id);
        }
        if (setVisible && this.helpBroker != null) {
            try {
                this.helpBroker.setDisplayed(true);
            }
            catch (UnsupportedOperationException e) {
                System.out.println("UnsupportedOperationException = " + (Object)((Object)e));
            }
        }
    }
}

