/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.GuiUtils;

public class GraphPaperLayout
implements LayoutManager2 {
    int hgap;
    int vgap;
    Dimension gridSize;
    Hashtable compTable;

    public GraphPaperLayout() {
        this(new Dimension(1, 1));
    }

    public GraphPaperLayout(Dimension gridSize) {
        this(gridSize, 0, 0);
    }

    public GraphPaperLayout(Dimension gridSize, int hgap, int vgap) {
        if (gridSize.width <= 0 || gridSize.height <= 0) {
            throw new IllegalArgumentException("dimensions must be greater than zero");
        }
        this.gridSize = new Dimension(gridSize);
        this.hgap = hgap;
        this.vgap = vgap;
        this.compTable = new Hashtable();
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setGridSize(Dimension d) {
        this.setGridSize(d.width, d.height);
    }

    public void setGridSize(int width, int height) {
        this.gridSize = new Dimension(width, height);
    }

    public void setConstraints(Component comp, Rectangle constraints) {
        this.compTable.put(comp, new Rectangle(constraints));
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.compTable.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    protected Dimension getLayoutSize(Container parent, boolean isPreferred) {
        Dimension largestSize = this.getLargestCellSize(parent, isPreferred);
        Insets insets = parent.getInsets();
        largestSize.width = largestSize.width * this.gridSize.width + this.hgap * (this.gridSize.width + 1) + insets.left + insets.right;
        largestSize.height = largestSize.height * this.gridSize.height + this.vgap * (this.gridSize.height + 1) + insets.top + insets.bottom;
        return largestSize;
    }

    protected Dimension getLargestCellSize(Container parent, boolean isPreferred) {
        int ncomponents = parent.getComponentCount();
        Dimension maxCellSize = new Dimension(0, 0);
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            Rectangle rect = (Rectangle)this.compTable.get(c);
            if (c == null || rect == null) continue;
            Dimension componentSize = isPreferred ? c.getPreferredSize() : c.getMinimumSize();
            maxCellSize.width = Math.max(maxCellSize.width, componentSize.width / rect.width);
            maxCellSize.height = Math.max(maxCellSize.height, componentSize.height / rect.height);
        }
        return maxCellSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            Dimension size = parent.getSize();
            int totalW = size.width - (insets.left + insets.right);
            int totalH = size.height - (insets.top + insets.bottom);
            int totalCellW = totalW / this.gridSize.width;
            int totalCellH = totalH / this.gridSize.height;
            int cellW = (totalW - (this.gridSize.width + 1) * this.hgap) / this.gridSize.width;
            int cellH = (totalH - (this.gridSize.height + 1) * this.vgap) / this.gridSize.height;
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                Rectangle rect = (Rectangle)this.compTable.get(c);
                if (rect == null) continue;
                int x = insets.left + totalCellW * rect.x + this.hgap;
                int y = insets.top + totalCellH * rect.y + this.vgap;
                int w = cellW * rect.width - this.hgap;
                int h = cellH * rect.height - this.vgap;
                c.setBounds(x, y, w, h);
            }
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraints;
            if (rect.width <= 0 || rect.height <= 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle must have positive width and height");
            }
            if (rect.x < 0 || rect.y < 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle x and y must be >= 0");
            }
            this.setConstraints(comp, rect);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a Rectangle");
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public static Dimension getDimensions(List locations) {
        Location l;
        int i;
        int maxCol = -1;
        int maxRow = -1;
        ArrayList<Location> nullComps = new ArrayList<Location>();
        for (i = 0; i < locations.size(); ++i) {
            l = (Location)locations.get(i);
            if (l.comp == null) continue;
            if (l.rect == null) {
                nullComps.add(l);
                continue;
            }
            maxCol = Math.max(maxCol, l.rect.x + (l.rect.width - 1));
            maxRow = Math.max(maxRow, l.rect.y + (l.rect.height - 1));
        }
        for (i = 0; i < nullComps.size(); ++i) {
            l = (Location)nullComps.get(i);
            l.rect = new Rectangle(0, ++maxRow, 1, 1);
        }
        return new Dimension(Math.max(1, maxCol + 1), Math.max(1, maxRow + 1));
    }

    public static JComponent layout(List locations) {
        Dimension dim = GraphPaperLayout.getDimensions(locations);
        JPanel panel = new JPanel(new GraphPaperLayout(dim));
        for (int i = 0; i < locations.size(); ++i) {
            Location l = (Location)locations.get(i);
            if (l.comp == null) continue;
            panel.add((Component)l.comp, l.rect);
        }
        return panel;
    }

    public static void showDialog(List locations, String title) {
        Dimension dim = GraphPaperLayout.getDimensions(locations);
        EditPanel editPanel = new EditPanel(dim.width, dim.height, locations);
        GuiUtils.showOkCancelDialog(null, title, editPanel.getContents(), null);
    }

    public static void main(String[] args) {
        EditPanel editPanel = new EditPanel(4, 3, null);
        JFrame f = new JFrame();
        f.getContentPane().add(editPanel.getContents());
        f.pack();
        f.setLocation(100, 100);
        f.setVisible(true);
    }

    public static class EditPanel
    implements MouseListener,
    MouseMotionListener {
        public static final String DRAG_LEFT = "LEFT";
        public static final String DRAG_RIGHT = "RIGHT";
        public static final String DRAG_TOP = "TOP";
        public static final String DRAG_BOTTOM = "BOTTOM";
        public static final Cursor MOVE_CURSOR = new Cursor(13);
        public static final Cursor DEFAULT_CURSOR = new Cursor(0);
        private int cols;
        private int rows;
        private List locations = new ArrayList();
        private JComponent contents;
        private JPanel paintPanel;
        private Location currentLocation;
        private String dragPoint;

        public EditPanel(int cols, int rows, List locs) {
            this.cols = cols;
            this.rows = rows;
            this.locations = locs;
            if (this.locations == null) {
                this.locations = new ArrayList();
                this.locations.add(new Location(new JButton("Button"), "The button", 0, 0, 2, 1));
                this.locations.add(new Location(new JTextField(" hello there"), "The field", 0, 1, 1, 1));
            }
            this.paintPanel = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.paintComponent(g);
                }

                @Override
                public void update(Graphics g) {
                    this.paintComponent(g);
                }
            };
            this.paintPanel.setPreferredSize(new Dimension(300, 300));
            this.paintPanel.setBackground(Color.white);
            this.paintPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.paintPanel.addMouseListener(this);
            this.paintPanel.addMouseMotionListener(this);
            this.contents = GuiUtils.centerRight(this.paintPanel, GuiUtils.top(GuiUtils.hbox((Component)new JLabel("Columns: "), (Component)this.makeButton("+", true, 1), this.makeButton("-", true, -1))));
            this.contents = GuiUtils.centerBottom(this.contents, GuiUtils.left(GuiUtils.hbox((Component)new JLabel("Rows: "), (Component)this.makeButton("+", false, 1), this.makeButton("-", false, -1))));
            this.contents = GuiUtils.inset((Component)this.contents, 5);
            if (cols == 0) {
                cols = 1;
            }
            if (rows == 0) {
                rows = 1;
            }
        }

        private JButton makeButton(String lbl, boolean forCol, int delta) {
            String method = forCol ? "deltaColumn" : "deltaRow";
            JButton btn = GuiUtils.makeButton(lbl, this, method, new Integer(delta));
            if (forCol) {
                btn.setToolTipText((delta > 0 ? "Add" : "Remove") + " a column");
            } else {
                btn.setToolTipText((delta > 0 ? "Add" : "Remove") + " a row");
            }
            btn.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            Font f = btn.getFont();
            btn.setFont(f.deriveFont((float)(f.getSize() + 2)));
            return btn;
        }

        public void deltaColumn(Integer i) {
            this.cols = Math.max(1, this.cols + i);
            this.contents.repaint();
        }

        public void deltaRow(Integer i) {
            this.rows = Math.max(1, this.rows + i);
            this.contents.repaint();
        }

        public JComponent getContents() {
            return this.contents;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.currentLocation == null) {
                return;
            }
            int col = this.xToColumn(e.getX());
            int row = this.yToRow(e.getY());
            if (this.dragPoint == null) {
                this.currentLocation.rect.x = col;
                this.currentLocation.rect.y = row;
            } else if (this.dragPoint.equals(DRAG_LEFT)) {
                int dcol = col - this.currentLocation.rect.x;
                this.currentLocation.rect.x = col;
                this.currentLocation.rect.width = Math.max(1, this.currentLocation.rect.width - dcol);
            } else if (this.dragPoint.equals(DRAG_RIGHT)) {
                int dcol = col - (this.currentLocation.rect.x + (this.currentLocation.rect.width - 1));
                this.currentLocation.rect.width = Math.max(1, this.currentLocation.rect.width + dcol);
            } else if (this.dragPoint.equals(DRAG_TOP)) {
                int drow = row - this.currentLocation.rect.y;
                this.currentLocation.rect.y = row;
                this.currentLocation.rect.height = Math.max(1, this.currentLocation.rect.height - drow);
            } else if (this.dragPoint.equals(DRAG_BOTTOM)) {
                int drow = row - (this.currentLocation.rect.y + (this.currentLocation.rect.height - 1));
                this.currentLocation.rect.height = Math.max(1, this.currentLocation.rect.height + drow);
            }
            this.paintPanel.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.currentLocation = null;
            this.paintPanel.repaint();
            this.paintPanel.setCursor(DEFAULT_CURSOR);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            double max = 5.0;
            this.currentLocation = null;
            this.dragPoint = null;
            for (int i = this.locations.size() - 1; i >= 0; --i) {
                Location location;
                this.currentLocation = location = (Location)this.locations.get(i);
                Rectangle r = location.displayRectangle;
                if (GuiUtils.distance(r.x, r.y + r.height / 2, x, y) < max) {
                    this.dragPoint = DRAG_LEFT;
                    this.paintPanel.setCursor(new Cursor(10));
                    return;
                }
                if (GuiUtils.distance(r.x + r.width, r.y + r.height / 2, x, y) < max) {
                    this.dragPoint = DRAG_RIGHT;
                    this.paintPanel.setCursor(new Cursor(11));
                    return;
                }
                if (GuiUtils.distance(r.x + r.width / 2, r.y, x, y) < max) {
                    this.dragPoint = DRAG_TOP;
                    this.paintPanel.setCursor(new Cursor(8));
                    return;
                }
                if (GuiUtils.distance(r.x + r.width / 2, r.y + r.height, x, y) < max) {
                    this.dragPoint = DRAG_BOTTOM;
                    this.paintPanel.setCursor(new Cursor(9));
                    return;
                }
                if (!r.contains(e.getX(), e.getY())) continue;
                this.currentLocation = location;
                this.paintPanel.setCursor(MOVE_CURSOR);
                return;
            }
            this.currentLocation = null;
        }

        private int xToColumn(int x) {
            Rectangle b = this.paintPanel.getBounds();
            int colWidth = b.width / this.cols;
            return Math.min(Math.max(0, x / colWidth), this.cols - 1);
        }

        private int yToRow(int y) {
            Rectangle b = this.paintPanel.getBounds();
            int rowHeight = b.height / this.rows;
            return Math.min(Math.max(0, y / rowHeight), this.rows - 1);
        }

        public void paintComponent(Graphics g) {
            int i;
            Rectangle b = this.paintPanel.getBounds();
            int width = b.width;
            int height = b.height;
            int off = 4;
            int off2 = 8;
            int colWidth = width / this.cols;
            int rowHeight = height / this.rows;
            g.setColor(Color.gray);
            for (i = 0; i < this.cols - 1; ++i) {
                int x = colWidth * (i + 1);
                g.drawLine(x, 0, x, b.height);
            }
            for (i = 0; i < this.rows - 1; ++i) {
                int y = rowHeight * (i + 1);
                g.drawLine(0, y, b.width, y);
            }
            if (this.currentLocation != null) {
                this.locations.remove(this.currentLocation);
                this.locations.add(this.currentLocation);
            }
            Color c = Color.lightGray;
            for (int i2 = 0; i2 < this.locations.size(); ++i2) {
                Location location = (Location)this.locations.get(i2);
                Rectangle r = location.rect;
                int col = r.x;
                int row = r.y;
                int left = col * colWidth + off;
                int right = left + r.width * colWidth - off2;
                int top = row * rowHeight + off;
                int bottom = top + r.height * rowHeight - off2;
                int w = right - left;
                int h = bottom - top;
                if (location == this.currentLocation) {
                    g.setColor(Color.black);
                    g.drawRect(left, top, right - left, bottom - top);
                } else {
                    g.setColor(c);
                    g.fillRect(left, top, right - left, bottom - top);
                }
                g.setColor(Color.black);
                location.displayRectangle = new Rectangle(left, top, right - left, bottom - top);
                String s = location.getLabel();
                if (location.image != null) {
                    g.drawImage(location.image, left, top, w, h, null, null);
                }
                g.fillRect(left + w / 2 - 2, top - 2, 4, 4);
                g.fillRect(left + w / 2 - 2, bottom - 2, 4, 4);
                g.fillRect(left - 2, top + h / 2 - 2, 4, 4);
                g.fillRect(right - 2, top + h / 2 - 2, 4, 4);
                if (s == null) continue;
                FontMetrics fm = g.getFontMetrics();
                while (s.length() > 0 && fm.stringWidth(s) > w - 4 - 9) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.length() <= 0) continue;
                int sh = fm.getMaxDescent() + fm.getMaxAscent();
                int sx = left + 5;
                int sy = top + 5 + sh;
                if (location.image != null) {
                    g.setColor(Color.white);
                    g.fillRect(sx - 1, sy - sh - 1, fm.stringWidth(s) + 2, sh + 2);
                    g.setColor(Color.black);
                    g.drawRect(sx - 1, sy - sh - 1, fm.stringWidth(s) + 2, sh + 2);
                }
                g.setColor(Color.black);
                g.drawString(s, sx, sy);
            }
        }
    }

    public static class Location {
        Rectangle rect;
        Rectangle displayRectangle;
        JComponent comp;
        String label;
        Image image;
        Object object;

        public Location(JComponent comp, Object object, String label) {
            this.comp = comp;
            this.object = object;
            this.label = label;
            if (comp != null) {
                try {
                    this.image = ImageUtils.getImage(comp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Location(JComponent comp, Object object, String label, Rectangle rect) {
            this(comp, object, label);
            this.rect = rect;
        }

        public Location(JComponent comp, String label, int x, int y, int width, int height) {
            this(comp, null, label, new Rectangle(x, y, width, height));
        }

        public Location(JComponent comp, int x, int y) {
            this(comp, null, "", new Rectangle(x, y, 1, 1));
        }

        public String getLabel() {
            return this.label;
        }

        public JComponent getComponent() {
            return this.comp;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

