/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.awt.Frame;
import ucar.unidata.ui.AnimatedGifEncoder;

class Gif_Stack_Writer
implements PlugIn {
    static String type = "gif";

    Gif_Stack_Writer() {
    }

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.showMessage((String)"Save As ", (String)"No images are open.");
            return;
        }
        String name = imp.getTitle();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        GenericDialog gd = new GenericDialog("Animated Gif Writer", (Frame)IJ.getInstance());
        boolean options = false;
        gd.addStringField("Name:", name, 12);
        gd.addCheckbox("Check for options", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        name = gd.getNextString();
        options = gd.getNextBoolean();
        IJ.register(Gif_Stack_Writer.class);
        SaveDialog sd = new SaveDialog("Save as " + type, name + "." + type, "." + type);
        String file = sd.getFileName();
        if (file == null) {
            return;
        }
        String directory = sd.getDirectory();
        ImageStack stack = imp.getStack();
        ImagePlus tmp = new ImagePlus();
        int nSlices = stack.getSize();
        AnimatedGifEncoder fr = new AnimatedGifEncoder();
        if (options) {
            fr.setoptions();
        }
        fr.start(directory + file);
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus((String)("writing: " + i + "/" + nSlices));
            IJ.showProgress((double)((double)i / (double)nSlices));
            tmp.setProcessor(null, stack.getProcessor(i));
            try {
                fr.addFrame(tmp);
            }
            catch (Exception e) {
                IJ.showMessage((String)("Save as " + type), (String)("" + e));
            }
            System.gc();
        }
        fr.finish();
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
    }
}

