/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.unidata.ui.ChooserList;
import ucar.unidata.util.GuiUtils;

public class FontSelector
implements ItemListener,
ListSelectionListener {
    public static final int COMBOBOX_UI = 0;
    public static final int LIST_UI = 1;
    public static final String[] styles = new String[]{"Plain", "Bold", "Italic", "Bold & Italic"};
    public static final String DEFAULT_NAME = "Default";
    public static final Font DEFAULT_FONT = new Font(null, 0, 12);
    private static final String MAX_TEXT = "XXXXXXXXXXXXXXXXXXX";
    private int uiType = 0;
    private boolean showLabels;
    private boolean showSample;
    private JComponent component;
    private String fontChoice;
    private int sizeChoice;
    private int styleChoice;
    private FontPanel sample;
    private JComponent fontSelector;
    private JComponent styleSelector;
    private JComponent sizeSelector;

    public FontSelector() {
        this(0, true, false);
    }

    public FontSelector(int uiType, boolean showLabels, boolean showSample) {
        ChooserList list;
        this.uiType = uiType;
        this.showLabels = showLabels;
        this.showSample = showSample;
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        Vector<String> fonts = new Vector<String>();
        for (int i = 1; i < envfonts.length; ++i) {
            fonts.addElement(envfonts[i]);
        }
        if (!fonts.contains(DEFAULT_NAME)) {
            fonts.insertElementAt(DEFAULT_NAME, 0);
        }
        if (uiType == 0) {
            JComboBox box = new JComboBox(fonts);
            box.setMaximumRowCount(9);
            Dimension d = box.getPreferredSize();
            int width = 6 * d.height;
            GuiUtils.setPreferredWidth(box, Math.min(d.width, width));
            box.addItemListener(this);
            this.fontSelector = box;
        } else {
            list = new ChooserList();
            list.setListData(fonts);
            list.addListSelectionListener(this);
            this.fontSelector = list;
        }
        Vector sizes = GuiUtils.getFontSizeList();
        if (uiType == 0) {
            JComboBox box = new JComboBox(sizes);
            box.setMaximumRowCount(9);
            box.addItemListener(this);
            this.sizeSelector = box;
        } else {
            list = new ChooserList();
            list.setListData(sizes);
            list.addListSelectionListener(this);
            this.sizeSelector = list;
        }
        if (uiType == 0) {
            JComboBox<String> box = new JComboBox<String>(styles);
            box.setMaximumRowCount(9);
            box.addItemListener(this);
            this.styleSelector = box;
        } else {
            list = new ChooserList();
            list.setListData(styles);
            list.addListSelectionListener(this);
            this.styleSelector = list;
        }
        this.sample = new FontPanel();
        this.sample.setBackground(Color.white);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        if (showLabels) {
            comps.add(new JLabel("Font:"));
            comps.add(new JLabel("Style:"));
            comps.add(new JLabel("Size:"));
        }
        if (uiType == 0) {
            comps.add(this.fontSelector);
            comps.add(this.styleSelector);
            comps.add(this.sizeSelector);
        } else {
            comps.add(((ChooserList)this.fontSelector).getScroller());
            comps.add(((ChooserList)this.styleSelector).getScroller());
            comps.add(((ChooserList)this.sizeSelector).getScroller());
        }
        this.component = GuiUtils.doLayout(comps, 3, GuiUtils.WT_YNN, GuiUtils.WT_N);
        if (showSample) {
            this.component = GuiUtils.topCenter(this.component, this.sample);
        }
    }

    public void setFontName(String fontName) {
        if (!fontName.equals(this.fontChoice)) {
            if (this.uiType == 0) {
                ((JComboBox)this.fontSelector).setSelectedItem(fontName);
            } else {
                ((JList)this.fontSelector).setSelectedValue(fontName, true);
            }
            this.fontChoice = fontName;
        }
    }

    public void setFontStyle(int fontStyle) {
        if (this.styleChoice != fontStyle) {
            if (this.uiType == 0) {
                ((JComboBox)this.styleSelector).setSelectedIndex(fontStyle);
            } else {
                ((JList)this.styleSelector).setSelectedIndex(fontStyle);
            }
            this.styleChoice = fontStyle;
        }
    }

    public void setFontSize(int fontSize) {
        if (this.sizeChoice != fontSize) {
            if (this.uiType == 0) {
                ((JComboBox)this.sizeSelector).setSelectedItem(new Integer(fontSize));
            } else {
                ((JList)this.sizeSelector).setSelectedValue(new Integer(fontSize), true);
            }
            this.sizeChoice = fontSize;
        }
    }

    public String getFontName() {
        return this.fontChoice;
    }

    public int getFontStyle() {
        return this.styleChoice;
    }

    public int getFontSize() {
        return this.sizeChoice;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Font getFont() {
        return new Font(this.fontChoice, this.styleChoice, this.sizeChoice);
    }

    public void setFont(Font f) {
        String name;
        if (f == null) {
            f = DEFAULT_FONT;
        }
        if (!(name = f.getName()).equals(DEFAULT_NAME)) {
            name = f.getFamily();
        }
        this.setFontName(name);
        this.setFontStyle(f.getStyle());
        this.setFontSize(f.getSize());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object list = e.getSource();
        if (list == this.fontSelector) {
            this.fontChoice = (String)((JComboBox)this.fontSelector).getSelectedItem();
        } else if (list == this.styleSelector) {
            String style = (String)((JComboBox)this.styleSelector).getSelectedItem();
            for (int i = 0; i < styles.length; ++i) {
                if (!style.equals(styles[i])) continue;
                this.styleChoice = i;
                break;
            }
        } else {
            this.sizeChoice = (Integer)((JComboBox)this.sizeSelector).getSelectedItem();
        }
        this.sample.changeFont(this.fontChoice, this.styleChoice, this.sizeChoice);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object list = e.getSource();
        if (list == this.fontSelector) {
            this.fontChoice = (String)((JList)this.fontSelector).getSelectedValue();
        } else if (list == this.styleSelector) {
            String style = (String)((JList)this.styleSelector).getSelectedValue();
            for (int i = 0; i < styles.length; ++i) {
                if (!style.equals(styles[i])) continue;
                this.styleChoice = i;
                break;
            }
        } else {
            this.sizeChoice = (Integer)((JList)this.sizeSelector).getSelectedValue();
        }
        this.sample.changeFont(this.fontChoice, this.styleChoice, this.sizeChoice);
    }

    public static void main(String[] s) {
        JFrame f = new JFrame("FontSelection");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        FontSelector fontSelection = new FontSelector();
        f.getContentPane().add((Component)fontSelection.getComponent(), "Center");
        fontSelection.setFont(DEFAULT_FONT);
        f.pack();
        f.setVisible(true);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.sample.addPropertyChangeListener("font", l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.sample.removePropertyChangeListener(l);
    }

    class FontPanel
    extends JPanel {
        Font thisFont = DEFAULT_FONT;

        public void changeFont(String f, int st, int si) {
            Integer newSize = new Integer(si);
            int size = newSize;
            this.thisFont = new Font(f, st, size);
            this.setFont(this.thisFont);
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setColor(Color.darkGray);
            g2.setFont(this.thisFont);
            String change = "Sample Text";
            FontMetrics metrics = g2.getFontMetrics();
            int width = metrics.stringWidth(change);
            int height = metrics.getHeight();
            g2.drawString(change, w / 2 - width / 2, h / 2 - height / 2);
        }
    }
}

