/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.ui.ObjectFlavor;

public class DropPanel
extends JPanel
implements DropTargetListener {
    private DropTarget dropTarget;
    private boolean doBorder;

    public DropPanel() {
        this((JComponent)null);
    }

    public DropPanel(JComponent comp) {
        this(comp, true);
    }

    public DropPanel(JComponent comp, boolean doBorder) {
        super(new BorderLayout());
        this.doBorder = doBorder;
        if (doBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.dropTarget = new DropTarget(this, this);
        if (comp != null) {
            this.add("Center", comp);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors.length == 0 || !(flavors[0] instanceof ObjectFlavor)) {
            return;
        }
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.doBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
        Object object = this.getObject(dtde.getCurrentDataFlavors());
        if (object == null) {
            return;
        }
        if (this.okToDrop(object) && this.doBorder) {
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.blue));
        }
    }

    private Object getObject(DataFlavor[] flavors) {
        if (flavors == null || flavors.length == 0 || !(flavors[0] instanceof ObjectFlavor)) {
            return null;
        }
        Object object = ((ObjectFlavor)flavors[0]).getObject();
        return object;
    }

    public boolean okToDrop(Object object) {
        return false;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.doBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        dtde.acceptDrop(3);
        Object object = this.getObject(dtde.getCurrentDataFlavors());
        if (!this.okToDrop(object)) {
            return;
        }
        if (object == null) {
            return;
        }
        this.handleDrop(object);
    }

    public void handleDrop(Object object) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

