/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DndTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DefaultMutableTreeNode sourceNode;
    private DefaultMutableTreeNode overNode;
    private Point dragPoint;
    private DragSource dragSource;
    private DropTarget dropTarget;

    public DndTree() {
        this.init();
    }

    public DndTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    private void init() {
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    protected boolean okToDrag(DefaultMutableTreeNode sourceNode) {
        return true;
    }

    protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean onNode) {
        return this.okToDrop(sourceNode, destNode);
    }

    protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
        return true;
    }

    protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean onNode) {
        this.doDrop(sourceNode, destNode);
    }

    protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        this.sourceNode = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
        if (this.sourceNode == null) {
            return;
        }
        if (!this.okToDrag(this.sourceNode)) {
            this.sourceNode = null;
            return;
        }
        TreeTransferable transferable = new TreeTransferable(this, this.sourceNode);
        Cursor cursor = this.selectCursor(e.getDragAction());
        this.dragSource.startDrag(e, cursor, transferable, this);
    }

    protected Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors.length == 0 || !(flavors[0] instanceof TreeFlavor)) {
            return;
        }
        if (((TreeFlavor)flavors[0]).tree != this) {
            return;
        }
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.overNode = null;
        this.dragPoint = null;
        this.clearSelection();
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        DefaultMutableTreeNode destNode;
        if (this.sourceNode == null) {
            return;
        }
        Point dropPoint = dtde.getLocation();
        TreePath dropPath = this.getClosestPathForLocation(dropPoint.x, dropPoint.y);
        this.overNode = destNode = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
        this.dragPoint = dropPoint;
        this.clearSelection();
        if (destNode == this.sourceNode) {
            destNode = null;
        }
        if (destNode != null) {
            boolean on = this.isOn(dropPoint, destNode);
            if (!this.okToDrop(this.sourceNode, destNode, on)) {
                destNode = null;
            } else if (on) {
                this.setSelectionPath(new TreePath(this.overNode.getPath()));
            }
        }
        if (destNode == null) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(3);
        }
        this.repaint();
    }

    private boolean isOn(Point dropPoint, DefaultMutableTreeNode node) {
        int row = this.getRowForLocation(dropPoint.x, dropPoint.y);
        Rectangle bounds = this.getRowBounds(row);
        if (bounds == null) {
            return false;
        }
        int delta = (int)((double)bounds.height * 0.25);
        return dropPoint.y >= bounds.y + delta && dropPoint.y <= bounds.y + bounds.height - delta;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.sourceNode == null) {
            return;
        }
        dtde.acceptDrop(3);
        Point dropPoint = dtde.getLocation();
        TreePath dropPath = this.getClosestPathForLocation(dropPoint.x, dropPoint.y);
        DefaultMutableTreeNode destNode = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
        boolean on = false;
        if (destNode != null && !this.okToDrop(this.sourceNode, destNode, on = this.isOn(dropPoint, destNode))) {
            destNode = null;
        }
        this.clearSelection();
        if (destNode != null) {
            int row = this.getRowForPath(new TreePath(this.overNode.getPath()));
            this.doDrop(this.sourceNode, destNode, on);
        }
        dtde.getDropTargetContext().dropComplete(true);
        this.overNode = null;
        this.sourceNode = null;
        this.dragPoint = null;
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.overNode != null) {
            int row = this.getRowForPath(new TreePath(this.overNode.getPath()));
            Rectangle b = this.getRowBounds(row);
            if (b != null) {
                g.setColor(Color.black);
                g.drawLine(b.x, b.y + b.height - 1, b.x + 40, b.y + b.height - 1);
                g.drawLine(b.x, b.y + b.height, b.x + 40, b.y + b.height);
            }
            if (this.dragPoint != null && this.sourceNode != null) {
                String text = this.sourceNode.toString();
                row = this.getRowForPath(new TreePath(this.sourceNode.getPath()));
                b = this.getRowBounds(row);
                g.setColor(Color.gray);
                g.drawRect(b.x, b.y, b.width, b.height);
            }
        }
    }

    private static class TreeFlavor
    extends DataFlavor {
        DndTree tree;

        public TreeFlavor(DndTree tree) {
            super(DndTree.class, "DndTree");
            this.tree = tree;
        }
    }

    public static class TreeTransferable
    implements Transferable {
        DndTree tree;
        DefaultMutableTreeNode treeNode;

        public TreeTransferable(DndTree tree, DefaultMutableTreeNode treeNode) {
            this.tree = tree;
            this.treeNode = treeNode;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this.treeNode;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{new TreeFlavor(this.tree)};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }
    }
}

