/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JLabel;
import ucar.unidata.ui.ObjectFlavor;
import ucar.unidata.util.GuiUtils;

public class DndImageButton
extends JLabel
implements DragSourceListener,
DragGestureListener,
Transferable {
    DragSource dragSource = null;
    Object data;
    String mimeType;
    private static String iconName = "/ucar/unidata/ui/images/dnd.gif";

    public DndImageButton(String label, Object data, String mimeType) {
        super(label);
        this.init(data, mimeType);
    }

    public DndImageButton(Object data, String mimeType) {
        this(data, mimeType, iconName);
    }

    public DndImageButton(Object data, String mimeType, String icon) {
        super(GuiUtils.getImageIcon(icon, false));
        this.init(data, mimeType);
    }

    private void init(Object data, String mimeType) {
        this.mimeType = mimeType;
        this.data = data;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.setToolTipText("Click to drag-and-drop");
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, this, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        return this.data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{new ObjectFlavor(this.data)};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return true;
    }
}

