/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import ucar.unidata.util.GuiUtils;

public class DateTimePicker
extends JPanel {
    private static TimeZone defaultTimeZone;
    SpinnerDateModel datetimeModel;

    public DateTimePicker() {
        this((Date)null, true);
    }

    public DateTimePicker(Date date) {
        this(date, true);
    }

    public DateTimePicker(Date date, boolean includeHours) {
        Calendar calendar = this.getCalendar(null);
        this.setLayout(new BorderLayout());
        this.datetimeModel = new SpinnerDateModel(calendar.getTime(), null, null, 11);
        JSpinner spinner = new JSpinner(this.datetimeModel);
        JSpinner.DateEditor editor = includeHours ? new JSpinner.DateEditor(spinner, "yyyy-MM-dd HH:mm") : new JSpinner.DateEditor(spinner, "yyyy-MM-dd");
        spinner.setEditor(editor);
        SimpleDateFormat format = ((JSpinner.DateEditor)spinner.getEditor()).getFormat();
        format.setTimeZone(TimeZone.getTimeZone(TimeZone.getTimeZone("GMT").getID()));
        JPanel timeComp = GuiUtils.hbox((Component)spinner, (Component)new JLabel(" " + DateTimePicker.getDefaultTimeZone().getID()), 5);
        this.add("Center", timeComp);
        if (date != null) {
            this.setDate(date);
        }
    }

    public static void setDefaultTimeZone(TimeZone timeZone) {
        defaultTimeZone = timeZone;
    }

    public static TimeZone getDefaultTimeZone() {
        if (defaultTimeZone == null) {
            defaultTimeZone = TimeZone.getTimeZone("GMT");
        }
        return defaultTimeZone;
    }

    public Date getDate() {
        Date d = this.datetimeModel.getDate();
        Calendar c0 = this.getCalendar(d);
        GregorianCalendar c1 = new GregorianCalendar(c0.get(1), c0.get(2), c0.get(5));
        if (this.datetimeModel != null) {
            Date time = this.datetimeModel.getDate();
            Calendar timeCal = this.getCalendar(time);
            c1.set(11, timeCal.get(11));
            c1.set(12, timeCal.get(12));
            c1.set(13, timeCal.get(13));
        }
        return c1.getTime();
    }

    private Calendar getCalendar(Date d) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (d != null) {
            calendar.setTime(d);
        }
        return calendar;
    }

    public void setDate(Date d) {
        this.datetimeModel.setValue(d);
    }
}

