/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.ui.DateTimePicker;
import ucar.unidata.ui.TimeLengthField;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public class DateSelectionGui
extends JPanel {
    private TimeLengthField intervalField;
    private TimeLengthField preRangeField;
    private TimeLengthField postRangeField;
    private TimeLengthField startOffsetField;
    private TimeLengthField endOffsetField;
    private TimeLengthField roundToField;
    private JComboBox startModeBox;
    private JComboBox endModeBox;
    private DateTimePicker startTimePicker;
    private DateTimePicker endTimePicker;
    private DateSelection dateSelection;
    private JTextField countFld;
    private JTextField skipFld;

    public DateSelectionGui(DateSelection dateSelection) {
        this.dateSelection = dateSelection;
        this.init();
    }

    public void setDateSelection(DateSelection dateSelection) {
        this.dateSelection = dateSelection;
        this.updateWidgets();
    }

    public void enableWidgets() {
        this.startTimePicker.setEnabled(GuiUtils.getValueFromBox(this.startModeBox) == 0);
        this.endTimePicker.setEnabled(GuiUtils.getValueFromBox(this.endModeBox) == 0);
    }

    private void init() {
        this.skipFld = new JTextField("", 4);
        this.countFld = new JTextField("", 4);
        this.startTimePicker = new DateTimePicker();
        this.endTimePicker = new DateTimePicker();
        this.intervalField = new TimeLengthField("Interval");
        this.startOffsetField = new TimeLengthField("Start Offset");
        this.endOffsetField = new TimeLengthField("Start Offset");
        this.preRangeField = new TimeLengthField("Before Range");
        this.postRangeField = new TimeLengthField("After Range");
        this.startModeBox = GuiUtils.makeComboBox(DateSelection.TIMEMODES, DateSelection.STARTMODELABELS, this.dateSelection.getStartMode());
        this.endModeBox = GuiUtils.makeComboBox(DateSelection.TIMEMODES, DateSelection.ENDMODELABELS, this.dateSelection.getEndMode());
        this.startOffsetField = new TimeLengthField("Start Offset");
        this.endOffsetField = new TimeLengthField("End Offset");
        JPanel startExtra = GuiUtils.wrap(this.startTimePicker);
        Component[] comps = new Component[]{GuiUtils.left(this.startModeBox), GuiUtils.hbox(new JLabel("Offset:"), this.startOffsetField.getContents()), startExtra};
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel startPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel endExtra = GuiUtils.wrap(this.endTimePicker);
        comps = new Component[]{GuiUtils.left(this.endModeBox), GuiUtils.hbox(new JLabel("Offset:"), this.endOffsetField.getContents()), endExtra};
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel endPanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        comps = new Component[]{GuiUtils.rLabel("Start Time:"), GuiUtils.left(startPanel), GuiUtils.rLabel("End Time:"), GuiUtils.left(endPanel), GuiUtils.rLabel("Interval:"), GuiUtils.left(GuiUtils.rowGrid(new Component[]{GuiUtils.cLabel("Before"), GuiUtils.cLabel("Center"), GuiUtils.cLabel("After"), this.preRangeField.getContents(), this.intervalField.getContents(), this.postRangeField.getContents()}, 2)), GuiUtils.rLabel("Max Count:"), GuiUtils.left(GuiUtils.hbox((Component)this.countFld, (Component)GuiUtils.filler(10, 5), (Component)GuiUtils.lLabel("Skip: "), GuiUtils.left(this.skipFld)))};
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        this.setLayout(new BorderLayout());
        this.add("Center", contents);
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.skipFld.setText(this.dateSelection.getSkip() + "");
        if (this.dateSelection.hasCount()) {
            this.countFld.setText(this.dateSelection.getCount() + "");
        } else {
            this.countFld.setText("");
        }
        this.intervalField.setTime(DateUtil.millisToMinutes(this.dateSelection.getInterval()));
        this.preRangeField.setTime(DateUtil.millisToMinutes(this.dateSelection.getPreRange()));
        this.postRangeField.setTime(DateUtil.millisToMinutes(this.dateSelection.getPostRange()));
        GuiUtils.setValueOfBox(this.startModeBox, this.dateSelection.getStartMode(), DateSelection.TIMEMODES, DateSelection.STARTMODELABELS);
        GuiUtils.setValueOfBox(this.endModeBox, this.dateSelection.getEndMode(), DateSelection.TIMEMODES, DateSelection.ENDMODELABELS);
        this.startOffsetField.setTime(DateUtil.millisToMinutes(this.dateSelection.getStartOffset()));
        this.endOffsetField.setTime(DateUtil.millisToMinutes(this.dateSelection.getEndOffset()));
        this.startTimePicker.setDate(this.dateSelection.getStartFixedDate());
        this.endTimePicker.setDate(this.dateSelection.getEndFixedDate());
        this.enableWidgets();
    }

    public boolean applyProperties() {
        if (GuiUtils.getValueFromBox(this.startModeBox) == GuiUtils.getValueFromBox(this.endModeBox) && GuiUtils.getValueFromBox(this.startModeBox) == 2) {
            LogUtil.userErrorMessage("The start and end modes cannot both be relative");
            return false;
        }
        double interval = this.intervalField.getTime();
        if (this.countFld.getText().trim().length() == 0) {
            this.dateSelection.setCount(Integer.MAX_VALUE);
        } else {
            this.dateSelection.setCount(new Integer(this.countFld.getText().trim()));
        }
        this.dateSelection.setSkip(new Integer(this.skipFld.getText().trim()));
        if (interval != interval) {
            this.dateSelection.setInterval(0.0);
        } else {
            this.dateSelection.setInterval(DateUtil.minutesToMillis(interval));
        }
        double preRange = this.preRangeField.getTime();
        if (preRange != preRange) {
            this.dateSelection.setPreRange(Double.NaN);
        } else {
            this.dateSelection.setPreRange(DateUtil.minutesToMillis(preRange));
        }
        double postRange = this.postRangeField.getTime();
        if (postRange != postRange) {
            this.dateSelection.setPostRange(Double.NaN);
        } else {
            this.dateSelection.setPostRange(DateUtil.minutesToMillis(postRange));
        }
        this.dateSelection.setStartFixedTime(this.startTimePicker.getDate());
        this.dateSelection.setEndFixedTime(this.endTimePicker.getDate());
        this.dateSelection.setStartOffset(DateUtil.minutesToMillis(this.startOffsetField.getTime()));
        this.dateSelection.setEndOffset(DateUtil.minutesToMillis(this.endOffsetField.getTime()));
        this.dateSelection.setStartMode(GuiUtils.getValueFromBox(this.startModeBox));
        this.dateSelection.setEndMode(GuiUtils.getValueFromBox(this.endModeBox));
        return true;
    }
}

