/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.ui.XmlUi;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.station.StationLocationMap;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlUtil;
import visad.CommonUnit;

public class DatasetUI {
    public static final String NULL_STRING = null;
    public static final String TAG_DATACHOICESET = "datachoiceSet";
    public static final String TAG_INTERFACES = "interfaces";
    public static final String TAG_INTERFACE = "interface";
    public static final String TAG_FIELD = "field";
    public static final String TAG_CHOICE = "choice";
    public static final String TAG_STATION = "station";
    public static final String TAG_URL = "url";
    public static final String TAG_CLIENT = "client";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_ALT = "alt";
    public static final String ATTR_LAT = "lat";
    public static final String ATTR_LON = "lon";
    public static final String ATTR_MAP = "map";
    public static final String ATTR_REQUIRED = "required";
    public static final String ATTR_URL = "url";
    public static final String ATTR_CLIENT = "client";
    public static final String ATTR_ID = "id";
    public static final String ATTR_SELECT = "select";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_COLS = "cols";
    public static final String ATTR_TYPE = "type";
    public static final String SELECT_ONE = "one";
    public static final String SELECT_MANY = "many";
    public static final String SELECT_RANGE = "range";
    public static final String TAG_SELECTIONS = "selections";
    public static final String TAG_QUERY = "query";
    public static final String TAG_SEL_LABEL = "selectLabel";
    public static final String TAG_SEL_BOOLEAN = "selectBoolean";
    public static final String TAG_SEL_LIST = "selectList";
    public static final String TAG_SEL_MENU = "selectMenu";
    public static final String TAG_SEL_NUMBER = "selectNumber";
    public static final String TAG_SEL_RADIO = "selectRadio";
    public static final String TAG_SEL_TEXT = "selectText";
    public static final String TAG_SEL_STATIONS = "selectStations";
    private ActionListener actionListener;
    private Element root;
    private JPanel contents;
    private String actionTemplate;
    private List widgets = new ArrayList();
    private Hashtable widgetToNode = new Hashtable();
    private XmlUi xmlUi;
    private List selectComponents = new ArrayList();

    public DatasetUI(Element root, ActionListener actionListener) {
        this.root = root;
        this.actionListener = actionListener;
        this.init();
    }

    private StringBuffer processSelections(Element selectionsNode) {
        StringBuffer uiXml = new StringBuffer();
        uiXml.append("<panel layout=\"gridbag\" colwidths=\"0,1\" >\n");
        NodeList children = XmlUtil.getElements(selectionsNode);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            String tag = child.getTagName();
            String id = XmlUtil.getAttribute(child, ATTR_ID);
            String label = XmlUtil.getAttribute((Node)child, ATTR_LABEL, id);
            Component comp = null;
            if (tag.equals(TAG_SEL_MENU)) {
                comp = this.processMenu(child);
            } else if (tag.equals(TAG_SEL_RADIO)) {
                comp = this.processRadio(child);
            } else if (tag.equals(TAG_SEL_LABEL)) {
                comp = new JLabel(label);
                label = "";
            } else if (tag.equals(TAG_SEL_LIST)) {
                comp = this.processList(child);
            } else if (tag.equals(TAG_SEL_TEXT)) {
                comp = this.processText(child);
            } else if (tag.equals(TAG_SEL_BOOLEAN)) {
                comp = this.processBoolean(child);
            } else if (tag.equals(TAG_SEL_STATIONS)) {
                comp = this.processStations(child);
            } else {
                throw new IllegalArgumentException("Unknown child tag:" + tag);
            }
            if (comp == null) continue;
            this.xmlUi.addComponent(id, comp);
            this.selectComponents.add(comp);
            uiXml.append("<label label=\"" + label + "\"/>\n");
            uiXml.append("<component id=\"" + id + "\"/>\n");
        }
        uiXml.append("</panel>\n");
        return uiXml;
    }

    private void init() {
        this.xmlUi = new XmlUi();
        ArrayList components = new ArrayList();
        Element selectionsNode = XmlUtil.findChild(this.root, TAG_SELECTIONS);
        if (selectionsNode == null) {
            throw new IllegalArgumentException("Dataset xml does not have a selections tag");
        }
        selectionsNode = XmlUtil.findUrlRefNode(selectionsNode, "url");
        Element interfacesNode = XmlUtil.findChild(this.root, TAG_INTERFACES);
        if (interfacesNode != null) {
            interfacesNode = XmlUtil.findUrlRefNode(interfacesNode, "url");
        }
        StringBuffer uiXml = this.processSelections(selectionsNode);
        Element interfaceNode = null;
        if (interfacesNode != null) {
            interfaceNode = XmlUtil.findElement(XmlUtil.getElements(interfacesNode, TAG_INTERFACE), "client", "idv");
            if (interfaceNode == null) {
                interfaceNode = XmlUtil.findElement(XmlUtil.getElements(interfacesNode, TAG_INTERFACE), "client", "java");
            }
            if (interfaceNode != null) {
                interfaceNode = XmlUtil.findUrlRefNode(interfaceNode, "url");
            }
        }
        if (interfaceNode == null) {
            try {
                interfaceNode = XmlUtil.getRoot("<interface><ui>" + uiXml.toString() + "</ui></interface>");
            }
            catch (Exception exc) {
                LogUtil.logException("Creating ui xml", exc);
            }
        }
        this.xmlUi.setRoot(interfaceNode);
        this.contents = GuiUtils.topCenterBottom(null, this.xmlUi.getContents(), null);
        Element queryNode = XmlUtil.findChild(this.root, TAG_QUERY);
        if (queryNode != null) {
            this.actionTemplate = XmlUtil.getAttribute(queryNode, ATTR_ACTION);
        }
    }

    private void associate(Object widget, Element node) {
        this.widgets.add(widget);
        this.widgetToNode.put(widget, node);
    }

    public String processActionTemplate() {
        int i;
        String processedTemplate = this.actionTemplate;
        ArrayList<String> macros = new ArrayList<String>();
        String errorMsg = null;
        for (i = 0; i < this.widgets.size(); ++i) {
            Object widget = this.widgets.get(i);
            Element node = (Element)this.widgetToNode.get(widget);
            String nodeTemplate = XmlUtil.getAttribute((Node)node, ATTR_TEMPLATE, "%value%");
            String id = XmlUtil.getAttribute(node, ATTR_ID);
            boolean required = XmlUtil.getAttribute((Node)node, ATTR_REQUIRED, false);
            List values = this.getValues(widget);
            if (required && (values == null || values.size() == 0)) {
                if (errorMsg == null) {
                    errorMsg = "";
                }
                errorMsg = errorMsg + "\n The " + XmlUtil.getAttribute((Node)node, ATTR_LABEL, "") + " field is required";
                continue;
            }
            if (values == null) continue;
            String macro = "%" + id + "%";
            macros.add(macro);
            for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                String theValue = (String)values.get(valueIdx);
                theValue = StringUtil.replace(nodeTemplate, "%value%", theValue);
                processedTemplate = StringUtil.replace(processedTemplate, macro, theValue + macro);
            }
        }
        if (errorMsg != null) {
            LogUtil.userMessage(errorMsg);
            return null;
        }
        for (i = 0; i < macros.size(); ++i) {
            processedTemplate = StringUtil.replace(processedTemplate, (String)macros.get(i), "");
        }
        return processedTemplate;
    }

    private List getValues(Object comp) {
        if (comp instanceof JCheckBox) {
            return Misc.newList("" + ((JCheckBox)comp).isSelected());
        }
        if (comp instanceof StationLocationMap) {
            StationLocationMap slm = (StationLocationMap)comp;
            List stations = slm.getSelectedStations();
            ArrayList<String> result = new ArrayList<String>();
            for (int idx = 0; idx < stations.size(); ++idx) {
                NamedStationImpl station = (NamedStationImpl)stations.get(idx);
                result.add(station.getID());
            }
            return result;
        }
        if (comp instanceof JTextField) {
            return Misc.newList(((JTextField)comp).getText());
        }
        if (comp instanceof JTextArea) {
            return Misc.newList(((JTextArea)comp).getText());
        }
        if (comp instanceof JComboBox) {
            TwoFacedObject tfo = (TwoFacedObject)((JComboBox)comp).getSelectedItem();
            return Misc.newList(tfo.getId());
        }
        if (comp instanceof ButtonGroup) {
            return Misc.newList(((ButtonGroup)comp).getSelection().getActionCommand());
        }
        if (comp instanceof JList) {
            JList jlist = (JList)comp;
            Object[] values = jlist.getSelectedValues();
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < values.length; ++i) {
                TwoFacedObject tfo = (TwoFacedObject)values[i];
                result.add(tfo.getId());
            }
            return result;
        }
        if (comp instanceof List) {
            List lcomp = (List)comp;
            if (lcomp.size() == 0) {
                return null;
            }
            Object e = lcomp.get(0);
        }
        System.err.println("Unknown component:" + comp.getClass().getName());
        return null;
    }

    private Component processBoolean(Element field) {
        boolean value = XmlUtil.getAttribute((Node)field, ATTR_VALUE, false);
        JCheckBox b = new JCheckBox("", value);
        this.associate(b, field);
        return b;
    }

    private Component processText(Element field) {
        int rows = XmlUtil.getAttribute((Node)field, ATTR_ROWS, 1);
        int cols = XmlUtil.getAttribute((Node)field, ATTR_COLS, 30);
        String value = XmlUtil.getAttribute((Node)field, ATTR_VALUE, "");
        if (rows == 1) {
            JTextField comp = new JTextField(value, cols);
            this.associate(comp, field);
            return comp;
        }
        JTextArea comp = new JTextArea(value, rows, cols);
        this.associate(comp, field);
        JScrollPane scroller = new JScrollPane(comp);
        return scroller;
    }

    private Component processStations(Element field) {
        ArrayList<NamedStationImpl> stations = new ArrayList<NamedStationImpl>();
        XmlNodeList children = XmlUtil.getElements(field, TAG_STATION);
        for (int i = 0; i < children.getLength(); ++i) {
            Element choice = (Element)children.item(i);
            String value = XmlUtil.getAttribute(choice, ATTR_VALUE);
            String name = XmlUtil.getAttribute((Node)choice, ATTR_NAME, value);
            double lat = XmlUtil.getAttribute((Node)choice, ATTR_LAT, 0.0);
            double lon = XmlUtil.getAttribute((Node)choice, ATTR_LON, 0.0);
            double alt = XmlUtil.getAttribute((Node)choice, ATTR_ALT, 0.0);
            try {
                stations.add(new NamedStationImpl(value, name, lat, lon, alt, CommonUnit.meter));
                continue;
            }
            catch (Exception exc) {
                LogUtil.logException("Creating station", exc);
                break;
            }
        }
        String select = XmlUtil.getAttribute((Node)field, ATTR_SELECT, SELECT_ONE);
        String map = XmlUtil.getAttribute((Node)field, ATTR_MAP, NULL_STRING);
        StationLocationMap slm = new StationLocationMap(select.equals(SELECT_MANY), map);
        slm.setPreferredSize(new Dimension(300, 300));
        slm.setStations(stations);
        this.associate(slm, field);
        return slm;
    }

    private Component processMenu(Element field) {
        Vector<TwoFacedObject> choices = new Vector<TwoFacedObject>();
        XmlNodeList children = XmlUtil.getElements(field, TAG_CHOICE);
        for (int i = 0; i < children.getLength(); ++i) {
            Element choice = (Element)children.item(i);
            String value = XmlUtil.getAttribute(choice, ATTR_VALUE);
            String name = XmlUtil.getAttribute((Node)choice, ATTR_NAME, value);
            choices.add(new TwoFacedObject((Object)name, value));
        }
        JComboBox box = new JComboBox(choices);
        this.associate(box, field);
        return box;
    }

    private Component processList(Element field) {
        int rows = XmlUtil.getAttribute((Node)field, ATTR_ROWS, 5);
        Vector<TwoFacedObject> choices = new Vector<TwoFacedObject>();
        XmlNodeList children = XmlUtil.getElements(field, TAG_CHOICE);
        int index = 0;
        String value = XmlUtil.getAttribute((Node)field, ATTR_VALUE, "");
        for (int i = 0; i < children.getLength(); ++i) {
            Element choice = (Element)children.item(i);
            String bvalue = XmlUtil.getAttribute(choice, ATTR_VALUE);
            String name = XmlUtil.getAttribute((Node)choice, ATTR_NAME, bvalue);
            choices.add(new TwoFacedObject((Object)name, bvalue));
            if (!bvalue.equals(value)) continue;
            index = i;
        }
        JList l = new JList(choices);
        l.setVisibleRowCount(rows);
        l.setSelectedIndex(index);
        this.associate(l, field);
        JScrollPane scroller = new JScrollPane(l);
        return scroller;
    }

    private Component processRadio(Element field) {
        String value = XmlUtil.getAttribute((Node)field, ATTR_VALUE, "");
        ButtonGroup group = new ButtonGroup();
        ArrayList<JRadioButton> buttons = new ArrayList<JRadioButton>();
        XmlNodeList children = XmlUtil.getElements(field, TAG_CHOICE);
        for (int i = 0; i < children.getLength(); ++i) {
            Element choice = (Element)children.item(i);
            String bvalue = XmlUtil.getAttribute(choice, ATTR_VALUE);
            JRadioButton b = new JRadioButton(XmlUtil.getAttribute((Node)choice, ATTR_NAME, value));
            b.setActionCommand(bvalue);
            if (bvalue.equals(value)) {
                b.setSelected(true);
            }
            buttons.add(b);
            group.add(b);
        }
        this.associate(group, field);
        return GuiUtils.hbox(buttons);
    }

    public Component getContents() {
        return this.contents;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Provide a choices xml file");
            System.exit(0);
        }
        try {
            final DatasetUI t = new DatasetUI(XmlUtil.getRoot(IOUtil.readContents(new File(args[0]))), null);
            JFrame f = new JFrame();
            JButton okBtn = new JButton("Process");
            okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String url = t.processActionTemplate();
                    System.err.println("URL:" + url);
                    try {
                        System.err.println("Contents:" + IOUtil.readContents(url));
                    }
                    catch (Exception exc) {
                        System.err.println("oops:" + exc);
                    }
                }
            });
            JPanel contents = GuiUtils.centerBottom(t.getContents(), okBtn);
            f.getContentPane().add(contents);
            f.pack();
            f.setVisible(true);
        }
        catch (Exception exc) {
            System.err.println("Error:" + exc);
        }
    }
}

