/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.collab.PropertiedThing;
import ucar.unidata.ui.ComponentGroup;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlUtil;

public class ComponentHolder
extends PropertiedThing {
    public static final String ATTR_NAME = "name";
    public static final String[] BORDERS = new String[]{"empty", "titled", "etched", "line"};
    public static final String[] BORDER_NAMES = new String[]{"None", "Title", "Etched", "Line"};
    private String borderLayoutLocation = "Center";
    private String name;
    protected JTextField nameFld;
    private boolean showHeader = false;
    protected JButton displayBtn;
    protected JComponent header;
    private String category;
    protected ComponentGroup parent;
    private JComponent innerContents;
    private JComponent outerContents;
    private Rectangle layoutRect;
    protected boolean isRemoved = false;
    private String border = "empty";
    private JComboBox borderBox;
    private JCheckBox showHeaderCbx;
    private JInternalFrame frame;
    private boolean internalFrameShown = true;

    public ComponentHolder() {
    }

    public ComponentHolder(String name) {
        this.name = name;
    }

    public ComponentHolder(String name, JComponent contents) {
        this(name);
        this.innerContents = contents;
    }

    public ComponentGroup getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        if (this instanceof ComponentGroup) {
            return (ComponentGroup)this;
        }
        return null;
    }

    private String myToString() {
        return this.toString();
    }

    public JInternalFrame getInternalFrame() {
        if (this.frame == null) {
            this.frame = new JInternalFrame(this.getName(), true, true, true, true);
            this.frame.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    ComponentHolder.this.doRemove();
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent e) {
                    GuiUtils.toggleHeavyWeightComponents(ComponentHolder.this.frame, false);
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    GuiUtils.toggleHeavyWeightComponents(ComponentHolder.this.frame, true);
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent e) {
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent e) {
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                }
            });
            if (!this.internalFrameShown) {
                try {
                    this.frame.setIcon(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.frame;
    }

    public String getHierachicalName() {
        if (this.getParent() != null) {
            return this.getParent().getHierachicalName() + "-" + this.getName();
        }
        return this.getName();
    }

    public void setState(Element node) {
        node.setAttribute(ATTR_NAME, this.getName());
        node.setAttribute("border", this.border);
        node.setAttribute("place", this.borderLayoutLocation);
    }

    public void initWith(Element node) {
        this.setName(XmlUtil.getAttribute((Node)node, ATTR_NAME, ""));
        if (XmlUtil.hasAttribute(node, "border")) {
            this.setBorder(XmlUtil.getAttribute((Node)node, "border", "empty"));
        }
        if (XmlUtil.hasAttribute(node, "place")) {
            this.borderLayoutLocation = XmlUtil.getAttribute((Node)node, "place", "");
        }
    }

    protected void clearContents() {
        this.innerContents = null;
    }

    public JComponent getContents() {
        if (this.innerContents == null) {
            this.innerContents = this.doMakeContents();
            if (this.header == null) {
                this.header = this.doMakeHeader();
                this.header.setVisible(this.getShowHeader());
            }
            this.innerContents = GuiUtils.topCenter(this.header, this.innerContents);
            this.setBorder(this.innerContents);
            this.outerContents = this.wrapContents(this.innerContents);
        }
        return this.outerContents;
    }

    protected JComponent doMakeHeader() {
        this.displayBtn = GuiUtils.getImageButton("/auxdata/ui/icons/Down16.gif", this.getClass());
        this.displayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ComponentHolder.this.showPopup(ComponentHolder.this.displayBtn, 0, (int)ComponentHolder.this.displayBtn.getBounds().getHeight());
            }
        });
        this.displayBtn.setPreferredSize(null);
        this.displayBtn.setText(this.getName());
        return GuiUtils.inset((Component)GuiUtils.left(this.displayBtn), new Insets(0, 5, 0, 0));
    }

    protected JComponent wrapContents(JComponent contents) {
        return contents;
    }

    public JComponent doMakeContents() {
        return this.innerContents;
    }

    public String getTypeName() {
        return "Component";
    }

    public void showPopup(JComponent where, int x, int y) {
        ArrayList items = new ArrayList();
        this.getPopupMenuItems(items);
        if (items.size() == 0) {
            return;
        }
        GuiUtils.makePopupMenu(items).show(where, x, y);
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        this.nameFld = new JTextField(this.getName());
        comps.add(GuiUtils.rLabel("Name:"));
        comps.add(this.nameFld);
        if (tabIdx == 0) {
            this.showHeaderCbx = new JCheckBox("Show Label", this.showHeader);
            this.borderBox = new JComboBox(new Vector(Misc.toList(BORDER_NAMES)));
            this.borderBox.setSelectedIndex(Misc.toList(BORDERS).indexOf(this.border));
            comps.add(GuiUtils.rLabel("Border:"));
            comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.borderBox, (Component)GuiUtils.filler(20, 5), this.showHeaderCbx)));
        }
    }

    @Override
    protected boolean applyProperties() {
        String newBorder;
        boolean result = super.applyProperties();
        if (!result) {
            return false;
        }
        if (this.nameFld != null) {
            this.setName(this.nameFld.getText());
        }
        if (this.displayBtn != null) {
            this.displayBtn.setText(this.getName());
        }
        if (!(newBorder = BORDERS[Misc.toList(BORDER_NAMES).indexOf(this.borderBox.getSelectedItem())]).equals(this.border)) {
            this.border = newBorder;
            if (this.innerContents != null) {
                this.setBorder(this.innerContents);
            }
        }
        if (this.showHeader != this.showHeaderCbx.isSelected()) {
            this.setShowHeader(this.showHeaderCbx.isSelected());
        }
        return true;
    }

    protected void setBorder(JComponent comp) {
        Border theBorder = null;
        if (this.border.equals("titled")) {
            theBorder = BorderFactory.createTitledBorder(this.getName());
        } else if (this.border.equals("line")) {
            theBorder = BorderFactory.createLineBorder(Color.black, 1);
        } else if (this.border.equals("etched")) {
            theBorder = BorderFactory.createEtchedBorder(0);
        }
        if (comp != null) {
            comp.setBorder(theBorder);
        }
    }

    public DefaultMutableTreeNode makeTree(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
        if (parent != null) {
            parent.add(node);
        }
        return node;
    }

    protected List getPopupMenuItems(List items) {
        items.add(GuiUtils.makeMenuItem("Remove " + this.getTypeName(), this, "removeDisplayComponent"));
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Properties...", this, "showProperties"));
        return items;
    }

    public boolean getBeingShown() {
        return true;
    }

    public boolean removeDisplayComponent() {
        if (GuiUtils.askYesNo("Remove Display", "Are you sure you want to remove: " + this.toString())) {
            this.doRemove();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public void print(String tab) {
        System.err.println(tab + this);
    }

    public void doRemove() {
        if (this.isRemoved) {
            return;
        }
        this.isRemoved = true;
        if (this.parent != null) {
            this.parent.removeComponent(this);
        }
        this.parent = null;
    }

    public void setName(String value) {
        this.name = value;
        if (this.displayBtn != null) {
            this.displayBtn.setText(this.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setParent(ComponentGroup newParent) {
        if (newParent == this.parent) {
            return;
        }
        ComponentGroup oldParent = this.parent;
        this.parent = null;
        if (oldParent != null) {
            oldParent.removeComponent(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            // empty if block
        }
    }

    public ComponentGroup getParent() {
        return this.parent;
    }

    public void setLayoutRect(Rectangle value) {
        this.layoutRect = value;
    }

    public Rectangle getLayoutRect() {
        return this.layoutRect;
    }

    public void setCategory(String value) {
        this.category = value;
    }

    public String getCategory() {
        return this.category;
    }

    public ImageIcon getIcon() {
        return null;
    }

    public void setShowHeader(boolean value) {
        this.showHeader = value;
        if (this.header != null) {
            this.header.setVisible(this.getShowHeader());
        }
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public void setBorder(String value) {
        this.border = value;
    }

    public String getBorder() {
        return this.border;
    }

    public void setBorderLayoutLocation(String value) {
        this.borderLayoutLocation = value;
    }

    public String getBorderLayoutLocation() {
        return this.borderLayoutLocation;
    }

    public void setInternalFrameShown(boolean value) {
        this.internalFrameShown = value;
    }

    public boolean getInternalFrameShown() {
        if (this.frame != null) {
            return !this.frame.isIcon();
        }
        return this.internalFrameShown;
    }
}

