/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.ui.ComponentHolder;
import ucar.unidata.ui.DndTree;
import ucar.unidata.ui.DropPanel;
import ucar.unidata.ui.GraphPaperLayout;
import ucar.unidata.ui.TreePanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlUtil;

public class ComponentGroup
extends ComponentHolder {
    public static final String LAYOUT_GRIDBAG = "gridbag";
    public static final String LAYOUT_GRID = "grid";
    public static final String LAYOUT_TABS = "tabs";
    public static final String LAYOUT_HSPLIT = "hsplit";
    public static final String LAYOUT_VSPLIT = "vsplit";
    public static final String LAYOUT_GRAPH = "graph";
    public static final String LAYOUT_TREE = "tree";
    public static final String LAYOUT_BORDER = "border";
    public static final String LAYOUT_DESKTOP = "desktop";
    public static final String LAYOUT_MENU = "menu";
    public static final String[] LAYOUT_NAMES = new String[]{"Columns", "Grid", "Tabs", "Hor. Split", "Vert. Split", "Graph", "Tree", "Border", "Menu", "Desktop"};
    public static final String[] LAYOUTS = new String[]{"gridbag", "grid", "tabs", "hsplit", "vsplit", "graph", "tree", "border", "menu", "desktop"};
    public static final List LAYOUT_LIST = Misc.toList(LAYOUTS);
    private String layout = "grid";
    protected JComponent container;
    protected JComponent outerContainer;
    private List displayComponents = new ArrayList();
    protected JTabbedPane tabbedPane;
    private JComboBox menuBox;
    private GuiUtils.CardLayoutPanel menuPanel;
    private JDesktopPane desktop;
    private int gridColumns = 1;
    private int numRows = 0;
    private int numColumns = 1;
    private Rectangle lastPosition;
    private boolean iconified = false;
    private Vector propertiesList;
    private JTextField dimFld;
    private JTextField colFld;
    private JComboBox layoutBox;
    private GuiUtils.CardLayoutPanel extraPanel;
    private JComponent extraPanelHolder;
    Hashtable borderLayoutLocations;
    private JRadioButton rowBtn;
    private JRadioButton colBtn;
    private JList displayList;
    private boolean displayOrderChanged;
    private MyDndTree propertiesTree;

    public ComponentGroup() {
    }

    public ComponentGroup(String name) {
        super(name);
    }

    @Override
    public void initWith(Element node) {
        super.initWith(node);
        String layoutString = XmlUtil.getAttribute((Node)node, "layout", (String)null);
        if (layoutString != null) {
            this.setLayout(layoutString);
            if (this.layout.equals(LAYOUT_GRIDBAG)) {
                this.gridColumns = XmlUtil.getAttribute((Node)node, "layout_columns", this.gridColumns);
            }
        }
    }

    @Override
    public void setState(Element node) {
        super.setState(node);
        node.setAttribute("layout", this.getLayout());
        if (this.layout.equals(LAYOUT_GRIDBAG)) {
            node.setAttribute("layout_columns", this.gridColumns + "");
        }
    }

    @Override
    public String getTypeName() {
        return "Group";
    }

    @Override
    public JComponent doMakeContents() {
        this.desktop = new JDesktopPane();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ComponentGroup.this.isLayout(ComponentGroup.LAYOUT_TABS)) {
                    GuiUtils.checkHeavyWeightComponents(ComponentGroup.this.tabbedPane);
                }
            }
        });
        this.container = new JPanel(new GridLayout(this.numRows, this.numColumns, 5, 5));
        this.outerContainer = GuiUtils.center(this.container);
        this.redoLayout();
        return this.outerContainer;
    }

    @Override
    protected JComponent wrapContents(JComponent contents) {
        DropPanel dropPanel = new DropPanel(){

            @Override
            public void handleDrop(Object object) {
                ComponentGroup.this.doDrop(object);
            }

            @Override
            public boolean okToDrop(Object object) {
                return ComponentGroup.this.dropOk(object);
            }
        };
        dropPanel.add("Center", contents);
        return dropPanel;
    }

    public boolean dropOk(Object object) {
        return false;
    }

    protected void doDrop(Object obj) {
    }

    @Override
    protected List getPopupMenuItems(List items) {
        super.getPopupMenuItems(items);
        ArrayList<JMenu> subItems = new ArrayList<JMenu>();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)this.displayComponents.get(i);
            ArrayList<Object> compItems = new ArrayList<Object>();
            comp.getPopupMenuItems(compItems);
            compItems.add("separator");
            compItems.add(GuiUtils.makeMenuItem("Properties...", comp, "showProperties"));
            subItems.add(GuiUtils.makeMenu(comp.getName(), compItems));
        }
        if (subItems.size() > 0) {
            items.add("separator");
            items.add(GuiUtils.makeMenu("Components", subItems));
        }
        return items;
    }

    public String[] xxxxgetPropertyTabs() {
        return new String[]{"Properties", "Tree View"};
    }

    @Override
    protected void getPropertiesComponents(List comps, int tabIdx) {
        super.getPropertiesComponents(comps, tabIdx);
        if (this.propertiesTree == null) {
            this.propertiesTree = new MyDndTree();
        }
        this.propertiesTree.setModel(new DefaultTreeModel(this.makeTree(null)));
        this.displayOrderChanged = false;
        this.propertiesList = new Vector(this.displayComponents);
        this.displayList = new JList(this.propertiesList);
        this.displayList.setToolTipText("Press 'delete' to remove selected display");
        JScrollPane displayPanel = GuiUtils.makeScrollPane(this.displayList, 300, 100);
        this.displayList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                ComponentHolder comp;
                if (event.getClickCount() > 1 && (comp = (ComponentHolder)ComponentGroup.this.displayList.getSelectedValue()) != null) {
                    comp.showProperties(ComponentGroup.this.displayList, 0, 0);
                }
            }
        });
        this.displayList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (GuiUtils.isDeleteEvent(e) && ComponentGroup.this.displayList.getSelectedIndex() >= 0) {
                    ComponentGroup.this.displayOrderChanged = true;
                    ComponentGroup.this.propertiesList.remove(ComponentGroup.this.displayList.getSelectedIndex());
                    ComponentGroup.this.displayList.setListData(new Vector(ComponentGroup.this.propertiesList));
                }
            }
        });
        Vector layoutList = new Vector(TwoFacedObject.createList(LAYOUTS, LAYOUT_NAMES));
        this.layoutBox = new JComboBox(layoutList);
        TwoFacedObject selectedLayout = TwoFacedObject.findId(this.layout, layoutList);
        if (selectedLayout == null) {
            selectedLayout = layoutList.get(0);
        }
        this.layoutBox.setSelectedItem(selectedLayout);
        this.layoutBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ComponentGroup.this.checkExtraPanel(TwoFacedObject.getIdString(ComponentGroup.this.layoutBox.getSelectedItem()));
            }
        });
        this.makeExtraPanel();
        comps.add(GuiUtils.rLabel("Layout: "));
        comps.add(GuiUtils.left(GuiUtils.leftCenter(this.layoutBox, GuiUtils.inset((Component)this.extraPanelHolder, new Insets(0, 5, 0, 0)))));
        comps.add(GuiUtils.rLabel("Tree:"));
        this.propertiesTree.treeSP.setPreferredSize(new Dimension(200, 300));
        comps.add(this.propertiesTree.treeSP);
    }

    private void makeExtraPanel() {
        if (this.rowBtn == null) {
            boolean fixedRows = this.getNumRows() != 0;
            this.rowBtn = new JRadioButton("Rows", fixedRows);
            this.colBtn = new JRadioButton("Columns", !fixedRows);
            GuiUtils.buttonGroup(this.rowBtn, this.colBtn);
            this.dimFld = new JTextField((fixedRows ? this.getNumRows() : this.getNumColumns()) + "", 5);
            this.colFld = new JTextField(this.getGridColumns() + "", 5);
        }
        this.borderLayoutLocations = new Hashtable();
        ArrayList<JComponent> borderComps = new ArrayList<JComponent>();
        Vector borderLayouts = new Vector(Misc.newList("Center", "North", "East", "South", "West"));
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)this.displayComponents.get(i);
            JComboBox box = new JComboBox(borderLayouts);
            box.setSelectedItem(comp.getBorderLayoutLocation());
            borderComps.add(new JLabel(comp.getName() + ": "));
            borderComps.add(box);
            this.borderLayoutLocations.put(comp, box);
        }
        this.extraPanel = new GuiUtils.CardLayoutPanel();
        this.extraPanel.add("", new JLabel(" "));
        this.extraPanel.add(LAYOUT_BORDER, GuiUtils.left(GuiUtils.hbox(borderComps)));
        this.extraPanel.add(LAYOUT_GRID, GuiUtils.left(GuiUtils.hbox((Component)new JLabel("  Dimension: "), (Component)GuiUtils.wrap(this.dimFld), GuiUtils.hbox(this.colBtn, this.rowBtn))));
        this.extraPanel.add(LAYOUT_GRIDBAG, GuiUtils.left(GuiUtils.hbox(new JLabel("  # Columns: "), GuiUtils.wrap(this.colFld))));
        this.extraPanel.add(LAYOUT_GRAPH, GuiUtils.left(GuiUtils.wrap(GuiUtils.makeButton("Edit", this, "editLayout"))));
        if (this.extraPanelHolder == null) {
            this.extraPanelHolder = new JPanel(new BorderLayout());
        }
        this.extraPanelHolder.removeAll();
        this.extraPanelHolder.add("Center", this.extraPanel);
        if (this.layoutBox != null) {
            this.checkExtraPanel(TwoFacedObject.getIdString(this.layoutBox.getSelectedItem()));
        }
    }

    private void checkExtraPanel(String theLayout) {
        if (this.extraPanel.containsKey(theLayout)) {
            this.extraPanel.show(theLayout);
        } else {
            this.extraPanel.show("");
        }
    }

    @Override
    public DefaultMutableTreeNode makeTree(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = super.makeTree(parent);
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ComponentHolder comp = (ComponentHolder)this.displayComponents.get(i);
            comp.makeTree(node);
        }
        return node;
    }

    public List findComponentsWithType(Class compClass) {
        ArrayList<ComponentHolder> comps = new ArrayList<ComponentHolder>();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ComponentHolder displayComponent = (ComponentHolder)this.displayComponents.get(i);
            if (compClass.isAssignableFrom(displayComponent.getClass())) {
                comps.add(displayComponent);
            }
            if (!(displayComponent instanceof ComponentGroup)) continue;
            comps.addAll(((ComponentGroup)displayComponent).findComponentsWithType(compClass));
        }
        return comps;
    }

    private boolean isLayout(String l) {
        return this.layout.equals(l);
    }

    public void redoLayout() {
        Object comp;
        ComponentHolder displayComponent;
        int i;
        if (this.tabbedPane == null) {
            return;
        }
        this.desktop.removeAll();
        if (!this.isLayout(LAYOUT_TABS) && this.tabbedPane.getTabCount() > 0) {
            GuiUtils.resetHeavyWeightComponents(this.tabbedPane);
            this.tabbedPane.removeAll();
        }
        this.container.setVisible(false);
        this.container.removeAll();
        if (this.displayComponents.size() == 0) {
            this.container.setVisible(true);
            this.container.setPreferredSize(new Dimension(100, 100));
            return;
        }
        this.container.setPreferredSize(null);
        if (this.isLayout(LAYOUT_GRID)) {
            this.container.setLayout(new GridLayout(this.numRows, this.numColumns, 5, 5));
        } else {
            this.container.setLayout(new BorderLayout());
        }
        int lastMenuIdx = 0;
        if (this.isLayout(LAYOUT_MENU)) {
            if (this.menuBox != null) {
                lastMenuIdx = this.menuBox.getSelectedIndex();
            }
            this.menuPanel = new GuiUtils.CardLayoutPanel();
        }
        Vector<String> menuItems = new Vector<String>();
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (i = 0; i < this.displayComponents.size(); ++i) {
            displayComponent = (ComponentHolder)this.displayComponents.get(i);
            comp = displayComponent.getContents();
            if (((Component)comp).getParent() != null) {
                ((Component)comp).getParent().remove((Component)comp);
            }
            ((JComponent)comp).setVisible(true);
            GuiUtils.toggleHeavyWeightComponents((Component)comp, true);
            if (this.isLayout(LAYOUT_TABS)) {
                this.tabbedPane.addTab(displayComponent.getName(), displayComponent.getIcon(), (Component)comp);
                continue;
            }
            if (this.isLayout(LAYOUT_DESKTOP)) {
                boolean shouldIconify = !displayComponent.getInternalFrameShown();
                JInternalFrame frame = displayComponent.getInternalFrame();
                frame.getContentPane().add((Component)comp);
                frame.pack();
                frame.show();
                this.desktop.add(frame);
                if (!shouldIconify) continue;
            }
            if (this.isLayout(LAYOUT_MENU)) {
                this.menuPanel.addCard((Component)comp);
                menuItems.add(displayComponent.getName());
                continue;
            }
            if (this.isLayout(LAYOUT_GRID)) {
                this.container.add((Component)comp);
                continue;
            }
            if (this.isLayout(LAYOUT_BORDER)) {
                this.container.add(displayComponent.getBorderLayoutLocation(), (Component)comp);
                continue;
            }
            comps.add((JComponent)comp);
        }
        if (this.isLayout(LAYOUT_TABS)) {
            this.container.add("Center", this.tabbedPane);
        } else if (this.isLayout(LAYOUT_MENU)) {
            this.menuBox = new JComboBox(menuItems);
            this.menuBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ComponentGroup.this.menuBox.getSelectedIndex() >= 0) {
                        ComponentGroup.this.menuPanel.show(ComponentGroup.this.menuBox.getSelectedIndex());
                    }
                }
            });
            if (lastMenuIdx >= 0 && this.displayComponents.size() > 0 && lastMenuIdx < this.displayComponents.size()) {
                this.menuBox.setSelectedIndex(lastMenuIdx);
                this.menuPanel.show(lastMenuIdx);
            }
            this.container.add("Center", GuiUtils.topCenter(GuiUtils.left(this.menuBox), this.menuPanel));
        } else if (this.isLayout(LAYOUT_DESKTOP)) {
            this.container.add("Center", this.desktop);
            for (i = 0; i < this.displayComponents.size(); ++i) {
                displayComponent = (ComponentHolder)this.displayComponents.get(i);
                GuiUtils.toggleHeavyWeightComponents(displayComponent.getInternalFrame(), displayComponent.getInternalFrame().isSelected());
            }
        } else if (this.isLayout(LAYOUT_HSPLIT)) {
            if (comps.size() > 0) {
                this.container.add("Center", GuiUtils.doMultiSplitPane(comps, true));
            }
        } else if (this.isLayout(LAYOUT_VSPLIT)) {
            if (comps.size() > 0) {
                this.container.add("Center", GuiUtils.doMultiSplitPane(comps, false));
            }
        } else if (this.isLayout(LAYOUT_GRAPH)) {
            this.container.add(GraphPaperLayout.layout(this.getLocations()));
        } else if (this.isLayout(LAYOUT_TREE)) {
            TreePanel treePanel = new TreePanel();
            for (int i2 = 0; i2 < this.displayComponents.size(); ++i2) {
                comp = (ComponentHolder)this.displayComponents.get(i2);
                String name = ((ComponentHolder)comp).getName();
                if (name == null) {
                    name = "Component";
                }
                treePanel.addComponent(((ComponentHolder)comp).getContents(), ((ComponentHolder)comp).getCategory(), name, ((ComponentHolder)comp).getIcon());
            }
            this.container.add(treePanel);
        } else if (this.isLayout(LAYOUT_GRIDBAG)) {
            this.container.add("Center", GuiUtils.doLayout(comps, this.gridColumns, GuiUtils.WT_Y, GuiUtils.WT_Y));
        }
        this.container.setVisible(true);
        this.container.revalidate();
    }

    private List getLocations() {
        ArrayList<GraphPaperLayout.Location> locations = new ArrayList<GraphPaperLayout.Location>();
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ComponentHolder displayComponent = (ComponentHolder)this.displayComponents.get(i);
            if (!displayComponent.getBeingShown()) continue;
            locations.add(new GraphPaperLayout.Location(displayComponent.getContents(), displayComponent, displayComponent.getName(), displayComponent.getLayoutRect()));
        }
        return locations;
    }

    private void applyLocations(List locations) {
        for (int i = 0; i < locations.size(); ++i) {
            GraphPaperLayout.Location loc = (GraphPaperLayout.Location)locations.get(i);
            ComponentHolder componentHolder = (ComponentHolder)loc.getObject();
            componentHolder.setLayoutRect(loc.getRect());
        }
    }

    public void editLayout() {
        List locations = this.getLocations();
        GraphPaperLayout.showDialog(locations, "Edit Group Layout");
        this.applyLocations(locations);
        this.redoLayout();
    }

    public void addComponent(ComponentHolder displayComponent) {
        this.addComponent(displayComponent, -1);
    }

    public int indexOf(ComponentHolder displayComponent) {
        return this.displayComponents.indexOf(displayComponent);
    }

    public void addComponent(ComponentHolder displayComponent, int index) {
        boolean wasMine = this.displayComponents.contains(displayComponent);
        if (wasMine) {
            this.displayComponents.remove(displayComponent);
        }
        if (index >= 0 && index < this.displayComponents.size()) {
            this.displayComponents.add(index, displayComponent);
        } else {
            this.displayComponents.add(displayComponent);
        }
        displayComponent.setParent(this);
        this.redoLayout();
        this.subtreeChanged();
    }

    protected void subtreeChanged() {
        if (this.propertiesTree != null) {
            Hashtable paths = GuiUtils.initializeExpandedPathsBeforeChange(this.propertiesTree, (DefaultMutableTreeNode)this.propertiesTree.getModel().getRoot());
            this.propertiesTree.setModel(new DefaultTreeModel(this.makeTree(null)));
            GuiUtils.expandPathsAfterChange(this.propertiesTree, paths, (DefaultMutableTreeNode)this.propertiesTree.getModel().getRoot());
        }
        if (this.parent != null) {
            this.parent.subtreeChanged();
        }
        this.makeExtraPanel();
    }

    @Override
    protected boolean applyProperties() {
        boolean result = super.applyProperties();
        if (!result) {
            return false;
        }
        try {
            for (int i = 0; i < this.displayComponents.size(); ++i) {
                ComponentHolder comp = (ComponentHolder)this.displayComponents.get(i);
                JComboBox box = (JComboBox)this.borderLayoutLocations.get(comp);
                if (box == null) continue;
                comp.setBorderLayoutLocation((String)box.getSelectedItem());
            }
            this.layout = TwoFacedObject.getIdString(this.layoutBox.getSelectedItem());
            if (this.rowBtn.isSelected()) {
                this.setRowsColumns(new Integer(this.dimFld.getText().trim()), 0);
            } else {
                this.setRowsColumns(0, new Integer(this.dimFld.getText().trim()));
            }
            this.setGridColumns(new Integer(this.colFld.getText().trim()));
            this.redoLayout();
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad number format " + nfe);
            return false;
        }
        return result;
    }

    public void removeComponent(ComponentHolder displayComponent) {
        this.displayComponents.remove(displayComponent);
        displayComponent.setParent(null);
        this.redoLayout();
        this.subtreeChanged();
    }

    @Override
    public void doRemove() {
        if (this.isRemoved) {
            return;
        }
        ArrayList tmp = new ArrayList(this.displayComponents);
        for (int i = 0; i < tmp.size(); ++i) {
            ((ComponentHolder)tmp.get(i)).doRemove();
        }
        this.displayComponents = null;
        super.doRemove();
    }

    public void setDisplayComponents(List value) {
        this.displayComponents = value;
    }

    public List getDisplayComponents() {
        return this.displayComponents;
    }

    public void setRowsColumns(int rows, int cols) {
        this.numRows = rows;
        this.numColumns = cols;
    }

    public void setNumRows(int value) {
        this.numRows = value;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumColumns(int value) {
        this.numColumns = value;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    @Override
    public String toString() {
        return "Group: " + this.getName() + " (" + this.getLayout() + ")";
    }

    public void setLastPosition(Rectangle value) {
        this.lastPosition = value;
    }

    public Rectangle getLastPosition() {
        return this.lastPosition;
    }

    public void setIconified(boolean value) {
        this.iconified = value;
    }

    public boolean getIconified() {
        return this.iconified;
    }

    public void setLayout(String value) {
        if (value != null && !LAYOUT_LIST.contains(value)) {
            throw new IllegalArgumentException("Unknown layout value:" + value);
        }
        this.layout = value;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setGridColumns(int value) {
        this.gridColumns = value;
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public static void main(String[] args) {
        ComponentGroup g1 = new ComponentGroup("Group 1");
        ComponentGroup g2 = new ComponentGroup("Group 2");
        JPanel lbl = GuiUtils.wrap(new JLabel("label1"));
        ComponentHolder comp = new ComponentHolder("label1", lbl);
        g1.addComponent(comp);
        lbl.setBackground(Color.red);
        comp.setCategory("Foo");
        lbl = GuiUtils.wrap(new JLabel("label2"));
        comp = new ComponentHolder("label2", lbl);
        g1.addComponent(comp);
        comp.setCategory("Foo");
        lbl.setBackground(Color.blue);
        lbl = GuiUtils.wrap(new JLabel("label3"));
        comp = new ComponentHolder("label3", lbl);
        g1.addComponent(comp);
        comp.setCategory("Bar");
        lbl.setBackground(Color.green);
        g1.layout = LAYOUT_TABS;
        g1.redoLayout();
        g2.layout = LAYOUT_HSPLIT;
        g2.addComponent(g1);
        lbl = GuiUtils.wrap(new JLabel("label4"));
        comp = new ComponentHolder("label4", lbl);
        g2.addComponent(comp);
        lbl.setBackground(Color.cyan);
        lbl = GuiUtils.wrap(new JLabel("label5"));
        comp = new ComponentHolder("label5", lbl);
        g2.addComponent(comp);
        lbl.setBackground(Color.orange);
        JFrame f = new JFrame();
        f.setLocation(300, 300);
        f.getContentPane().add(g2.getContents());
        f.pack();
        f.setVisible(true);
    }

    public static boolean isAncestor(ComponentGroup parent, ComponentHolder descendant) {
        if (descendant == parent) {
            return true;
        }
        if (descendant.getParent() == null) {
            return false;
        }
        return ComponentGroup.isAncestor(parent, descendant.getParent());
    }

    private void changeParent(ComponentHolder src, ComponentHolder dest, boolean on) {
        if (on && dest instanceof ComponentGroup) {
            if (dest == src) {
                return;
            }
            ((ComponentGroup)dest).addComponent(src);
            src.setParent((ComponentGroup)dest);
            return;
        }
        ComponentGroup newParent = dest.getParent();
        if (newParent == null) {
            return;
        }
        if (src.getParent() != null) {
            src.getParent().removeComponent(src);
        }
        newParent.addComponent(src, newParent.indexOf(dest) + 1);
    }

    @Override
    public void print(String tab) {
        System.err.println(tab + this);
        for (int i = 0; i < this.displayComponents.size(); ++i) {
            ComponentHolder displayComponent = (ComponentHolder)this.displayComponents.get(i);
            displayComponent.print(tab + "   ");
        }
    }

    private class MyDndTree
    extends DndTree {
        public JScrollPane treeSP = GuiUtils.makeScrollPane(this, 300, 400);

        public MyDndTree() {
            this.setToolTipText("Right click to show menu; Double click to show properties dialog");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    TreePath path = MyDndTree.this.getPathForLocation(event.getX(), event.getY());
                    if (path == null) {
                        return;
                    }
                    Object last = path.getLastPathComponent();
                    if (last == null) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)last;
                    ComponentHolder comp = (ComponentHolder)node.getUserObject();
                    if (SwingUtilities.isRightMouseButton(event)) {
                        comp.showPopup(MyDndTree.this.treeSP, event.getX(), event.getY());
                        return;
                    }
                    if (event.getClickCount() > 1) {
                        comp.showProperties(MyDndTree.this, 0, 0);
                    }
                }
            });
        }

        @Override
        protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean onNode) {
            ComponentGroup.this.changeParent((ComponentHolder)sourceNode.getUserObject(), (ComponentHolder)destNode.getUserObject(), onNode);
        }

        @Override
        protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean onNode) {
            boolean result = this.okToDropx(sourceNode, destNode, onNode);
            return result;
        }

        protected boolean okToDropx(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode, boolean onNode) {
            if (!(sourceNode.getUserObject() instanceof ComponentGroup)) {
                return true;
            }
            ComponentGroup srcGroup = (ComponentGroup)sourceNode.getUserObject();
            return !ComponentGroup.isAncestor(srcGroup, (ComponentHolder)destNode.getUserObject());
        }
    }
}

