/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.ui.Command;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;

public class CommandManager {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(CommandManager.class.getName());
    private Object MUTEX = new Object();
    ArrayList commands = new ArrayList();
    int currentIdx = -1;
    int historySize = 30;
    JButton bBtn;
    JButton fBtn;
    private boolean applyingCommand = false;

    public CommandManager() {
    }

    public CommandManager(int historySize) {
        this.historySize = historySize;
    }

    public JPanel getContents() {
        return this.getContents(true);
    }

    public JPanel getContents(boolean includeHistory) {
        if (includeHistory) {
            return GuiUtils.hbox((Component)new JLabel("History: "), (Component)this.getBackButton(), this.getForwardButton());
        }
        return GuiUtils.hbox(this.getBackButton(), this.getForwardButton());
    }

    public JButton getBackButton() {
        if (this.bBtn == null) {
            this.bBtn = GuiUtils.getImageButton(GuiUtils.getImageIcon("/auxdata/ui/icons/arrow_undo.png", this.getClass()));
            this.bBtn.setToolTipText("Click to go back one step. Shift click to go back 10 steps");
            this.bBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cnt;
                    int n = cnt = CommandManager.this.isShift(e) ? 10 : 1;
                    while (CommandManager.this.bBtn.isEnabled() && --cnt >= 0) {
                        CommandManager.this.move(-1);
                    }
                }
            });
            this.checkGui();
        }
        return this.bBtn;
    }

    public JButton getForwardButton() {
        if (this.fBtn == null) {
            this.fBtn = GuiUtils.getImageButton(GuiUtils.getImageIcon("/auxdata/ui/icons/arrow_redo.png", this.getClass()));
            this.fBtn.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.fBtn.setToolTipText("Click to go forward one step. Shift click to go forward 10 steps");
            this.fBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cnt;
                    int n = cnt = CommandManager.this.isShift(e) ? 10 : 1;
                    while (CommandManager.this.fBtn.isEnabled() && --cnt >= 0) {
                        CommandManager.this.move(1);
                    }
                }
            });
            this.checkGui();
        }
        return this.fBtn;
    }

    public void undo() {
        this.move(-1);
    }

    public void redo() {
        this.move(1);
    }

    private boolean isShift(ActionEvent e) {
        return (e.getModifiers() & 1) != 0;
    }

    public void move(int delta) {
        int newIdx = this.currentIdx + delta;
        if (newIdx < 0) {
            newIdx = -1;
        } else if (newIdx >= this.commands.size()) {
            newIdx = this.commands.size() - 1;
        }
        this.applyingCommand = true;
        if (newIdx > this.currentIdx) {
            Command newCommand = (Command)this.commands.get(newIdx);
            newCommand.redoCommand();
        } else if (newIdx < this.currentIdx) {
            Command oldCommand = (Command)this.commands.get(this.currentIdx);
            oldCommand.undoCommand();
        }
        this.applyingCommand = false;
        this.currentIdx = newIdx;
        this.checkGui();
    }

    public boolean getApplyingCommand() {
        return this.applyingCommand;
    }

    public void checkGui() {
        if (this.bBtn != null) {
            this.bBtn.setEnabled(this.currentIdx >= 0);
        }
        if (this.fBtn != null) {
            this.fBtn.setEnabled(this.currentIdx < this.commands.size() - 1);
        }
    }

    public void add(Command command) {
        this.add(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Command command, boolean andCallDoCommand) {
        Object object = this.MUTEX;
        synchronized (object) {
            int i = this.currentIdx + 1;
            while (i < this.commands.size()) {
                this.commands.remove(i);
            }
            while (this.commands.size() > this.historySize) {
                this.commands.remove(0);
            }
            this.commands.add(command);
            this.currentIdx = this.commands.size() - 1;
        }
        if (andCallDoCommand) {
            command.doCommand();
        }
        this.checkGui();
    }

    public int size() {
        return this.commands.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String s = "Commands:";
        Object object = this.MUTEX;
        synchronized (object) {
            for (int i = 0; i < this.commands.size(); ++i) {
                s = s + "\n\t" + this.commands.get(i);
            }
        }
        return s;
    }

    public boolean canGoForward() {
        return this.currentIdx < this.commands.size() - 1;
    }

    public boolean canGoBack() {
        return this.currentIdx > 0;
    }
}

