/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.ui.Help;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class ChooserPanel
extends JPanel
implements ActionListener {
    protected static final int GRID_SPACING = 5;
    protected static final int GRID_SPACING_V = 3;
    protected static final int GRID_SPACING_H = 5;
    protected static final Insets GRID_INSETS = new Insets(3, 5, 3, 5);
    public static final Color MAP_COLOR = Color.lightGray;
    public static final String CMD_LOAD = "Add Source";
    private int cursorCnt = 0;
    protected String helpPath = "";
    protected JComponent contents;
    protected JButton loadButton;
    protected JButton cancelButton;
    protected boolean haveData = false;
    private PropertyChangeSupport changeListeners;
    protected JLabel statusLabel;
    private JComponent statusComp;
    private Hashtable statusComps = new Hashtable();
    protected boolean simpleMode = false;
    private String messageTemplate;

    public ChooserPanel() {
        this.changeListeners = new PropertyChangeSupport(this);
    }

    public void setMessageTemplate(String template) {
        this.messageTemplate = template;
    }

    protected String getMessageTemplate() {
        return this.messageTemplate;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.addPropertyChangeListener(listener);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeListeners != null) {
            this.changeListeners.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void revalidate() {
    }

    protected JComponent registerStatusComp(String name, JComponent comp) {
        comp = GuiUtils.inset((Component)comp, 1);
        comp = GuiUtils.inset((Component)comp, 2);
        this.statusComps.put(name, comp);
        return comp;
    }

    public void setStatus(String msg) {
        this.setStatus(msg, "nocomp");
    }

    public boolean getSimpleMode() {
        return this.simpleMode;
    }

    public void setStatus(String msg, String compId) {
        String template = this.getMessageTemplate();
        if (template != null) {
            msg = template.replace("${message}", msg);
        }
        this.getStatusLabel().setText(msg);
        if (!this.getSimpleMode()) {
            return;
        }
        Enumeration keys = this.statusComps.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            JComponent comp = (JComponent)this.statusComps.get(key);
            if (compId.equals(key)) {
                comp.setBackground(Color.cyan);
                continue;
            }
            comp.setBackground(null);
        }
    }

    protected JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setOpaque(true);
            this.statusLabel.setForeground(this.getStatusLabelForeground());
            this.statusLabel.setBackground(this.getStatusLabelBackground());
        }
        return this.statusLabel;
    }

    public Color getStatusLabelBackground() {
        return new Color(255, 255, 204);
    }

    public Color getStatusLabelForeground() {
        return Color.BLACK;
    }

    protected JComponent getStatusComponent() {
        if (this.statusComp == null) {
            JLabel statusLabel = this.getStatusLabel();
            this.statusComp = GuiUtils.inset((Component)statusLabel, new Insets(3, 2, 1, 0));
            this.statusComp.setBackground(this.getStatusLabelBackground());
            this.statusComp = GuiUtils.inset((Component)this.statusComp, new Insets(2, 2, 2, 2));
        }
        return this.statusComp;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_UPDATE)) {
            this.doUpdate();
        } else if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.doCancel();
        } else if (cmd.equals(this.getLoadCommandName())) {
            this.doLoad();
        } else if (cmd.equals(GuiUtils.CMD_HELP)) {
            this.doHelp();
        }
    }

    protected String getLoadCommandName() {
        return CMD_LOAD;
    }

    public JComponent getDefaultButtons() {
        return this.getDefaultButtons(this);
    }

    public JComponent getDefaultButtons(ActionListener listener) {
        Hashtable buttonMap = new Hashtable();
        String[] commands = this.getButtonLabels();
        String[] labels = new String[commands.length];
        String loadCommand = this.getLoadCommandName();
        String[] tooltips = new String[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            labels[i] = commands[i];
            if (commands[i].equals(loadCommand)) {
                tooltips[i] = this.getLoadToolTip();
                continue;
            }
            if (commands[i].equals(GuiUtils.CMD_UPDATE)) {
                tooltips[i] = this.getUpdateToolTip();
                labels[i] = "icon:/auxdata/ui/icons/view-refresh22.png";
                continue;
            }
            if (commands[i].equals(GuiUtils.CMD_HELP)) {
                tooltips[i] = "Show help for this chooser";
                labels[i] = "icon:/auxdata/ui/icons/show-help22.png";
                continue;
            }
            if (!commands[i].equals(GuiUtils.CMD_CANCEL)) continue;
            tooltips[i] = "Cancel choosing and close the window";
        }
        JPanel comp = GuiUtils.makeButtons(listener, labels, commands, tooltips, buttonMap);
        this.loadButton = (JButton)buttonMap.get(this.getLoadCommandName());
        JButton tmpButton = (JButton)buttonMap.get(GuiUtils.CMD_CANCEL);
        if (tmpButton != null) {
            this.cancelButton = tmpButton;
            this.cancelButton.setEnabled(false);
        }
        this.setHaveData(this.haveData);
        return this.registerStatusComp("buttons", comp);
    }

    public boolean canDoUpdate() {
        return true;
    }

    protected String[] getButtonLabels() {
        if (this.canDoUpdate()) {
            return new String[]{this.getLoadCommandName(), GuiUtils.CMD_UPDATE, GuiUtils.CMD_HELP};
        }
        return new String[]{this.getLoadCommandName(), GuiUtils.CMD_HELP};
    }

    protected String getLoadToolTip() {
        return "Load the selected data";
    }

    protected String getUpdateToolTip() {
        return "Refresh content shown in this Chooser";
    }

    public void setHaveData(boolean have) {
        if (this.loadButton != null) {
            this.loadButton.setEnabled(have);
        }
        this.haveData = have;
    }

    public boolean getHaveData() {
        return this.haveData;
    }

    public void clearWaitCursor() {
        this.cursorCnt = 0;
        GuiUtils.setCursor(this.getContents(), Cursor.getPredefinedCursor(0));
    }

    public void showWaitCursor() {
        this.showWaitCursor(this.getContents());
    }

    public void showNormalCursor() {
        this.showNormalCursor(this.getContents());
    }

    public void showWaitCursor(JComponent comp) {
        ++this.cursorCnt;
        GuiUtils.setCursor(comp, Cursor.getPredefinedCursor(3));
    }

    public void showNormalCursor(JComponent comp) {
        --this.cursorCnt;
        if (this.cursorCnt < 0) {
            this.cursorCnt = 0;
        }
        if (this.cursorCnt == 0) {
            GuiUtils.setCursor(comp, Cursor.getPredefinedCursor(0));
        }
    }

    public JComponent padLabel(String s) {
        return GuiUtils.inset((Component)new JLabel(s), new Insets(0, 5, 0, 5));
    }

    public JComponent getContents() {
        if (this.contents == null) {
            this.contents = this.doMakeContents();
            this.updateStatus();
        }
        return this.contents;
    }

    protected JComponent doMakeContents() {
        return new JPanel();
    }

    protected void updateStatus() {
    }

    public void doLoad() {
        Misc.run(this, "doLoadInThread");
    }

    public void doLoadInThread() {
    }

    public void doUpdate() {
    }

    public void doHelp() {
        Help.getDefaultHelp().gotoTarget(this.helpPath);
    }

    public void doCancel() {
    }

    protected void doClose() {
    }

    public void logException(String msg, Exception exc) {
        LogUtil.logException(msg, exc);
    }

    public void setHelpPath(String path) {
        this.helpPath = path;
    }
}

