/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Resource;

public class CheckboxCategoryPanel
extends JPanel
implements ChangeListener {
    public static ImageIcon categoryOpenIcon = new ImageIcon(Resource.getImage("/auxdata/ui/icons/CategoryOpen.gif"));
    public static ImageIcon categoryClosedIcon = new ImageIcon(Resource.getImage("/auxdata/ui/icons/CategoryClosed.gif"));
    private boolean checking = false;
    private List<JCheckBox> items = new ArrayList<JCheckBox>();
    private JCheckBox visCbx;
    private JButton toggleBtn;
    private Font normalFont;
    private Font specialFont;

    public CheckboxCategoryPanel(String catName, boolean visible) {
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.setVisible(visible);
        final CheckboxCategoryPanel theCatPanel = this;
        this.toggleBtn = GuiUtils.getImageButton(categoryClosedIcon);
        this.toggleBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (theCatPanel.isVisible()) {
                    theCatPanel.setVisible(false);
                    CheckboxCategoryPanel.this.toggleBtn.setIcon(categoryClosedIcon);
                } else {
                    theCatPanel.setVisible(true);
                    CheckboxCategoryPanel.this.toggleBtn.setIcon(categoryOpenIcon);
                }
            }
        });
        this.visCbx = new JCheckBox(catName);
        this.visCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckboxCategoryPanel.this.toggleAll(CheckboxCategoryPanel.this.visCbx.isSelected());
            }
        });
        this.normalFont = this.visCbx.getFont();
        this.specialFont = this.normalFont.deriveFont(3);
    }

    public void addItem(JCheckBox box) {
        this.items.add(box);
        box.addChangeListener(this);
        this.checkVisCbx();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.checkVisCbx();
    }

    public JPanel getTopPanel() {
        return GuiUtils.hbox(Misc.newList(this.toggleBtn, this.visCbx));
    }

    public void toggleAll(boolean toWhat) {
        this.visCbx.setSelected(toWhat);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setSelected(toWhat);
        }
    }

    public void checkVisCbx() {
        if (this.checking) {
            return;
        }
        this.checking = true;
        boolean anyOn = false;
        boolean allOn = true;
        for (JCheckBox cbx : this.items) {
            if (cbx.isSelected()) {
                anyOn = true;
                continue;
            }
            allOn = false;
        }
        this.visCbx.setSelected(anyOn);
        if (anyOn) {
            if (allOn) {
                this.visCbx.setFont(this.normalFont);
            } else {
                this.visCbx.setFont(this.specialFont);
            }
        } else {
            this.visCbx.setFont(this.normalFont);
        }
        this.checking = false;
    }
}

