/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import ucar.unidata.util.GuiUtils;

public class ButtonTabbedPane
extends JPanel {
    private static Image BUTTON_ICON;
    public static final Color BUTTON_FG_COLOR;
    public static final Color BUTTON_ON_COLOR;
    public static final Color BUTTON_LINE_COLOR;
    private static final Font BUTTON_FONT;
    private static final Border BUTTON_BORDER;
    private List buttonList = new ArrayList();
    private List contentList = new ArrayList();
    private JComponent buttonPanel;
    private ComponentPanel rightPanel;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int width;
    private boolean deleteEnabled = false;

    public ButtonTabbedPane() {
        this((JComponent)null);
    }

    public ButtonTabbedPane(int width) {
        this(null, width);
    }

    public ButtonTabbedPane(JComponent label) {
        this(label, 150);
    }

    public ButtonTabbedPane(JComponent label, int width) {
        this.width = width;
        this.buttonPanel = new JPanel(new BorderLayout());
        JComponent buttonPanelHolder = GuiUtils.top(this.buttonPanel);
        JScrollPane sp = new JScrollPane(buttonPanelHolder);
        buttonPanelHolder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        sp.setBorder(null);
        buttonPanelHolder = sp;
        JComponent filler = width < 0 ? new JPanel() : GuiUtils.filler(width, 1);
        JComponent labelComp = label != null ? GuiUtils.vbox(filler, label) : filler;
        JPanel leftPanel = GuiUtils.topCenter(labelComp, buttonPanelHolder);
        this.rightPanel = new ComponentPanel(this);
        this.setLayout(new BorderLayout());
        this.add("West", leftPanel);
        this.add("Center", this.rightPanel);
    }

    public Image getIcon() {
        if (BUTTON_ICON == null) {
            BUTTON_ICON = GuiUtils.getImage("/auxdata/ui/icons/Selected.gif");
            BUTTON_ICON.getWidth(this);
        }
        return BUTTON_ICON;
    }

    protected void paintButton(Graphics g, AbstractButton button) {
        this.getIcon();
        Rectangle b = button.getBounds();
        g.setColor(button.getBackground());
        g.setFont(button.getFont());
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        if (button.isSelected()) {
            g.setColor(BUTTON_ON_COLOR);
        }
        g.fillRect(0, 0, b.width, b.height);
        g.setColor(BUTTON_LINE_COLOR);
        g.drawLine(0, b.height - 1, b.width, b.height - 1);
        g.setColor(BUTTON_FG_COLOR);
        String text = button.getText();
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int y = (button.getHeight() + fm.getHeight()) / 2 - 2;
        int offset = 2 + BUTTON_ICON.getWidth(null) + 4;
        int textWidth = fm.stringWidth(text);
        int availableWidth = b.width - offset - 2;
        while (textWidth > availableWidth && text.length() > 5) {
            text = text.substring(0, text.length() - 2);
            textWidth = fm.stringWidth(text);
        }
        g.drawString(text, offset, y);
        if (button.isSelected()) {
            int imageHeight = BUTTON_ICON.getHeight(null);
            g.drawImage(BUTTON_ICON, 2, b.height / 2 - imageHeight / 2, null);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0x20) != 0) {
            this.buttonPanel.repaint();
            return false;
        }
        return true;
    }

    private void buttonsChanged(int idx) {
        ArrayList tmp = new ArrayList(this.buttonList);
        boolean anySelected = false;
        if (idx < 0) {
            for (int i = 0; i < tmp.size() && !anySelected; ++i) {
                JToggleButton btn = (JToggleButton)tmp.get(i);
                anySelected = btn.isSelected();
            }
            if (!anySelected && tmp.size() > 0) {
                this.select((JToggleButton)tmp.get(tmp.size() - 1));
            }
        } else {
            while (idx >= 0 && idx >= tmp.size()) {
                --idx;
            }
            if (idx >= 0 && idx < tmp.size()) {
                this.select((JToggleButton)tmp.get(idx));
            }
        }
        this.buttonPanel.removeAll();
        this.buttonPanel.add("North", GuiUtils.vbox(this.buttonList));
        this.buttonPanel.repaint();
    }

    public void setSelectedIndex(int i) {
        this.show((Component)this.contentList.get(i));
    }

    public String getTitleAt(int i) {
        return ((AbstractButton)this.buttonList.get(i)).getText();
    }

    public void show(Component content) {
        for (int i = 0; i < this.contentList.size(); ++i) {
            if (content != this.contentList.get(i)) continue;
            ((JToggleButton)this.buttonList.get(i)).setSelected(true);
        }
        this.rightPanel.show(content);
    }

    public void remove(JToggleButton button, Component contents) {
        int idx = this.buttonList.indexOf(button);
        if (!button.isSelected()) {
            idx = -1;
        }
        this.buttonGroup.remove(button);
        this.buttonList.remove(button);
        this.contentList.remove(contents);
        this.rightPanel.remove(contents);
        this.buttonsChanged(idx);
    }

    public void selectTabForComponent(Component comp) {
        for (int i = 0; i < this.contentList.size(); ++i) {
            Component c = (Component)this.contentList.get(i);
            if (c != comp && !((Container)c).isAncestorOf(comp)) continue;
            ((JToggleButton)this.buttonList.get(i)).setSelected(true);
        }
    }

    public JToggleButton addTab(String label, final Component contents) {
        final JToggleButton[] tmp = new JToggleButton[]{null};
        JToggleButton button = tmp[0] = new JToggleButton(label){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                ButtonTabbedPane.this.paintButton(g, tmp[0]);
            }
        };
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ce) {
                if (tmp[0].isSelected()) {
                    ButtonTabbedPane.this.rightPanel.show(contents);
                }
            }
        });
        button.setForeground(BUTTON_FG_COLOR);
        button.setBorder(BUTTON_BORDER);
        int height = button.getPreferredSize().height;
        if (GuiUtils.checkHeight(height)) {
            if (this.width > 0) {
                button.setPreferredSize(new Dimension(this.width, height));
            } else {
                button.setPreferredSize(new Dimension(button.getPreferredSize().width + 10, height));
            }
        }
        this.addTab(button, contents);
        return button;
    }

    public void setDeleteEnabled(boolean b) {
        this.deleteEnabled = b;
    }

    public void addTab(final JToggleButton button, final Component contents) {
        this.buttonGroup.add(button);
        this.buttonList.add(button);
        this.contentList.add(contents);
        this.rightPanel.addCard(contents);
        this.buttonsChanged(-1);
        this.select(button);
        button.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int idx;
                int code = e.getKeyCode();
                if (ButtonTabbedPane.this.deleteEnabled && GuiUtils.isDeleteEvent(e)) {
                    ButtonTabbedPane.this.remove(button, contents);
                } else if (code == 40) {
                    int idx2 = ButtonTabbedPane.this.buttonList.indexOf(button) + 1;
                    if (idx2 < ButtonTabbedPane.this.buttonList.size()) {
                        ButtonTabbedPane.this.select((JToggleButton)ButtonTabbedPane.this.buttonList.get(idx2));
                    }
                } else if (code == 38 && (idx = ButtonTabbedPane.this.buttonList.indexOf(button) - 1) >= 0) {
                    ButtonTabbedPane.this.select((JToggleButton)ButtonTabbedPane.this.buttonList.get(idx));
                }
            }
        });
    }

    private void select(JToggleButton b) {
        b.doClick();
        b.requestFocusInWindow();
    }

    static {
        BUTTON_FG_COLOR = Color.black;
        BUTTON_ON_COLOR = Color.gray.brighter();
        BUTTON_LINE_COLOR = Color.gray;
        BUTTON_FONT = new Font("Dialog", 1, 12);
        BUTTON_BORDER = BorderFactory.createEmptyBorder(4, 6, 2, 0);
    }

    public static class ComponentPanel
    extends GuiUtils.CardLayoutPanel {
        ButtonTabbedPane tab;

        public ComponentPanel(ButtonTabbedPane tab) {
            this.tab = tab;
        }

        @Override
        public void show(Component comp) {
            super.show(comp);
            this.tab.selectTabForComponent(comp);
        }
    }
}

