/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Resource;

public class BAMutil {
    public static final String ROLLOVER_ICON = "RolloverIcon";
    public static final String TOGGLE = "isToggle";
    public static final String MNEMONIC = "mnemonic";
    public static final String ACCEL = "accelerator";
    public static final String STATE = "state";
    private static String defaultResourcePath = "/auxdata/ui/icons/";
    private static final int META_KEY = 2;
    static Class cl = new BAMutil().getClass();
    private static boolean debug = false;
    private static boolean debugToggle = false;

    public static ImageIcon getIcon(String name, boolean errMsg) {
        return GuiUtils.getScaledImageIcon(defaultResourcePath + name + ".gif", null, true);
    }

    public static Image getImage(String name) {
        return Resource.getImage(defaultResourcePath + name + ".gif");
    }

    public static Cursor makeCursor(String name) {
        return Resource.makeCursor(defaultResourcePath + name + ".gif");
    }

    public static AbstractButton makeButtcon(Icon icon, Icon rollover, String tooltip, boolean is_toggle) {
        AbstractButton butt = is_toggle ? new JToggleButton() : new JButton();
        if (debug) {
            System.out.println("   makeButtcon" + icon + " " + rollover + " " + tooltip + " " + is_toggle);
        }
        if (icon != null) {
            butt.setIcon(icon);
        }
        if (rollover != null) {
            butt.setRolloverIcon(rollover);
            butt.setRolloverSelectedIcon(rollover);
            butt.setPressedIcon(rollover);
            butt.setRolloverEnabled(true);
        }
        butt.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        if (icon != null) {
            butt.setPreferredSize(new Dimension(icon.getIconHeight() + 2, icon.getIconWidth() + 2));
        } else {
            butt.setPreferredSize(new Dimension(28, 28));
        }
        butt.setMaximumSize(new Dimension(28, 28));
        butt.setToolTipText(tooltip);
        butt.setFocusPainted(false);
        return butt;
    }

    private static JMenuItem makeMenuItem(Icon icon, Icon rollover, String menu_cmd, boolean is_toggle, int mnemonic, int accel) {
        JMenuItem mi = is_toggle ? new JCheckBoxMenuItem(menu_cmd) : new JMenuItem(menu_cmd);
        if (icon != null) {
            mi.setIcon(icon);
        }
        if (rollover != null) {
            mi.setRolloverIcon(rollover);
            mi.setRolloverSelectedIcon(rollover);
            mi.setPressedIcon(rollover);
            mi.setRolloverEnabled(true);
        }
        mi.setHorizontalTextPosition(2);
        if (mnemonic != 0) {
            mi.setMnemonic(mnemonic);
        }
        if (accel != 0) {
            mi.setAccelerator(KeyStroke.getKeyStroke(accel, 2));
        }
        return mi;
    }

    private static JMenuItem makeMenuItemFromAction(Action act) {
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean is_toggle = tog == null ? false : tog;
        Integer mnu = (Integer)act.getValue(MNEMONIC);
        int mnemonic = tog == null ? -1 : mnu;
        Integer acc = (Integer)act.getValue(ACCEL);
        int accel = acc == null ? 0 : acc;
        return BAMutil.makeMenuItem((Icon)act.getValue("SmallIcon"), (Icon)act.getValue(ROLLOVER_ICON), (String)act.getValue("ShortDescription"), is_toggle, mnemonic, accel < 0 ? 0 : accel);
    }

    public static JMenuItem addActionToMenu(JMenu menu, Action act, int menuPos) {
        JMenuItem mi = BAMutil.makeMenuItemFromAction(act);
        if (menuPos >= 0) {
            menu.add((Component)mi, menuPos);
        } else {
            menu.add(mi);
        }
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean is_toggle = tog == null ? false : tog;
        Action myAct = is_toggle ? new toggleAction(act) : act;
        mi.addActionListener(myAct);
        act.addPropertyChangeListener(new myActionChangedListener(mi));
        return mi;
    }

    public static JMenuItem addActionToMenu(JMenu menu, Action act) {
        return BAMutil.addActionToMenu(menu, act, -1);
    }

    private static AbstractButton makeButtconFromAction(Action act) {
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean is_toggle = tog == null ? false : tog;
        return BAMutil.makeButtcon((Icon)act.getValue("SmallIcon"), (Icon)act.getValue(ROLLOVER_ICON), (String)act.getValue("ShortDescription"), is_toggle);
    }

    public static AbstractButton addActionToContainerPos(Container c, Action act, int pos) {
        Boolean tog;
        AbstractButton butt = BAMutil.makeButtconFromAction(act);
        if (pos < 0) {
            c.add(butt);
        } else {
            c.add((Component)butt, pos);
        }
        if (debug) {
            System.out.println(" addActionToContainerPos " + act + " " + butt + " " + pos);
        }
        boolean is_toggle = (tog = (Boolean)act.getValue(TOGGLE)) == null ? false : tog;
        Action myAct = is_toggle ? new toggleAction(act) : act;
        butt.addActionListener(myAct);
        act.addPropertyChangeListener(new myActionChangedListener(butt));
        return butt;
    }

    public static AbstractButton addActionToContainer(Container c, Action act) {
        return BAMutil.addActionToContainerPos(c, act, -1);
    }

    public static void setActionProperties(AbstractAction act, String icon_name, String action_name, boolean is_toggle, int mnemonic, int accel) {
        if (icon_name != null) {
            act.putValue("SmallIcon", BAMutil.getIcon(icon_name, true));
        }
        act.putValue("ShortDescription", action_name);
        act.putValue("LongDescription", action_name);
        act.putValue(TOGGLE, new Boolean(is_toggle));
        act.putValue(MNEMONIC, new Integer(mnemonic));
        act.putValue(ACCEL, new Integer(accel));
    }

    private static class myActionChangedListener
    implements PropertyChangeListener {
        private AbstractButton button;

        myActionChangedListener(AbstractButton b) {
            this.button = b;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (debugToggle) {
                System.out.println("propertyChange " + propertyName + " " + (Boolean)e.getNewValue());
            }
            if (propertyName.equals("Name")) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
                this.button.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if (propertyName.equals(BAMutil.STATE)) {
                Boolean state = (Boolean)e.getNewValue();
                this.button.setSelected(state);
                this.button.repaint();
            }
        }
    }

    private static class toggleAction
    extends AbstractAction {
        private Action orgAct;

        toggleAction(Action orgAct) {
            this.orgAct = orgAct;
            orgAct.putValue(BAMutil.STATE, new Boolean(false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean state = (Boolean)this.orgAct.getValue(BAMutil.STATE);
            this.orgAct.putValue(BAMutil.STATE, new Boolean(state == false));
            if (debugToggle) {
                System.out.println("toggleAction " + state);
            }
            this.orgAct.actionPerformed(e);
        }
    }

    public static class ActionToggle
    extends AbstractAction {
        private Action orgAct;
        private AbstractButton button;

        public ActionToggle(Action oa, AbstractButton b) {
            this.orgAct = oa;
            this.button = b;
            this.orgAct.putValue(BAMutil.STATE, new Boolean(true));
            this.orgAct.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String propertyName = e.getPropertyName();
                    if (debugToggle) {
                        System.out.println("propertyChange " + propertyName + " " + (Boolean)e.getNewValue());
                    }
                    if (propertyName.equals("Name")) {
                        String text = (String)e.getNewValue();
                        button.setText(text);
                        button.repaint();
                    } else if (propertyName.equals("enabled")) {
                        Boolean enabledState = (Boolean)e.getNewValue();
                        button.setEnabled(enabledState);
                        button.repaint();
                    } else if (propertyName.equals(BAMutil.STATE)) {
                        Boolean state = (Boolean)e.getNewValue();
                        button.setSelected(state);
                        button.repaint();
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean state = (Boolean)this.orgAct.getValue(BAMutil.STATE);
            this.orgAct.putValue(BAMutil.STATE, new Boolean(state == false));
            this.orgAct.actionPerformed(e);
        }
    }
}

