/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Resource;
import ucar.unidata.util.StringUtil;

public class AudioPlayer
extends JPanel
implements LineListener,
MetaEventListener {
    private static Icon startIcon;
    private static Icon pauseIcon;
    private int timestamp = 0;
    private JLabel timeLabel;
    private JProgressBar progressBar;
    private boolean running = false;
    private Sequencer sequencer;
    private boolean midiEOM;
    private boolean audioEOM;
    private Synthesizer synthesizer;
    private MidiChannel[] channels;
    private Object currentSound;
    private String currentName;
    private double duration;
    private JButton startBtn;
    private JButton rewindBtn;
    private JSlider volumeSlider;
    private JSlider seekSlider;
    private String soundFile;

    public AudioPlayer() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(this.doMakeControls());
        this.init();
    }

    public void setFile(String file) {
        this.stopPlaying();
        this.currentSound = null;
        this.soundFile = file;
    }

    public void startPlaying() {
        if (this.soundFile == null || this.running) {
            return;
        }
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    AudioPlayer.this.timestamp++;
                    if (AudioPlayer.this.currentSound == null && !AudioPlayer.this.loadSound(AudioPlayer.this.soundFile)) {
                        return;
                    }
                    if (AudioPlayer.this.currentSound != null) {
                        AudioPlayer.this.running = true;
                        AudioPlayer.this.playSound(AudioPlayer.this.timestamp);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    public void stopPlaying() {
        ++this.timestamp;
        this.startBtn.setIcon(startIcon);
        this.running = false;
        if (this.usingClip()) {
            ((Clip)this.currentSound).stop();
        } else if (this.usingSequencer()) {
            this.sequencer.stop();
        }
    }

    public void handleRewindButton() {
        boolean wasRunning = this.running;
        if (this.usingClip()) {
            ((Clip)this.currentSound).setFramePosition(0);
        } else {
            this.stopPlaying();
            if (wasRunning) {
                this.startPlaying();
            }
        }
        this.updateControls();
    }

    public void handleStartButton() {
        if (!this.running) {
            this.startPlaying();
        } else {
            this.stopPlaying();
        }
    }

    public void init() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer instanceof Synthesizer) {
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
                this.channels = this.synthesizer.getChannels();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.sequencer.addMetaEventListener(this);
    }

    public boolean loadSound(String file) {
        this.currentName = IOUtil.getFileTail(file);
        this.duration = 0.0;
        this.updateControls();
        try {
            File f = new File(file);
            if (f.exists()) {
                try {
                    this.currentSound = AudioSystem.getAudioInputStream(f);
                }
                catch (Exception e1) {
                    FileInputStream is = new FileInputStream(f);
                    this.currentSound = new BufferedInputStream(is, 1024);
                }
            } else {
                InputStream is = IOUtil.getInputStream(file);
                try {
                    this.currentSound = AudioSystem.getAudioInputStream(is);
                }
                catch (Exception e) {
                    this.currentSound = new BufferedInputStream(is, 1024);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.currentSound = null;
            return false;
        }
        if (this.sequencer == null) {
            this.currentSound = null;
            return false;
        }
        if (this.currentSound instanceof AudioInputStream) {
            try {
                AudioInputStream stream = (AudioInputStream)this.currentSound;
                AudioFormat format = stream.getFormat();
                if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                    AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                    stream = AudioSystem.getAudioInputStream(tmp, stream);
                    format = tmp;
                }
                DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.addLineListener(this);
                clip.open(stream);
                this.currentSound = clip;
                this.seekSlider.setMaximum((int)stream.getFrameLength());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.currentSound = null;
                return false;
            }
        }
        if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream) {
            try {
                this.sequencer.open();
                if (this.currentSound instanceof Sequence) {
                    this.sequencer.setSequence((Sequence)this.currentSound);
                } else {
                    this.sequencer.setSequence((BufferedInputStream)this.currentSound);
                }
                this.seekSlider.setMaximum((int)(this.sequencer.getMicrosecondLength() / 1000L));
            }
            catch (InvalidMidiDataException imde) {
                LogUtil.userErrorMessage("Unsupported audio file:" + file);
                this.currentSound = null;
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.currentSound = null;
                return false;
            }
        }
        this.seekSlider.setValue(0);
        this.seekSlider.setEnabled(true);
        this.volumeSlider.setEnabled(true);
        this.duration = this.getDuration();
        return true;
    }

    private boolean usingSequencer() {
        if (this.currentSound == null) {
            return false;
        }
        return this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream;
    }

    private boolean usingClip() {
        if (this.currentSound == null) {
            return false;
        }
        return this.currentSound instanceof Clip;
    }

    private void playSound(int myTimestamp) {
        this.running = true;
        this.setVolume();
        this.audioEOM = false;
        this.midiEOM = false;
        if (this.usingSequencer()) {
            this.sequencer.start();
            while (!this.midiEOM && this.running && myTimestamp == this.timestamp) {
                Misc.sleep(99L);
                this.updateControls();
            }
        } else if (this.usingClip()) {
            Clip clip = (Clip)this.currentSound;
            clip.start();
            Misc.sleep(99L);
            while (clip.isActive() && this.running && myTimestamp == this.timestamp) {
                Misc.sleep(99L);
                this.updateControls();
            }
            if (!clip.isActive() && this.running && myTimestamp == this.timestamp) {
                clip.stop();
                clip.setFramePosition(0);
                this.updateControls();
                this.running = false;
            }
        }
    }

    public void close() {
        this.stopPlaying();
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    public double getDuration() {
        double duration = 0.0;
        if (this.currentSound instanceof Sequence) {
            duration = (double)((Sequence)this.currentSound).getMicrosecondLength() / 1000000.0;
        } else if (this.currentSound instanceof BufferedInputStream) {
            duration = (double)this.sequencer.getMicrosecondLength() / 1000000.0;
        } else if (this.usingClip()) {
            Clip clip = (Clip)this.currentSound;
            duration = (float)clip.getBufferSize() / ((float)clip.getFormat().getFrameSize() * clip.getFormat().getFrameRate());
        }
        return duration;
    }

    public double getSeconds() {
        double seconds = 0.0;
        if (this.usingClip()) {
            Clip clip = (Clip)this.currentSound;
            seconds = (float)clip.getFramePosition() / clip.getFormat().getFrameRate();
        } else if (this.usingSequencer()) {
            try {
                seconds = (double)this.sequencer.getMicrosecondPosition() / 1000000.0;
            }
            catch (IllegalStateException e) {
                LogUtil.logException(" IllegalStateException on sequencer.getMicrosecondPosition(): ", e);
            }
        }
        return seconds;
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            this.startBtn.setIcon(startIcon);
            this.audioEOM = true;
        } else if (event.getType() == LineEvent.Type.START) {
            this.startBtn.setIcon(pauseIcon);
        }
    }

    @Override
    public void meta(MetaMessage message) {
        if (message.getType() == 47) {
            this.midiEOM = true;
        }
    }

    public void setVolume() {
        double value = (double)this.volumeSlider.getValue() / 100.0;
        if (this.usingClip()) {
            try {
                Clip clip = (Clip)this.currentSound;
                FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                float dB = (float)(Math.log(value == 0.0 ? 1.0E-4 : value) / Math.log(10.0) * 20.0);
                gainControl.setValue(dB);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.usingSequencer()) {
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].controlChange(7, (int)(value * 127.0));
            }
        }
    }

    private JPanel doMakeControls() {
        if (startIcon == null) {
            pauseIcon = Resource.getIcon("/auxdata/ui/icons/Pause16.gif", true);
            startIcon = Resource.getIcon("/auxdata/ui/icons/Play16.gif", true);
        }
        Font monoFont = Font.decode("monospaced");
        this.timeLabel = new JLabel(StringUtil.padRight(" ", 12));
        this.timeLabel.setFont(monoFont);
        this.progressBar = new JProgressBar(0, 100);
        this.startBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Play16.gif", this, "handleStartButton");
        this.rewindBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Rewind16.gif", this, "handleRewindButton");
        JPanel buttons = GuiUtils.left(GuiUtils.hbox(this.rewindBtn, this.startBtn));
        this.seekSlider = GuiUtils.makeSlider(0, 100, 0, this, "seekSliderChanged");
        this.volumeSlider = GuiUtils.makeSlider(0, 100, 80, this, "volumeSliderChanged");
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel sliderPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Seek:"), this.seekSlider, GuiUtils.rLabel("Volume:"), this.volumeSlider}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        return GuiUtils.top(GuiUtils.vbox(GuiUtils.inset((Component)buttons, 3), GuiUtils.leftCenterRight(buttons, this.progressBar, GuiUtils.inset((Component)this.timeLabel, new Insets(0, 5, 0, 5))), sliderPanel));
    }

    public void volumeSliderChanged(int value) {
        this.setVolume();
    }

    public void seekSliderChanged(int value) {
        if (this.usingClip()) {
            ((Clip)this.currentSound).setFramePosition(value);
        } else if (this.currentSound instanceof Sequence) {
            long dur = ((Sequence)this.currentSound).getMicrosecondLength();
            this.sequencer.setMicrosecondPosition(value * 1000);
        } else if (this.currentSound instanceof BufferedInputStream) {
            long dur = this.sequencer.getMicrosecondLength();
            this.sequencer.setMicrosecondPosition(value * 1000);
        }
        this.updateControls();
    }

    public void setComponentsEnabled(boolean state) {
    }

    public void updateControls() {
        this.timeLabel.setText(StringUtil.padRight(" ", 12));
        double seconds = this.getSeconds();
        if (this.midiEOM) {
            seconds = this.duration;
        }
        if (this.currentSound == null || this.duration <= 0.0 || seconds <= 0.0) {
            this.progressBar.setValue(0);
            return;
        }
        String s = String.valueOf(seconds);
        s = s.substring(0, s.indexOf(46) + 2);
        s = s + "/" + (int)this.duration;
        this.timeLabel.setText(StringUtil.padRight(s, 12));
        int progress = (int)(seconds / this.duration * 100.0);
        this.progressBar.setValue(progress);
    }
}

