/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.sql.Clause;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class SqlUtil {
    public static boolean debug = false;
    public static final GregorianCalendar calendar = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
    private static SimpleDateFormat sdf;
    public static boolean showLoadingSql;
    private static ConnectionManager connectionManager;

    public static String quote(Object s) {
        return "'" + s.toString() + "'";
    }

    public static String group(String s) {
        return "(" + s + ")";
    }

    public static String groupBy(String columns) {
        return " GROUP BY " + columns;
    }

    public static String makeAnd(List toks) {
        return StringUtil.join(" AND ", toks);
    }

    public static String makeAnd(String clause1, String clause2) {
        return clause1 + " AND " + clause2;
    }

    public static String makeAnd(String clause1, String clause2, String clause3) {
        return SqlUtil.makeAnd(clause1, clause2) + " AND " + clause3;
    }

    public static String makeOr(List toks) {
        return StringUtil.join(" OR ", toks);
    }

    public static String makeWhere(List toks) {
        if (toks.size() > 0) {
            return " WHERE " + StringUtil.join(" AND ", toks);
        }
        return " ";
    }

    public static String format(java.util.Date d) {
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
        }
        return sdf.format(d);
    }

    public static String getDateString(String dttm) throws ParseException {
        java.util.Date date = DateUtil.parse(dttm);
        return SqlUtil.format(date);
    }

    public static String getQuestionMarks(int cnt) {
        String s = "";
        for (int i = 0; i < cnt; ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + "?";
        }
        return s;
    }

    public static String comma(Object s1, Object s2) {
        return s1.toString() + "," + s2.toString();
    }

    public static String comma(String[] s) {
        return StringUtil.join(",", s);
    }

    public static String commaNoDot(String[] s) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            l.add(SqlUtil.unDot(s[i]));
        }
        return StringUtil.join(",", l);
    }

    public static String unDot(String col) {
        int idx = col.indexOf(".");
        if (idx >= 0) {
            col = col.substring(idx + 1);
        }
        return col;
    }

    public static String comma(List s) {
        return StringUtil.join(",", s);
    }

    public static String comma(Object s1, Object s2, Object s3) {
        return s1.toString() + "," + s2.toString() + "," + s3.toString();
    }

    public static String comma(Object s1, Object s2, Object s3, Object s4) {
        return s1.toString() + "," + s2.toString() + "," + s3.toString() + "," + s4.toString();
    }

    public static String comma(Object s1, Object s2, Object s3, Object s4, Object s5) {
        return s1.toString() + "," + s2.toString() + "," + s3.toString() + "," + s4.toString() + "," + s5.toString();
    }

    public static String comma(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6) {
        return SqlUtil.comma(s1, s2, s3, s4, s5) + "," + s6;
    }

    public static String comma(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7) {
        return SqlUtil.comma(s1, s2, s3, s4, s5, s6) + "," + s7;
    }

    public static String comma(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8) {
        return SqlUtil.comma(s1, s2, s3, s4, s5, s6, s7) + "," + s8;
    }

    public static String makeOrSplit(String column, String values, boolean quoteThem) {
        String value;
        int i;
        List<String> toks = StringUtil.split(values, ",", true, true);
        ArrayList<String> nots = new ArrayList<String>();
        ArrayList<String> notNots = new ArrayList<String>();
        for (int i2 = 0; i2 < toks.size(); ++i2) {
            String expr = toks.get(i2).trim();
            if (expr.startsWith("!")) {
                nots.add(expr);
                continue;
            }
            notNots.add(expr);
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer notSb = new StringBuffer();
        for (i = 0; i < nots.size(); ++i) {
            if (i > 0) {
                notSb.append(" AND ");
            }
            value = nots.get(i).toString();
            notSb.append(SqlUtil.expr(column, value, quoteThem));
        }
        for (i = 0; i < notNots.size(); ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            value = notNots.get(i).toString();
            sb.append(SqlUtil.expr(column, value, quoteThem));
        }
        if (nots.size() > 0 && notNots.size() > 0) {
            return SqlUtil.group(notSb.toString()) + " AND " + SqlUtil.group(sb.toString());
        }
        if (nots.size() > 0) {
            return SqlUtil.group(notSb.toString());
        }
        if (notNots.size() > 0) {
            return SqlUtil.group(sb.toString());
        }
        return "";
    }

    public static String validName(String name) {
        return name;
    }

    public static String count(String name) {
        return " count(" + SqlUtil.validName(name) + ")";
    }

    public static String distinct(String name) {
        return " distinct " + SqlUtil.validName(name);
    }

    public static String max(String name) {
        return " max(" + SqlUtil.validName(name) + ")";
    }

    public static String min(String name) {
        return " min(" + SqlUtil.validName(name) + ")";
    }

    public static void makeInsert(StringBuffer sb, String table, String values) {
        sb.append("INSERT INTO ");
        sb.append(table);
        sb.append(" VALUES (");
        sb.append(values);
        sb.append(")");
    }

    public static String makeInsert(String table, String names, String values) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(table);
        sb.append(" (");
        sb.append(names);
        sb.append(" )");
        sb.append(" VALUES (");
        sb.append(values);
        sb.append(")");
        return sb.toString();
    }

    public static String makeInsert(String table, String[] names) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(table);
        sb.append(" (");
        sb.append(SqlUtil.comma(names));
        sb.append(" ) values ( ");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(" ? ");
        }
        sb.append(" )");
        return sb.toString();
    }

    public static String makeDelete(String table, String where) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM   ");
        sb.append(table);
        sb.append(" WHERE ");
        sb.append(where);
        return sb.toString();
    }

    public static String makeDelete(String table, String colId, String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM   ");
        sb.append(table);
        sb.append(" WHERE ");
        sb.append(colId + "=" + id);
        return sb.toString();
    }

    public static void update(Connection connection, String table, String colId, String id, String[] names, Object[] values) throws Exception {
        String query = SqlUtil.makeUpdate(table, colId, names);
        PreparedStatement stmt = connection.prepareStatement(query);
        for (int i = 0; i < values.length; ++i) {
            SqlUtil.setValue(stmt, values[i], i + 1);
        }
        stmt.setString(values.length + 1, id);
        stmt.execute();
        SqlUtil.close(stmt);
    }

    public static void update(Connection connection, String table, Clause clause, String[] names, Object[] values) throws Exception {
        String query = SqlUtil.makeUpdate(table, clause, names);
        PreparedStatement stmt = connection.prepareStatement(query);
        int colCnt = 1;
        for (int i = 0; i < values.length; ++i) {
            SqlUtil.setValue(stmt, values[i], colCnt);
            ++colCnt;
        }
        clause.setValue(stmt, colCnt);
        stmt.execute();
        SqlUtil.close(stmt);
    }

    public static void setValue(PreparedStatement stmt, Object value, int col) throws Exception {
        if (value instanceof String) {
            stmt.setString(col, value.toString());
        } else if (value instanceof Double) {
            stmt.setDouble(col, (Double)value);
        } else if (value instanceof Integer) {
            stmt.setInt(col, (Integer)value);
        } else if (value instanceof java.util.Date) {
            java.util.Date dttm = (java.util.Date)value;
            stmt.setTimestamp(col, new Timestamp(dttm.getTime()), calendar);
        } else {
            throw new IllegalArgumentException("Unknown value:" + value);
        }
    }

    public static String makeUpdate(String table, String colId, String[] names) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE  ");
        sb.append(table);
        sb.append(" SET ");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(" " + SqlUtil.unDot(names[i]) + "=?" + " ");
        }
        sb.append(" WHERE ");
        sb.append(colId + " = ?");
        return sb.toString();
    }

    public static String makeUpdate(String table, Clause clause, String[] names) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE  ");
        sb.append(table);
        sb.append(" SET ");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(" " + SqlUtil.unDot(names[i]) + "=?" + " ");
        }
        sb.append(" WHERE ");
        clause.addClause(sb);
        return sb.toString();
    }

    public static String eq(String name, String value) {
        return " " + SqlUtil.validName(name) + "=" + value + " ";
    }

    public static String ge(String name, double value) {
        return " " + SqlUtil.validName(name) + ">=" + value + " ";
    }

    public static String ge(String name, int value) {
        return " " + SqlUtil.validName(name) + ">=" + value + " ";
    }

    public static String ge(String name, String value) {
        return " " + SqlUtil.validName(name) + ">=" + value + " ";
    }

    public static String le(String name, double value) {
        return " " + SqlUtil.validName(name) + "<=" + value + " ";
    }

    public static String le(String name, int value) {
        return " " + SqlUtil.validName(name) + "<=" + value + " ";
    }

    public static String le(String name, java.util.Date value) {
        return " " + SqlUtil.validName(name) + "<=" + SqlUtil.quote(SqlUtil.format(value)) + " ";
    }

    public static String ge(String name, java.util.Date value) {
        return " " + SqlUtil.validName(name) + ">=" + SqlUtil.quote(SqlUtil.format(value)) + " ";
    }

    public static String eq(String name, java.util.Date value) {
        return " " + SqlUtil.validName(name) + "=" + SqlUtil.quote(SqlUtil.format(value)) + " ";
    }

    public static String neq(String name, java.util.Date value) {
        return " " + SqlUtil.validName(name) + "<>" + SqlUtil.quote(SqlUtil.format(value)) + " ";
    }

    public static String makeSelect(String what, String table, String where) {
        return SqlUtil.makeSelect(what, Misc.newList(table), where);
    }

    public static String makeSelect(String what, List<String> tables) {
        return SqlUtil.makeSelect(what, tables, "");
    }

    public static String makeSelect(String what, List<String> tables, String where) {
        return SqlUtil.makeSelect(what, tables, where, "");
    }

    public static String makeSelect(String what, List tables, String where, String suffixSql) {
        return SqlUtil.makeSelect(what, tables, where, null, suffixSql);
    }

    public static String makeSelect(String what, List tables, String where, String sqlBetweenFromAndWhere, String suffixSql) {
        sqlBetweenFromAndWhere = sqlBetweenFromAndWhere == null ? "" : " " + sqlBetweenFromAndWhere;
        suffixSql = suffixSql == null ? "" : " " + suffixSql;
        String tableClause = "";
        Hashtable<String, String> seen = new Hashtable<String, String>();
        for (int i = 0; i < tables.size(); ++i) {
            String table = (String)tables.get(i);
            if (seen.get(table) != null) continue;
            seen.put(table, table);
            if (tableClause.length() > 0) {
                tableClause = tableClause + ",";
            }
            tableClause = tableClause + table;
        }
        String sql = "SELECT " + what + " FROM " + tableClause + sqlBetweenFromAndWhere + (where.trim().length() > 0 ? " \nWHERE " + where : "") + suffixSql;
        return sql;
    }

    public static String expr(String col, String value, boolean quoteThem) {
        boolean doNot = false;
        if (value.startsWith("!")) {
            value = value.substring(1);
            doNot = true;
        }
        if (value.startsWith("%") || value.endsWith("%")) {
            return " " + col + (doNot ? " NOT " : "") + " LIKE " + SqlUtil.quote(value) + " ";
        }
        return " " + col + (doNot ? " <> " : "=") + (quoteThem ? SqlUtil.quote(value) : value) + " ";
    }

    public static void loadSql(String sql, Statement statement, boolean ignoreErrors) throws Exception {
        SqlUtil.loadSql(sql, statement, ignoreErrors, false);
    }

    public static void loadSql(String sql, Statement statement, boolean ignoreErrors, boolean printStatus) throws Exception {
        SqlUtil.loadSql(sql, statement, ignoreErrors, printStatus, new ArrayList<SqlError>());
    }

    public static void loadSql(String sql, Statement statement, boolean ignoreErrors, boolean printStatus, List<SqlError> errors) throws Exception {
        int cnt = 0;
        for (String command : SqlUtil.parseSql(sql)) {
            if (printStatus) {
                if (++cnt % 100 == 0) {
                    System.err.print(".");
                }
                if (cnt % 1000 == 0) {
                    System.err.println("\n" + cnt);
                }
            }
            try {
                if ((command = command.trim()).length() <= 0) continue;
                statement.execute(command);
                if (!showLoadingSql) continue;
                System.err.println("SqlUtil.loadSql:" + command.replace("\n", " "));
            }
            catch (Exception exc) {
                errors.add(new SqlError(command, exc));
                String msg = exc.toString().toLowerCase();
                if (msg.indexOf("duplicate") < 0 && msg.indexOf("already exists") < 0 && msg.indexOf("can't drop") < 0 && msg.indexOf("doesn't exist") < 0 && msg.indexOf("is not a column in table") < 0) {
                    System.err.println("\n*********************************************");
                    System.err.println("Bad sql:" + command);
                    System.err.println(exc);
                    System.err.println("********************************************\n");
                }
                if (ignoreErrors) continue;
                throw exc;
            }
        }
    }

    public static List<String> parseSql(String sql) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> toks = StringUtil.split(sql, "\n");
        StringBuffer sb = new StringBuffer();
        for (String line : toks) {
            String trimLine = line.trim();
            if (trimLine.startsWith("--")) continue;
            sb.append(line);
            sb.append("\n");
            if (!trimLine.endsWith(";")) continue;
            String lineSql = sb.toString().trim();
            lineSql = lineSql.substring(0, lineSql.length() - 1);
            result.add(lineSql);
            sb = new StringBuffer();
        }
        if (sb.toString().length() > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    public static double[] readTime(Iterator iter, int column) throws Exception {
        ResultSet results;
        double[] current = new double[10000];
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            Date dttm = results.getDate(column, (Calendar)calendar);
            double value = dttm.getTime();
            current[cnt++] = value;
            if (cnt < current.length) continue;
            double[] tmp = current;
            current = new double[current.length * 2];
            System.arraycopy(tmp, 0, current, 0, tmp.length);
        }
        double[] actual = new double[cnt];
        System.arraycopy(current, 0, actual, 0, cnt);
        return actual;
    }

    public static float[] readFloat(Iterator iter, int column, float missing) throws Exception {
        ResultSet results;
        float[] current = new float[10000];
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            float value = results.getFloat(column);
            if (value == missing) {
                value = Float.NaN;
            }
            current[cnt++] = value;
            if (cnt < current.length) continue;
            float[] tmp = current;
            current = new float[current.length * 2];
            System.arraycopy(tmp, 0, current, 0, tmp.length);
        }
        float[] actual = new float[cnt];
        System.arraycopy(current, 0, actual, 0, cnt);
        return actual;
    }

    public static List<float[]> readFloats(Iterator iter, float missing) throws Exception {
        int column;
        ResultSet results;
        ArrayList<float[]> arrays = new ArrayList<float[]>();
        int numCols = -1;
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            if (numCols == -1) {
                ResultSetMetaData rsmd = results.getMetaData();
                numCols = rsmd.getColumnCount();
                for (int column2 = 0; column2 < numCols; ++column2) {
                    arrays.add(new float[1000]);
                }
            }
            for (column = 0; column < numCols; ++column) {
                float[] current = (float[])arrays.get(column);
                float value = results.getFloat(column + 1);
                if (value == missing) {
                    value = Float.NaN;
                }
                current[cnt] = value;
                if (cnt + 1 < current.length) continue;
                float[] tmp = current;
                current = new float[current.length * 2];
                System.arraycopy(tmp, 0, current, 0, tmp.length);
                arrays.set(column, current);
            }
            ++cnt;
        }
        if (debug) {
            // empty if block
        }
        for (column = 0; column < numCols; ++column) {
            float[] current = (float[])arrays.get(column);
            float[] actual = new float[cnt];
            System.arraycopy(current, 0, actual, 0, cnt);
            arrays.set(column, actual);
        }
        return arrays;
    }

    public static int[] readInt(Iterator iter, int column) throws Exception {
        ResultSet results;
        int[] current = new int[10000];
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            int value = results.getInt(column);
            current[cnt++] = value;
            if (cnt < current.length) continue;
            int[] tmp = current;
            current = new int[current.length * 2];
            System.arraycopy(tmp, 0, current, 0, tmp.length);
        }
        int[] actual = new int[cnt];
        System.arraycopy(current, 0, actual, 0, cnt);
        return actual;
    }

    public static String[] readString(Iterator iter, String columnName) throws Exception {
        return SqlUtil.readString(iter, -1, columnName);
    }

    public static String[] readString(Iterator iter) throws Exception {
        return SqlUtil.readString(iter, 1);
    }

    public static String[] readString(Iterator iter, int column) throws Exception {
        return SqlUtil.readString(iter, column, null);
    }

    private static String[] readString(Iterator iter, int column, String name) throws Exception {
        ResultSet results;
        String[] current = new String[10000];
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            String value;
            if (name != null) {
                column = results.findColumn(name);
                name = null;
            }
            if ((value = results.getString(column)) == null) continue;
            current[cnt++] = value;
            if (cnt < current.length) continue;
            String[] tmp = current;
            current = new String[current.length * 2];
            System.arraycopy(tmp, 0, current, 0, tmp.length);
        }
        String[] actual = new String[cnt];
        System.arraycopy(current, 0, actual, 0, cnt);
        return actual;
    }

    public static List<String[]> readStringTuples(Iterator iter, int cnt) throws Exception {
        ResultSet results;
        ArrayList<String[]> values = new ArrayList<String[]>();
        while ((results = iter.getNext()) != null) {
            String[] tuple = new String[cnt];
            for (int col = 1; col <= cnt; ++col) {
                tuple[col - 1] = results.getString(col);
            }
            values.add(tuple);
        }
        return values;
    }

    public static double[] readDouble(Iterator iter, int column, double missing) throws Exception {
        ResultSet results;
        double[] current = new double[10000];
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            double value = results.getDouble(column);
            if (value == missing) {
                value = Double.NaN;
            }
            current[cnt++] = value;
            if (cnt < current.length) continue;
            double[] tmp = current;
            current = new double[current.length * 2];
            System.arraycopy(tmp, 0, current, 0, tmp.length);
        }
        double[] actual = new double[cnt];
        System.arraycopy(current, 0, actual, 0, cnt);
        return actual;
    }

    public static java.util.Date[] readDate(Iterator iter, int column) throws Exception {
        ResultSet results;
        java.util.Date[] current = new java.util.Date[10000];
        int cnt = 0;
        while ((results = iter.getNext()) != null) {
            Date value = results.getDate(column, (Calendar)calendar);
            current[cnt++] = value;
            if (cnt < current.length) continue;
            java.util.Date[] tmp = current;
            current = new java.util.Date[current.length * 2];
            System.arraycopy(tmp, 0, current, 0, tmp.length);
        }
        java.util.Date[] actual = new java.util.Date[cnt];
        System.arraycopy(current, 0, actual, 0, cnt);
        return actual;
    }

    public static Iterator getIterator(Statement stmt) {
        return new Iterator(stmt);
    }

    public static Iterator getIterator(Statement stmt, int offset, int limit) {
        return new Iterator(stmt, offset, limit);
    }

    public static void setConnectionManager(ConnectionManager mgr) {
        if (connectionManager == null || connectionManager != mgr) {
            // empty if block
        }
        connectionManager = mgr;
    }

    public static void close(Statement stmt) throws SQLException {
        if (connectionManager != null) {
            connectionManager.closeStatement(stmt);
        } else {
            stmt.close();
        }
    }

    public static Hashtable cleanUpArguments(Hashtable formArgs) {
        Hashtable<String, String> cleanArgs = new Hashtable<String, String>();
        Enumeration keys = formArgs.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)formArgs.get(key);
            value = SqlUtil.cleanUp(value);
            cleanArgs.put(key, value);
        }
        return cleanArgs;
    }

    public static String cleanUp(String value) {
        value = value.replace("'", "");
        return value;
    }

    public static String cleanName(String value) {
        value = value.replaceAll(" ", "_");
        value = value.replaceAll("\\.", "_");
        return value;
    }

    public static PreparedStatement getSelectStatement(Connection connection, String what, List tables, Clause clause, String suffixSql) throws Exception {
        return SqlUtil.getSelectStatement(connection, what, tables, clause, null, suffixSql);
    }

    public static PreparedStatement getSelectStatement(Connection connection, String what, List tables, Clause clause, String sqlBetweenFromAndWhere, String suffixSql) throws Exception {
        PreparedStatement statement = connection.prepareStatement(SqlUtil.getSelectStatement(what, tables, clause, sqlBetweenFromAndWhere, suffixSql));
        if (connectionManager != null) {
            connectionManager.initSelectStatement(statement);
        }
        return statement;
    }

    public static String getSelectStatement(String what, List tables, Clause clause, String suffixSql) throws Exception {
        return SqlUtil.getSelectStatement(what, tables, clause, null, suffixSql);
    }

    public static String getSelectStatement(String what, List tables, Clause clause, String sqlBetweenFromAndWhere, String suffixSql) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (clause != null) {
            clause.addClause(sb);
        }
        String sql = SqlUtil.makeSelect(what, tables, sb.toString(), sqlBetweenFromAndWhere, suffixSql);
        if (debug) {
            System.err.println("sql: " + sql);
        }
        return sql;
    }

    public static Statement select(Connection connection, String what, List tables, Clause clause, String extra) throws Exception {
        return SqlUtil.select(connection, what, tables, clause, extra, -1);
    }

    public static Statement select(Connection connection, String what, List tables, Clause clause, String extra, int max) throws Exception {
        return SqlUtil.select(connection, what, tables, clause, extra, max, 0);
    }

    public static Statement select(Connection connection, String what, List tables, Clause clause, String suffixSql, int max, int timeout) throws Exception {
        return SqlUtil.select(connection, what, tables, clause, null, suffixSql, max, timeout);
    }

    public static Statement select(Connection connection, String what, List tables, Clause clause, String sqlBetweenFromAndWhere, String suffixSql, int max, int timeout) throws Exception {
        PreparedStatement stmt = SqlUtil.getSelectStatement(connection, what, tables, clause, sqlBetweenFromAndWhere, suffixSql);
        if (max > 0) {
            stmt.setMaxRows(max);
        }
        if (clause != null) {
            clause.setValue(stmt, 1);
        }
        if (timeout > 0) {
            stmt.setQueryTimeout(timeout);
        }
        stmt.execute();
        return stmt;
    }

    public static PreparedStatement getDeleteStatement(Connection connection, String table, Clause clause) throws Exception {
        StringBuffer sb = new StringBuffer();
        clause.addClause(sb);
        String query = SqlUtil.makeDelete(table, sb.toString());
        return connection.prepareStatement(query);
    }

    public static void delete(Connection connection, String table, Clause clause) throws Exception {
        PreparedStatement stmt = SqlUtil.getDeleteStatement(connection, table, clause);
        clause.setValue(stmt, 1);
        stmt.execute();
        SqlUtil.close(stmt);
    }

    public static Statement select(Connection connection, String what, List tables, Clause clause) throws Exception {
        return SqlUtil.select(connection, what, tables, clause, "");
    }

    public static Statement select(Connection connection, String what, List tables, Clause[] clauses) throws Exception {
        return SqlUtil.select(connection, what, tables, clauses == null ? null : Clause.and(clauses));
    }

    public static Statement select(Connection connection, String what, List tables, Clause[] clauses, String extra) throws Exception {
        return SqlUtil.select(connection, what, tables, clauses == null ? null : Clause.and(clauses), extra);
    }

    public static void update(Connection connection, String table, Clause clause) throws Exception {
    }

    public static String wildCardBefore(String s) {
        return "%" + s;
    }

    public static String wildCardAfter(String s) {
        return s + "%";
    }

    public static String wildCardBoth(String s) {
        return "%" + s + "%";
    }

    static {
        showLoadingSql = false;
    }

    public static final class SqlError {
        private String sql;
        private Exception exception;

        public SqlError(String sql, Exception exc) {
            this.sql = sql;
            this.exception = exc;
        }

        public String getSql() {
            return this.sql;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static interface ConnectionManager {
        public void closeStatement(Statement var1);

        public void initSelectStatement(Statement var1);
    }

    public static class Iterator {
        private Statement stmt;
        private int resultSetCnt = 0;
        private ResultSet lastResultSet;
        private boolean shouldCloseStatement = true;
        private int offset = 0;
        private int limit = -1;
        private int cnt = 0;

        public Iterator(Statement stmt) {
            this(stmt, 0, -1);
        }

        public Iterator(Statement stmt, int offset, int limit) {
            this.stmt = stmt;
            this.offset = offset;
            this.limit = limit;
        }

        public void setShouldCloseStatement(boolean value) {
            this.shouldCloseStatement = value;
        }

        public boolean getShouldCloseStatement() {
            return this.shouldCloseStatement;
        }

        public ResultSet xxxnext() throws SQLException {
            if (this.stmt == null) {
                return null;
            }
            if (this.resultSetCnt != 0) {
                this.stmt.getMoreResults();
            }
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
            ++this.resultSetCnt;
            this.lastResultSet = this.stmt.getResultSet();
            if (this.lastResultSet == null) {
                if (this.shouldCloseStatement) {
                    this.close(this.stmt);
                }
                this.stmt = null;
            }
            return this.lastResultSet;
        }

        public ResultSet getResults() {
            return this.lastResultSet;
        }

        public ResultSet getNext() throws SQLException {
            try {
                if (this.stmt == null) {
                    return null;
                }
                if (this.lastResultSet == null) {
                    this.lastResultSet = this.stmt.getResultSet();
                    if (this.lastResultSet == null) {
                        return null;
                    }
                    if (!this.lastResultSet.next()) {
                        this.checkClose();
                        return null;
                    }
                    while (this.offset-- > 0) {
                        if (this.lastResultSet.next()) continue;
                        this.checkClose();
                        return null;
                    }
                    ++this.cnt;
                    return this.lastResultSet;
                }
                if (this.lastResultSet.next()) {
                    ++this.cnt;
                    return this.lastResultSet;
                }
                if (this.lastResultSet != null) {
                    this.lastResultSet.close();
                }
                this.lastResultSet = this.stmt.getResultSet();
                if (this.lastResultSet.next()) {
                    ++this.cnt;
                    return this.lastResultSet;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.checkClose();
            return null;
        }

        public int getCount() {
            return this.cnt;
        }

        public boolean countOK() {
            return this.cnt < this.limit;
        }

        private void checkClose() throws SQLException {
            if (this.shouldCloseStatement) {
                this.close(this.stmt);
                this.lastResultSet = null;
                this.stmt = null;
            }
        }

        public void close() throws SQLException {
            if (this.stmt != null) {
                if (this.shouldCloseStatement) {
                    this.close(this.stmt);
                }
                this.stmt = null;
            }
        }

        protected void close(Statement stmt) throws SQLException {
            SqlUtil.close(stmt);
        }
    }
}

