/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.sql;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import ucar.unidata.sql.SqlUtil;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class Clause {
    public static final GregorianCalendar calendar = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
    public static final String EXPR_EQUALS = "=";
    public static final String EXPR_GE = ">=";
    public static final String EXPR_LE = "<=";
    public static final String EXPR_LT = "<";
    public static final String EXPR_GT = ">";
    public static final String EXPR_NOTEQUALS = "<>";
    public static final String EXPR_LIKE = "LIKE";
    public static final String EXPR_NOTLIKE = "NOTLIKE";
    public static final String EXPR_ISNULL = "is null";
    public static final String EXPR_ISNOTNULL = "is not null";
    public static final String EXPR_IN = "IN";
    public static final String EXPR_OR = "OR";
    public static final String EXPR_AND = "AND";
    public static final String EXPR_JOIN = "join";
    private String expr = null;
    private String column;
    private Object value;
    private String extraSelectForInClause;
    private Clause[] subClauses;

    public Clause() {
    }

    public Clause(String expr, Clause[] subClauses) {
        this.expr = expr;
        this.subClauses = subClauses;
    }

    public Clause(String column, String expr, Object value) {
        this.column = column;
        this.expr = expr;
        this.value = value;
    }

    public static Clause or(Clause clause1, Clause clause2) {
        return new Clause(EXPR_OR, new Clause[]{clause1, clause2});
    }

    public static Clause and(Clause clause1, Clause clause2) {
        return new Clause(EXPR_AND, new Clause[]{clause1, clause2});
    }

    public static Clause or(Clause[] clauses) {
        if (clauses == null || clauses.length == 0) {
            return null;
        }
        return new Clause(EXPR_OR, clauses);
    }

    public static Clause and(Clause[] clauses) {
        if (clauses == null || clauses.length == 0) {
            return null;
        }
        return new Clause(EXPR_AND, clauses);
    }

    public static Clause and(List<Clause> clauses) {
        return new Clause(EXPR_AND, Clause.toArray(clauses));
    }

    public static Clause or(List<Clause> clauses) {
        return new Clause(EXPR_OR, Clause.toArray(clauses));
    }

    public static List<Clause> makeIntClauses(String colName, List<String> values) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (String value : values) {
            if (value == null) continue;
            value = value.trim();
            clauses.add(Clause.eq(colName, (int)new Integer(value)));
        }
        return clauses;
    }

    public static List<Clause> makeStringClauses(String colName, List<String> values) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (String value : values) {
            if (value == null) continue;
            value = value.trim();
            clauses.add(Clause.eq(colName, value));
        }
        return clauses;
    }

    public static Clause eq(String column, Object value, boolean not) {
        if (not) {
            return Clause.neq(column, value);
        }
        return Clause.eq(column, value);
    }

    public static Clause eq(String column, Object value) {
        return new Clause(column, EXPR_EQUALS, value);
    }

    public static Clause neq(String column, Object value) {
        return new Clause(column, EXPR_NOTEQUALS, value);
    }

    public static Clause ge(String column, Object value) {
        return new Clause(column, EXPR_GE, value);
    }

    public static Clause gt(String column, Object value) {
        return new Clause(column, EXPR_GT, value);
    }

    public static Clause lt(String column, Object value) {
        return new Clause(column, EXPR_LT, value);
    }

    public static Clause le(String column, Object value) {
        return new Clause(column, EXPR_LE, value);
    }

    public static Clause le(String column, double value) {
        return Clause.le(column, new Double(value));
    }

    public static Clause ge(String column, double value) {
        return Clause.ge(column, new Double(value));
    }

    public static Clause isNull(String column) {
        return new Clause(column, EXPR_ISNULL, null);
    }

    public static Clause isNotNull(String column) {
        return new Clause(column, EXPR_ISNOTNULL, null);
    }

    public static Clause like(String column, Object value, boolean not) {
        if (not) {
            return Clause.notLike(column, value);
        }
        return Clause.like(column, value);
    }

    public static Clause like(String column, Object value) {
        return new Clause(column, EXPR_LIKE, value);
    }

    public static Clause notLike(String column, Object value) {
        return new Clause(column, EXPR_NOTLIKE, value);
    }

    public static Clause in(String column, String inner) {
        return new Clause(column, EXPR_IN, inner);
    }

    public static Clause in(String column, String what, String from, Clause inner) {
        Clause clause = new Clause(EXPR_IN, new Clause[]{inner});
        clause.column = column;
        clause.extraSelectForInClause = " select " + what + " from " + from + " ";
        return clause;
    }

    public static Clause join(String column, String column2) {
        return new Clause(column, EXPR_JOIN, column2);
    }

    public static Clause[] toArray(List<Clause> clauses) {
        Clause[] array = new Clause[clauses.size()];
        for (int i = 0; i < clauses.size(); ++i) {
            array[i] = clauses.get(i);
        }
        return array;
    }

    public static boolean isColumnFromTable(List<Clause> clauses, String table) {
        for (Clause clause : clauses) {
            if (!clause.isColumnFromTable(table)) continue;
            return true;
        }
        return false;
    }

    public static Clause makeOrSplit(String column, String values) {
        String value;
        int i;
        List<String> toks = StringUtil.split(values, ",", true, true);
        ArrayList<String> nots = new ArrayList<String>();
        ArrayList<String> notNots = new ArrayList<String>();
        for (int i2 = 0; i2 < toks.size(); ++i2) {
            String expr = toks.get(i2).trim();
            if (expr.startsWith("!")) {
                nots.add(expr.substring(1));
                continue;
            }
            notNots.add(expr);
        }
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        ArrayList<Clause> notClauses = new ArrayList<Clause>();
        for (i = 0; i < nots.size(); ++i) {
            value = nots.get(i).toString();
            notClauses.add(Clause.neq(column, value));
        }
        for (i = 0; i < notNots.size(); ++i) {
            value = notNots.get(i).toString();
            if (value.startsWith("%") || value.endsWith("%")) {
                clauses.add(Clause.like(column, value));
                continue;
            }
            clauses.add(Clause.eq(column, value));
        }
        if (notClauses.size() > 0 && clauses.size() > 0) {
            return Clause.and(Clause.and(Clause.toArray(notClauses)), Clause.or(Clause.toArray(clauses)));
        }
        if (notClauses.size() > 0) {
            if (notClauses.size() == 1) {
                return (Clause)notClauses.get(0);
            }
            return Clause.and(Clause.toArray(notClauses));
        }
        if (clauses.size() > 0) {
            if (clauses.size() == 1) {
                return (Clause)clauses.get(0);
            }
            return Clause.or(Clause.toArray(clauses));
        }
        return new Clause();
    }

    public boolean isColumnFromTable(String table) {
        if (this.column == null) {
            if (this.subClauses != null) {
                for (int i = 0; i < this.subClauses.length; ++i) {
                    if (this.subClauses[i] == null || !this.subClauses[i].isColumnFromTable(table)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.column.startsWith(table + ".");
    }

    public List<String> getTableNames() {
        return this.getTableNames(new ArrayList<String>());
    }

    public List<String> getTableNames(List<String> names) {
        this.doGetTableNames(names);
        return names;
    }

    private void doGetTableNames(List<String> names) {
        String name;
        int idx;
        if (this.expr.equals(EXPR_IN)) {
            return;
        }
        if (this.subClauses != null) {
            for (Clause clause : this.subClauses) {
                if (clause == null) continue;
                clause.doGetTableNames(names);
            }
            return;
        }
        if (this.expr.equals(EXPR_JOIN) && (idx = this.value.toString().indexOf(".")) >= 0 && !names.contains(name = this.value.toString().substring(0, idx))) {
            names.add(name);
        }
        if (this.column != null && (idx = this.column.indexOf(".")) >= 0 && !names.contains(name = this.column.substring(0, idx))) {
            names.add(name);
        }
    }

    public boolean isColumn(String col) {
        if (this.column == null) {
            return false;
        }
        return this.column.equals(col);
    }

    public static boolean isColumn(List<Clause> clauses, String col) {
        for (Clause clause : clauses) {
            if (!clause.isColumn(col)) continue;
            return true;
        }
        return false;
    }

    public StringBuffer addClause(StringBuffer sb) {
        if (this.expr == null) {
            return sb;
        }
        if (this.subClauses != null) {
            ArrayList<String> toks = new ArrayList<String>();
            for (int i = 0; i < this.subClauses.length; ++i) {
                StringBuffer buff = new StringBuffer();
                if (this.subClauses[i] == null) continue;
                this.subClauses[i].addClause(buff);
                toks.add(buff.toString());
            }
            if (this.expr.equals(EXPR_IN)) {
                if (toks.size() == 0) {
                    sb.append(SqlUtil.group(this.column + "  IN ( " + this.extraSelectForInClause + ")"));
                } else {
                    sb.append(SqlUtil.group(this.column + "  IN ( " + this.extraSelectForInClause + " WHERE " + toks.get(0) + ")"));
                }
            } else {
                if (toks.size() > 1) {
                    sb.append("(");
                }
                sb.append(StringUtil.join(" " + this.expr + " ", toks));
                if (toks.size() > 1) {
                    sb.append(")");
                }
            }
            return sb;
        }
        if (this.expr.equals(EXPR_ISNULL)) {
            sb.append(SqlUtil.group(this.column + " is null "));
        } else if (this.expr.equals(EXPR_ISNOTNULL)) {
            sb.append(SqlUtil.group(this.column + " is not null "));
        } else if (this.expr.equals(EXPR_JOIN)) {
            sb.append(SqlUtil.group(this.column + " =  " + this.value));
        } else if (this.expr.equals(EXPR_LIKE)) {
            sb.append(SqlUtil.group(this.column + "  like ?"));
        } else if (this.expr.equals(EXPR_IN)) {
            sb.append(SqlUtil.group(this.column + "  IN (" + this.value + ")"));
        } else if (this.expr.equals(EXPR_NOTLIKE)) {
            sb.append(SqlUtil.group("NOT " + this.column + "  like ?"));
        } else {
            if (SqlUtil.debug) {
                // empty if block
            }
            String theExpr = this.column + " " + this.expr + " ?";
            sb.append(SqlUtil.group(theExpr));
        }
        return sb;
    }

    public int setValue(PreparedStatement stmt, int col) throws Exception {
        if (this.expr == null) {
            return col;
        }
        if (this.subClauses != null) {
            for (int i = 0; i < this.subClauses.length; ++i) {
                if (this.subClauses[i] == null) continue;
                col = this.subClauses[i].setValue(stmt, col);
            }
            return col;
        }
        if (this.expr.equals(EXPR_ISNULL) || this.expr.equals(EXPR_ISNOTNULL) || this.expr.equals(EXPR_JOIN)) {
            return col;
        }
        if (SqlUtil.debug) {
            System.err.println("   value:" + this.value + " " + col);
        }
        SqlUtil.setValue(stmt, this.value, col);
        return col + 1;
    }

    public void setColumn(String value) {
        this.column = value;
    }

    public String getColumn() {
        return this.column;
    }

    public void setExpr(String value) {
        this.expr = value;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setValue(Object value) {
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.column != null) {
            if (this.expr.equals(EXPR_IN)) {
                if (this.subClauses != null && this.subClauses.length > 0) {
                    return this.column + " " + this.expr + " (" + this.extraSelectForInClause + " WHERE " + this.subClauses[0] + ")";
                }
                return this.column + " " + this.expr + " (" + this.extraSelectForInClause + ")";
            }
            String svalue = this.value instanceof String ? "'" + this.value + "'" : "" + this.value;
            return this.column + " " + this.expr + " " + svalue;
        }
        if (this.subClauses != null) {
            if (this.subClauses.length == 1) {
                return this.subClauses[0].toString();
            }
            return "(" + Misc.join(" " + this.expr + " ", this.subClauses) + ")";
        }
        return "clause:null";
    }
}

