/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.metdata;

import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.DataUtil;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.StationTableImpl;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.Unit;

public class NamedStationTable
extends StationTableImpl {
    private boolean valid = true;
    private String type;
    private String name = null;
    private String description = null;
    private int counter = 0;
    private String category;
    private String base;
    private static final String TAG_STATIONTABLES = "stationtables";
    private static final String TAG_COORDINATES = "coordinates";
    private static final String TAG_STATIONTABLE = "stationtable";
    private static final String TAG_STATION = "station";
    private static final String TAG_YRESULTSET = "ResultSet";
    private static final String TAG_YRESULT = "Result";
    private static final String TAG_YLATITUDE = "Latitude";
    private static final String TAG_YLONGITUDE = "Longitude";
    private static final String TAG_YTITLE = "Title";
    private static final String TAG_YADDRESS = "Address";
    private static final String TAG_YCITY = "City";
    private static final String TAG_YSTATE = "State";
    private static final String TAG_YPHONE = "Phone";
    private static final String TAG_CHANNEL = "channel";
    private static final String TAG_DC_SUBJECT = "dc:subject";
    private static final String TAG_RSS = "rss";
    private static final String TAG_LINK = "link";
    private static final String TAG_ITEM = "item";
    private static final String TAG_GEO_LAT = "geo:lat";
    private static final String TAG_GEO_LONG = "geo:long";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_TITLE = "title";
    private static final String TAG_STN = "stn";
    private static final String TAG_LOCATION = "location";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LAT = "lat";
    private static final String ATTR_LON = "lon";
    private static final String ATTR_ELEV = "elev";
    private static final String ATTR_ELEVUNIT = "elevunit";
    private static final String ATTR_LOADMORE = "loadmore";
    public static final String KEY_IDNUMBER = "idn";
    public static final String KEY_STATE = "st";
    public static final String KEY_COUNTRY = "co";
    public static final String KEY_BULLETIN = "bull";
    public static final String KEY_PRIORITY = "pri";
    public static final String KEY_EXTRA = "extra";
    private String id;
    private boolean haveCreatedMap = false;
    private List roots = new ArrayList();

    public NamedStationTable(Element root) {
        if (root != null) {
            this.roots.add(root);
        }
    }

    public NamedStationTable() {
        this((String)null);
    }

    public NamedStationTable(String name) {
        this.setName(name != null ? name : "Table " + this.counter++);
    }

    private void addRoot(Element root) {
        if (root != null) {
            this.roots.add(root);
        }
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.category != null) {
            return this.category + "::" + this.name;
        }
        return this.name;
    }

    public void setCategory(String value) {
        this.category = value;
    }

    public String getCategory() {
        return this.category;
    }

    public static String getStationXml(String name, String category, List stations) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        sb.append("\n");
        String attrs = XmlUtil.attr(ATTR_NAME, name);
        if (category != null) {
            attrs = attrs + XmlUtil.attr(ATTR_CATEGORY, category);
        }
        sb.append(XmlUtil.openTag(TAG_STATIONTABLE, attrs));
        sb.append("\n");
        for (int i = 0; i < stations.size(); ++i) {
            NamedStationImpl station = (NamedStationImpl)stations.get(i);
            sb.append(XmlUtil.tag(TAG_STATION, XmlUtil.attrs(ATTR_ID, station.getID(), ATTR_NAME, station.getName(), ATTR_LAT, station.getLatitude() + "") + XmlUtil.attrs(ATTR_LON, station.getLongitude() + "", ATTR_ELEV, station.getAltitude() + "")));
            sb.append("\n");
        }
        sb.append(XmlUtil.closeTag(TAG_STATIONTABLE));
        sb.append("\n");
        return sb.toString();
    }

    private static boolean isKml(String filename) {
        return IOUtil.hasSuffix(filename, ".kml") || IOUtil.hasSuffix(filename, ".kmz");
    }

    private static boolean isGempak(String filename) {
        return IOUtil.hasSuffix(filename, ".tbl");
    }

    public static List createStationTables(XmlResourceCollection xrc) {
        Hashtable<String, NamedStationTable> nameToTable = new Hashtable<String, NamedStationTable>();
        ArrayList<NamedStationTable> tables = new ArrayList<NamedStationTable>();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> hrefBases = new ArrayList<String>();
        XmlNodeList tableRoots = new XmlNodeList();
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (int i = 0; i < xrc.size(); ++i) {
            NamedStationTable table;
            String name = xrc.get(i).toString();
            String title = xrc.getProperty(ATTR_NAME, i);
            if (title == null) {
                title = IOUtil.stripExtension(IOUtil.getFileTail(name));
            }
            String type = xrc.getProperty(ATTR_TYPE, i);
            String category = xrc.getProperty(ATTR_CATEGORY, i);
            if (name.toLowerCase().endsWith(".csv")) {
                try {
                    String csv = xrc.read(i);
                    if (csv == null) continue;
                    table = new NamedStationTable(title);
                    table.createStationTableFromCsv(csv);
                    tables.add(table);
                    table.setType(type);
                    table.setCategory(category);
                }
                catch (Exception exc) {
                    System.err.println("error processing locations file:" + name);
                    exc.printStackTrace();
                }
                continue;
            }
            if (NamedStationTable.isKml(name)) {
                try {
                    NamedStationTable table2 = NamedStationTable.createStationTableFromFile(xrc.get(i).toString());
                    if (table2 == null || !table2.valid) continue;
                    tables.add(table2);
                    table2.setType(type);
                    table2.setCategory(category);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                continue;
            }
            if (NamedStationTable.isGempak(name)) {
                try {
                    String tbl = xrc.read(i);
                    if (tbl == null) continue;
                    table = new NamedStationTable(title);
                    Trace.call1("creating Gempak station table " + name);
                    table.createStationTableFromGempak(tbl);
                    Trace.call2("creating Gempak station table " + name);
                    tables.add(table);
                    table.setType(type);
                    table.setCategory(category);
                }
                catch (Exception exc) {
                    System.err.println("error processing locations file:" + name);
                    exc.printStackTrace();
                }
                continue;
            }
            Element root = xrc.getRoot(i);
            if (root == null) continue;
            String tag = root.getTagName();
            String resourceId = xrc.getResourceId(i);
            if (Misc.equals(tag, TAG_STATIONTABLES)) {
                XmlNodeList children = XmlUtil.getElements(root, TAG_STATIONTABLE);
                for (int childIdx = 0; childIdx < children.size(); ++childIdx) {
                    tableRoots.add(children.get(childIdx));
                    types.add(type);
                    resourceIds.add(resourceId);
                    hrefBases.add(XmlUtil.getAttribute((Node)root, "base", (String)null));
                }
                continue;
            }
            tableRoots.add(root);
            types.add(type);
            resourceIds.add(resourceId);
            hrefBases.add(null);
        }
        for (int tableIdx = 0; tableIdx < tableRoots.size(); ++tableIdx) {
            Element root = (Element)tableRoots.get(tableIdx);
            String type = (String)types.get(tableIdx);
            String name = XmlUtil.getAttribute((Node)root, ATTR_NAME, "");
            String desc = XmlUtil.getAttribute((Node)root, "description", (String)null);
            String category = XmlUtil.getAttribute((Node)root, ATTR_CATEGORY, (String)null);
            String base = (String)hrefBases.get(tableIdx);
            String key = name + "_" + category;
            NamedStationTable table = (NamedStationTable)nameToTable.get(key);
            if (table == null) {
                table = NamedStationTable.createStationTable(root);
                if (table.getType() == null) {
                    table.setType(type);
                }
                table.setId((String)resourceIds.get(tableIdx));
                table.setDescription(desc);
                if (base != null) {
                    table.base = base;
                }
                nameToTable.put(key, table);
                if (table == null) continue;
                tables.add(table);
                continue;
            }
            table.addRoot(root);
        }
        return tables;
    }

    private void makeStations(Element root) {
        Trace.call1("NamedStationTable.makeStations");
        this.makeStationsInner(root);
        Trace.call2("NamedStationTable.makeStations");
    }

    private void makeStationsInner(Element root) {
        try {
            String desc = XmlUtil.getAttribute((Node)root, "description", (String)null);
            if (desc != null) {
                this.description = desc;
            }
            NodeList children = root.getChildNodes();
            Unit elevUnit = CommonUnit.meter;
            String elevUnitStr = XmlUtil.getAttribute((Node)root, ATTR_ELEVUNIT, (String)null);
            if (elevUnitStr != null) {
                elevUnit = Util.parseUnit(elevUnitStr);
            }
            for (int childIdx = 0; childIdx < children.getLength(); ++childIdx) {
                Element coordNode;
                Node node = children.item(childIdx);
                String tagName = node.getNodeName();
                if (!tagName.equals(TAG_STATION) && !tagName.equals(TAG_STN) && !tagName.equals(TAG_LOCATION)) continue;
                String id = XmlUtil.getAttribute(node, ATTR_ID, (String)null);
                String stationName = XmlUtil.getAttribute(node, ATTR_NAME, id);
                if (stationName == null) {
                    stationName = TAG_LOCATION;
                }
                if (id == null) {
                    id = stationName;
                }
                String coordString = (coordNode = XmlUtil.findChild(node, TAG_COORDINATES)) != null ? XmlUtil.getChildText(coordNode) : null;
                ArrayList<double[][]> coords = null;
                double lat = 0.0;
                double lon = 0.0;
                double alt = 0.0;
                String elev = null;
                if (coordString == null) {
                    lat = Misc.decodeLatLon(XmlUtil.getAttribute(node, ATTR_LAT));
                    lon = Misc.decodeLatLon(XmlUtil.getAttribute(node, ATTR_LON));
                } else {
                    double[][] tmp = StringUtil.parseCoordinates(coordString);
                    coords = new ArrayList<double[][]>();
                    coords.add(tmp);
                }
                elev = XmlUtil.getAttribute(node, ATTR_ELEV, (String)null);
                Unit tmpElevUnit = elevUnit;
                if (elev != null && elev.trim().length() > 0) {
                    try {
                        Real tmp = Util.toReal(elev);
                        alt = tmp.getValue();
                        if (tmp.getUnit() != null && !tmp.getUnit().toString().equals("UniversalUnit")) {
                            tmpElevUnit = tmp.getUnit();
                        }
                    }
                    catch (Exception exc) {
                        System.err.println("error parsing elevation:" + elev);
                    }
                }
                try {
                    NamedStationImpl station;
                    if (coords != null) {
                        station = new NamedStationImpl(id, stationName, coords, tmpElevUnit);
                        station.addProperty(ATTR_LON, station.getLongitude() + "");
                        station.addProperty(ATTR_LAT, station.getLatitude() + "");
                        station.addProperty(ATTR_ELEV, station.getAltitude());
                    } else {
                        station = new NamedStationImpl(id, stationName, lat, lon, alt, tmpElevUnit);
                    }
                    String childText = XmlUtil.getChildText(node).trim();
                    if (childText.length() > 0) {
                        station.addProperty("description", childText);
                    }
                    NamedNodeMap attrs = node.getAttributes();
                    int numAttrs = attrs.getLength();
                    for (int i = 0; i < numAttrs; ++i) {
                        Attr attr = (Attr)attrs.item(i);
                        String attrName = attr.getNodeName();
                        if (attrName.equals(ATTR_ELEV)) {
                            station.addProperty(attrName, new Real(RealType.Altitude, alt, tmpElevUnit));
                            continue;
                        }
                        station.addProperty(attrName, attr.getNodeValue());
                    }
                    this.add(station, true);
                    continue;
                }
                catch (Exception excp) {
                    System.err.println("Error reading locations:" + excp);
                    excp.printStackTrace();
                    return;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void makeStationsFromRss(Element root) {
        try {
            Element channel = root.getTagName().equals(TAG_CHANNEL) ? root : XmlUtil.findChild(root, TAG_CHANNEL);
            if (channel == null) {
                return;
            }
            String mainTitle = XmlUtil.getGrandChildText(channel, TAG_TITLE);
            if (mainTitle != null) {
                this.setName(mainTitle);
            }
            this.description = XmlUtil.getGrandChildText(channel, "description");
            NodeList children = channel.getChildNodes();
            for (int childIdx = 0; childIdx < children.getLength(); ++childIdx) {
                Node itemNode = children.item(childIdx);
                String tagName = itemNode.getNodeName();
                if (!tagName.equals(TAG_ITEM)) continue;
                String title = XmlUtil.getGrandChildText(itemNode, TAG_TITLE);
                Element latNode = XmlUtil.findChild(itemNode, TAG_GEO_LAT);
                Element lonNode = XmlUtil.findChild(itemNode, TAG_GEO_LONG);
                if (title == null || latNode == null || lonNode == null) continue;
                String id = title;
                double lat = Misc.decodeLatLon(XmlUtil.getChildText(latNode));
                double lon = Misc.decodeLatLon(XmlUtil.getChildText(lonNode));
                double alt = 0.0;
                try {
                    String link;
                    NamedStationImpl station = new NamedStationImpl(title, title, lat, lon, alt, CommonUnit.meter);
                    String description = XmlUtil.getGrandChildText(itemNode, "description");
                    if (description != null) {
                        station.addProperty("description", description);
                    }
                    if ((link = XmlUtil.getGrandChildText(itemNode, TAG_LINK)) != null) {
                        station.addProperty(TAG_LINK, link);
                    }
                    List subjects = XmlUtil.findChildren(itemNode, TAG_DC_SUBJECT);
                    for (int i = 0; i < subjects.size(); ++i) {
                        station.addProperty("subject" + (i + 1), XmlUtil.getChildText((Element)subjects.get(i)));
                    }
                    this.add(station, true);
                    continue;
                }
                catch (Exception excp) {
                    System.out.println("bad station id=" + id + "name = " + mainTitle + "lat = " + lat + "lon = " + lon + "alt = " + alt);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void makeStationsFromYahooQuery(Element root) {
        try {
            this.setName("Yahoo Query");
            List results = XmlUtil.findChildren(root, TAG_YRESULT);
            String[] attrTags = new String[]{TAG_YADDRESS, TAG_YCITY, TAG_YSTATE, TAG_YPHONE};
            for (int resultIdx = 0; resultIdx < results.size(); ++resultIdx) {
                Node resultNode = (Node)results.get(resultIdx);
                String title = XmlUtil.getGrandChildText(resultNode, TAG_YTITLE);
                if (title == null) {
                    title = ATTR_NAME;
                }
                double lat = Misc.decodeLatLon(XmlUtil.getGrandChildText(resultNode, TAG_YLATITUDE));
                double lon = Misc.decodeLatLon(XmlUtil.getGrandChildText(resultNode, TAG_YLONGITUDE));
                double alt = 0.0;
                try {
                    NamedStationImpl station = new NamedStationImpl(title, title, lat, lon, alt, CommonUnit.meter);
                    StringBuffer sb = new StringBuffer();
                    for (int attrIdx = 0; attrIdx < attrTags.length; ++attrIdx) {
                        String text = XmlUtil.getGrandChildText(resultNode, attrTags[attrIdx]);
                        if (text == null) continue;
                        sb.append(attrTags[attrIdx] + ": " + text + "<br>");
                    }
                    station.addProperty("description", sb.toString());
                    this.add(station, true);
                    continue;
                }
                catch (Exception excp) {
                    System.out.println("bad station id=" + title);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void createStationTableFromKmlFile(String filename) throws Exception {
        String kml = null;
        if (IOUtil.hasSuffix(filename, ".kmz")) {
            ZipEntry ze;
            InputStream is = IOUtil.getInputStream(filename);
            if (is == null) {
                this.valid = false;
                return;
            }
            BufferedInputStream bin = new BufferedInputStream(is);
            ZipInputStream zin = new ZipInputStream(bin);
            while ((ze = zin.getNextEntry()) != null) {
                String name = ze.getName().toLowerCase();
                if (!name.toLowerCase().endsWith(".kml")) continue;
                kml = new String(IOUtil.readBytes(zin, null, false));
                break;
            }
        } else {
            kml = IOUtil.readContents(filename, NamedStationTable.class);
        }
        if (kml == null) {
            this.valid = false;
            return;
        }
        Element root = XmlUtil.getRoot("xml:" + kml, NamedStationTable.class);
        if (root == null) {
            return;
        }
        List nodes = XmlUtil.findDescendants(root, "Placemark");
        for (int i = 0; i < nodes.size(); ++i) {
            List<String> toks;
            String name;
            String coords;
            Element node = (Element)nodes.get(i);
            Element coordsNode = XmlUtil.findDescendant(node, TAG_COORDINATES);
            if (coordsNode == null || (coords = XmlUtil.getChildText(coordsNode)) == null || (name = XmlUtil.getGrandChildText(node, ATTR_NAME)) == null || (toks = StringUtil.split(coords, ",", true, true)).size() <= 1) continue;
            double lon = Misc.decodeLatLon(toks.get(0).toString());
            double lat = Misc.decodeLatLon(toks.get(1).toString());
            double altitude = toks.size() >= 3 ? Misc.parseDouble(toks.get(2).toString()) : 0.0;
            String desc = XmlUtil.getGrandChildText(node, "description");
            NamedStationImpl station = new NamedStationImpl(name, name, lat, lon, altitude, CommonUnit.meter);
            this.add(station, true);
            if (desc == null) continue;
            station.addProperty("description", desc);
        }
    }

    public void createStationTableFromCsv(String csv) throws Exception {
        int i;
        List<String> lines = StringUtil.split(csv, "\n");
        if (lines.size() == 0) {
            return;
        }
        List<String> names = StringUtil.split(lines.get(0), ",", true, true);
        int latIndex = -1;
        int lonIndex = -1;
        int altIndex = -1;
        int titleIndex = -1;
        for (i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            if ((name = name.toLowerCase().trim()).equals("latitude") && latIndex == -1) {
                latIndex = i;
            }
            if (name.equals("longitude") && lonIndex == -1) {
                lonIndex = i;
            }
            if (name.equals(ATTR_LAT) && latIndex == -1) {
                latIndex = i;
            }
            if (name.equals("long") && lonIndex == -1) {
                lonIndex = i;
            }
            if (name.equals(ATTR_LON) && lonIndex == -1) {
                lonIndex = i;
            }
            if ((name.startsWith("alt") || name.startsWith("altitude")) && altIndex == -1) {
                altIndex = i;
            } else if (name.startsWith(ATTR_ELEV) && altIndex == -1) {
                altIndex = i;
            }
            if (name.equals(ATTR_ID) || name.startsWith(TAG_STATION) || name.startsWith("site")) {
                titleIndex = i;
            }
            if (i == latIndex || i == lonIndex || i == altIndex || titleIndex != -1) continue;
            titleIndex = i;
        }
        if (latIndex == -1) {
            throw new IllegalStateException("Unable to determine the latitude value");
        }
        if (lonIndex == -1) {
            throw new IllegalStateException("Unable to determine the longitude value");
        }
        if (titleIndex == -1) {
            throw new IllegalStateException("Unable to determine the name value");
        }
        for (i = 1; i < lines.size(); ++i) {
            List<String> toks;
            String line = lines.get(i).toString().trim();
            if (line.length() == 0 || (toks = StringUtil.split(line, ",", true, false)).size() == 0) continue;
            if (toks.size() != names.size()) {
                throw new IllegalStateException("CSV line: " + lines.get(i) + " does not have correct number of elements. Has:" + toks.size() + " looking for:" + names.size());
            }
            double lat = Misc.decodeLatLon(toks.get(latIndex));
            double lon = Misc.decodeLatLon(toks.get(lonIndex));
            double altitude = 0.0;
            Unit altUnit = CommonUnit.meter;
            if (altIndex != -1) {
                String tok = toks.get(altIndex);
                Real tmp = Util.toReal(tok);
                altitude = tmp.getValue();
                if (tok.indexOf("[") >= 0) {
                    altUnit = tmp.getUnit();
                }
            }
            String title = toks.get(titleIndex);
            NamedStationImpl station = new NamedStationImpl(title, title, lat, lon, altitude, altUnit);
            for (int j = 0; j < toks.size(); ++j) {
                if (j == latIndex || j == lonIndex || j == titleIndex || j == altIndex) continue;
                station.addProperty(names.get(j), toks.get(j));
            }
            this.add(station, true);
        }
    }

    public void createStationTableFromGempak(String tbl) throws Exception {
        List<String> lines = StringUtil.split(tbl, "\n", false, true);
        if (lines.size() == 0) {
            return;
        }
        int[] indices = new int[]{0, 9, 16, 49, 52, 55, 61, 68};
        int[] lengths = new int[]{8, 6, 32, 2, 2, 5, 6, 5};
        boolean readOne = false;
        int idIndex = 0;
        int idnIndex = 1;
        int nameIndex = 2;
        int stIndex = 3;
        int coIndex = 4;
        int latIndex = 5;
        int lonIndex = 6;
        int altIndex = 7;
        int priIndex = 8;
        int extraIndex = 9;
        int numToks = indices.length;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.startsWith("!")) continue;
            if (!readOne) {
                String station = line.substring(0, 8);
                if (!station.substring(4, 8).equals("    ") && station.substring(4, 5).equals(" ")) {
                    indices = new int[]{0, 5, 12, 45, 48, 51, 57, 64};
                    lengths = new int[]{4, 6, 32, 2, 2, 5, 6, 5};
                }
                readOne = true;
            }
            String[] words = new String[numToks + 2];
            try {
                for (int idx = 0; idx < indices.length; ++idx) {
                    words[idx] = line.substring(indices[idx], indices[idx] + lengths[idx]);
                    words[idx] = words[idx].trim();
                }
                int lastRead = indices[numToks - 1] + lengths[numToks - 1];
                if (line.length() > lastRead) {
                    String rest = line.substring(lastRead, line.length()).trim();
                    int end = Math.min(2, rest.length());
                    if (!rest.equals("")) {
                        words[priIndex] = rest.substring(0, end);
                    }
                    if (rest.length() > 2) {
                        words[numToks] = rest.substring(2, rest.length());
                    }
                }
                String id = words[idIndex];
                String name = words[nameIndex];
                double lat = Misc.parseDouble(words[latIndex]) / 100.0;
                double lon = Misc.parseDouble(words[lonIndex]) / 100.0;
                double alt = Misc.parseDouble(words[altIndex]) / 100.0;
                NamedStationImpl station = new NamedStationImpl(id, name, lat, lon, alt, CommonUnit.meter);
                station.addProperty(KEY_IDNUMBER, words[idnIndex]);
                station.addProperty(KEY_STATE, words[stIndex]);
                station.addProperty(KEY_COUNTRY, words[coIndex]);
                if (words[priIndex] != null) {
                    station.addProperty(KEY_PRIORITY, words[priIndex]);
                }
                if (words[extraIndex] != null) {
                    station.addProperty(KEY_EXTRA, words[extraIndex]);
                }
                this.add(station, true);
                continue;
            }
            catch (Exception e) {
                System.out.println("Unable to parse station [" + i + "] for:\n" + line);
                System.err.println("error:" + e);
            }
        }
    }

    public void createStationTableFromBulletin(String tbl) throws Exception {
        List<String> lines = StringUtil.split(tbl, "\n", false, true);
        if (lines.size() == 0) {
            return;
        }
        int bullIndex = 0;
        int idIndex = 1;
        int nameIndex = 2;
        int stIndex = 3;
        int coIndex = 4;
        int latIndex = 5;
        int lonIndex = 6;
        int altIndex = 7;
        int priIndex = 8;
        int extraIndex = 9;
        int numToks = 8;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.startsWith("!")) continue;
            String[] words = null;
            try {
                words = line.split("\\s++", numToks);
                if (words.length < numToks) {
                    System.err.println("invalid line: " + line);
                    continue;
                }
                String id = words[idIndex];
                String name = words[nameIndex];
                double lat = Misc.parseDouble(words[latIndex]) / 100.0;
                double lon = Misc.parseDouble(words[lonIndex]) / 100.0;
                double alt = Misc.parseDouble(words[altIndex]) / 100.0;
                NamedStationImpl station = new NamedStationImpl(id, name, lat, lon, alt, CommonUnit.meter);
                station.addProperty(KEY_BULLETIN, words[bullIndex]);
                station.addProperty(KEY_STATE, words[stIndex]);
                station.addProperty(KEY_COUNTRY, words[coIndex]);
                this.add(station, true);
                continue;
            }
            catch (Exception e) {
                System.out.println("Unable to parse station [" + i + "] for:\n" + line);
                System.err.println("error:" + e);
            }
        }
    }

    public static NamedStationTable createStationTableFromFile(String filename) throws Exception {
        if (filename.indexOf("<stationtable") >= 0) {
            return NamedStationTable.createStationTable(filename);
        }
        if (IOUtil.hasSuffix(filename, ".csv")) {
            NamedStationTable table = new NamedStationTable(IOUtil.stripExtension(IOUtil.getFileTail(filename)));
            table.createStationTableFromCsv(IOUtil.readContents(filename, NamedStationTable.class));
            return table;
        }
        if (IOUtil.hasSuffix(filename, ".xls")) {
            NamedStationTable table = new NamedStationTable(IOUtil.stripExtension(IOUtil.getFileTail(filename)));
            String csv = DataUtil.xlsToCsv(filename);
            table.createStationTableFromCsv(csv);
            return table;
        }
        if (NamedStationTable.isKml(filename)) {
            NamedStationTable table = new NamedStationTable(IOUtil.stripExtension(IOUtil.getFileTail(filename)));
            table.createStationTableFromKmlFile(filename);
            return table;
        }
        if (NamedStationTable.isGempak(filename)) {
            NamedStationTable table = new NamedStationTable(IOUtil.stripExtension(IOUtil.getFileTail(filename)));
            table.createStationTableFromGempak(IOUtil.readContents(filename, NamedStationTable.class));
            return table;
        }
        return NamedStationTable.createStationTable(XmlUtil.getRoot(filename, NamedStationTable.class));
    }

    public static NamedStationTable createStationTable(String xml) throws Exception {
        Element root = XmlUtil.getRoot(xml);
        return NamedStationTable.createStationTable(root);
    }

    public static NamedStationTable createStationTable(Element root) {
        if (root == null) {
            return null;
        }
        if (root.getTagName().equals(TAG_RSS) || root.getTagName().equals(TAG_CHANNEL)) {
            NamedStationTable table = new NamedStationTable();
            table.makeStationsFromRss(root);
            return table;
        }
        if (root.getTagName().equals(TAG_YRESULTSET)) {
            NamedStationTable table = new NamedStationTable();
            table.makeStationsFromYahooQuery(root);
            return table;
        }
        String name = XmlUtil.getAttribute((Node)root, ATTR_NAME, "");
        String type = XmlUtil.getAttribute((Node)root, ATTR_TYPE, (String)null);
        String category = XmlUtil.getAttribute((Node)root, ATTR_CATEGORY, (String)null);
        NamedStationTable table = new NamedStationTable(root);
        table.setType(type);
        table.setName(name);
        table.setCategory(category);
        return table;
    }

    @Override
    protected Map getMap() {
        if (!this.haveCreatedMap) {
            this.haveCreatedMap = true;
            for (int i = 0; i < this.roots.size(); ++i) {
                Element root = (Element)this.roots.get(i);
                String href = XmlUtil.getAttribute((Node)root, "href", (String)null);
                if (href != null) {
                    if (this.base != null && !href.startsWith("http")) {
                        href = !href.startsWith("/") && !this.base.endsWith("/") ? this.base + "/" + href : this.base + href;
                    }
                    if (NamedStationTable.isKml(href)) {
                        try {
                            this.createStationTableFromKmlFile(href);
                            return super.getMap();
                        }
                        catch (Exception exc) {
                            return null;
                        }
                    }
                    if (NamedStationTable.isGempak(href)) {
                        try {
                            this.createStationTableFromGempak(IOUtil.readContents(href, NamedStationTable.class));
                            return super.getMap();
                        }
                        catch (Exception exc) {
                            return null;
                        }
                    }
                    try {
                        root = XmlUtil.getRoot(href, this.getClass());
                    }
                    catch (Exception exc) {
                        throw new WrapperException("Loading in stations from:" + href, exc);
                    }
                }
                if (root.getTagName().equals(TAG_RSS) || root.getTagName().equals(TAG_CHANNEL)) {
                    this.makeStationsFromRss(root);
                } else if (root.getTagName().equals(TAG_YRESULTSET)) {
                    this.makeStationsFromYahooQuery(root);
                } else {
                    this.makeStations(root);
                }
                if (!XmlUtil.getAttribute((Node)root, ATTR_LOADMORE, true)) break;
            }
        }
        return super.getMap();
    }

    public static List xxxxmakeMenuItems(List stations, final ObjectListener listener) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        Object stationsMenu = null;
        Hashtable<String, JMenu> menus = new Hashtable<String, JMenu>();
        for (int i = 0; i < stations.size(); ++i) {
            NamedStationTable stationTable = (NamedStationTable)stations.get(i);
            JMenuItem mi = new JMenuItem(stationTable.getName());
            mi.addActionListener(new ObjectListener(stationTable){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    listener.actionPerformed(ae, this.theObject);
                }
            });
            String category = stationTable.getCategory();
            if (category == null) {
                category = "";
            }
            JMenu catMenu = null;
            JMenu lastMenu = null;
            String catSoFar = "";
            List<String> cats = StringUtil.split(category, "/", true, true);
            for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
                String subCat = cats.get(catIdx);
                catMenu = (JMenu)menus.get(catSoFar = catSoFar + "/" + subCat);
                if (catMenu == null) {
                    catMenu = new JMenu(subCat);
                    menus.put(catSoFar, catMenu);
                    if (lastMenu == null) {
                        items.add(catMenu);
                    } else {
                        lastMenu.add(catMenu);
                    }
                }
                lastMenu = catMenu;
            }
            if (catMenu != null) {
                catMenu.add(mi);
                continue;
            }
            items.add(mi);
        }
        return items;
    }

    public static List<JMenuItem> makeMenuItems(List locations, ObjectListener listener) {
        return NamedStationTable.makeMenuItemsInner(locations, listener);
    }

    private static List<JMenuItem> makeMenuItemsInner(List locations, final ObjectListener listener) {
        String category;
        NamedStationTable stationTable;
        int i;
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        Object locationsMenu = null;
        Hashtable<String, JMenu> menus = new Hashtable<String, JMenu>();
        final Hashtable<String, ArrayList<NamedStationTable>> categoryMap = new Hashtable<String, ArrayList<NamedStationTable>>();
        final ArrayList macItems = new ArrayList();
        for (i = 0; i < locations.size(); ++i) {
            stationTable = (NamedStationTable)locations.get(i);
            category = stationTable.getCategory();
            if (category == null) continue;
            category = "/" + category;
            ArrayList<NamedStationTable> catLocations = (ArrayList<NamedStationTable>)categoryMap.get(category);
            if (catLocations == null) {
                catLocations = new ArrayList<NamedStationTable>();
                categoryMap.put(category, catLocations);
            }
            catLocations.add(stationTable);
        }
        for (i = 0; i < locations.size(); ++i) {
            stationTable = (NamedStationTable)locations.get(i);
            category = stationTable.getCategory();
            if (category == null) {
                category = "";
            }
            JMenu catMenu = null;
            JMenu lastMenu = null;
            String catSoFar = "";
            List<String> cats = StringUtil.split(category, "/", true, true);
            for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
                String subCat = cats.get(catIdx);
                catMenu = (JMenu)menus.get(catSoFar = catSoFar + "/" + subCat);
                if (catMenu == null) {
                    catMenu = new JMenu(subCat);
                    menus.put(catSoFar, catMenu);
                    if (lastMenu == null) {
                        items.add(catMenu);
                    } else {
                        lastMenu.add(catMenu);
                    }
                }
                lastMenu = catMenu;
            }
            if (catMenu != null) {
                boolean newOne;
                boolean bl = newOne = catMenu.getMenuListeners().length == 0;
                if (!newOne) continue;
                final JMenu theMenu = catMenu;
                final String theCategory = catSoFar;
                catMenu.addMenuListener(new MenuListener(){

                    @Override
                    public void menuCanceled(MenuEvent e) {
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                    }

                    @Override
                    public void menuSelected(MenuEvent e) {
                        NamedStationTable.addMenuItems(categoryMap, theMenu, theCategory, listener);
                    }
                });
                continue;
            }
            JMenuItem mi = new JMenuItem(stationTable.getName());
            mi.addActionListener(new ObjectListener(stationTable){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    listener.actionPerformed(ae, this.theObject);
                }
            });
            items.add(mi);
        }
        if (macItems.size() > 0) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    for (Object[] tuple : macItems) {
                        Hashtable categoryMap = (Hashtable)tuple[0];
                        JMenu theMenu = (JMenu)tuple[1];
                        String theCategory = (String)tuple[2];
                        NamedStationTable.addMenuItems(categoryMap, theMenu, theCategory, listener);
                    }
                }
            });
        }
        return items;
    }

    private static void addMenuItems(Hashtable categoryMap, JMenu menu, String menuCategory, final ObjectListener listener) {
        List locations = (List)categoryMap.get(menuCategory);
        if (locations == null) {
            return;
        }
        categoryMap.remove(menuCategory);
        for (int i = 0; i < locations.size(); ++i) {
            NamedStationTable location = (NamedStationTable)locations.get(i);
            JMenuItem mi = new JMenuItem(location.getName());
            mi.addActionListener(new ObjectListener(location){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    listener.actionPerformed(ae, this.theObject);
                }
            });
            menu.add(mi);
        }
    }

    public boolean isEmpty() {
        return this.byId_.isEmpty();
    }

    public String toString() {
        return this.getCategory() + ">" + this.getName() + "(" + this.size() + ")";
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getId() {
        return this.id;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Need to supply a file name");
        }
        NamedStationTable tbl = NamedStationTable.createStationTableFromFile(args[0]);
    }
}

