/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.metdata;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.metdata.NamedStation;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.NamedLocation;
import visad.georef.NamedLocationTuple;

public class NamedStationImpl
implements NamedStation {
    private List coords;
    private EarthLocation earthLocation;
    private double latitude;
    private double longitude;
    private Real altitude;
    private double altValue;
    private Unit altUnit;
    private String id;
    private String name;
    private Hashtable hashtable = new Hashtable();
    private NamedLocation nLT;

    public NamedStationImpl(String id, String name, double latitude, double longitude, double alt, Unit unit) throws VisADException, RemoteException {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altValue = alt;
        this.altUnit = unit;
    }

    public NamedStationImpl(String id, String name, List coords, Unit unit) throws VisADException, RemoteException {
        this.id = id;
        this.name = name;
        this.coords = coords;
        double[][] tmp = (double[][])coords.get(0);
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double altSum = 0.0;
        for (int i = 0; i < tmp[0].length; ++i) {
            maxLat = Math.max(maxLat, tmp[1][i]);
            minLat = Math.min(minLat, tmp[1][i]);
            maxLon = Math.max(maxLon, tmp[0][i]);
            minLon = Math.min(minLon, tmp[0][i]);
            if (tmp.length <= 2) continue;
            altSum += tmp[2][i];
        }
        this.latitude = minLat + (maxLat - minLat) / 2.0;
        this.longitude = minLon + (maxLon - minLon) / 2.0;
        if (tmp.length > 2) {
            this.altValue = altSum / (double)tmp[0].length;
        }
        this.altUnit = unit;
    }

    public NamedStationImpl(String name, NamedLocationTuple in_nLT) {
        this.id = in_nLT.getIdentifier().getValue();
        this.name = name;
        this.latitude = in_nLT.getLatitude().getValue();
        this.longitude = in_nLT.getLongitude().getValue();
        this.altitude = in_nLT.getAltitude();
        this.nLT = in_nLT;
    }

    public NamedStationImpl() {
    }

    public void setNamedLocationTuple(NamedLocationTuple v) {
        this.nLT = v;
    }

    public List getCoords() {
        return this.coords;
    }

    public EarthLocation getEarthLocation() throws VisADException, RemoteException {
        if (this.earthLocation == null) {
            this.earthLocation = new EarthLocationTuple(new Real(RealType.Latitude, this.latitude), new Real(RealType.Longitude, this.longitude), this.getAltitude());
        }
        return this.earthLocation;
    }

    @Override
    public NamedLocation getNamedLocation() {
        if (this.nLT == null) {
            try {
                return new NamedLocationTuple(this.id, this.latitude, this.longitude, this.getAltitude().getValue(CommonUnit.meter));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.nLT;
    }

    @Override
    public void setNamedLocation(NamedLocation v) {
        this.nLT = v;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public void setLatitude(double v) {
        this.latitude = v;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public void setLongitude(double v) {
        this.longitude = v;
    }

    @Override
    public Real getAltitude() {
        if (this.altitude == null) {
            try {
                this.altitude = new Real(RealType.Altitude, this.altValue, this.altUnit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.altitude;
    }

    @Override
    public void setAltitude(Real v) {
        this.altitude = v;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String v) {
        this.id = v;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String v) {
        this.name = v;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NamedStation)) {
            return false;
        }
        NamedStation that = (NamedStation)o;
        return this.id.equals(that.getID()) && this.latitude == that.getLatitude() && this.longitude == that.getLongitude() && this.getAltitude().equals(that.getAltitude());
    }

    @Override
    public String getIdentifier() {
        if (this.id == null || this.id.length() == 0) {
            return this.name;
        }
        return this.id;
    }

    public double getAltitudeAsDouble() {
        return this.getAltitude().getValue();
    }

    public Unit getAltitudeUnit() {
        return this.getAltitude().getUnit();
    }

    public Hashtable getProperties() {
        return this.hashtable;
    }

    public void setProperties(Hashtable v) {
        this.hashtable = v;
    }

    public void addProperty(String key, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, value);
    }

    public Object getProperty(String key, Object deflt) {
        if (this.hashtable == null) {
            return deflt;
        }
        Object retVal = this.hashtable.get(key);
        return retVal == null ? deflt : retVal;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(NamedStationImpl stn) {
        return this.name.compareTo(stn.getName());
    }

    public int compareTo(Object oo) {
        return this.compareTo((NamedStationImpl)oo);
    }
}

