/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.java3d;

import java.awt.Insets;
import java.util.List;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DirectionalLight;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;

public class LightInfo {
    private DirectionalLight light;
    private String name;
    private Vector3f direction;
    private Color3f color;
    private boolean visible = true;
    private Point3d location;
    private JCheckBox visibleCbx;
    private JSlider slider;
    private JTextField directionXFld;
    private JTextField directionYFld;
    private JTextField directionZFld;
    private JTextField locationXFld;
    private JTextField locationYFld;
    private JTextField locationZFld;

    public LightInfo() {
    }

    public LightInfo(LightInfo that) {
        this.name = that.name;
        this.direction = that.direction;
        this.location = that.location;
        this.color = that.color;
        if (this.direction == null) {
            this.direction = new Vector3f(0.0f, 0.0f, 1.0f);
        }
        if (this.location == null) {
            this.location = new Point3d(0.0, 0.0, 0.0);
        }
        this.getLight();
    }

    public LightInfo(String name, Point3d location, Vector3f direction) {
        this.name = name;
        if (direction == null) {
            direction = new Vector3f(0.0f, 0.0f, 1.0f);
        }
        if (location == null) {
            location = new Point3d(0.0, 0.0, 0.0);
        }
        this.direction = direction;
        this.location = location;
        this.color = new Color3f(0.0f, 0.0f, 0.0f);
        this.getLight();
    }

    public void initWith(LightInfo that) {
        this.color = that.color;
        this.visible = that.visible;
        this.updateLight();
    }

    public void getPropertyComponents(List comps, ObjectListener listener) {
        this.visibleCbx = new JCheckBox(this.getName(), this.visible);
        float[] rgb = this.color.get().getRGBComponents(null);
        this.slider = new JSlider(0, 100, (int)(rgb[0] * 100.0f));
        float[] xyz = new float[3];
        this.direction.get(xyz);
        this.directionXFld = this.makeField("" + xyz[0], listener, "X Direction");
        this.directionYFld = this.makeField("" + xyz[1], listener, "Y Direction");
        this.directionZFld = this.makeField("" + xyz[2], listener, "Z Direction");
        double[] pxyz = new double[3];
        this.location.get(pxyz);
        this.locationXFld = this.makeField("" + pxyz[0], listener, "");
        this.locationYFld = this.makeField("" + pxyz[1], listener, "");
        this.locationZFld = this.makeField("" + pxyz[2], listener, "");
        List fldComps = Misc.newList(GuiUtils.rLabel("Direction:"), this.directionXFld, this.directionYFld, this.directionZFld);
        comps.add(this.visibleCbx);
        GuiUtils.tmpInsets = new Insets(0, 2, 0, 0);
        comps.add(GuiUtils.vbox(this.slider, GuiUtils.left(GuiUtils.doLayout(fldComps, 4, GuiUtils.WT_N, GuiUtils.WT_N))));
        if (listener != null) {
            this.visibleCbx.addActionListener(listener);
            this.slider.addChangeListener(listener);
        }
    }

    private JTextField makeField(String s, ObjectListener listener, String tip) {
        JTextField fld = new JTextField(s, 3);
        if (listener != null) {
            fld.addActionListener(listener);
        }
        fld.setToolTipText(tip);
        return fld;
    }

    public void applyProperties() {
        this.visible = this.visibleCbx.isSelected();
        float f = (float)this.slider.getValue() / 100.0f;
        this.color = new Color3f(f, f, f);
        this.location = new Point3d(new Double(this.locationXFld.getText()).doubleValue(), new Double(this.locationYFld.getText()).doubleValue(), new Double(this.locationZFld.getText()).doubleValue());
        this.direction = new Vector3f(new Float(this.directionXFld.getText()).floatValue(), new Float(this.directionYFld.getText()).floatValue(), new Float(this.directionZFld.getText()).floatValue());
        this.updateLight();
    }

    public void brighter() {
        float[] rgb = this.color.get().getRGBComponents(null);
        rgb[0] = (float)Math.min((double)rgb[0] + 0.1, 1.0);
        rgb[1] = (float)Math.min((double)rgb[1] + 0.1, 1.0);
        rgb[2] = (float)Math.min((double)rgb[2] + 0.1, 1.0);
        this.color = new Color3f(rgb);
        this.updateLight();
    }

    public DirectionalLight getLight() {
        if (this.light == null) {
            this.light = new DirectionalLight(this.visible, this.color, this.direction);
            BoundingSphere bounds = new BoundingSphere(this.location, Double.POSITIVE_INFINITY);
            this.light.setCapability(18);
            this.light.setCapability(19);
            this.light.setCapability(14);
            this.light.setCapability(15);
            this.light.setCapability(16);
            this.light.setCapability(17);
            this.light.setCapability(28);
            this.light.setCapability(29);
            this.light.setCapability(12);
            this.light.setCapability(13);
            this.light.setInfluencingBounds((Bounds)bounds);
        }
        return this.light;
    }

    public void updateLight() {
        this.getLight().setEnable(this.visible);
        this.getLight().setColor(this.color);
        this.getLight().setDirection(this.direction);
        this.getLight().setInfluencingBounds((Bounds)new BoundingSphere(this.location, Double.POSITIVE_INFINITY));
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setDirection(Vector3f value) {
        this.direction = value;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setColor(Color3f value, boolean updateGui) {
        this.setColor(value);
        if (updateGui && this.slider != null) {
            float[] rgb = this.getColor().get().getRGBComponents(null);
            int sliderValue = (int)(100.0f * rgb[0]);
            this.slider.setValue(sliderValue);
        }
    }

    public void setColor(Color3f value) {
        this.color = value;
    }

    public Color3f getColor() {
        return this.color;
    }

    public void setVisible(boolean value, boolean updateGui) {
        this.setVisible(value);
        if (updateGui && this.visibleCbx != null) {
            this.visibleCbx.setSelected(this.visible);
        }
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public String toString() {
        return this.name;
    }

    public void setLocation(Point3d value) {
        this.location = value;
    }

    public Point3d getLocation() {
        return this.location;
    }
}

