/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.ui.IdvComponentGroup;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.idv.ui.ViewPanel;
import ucar.unidata.ui.DndImageButton;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.StringUtil;

public class ViewPanelImpl
extends IdvManager
implements ViewPanel {
    static Image BUTTON_ICON = GuiUtils.getImage("/auxdata/ui/icons/Selected.gif");
    static ImageIcon CATEGORY_OPEN_ICON;
    static ImageIcon CATEGORY_CLOSED_ICON;
    static Color BUTTON_FG_COLOR;
    static Color BUTTON_ON_COLOR;
    static Border BUTTON_BORDER;
    static boolean BUTTON_SHOWPOPUP;
    static boolean BUTTON_SHOWCATEGORIES;
    static Font BUTTON_FONT;
    static Color BUTTON_LINE_COLOR;
    static Font CATEGORY_FONT;
    public static ImageIcon ICON_MAP;
    public static ImageIcon ICON_TRANSECT;
    public static ImageIcon ICON_GLOBE;
    public static ImageIcon ICON_DEFAULT;
    public static Border headerPanelBorder;
    public static Border headerPanelHighlightBorder;
    private JComponent contents;
    private JPanel leftPanel;
    private JPanel viewContainer;
    ButtonGroup buttonGroup = new ButtonGroup();
    private GuiUtils.CardLayoutPanel rightPanel;
    private List vmInfos = new ArrayList();
    private static final String PROP_CONTROLINFO = "prop.controlinfo";
    private Object VM_MUTEX = new Object();
    private static final Object BUTTONSTATE_MUTEX;

    public ViewPanelImpl(IntegratedDataViewer idv) {
        super(idv);
    }

    private void init() {
        this.leftPanel = new JPanel(new BorderLayout());
        this.leftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.leftPanel.add("North", GuiUtils.filler(150, 1));
        this.viewContainer = new JPanel();
        this.viewContainer.setLayout(new BoxLayout(this.viewContainer, 1));
        JScrollPane viewScroll = new JScrollPane(GuiUtils.top(this.viewContainer));
        viewScroll.setBorder(null);
        this.leftPanel.add("Center", viewScroll);
        this.rightPanel = new GuiUtils.CardLayoutPanel(){

            @Override
            public void show(Component comp) {
                super.show(comp);
                ArrayList localVMInfos = new ArrayList(ViewPanelImpl.this.vmInfos);
                block0: for (int vmIdx = 0; vmIdx < localVMInfos.size(); ++vmIdx) {
                    VMInfo vmInfo = (VMInfo)localVMInfos.get(vmIdx);
                    for (int i = 0; i < vmInfo.controlInfos.size(); ++i) {
                        ControlInfo controlInfo = (ControlInfo)vmInfo.controlInfos.get(i);
                        if (controlInfo.outer != comp) continue;
                        controlInfo.button.setSelected(true);
                        continue block0;
                    }
                }
            }
        };
        this.contents = GuiUtils.leftCenter(this.leftPanel, this.rightPanel);
        Msg.translateTree(this.contents);
    }

    private void selectNext(boolean up) {
        boolean gotit = false;
        VMInfo select = null;
        int index = 0;
        ArrayList localVMInfos = new ArrayList(this.vmInfos);
        block0: for (int vmIdx = 0; !gotit && vmIdx < localVMInfos.size(); ++vmIdx) {
            VMInfo vmInfo = (VMInfo)localVMInfos.get(vmIdx);
            List cis = vmInfo.controlInfos;
            for (int i = 0; i < cis.size(); ++i) {
                ControlInfo ci = (ControlInfo)cis.get(i);
                if (!ci.button.isSelected()) continue;
                if (up) {
                    if (vmInfo.getCatOpen() && i > 0) {
                        select = vmInfo;
                        index = i - 1;
                    } else {
                        --vmIdx;
                        while (vmIdx >= 0) {
                            VMInfo prev;
                            if (!(prev = (VMInfo)localVMInfos.get(vmIdx--)).getCatOpen() || prev.controlInfos.size() <= 0) continue;
                            select = prev;
                            index = select.controlInfos.size() - 1;
                            break;
                        }
                    }
                } else if (vmInfo.getCatOpen() && i < cis.size() - 1) {
                    select = vmInfo;
                    index = i + 1;
                } else {
                    ++vmIdx;
                    while (vmIdx < localVMInfos.size()) {
                        VMInfo next;
                        if (!(next = (VMInfo)localVMInfos.get(vmIdx++)).getCatOpen() || next.controlInfos.size() <= 0) continue;
                        select = next;
                        index = 0;
                        break;
                    }
                }
                gotit = true;
                continue block0;
            }
        }
        if (select != null && index >= 0 && index < select.controlInfos.size()) {
            ((ControlInfo)select.controlInfos.get((int)index)).button.doClick();
        }
    }

    @Override
    public JComponent getContents() {
        if (this.contents == null) {
            this.init();
        }
        return this.contents;
    }

    @Override
    public void addDisplayControl(DisplayControl control) {
        this.addControlTab(control, false);
    }

    @Override
    public void viewManagerAdded(ViewManager viewManager) {
        VMInfo vmInfo = this.getVMInfo(viewManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewManagerDestroyed(ViewManager viewManager) {
        Object object = this.VM_MUTEX;
        synchronized (object) {
            VMInfo vmInfo = this.findVMInfo(viewManager);
            if (vmInfo != null) {
                this.vmInfos.remove(vmInfo);
                vmInfo.viewManagerDestroyed();
            }
        }
    }

    @Override
    public void viewManagerChanged(ViewManager viewManager) {
        VMInfo vmInfo = this.findVMInfo(viewManager);
        if (vmInfo != null) {
            vmInfo.viewManagerChanged();
        }
    }

    private void addControlTab(DisplayControl control, boolean forceShow) {
        if (!(control.getActive() && control.canBeDocked() && control.shouldBeDocked())) {
            return;
        }
        ((DisplayControlImpl)control).setMakeWindow(false);
        this.addControlTabInThread(control, forceShow);
    }

    private void addControlTabInThread(DisplayControl control, boolean forceShow) {
        ControlInfo controlInfo;
        IdvWindow window;
        if (!control.getActive()) {
            return;
        }
        if (!control.canBeDocked() || !control.shouldBeDocked()) {
            return;
        }
        ViewManager viewManager = control.getViewManager();
        if (viewManager != null && (window = viewManager.getDisplayWindow()) != null) {
            List<IdvComponentGroup> groups = window.getComponentGroups();
            for (int i = 0; i < groups.size(); ++i) {
                IdvComponentGroup obj = groups.get(i);
                if (!(obj instanceof IdvComponentGroup) || !obj.tryToImportDisplayControl((DisplayControlImpl)control)) continue;
                return;
            }
        }
        if ((controlInfo = (ControlInfo)control.getTmpProperty(PROP_CONTROLINFO)) != null) {
            return;
        }
        ((DisplayControlImpl)control).setMakeWindow(false);
        JButton removeBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/delete.png", control, "doRemove");
        removeBtn.setToolTipText("Remove Display Control");
        GuiUtils.makeMouseOverBorder(removeBtn);
        JButton expandBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/DownDown.gif", this, "expandControl", control);
        expandBtn.setToolTipText("Expand in the tabs");
        GuiUtils.makeMouseOverBorder(expandBtn);
        JButton exportBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/application_get.png", this, "undockControl", control);
        exportBtn.setToolTipText("Undock control window");
        GuiUtils.makeMouseOverBorder(exportBtn);
        JButton propBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/information.png", control, "showProperties");
        propBtn.setToolTipText("Show Display Control Properties");
        GuiUtils.makeMouseOverBorder(propBtn);
        DndImageButton dnd = new DndImageButton(control, "idv/display");
        GuiUtils.makeMouseOverBorder(dnd);
        dnd.setToolTipText("Drag and drop to a window component");
        JPanel buttonPanel = GuiUtils.left(GuiUtils.hbox(Misc.newList(expandBtn, exportBtn, dnd, propBtn, removeBtn), 4));
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.lightGray.darker()));
        JComponent inner = (JComponent)((DisplayControlImpl)control).getOuterContents();
        inner = GuiUtils.centerBottom(inner, buttonPanel);
        JPanel outer = GuiUtils.top(inner);
        outer.setBorder(BorderFactory.createEmptyBorder(2, 1, 0, 0));
        if (!control.getActive()) {
            return;
        }
        ViewManager dfltViewManager = control.getDefaultViewManager();
        if (dfltViewManager == null) {
            dfltViewManager = this.getIdv().getViewManager();
        }
        controlInfo = new ControlInfo(control, expandBtn, outer, inner, this.getVMInfo(dfltViewManager));
        control.putTmpProperty(PROP_CONTROLINFO, controlInfo);
        boolean didToggle = false;
        if (!this.getStateManager().getProperty("idv.loadingxml", false)) {
            if (!forceShow) {
                // empty if block
            }
            didToggle = true;
            GuiUtils.toggleHeavyWeightComponents(outer, true);
            GuiUtils.showComponentInTabs(outer);
        }
        if (!didToggle) {
            GuiUtils.toggleHeavyWeightComponents(outer, false);
        }
    }

    @Override
    public void displayControlChanged(DisplayControl control) {
        ControlInfo controlInfo = (ControlInfo)control.getTmpProperty(PROP_CONTROLINFO);
        if (controlInfo != null) {
            controlInfo.displayControlChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMInfo getVMInfo(Object vm) {
        if (vm == null) {
            vm = "No View";
        }
        Object object = this.VM_MUTEX;
        synchronized (object) {
            VMInfo vmInfo = this.findVMInfo(vm);
            if (vmInfo == null) {
                vmInfo = new VMInfo(vm);
                this.vmInfos.add(vmInfo);
            }
            return vmInfo;
        }
    }

    private VMInfo findVMInfo(Object vm) {
        ArrayList localVMInfos = new ArrayList(this.vmInfos);
        for (int i = 0; i < localVMInfos.size(); ++i) {
            VMInfo vmInfo = (VMInfo)localVMInfos.get(i);
            if (!vmInfo.holds(vm)) continue;
            return vmInfo;
        }
        return null;
    }

    @Override
    public void removeDisplayControl(DisplayControl control) {
        this.removeControlTab(control);
    }

    public void removeControlTab(DisplayControl control) {
        this.removeControlTab(control, true);
    }

    public void removeControlTab(final DisplayControl control, boolean inSwingThread) {
        if (inSwingThread) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewPanelImpl.this.removeControlTabInThread(control);
                }
            });
        } else {
            this.removeControlTabInThread(control);
        }
    }

    private void removeControlTabInThread(DisplayControl control) {
        ControlInfo tabInfo = (ControlInfo)control.removeTmpProperty(PROP_CONTROLINFO);
        if (tabInfo != null) {
            tabInfo.removeDisplayControl();
        }
    }

    @Override
    public void addViewMenuItems(DisplayControl control, List items) {
        if (control.canBeDocked()) {
            items.add("separator");
            if (!control.shouldBeDocked()) {
                items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Dock in Dashboard", this, "dockControl", control), "/auxdata/ui/icons/application_put.png"));
            } else {
                items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Undock from Dashboard", this, "undockControl", control), "/auxdata/ui/icons/application_get.png"));
            }
            List groups = this.getIdv().getIdvUIManager().getComponentGroups();
            ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
            for (int i = 0; i < groups.size(); ++i) {
                IdvComponentGroup group = (IdvComponentGroup)groups.get(i);
                subItems.add(GuiUtils.makeMenuItem(group.getHierachicalName(), group, "importDisplayControl", control));
            }
            if (subItems.size() > 0) {
                items.add(GuiUtils.makeMenu("Export to component", subItems));
            }
        }
    }

    public void expandControl(DisplayControl control) {
        ControlInfo tabInfo = (ControlInfo)control.getTmpProperty(PROP_CONTROLINFO);
        if (tabInfo == null) {
            return;
        }
        tabInfo.expand();
    }

    public void dockControl(DisplayControl control) {
        control.setShowInTabs(true);
        ((DisplayControlImpl)control).guiImported();
        this.addControlTab(control, true);
    }

    public void undockControl(final DisplayControl control) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewPanelImpl.this.removeControlTab(control, false);
                control.setShowInTabs(false);
                ((DisplayControlImpl)control).setMakeWindow(true);
                ((DisplayControlImpl)control).popup(null);
            }
        });
    }

    @Override
    public void controlMoved(DisplayControl control) {
        this.removeControlTab(control);
        this.addControlTab(control, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initButtonState(IntegratedDataViewer idv) {
        Object object = BUTTONSTATE_MUTEX;
        synchronized (object) {
            if (BUTTON_FG_COLOR == null) {
                BUTTON_SHOWPOPUP = idv.getProperty("idv.ui.viewpanel.showpopup", false);
                BUTTON_SHOWCATEGORIES = idv.getProperty("idv.ui.viewpanel.showcategories", false);
                BUTTON_BORDER = BorderFactory.createEmptyBorder(2, 6, 2, 0);
                BUTTON_FONT = new Font("Dialog", 0, 11);
                CATEGORY_FONT = new Font("Dialog", 1, 11);
                BUTTON_LINE_COLOR = Color.gray;
                CATEGORY_OPEN_ICON = GuiUtils.getImageIcon("/auxdata/ui/icons/CategoryOpen.gif");
                CATEGORY_CLOSED_ICON = GuiUtils.getImageIcon("/auxdata/ui/icons/CategoryClosed.gif");
                BUTTON_FG_COLOR = Color.black;
            }
        }
    }

    static {
        BUTTON_FG_COLOR = null;
        BUTTON_ON_COLOR = null;
        BUTTON_SHOWPOPUP = true;
        BUTTON_SHOWCATEGORIES = false;
        ICON_MAP = GuiUtils.getImageIcon("/auxdata/ui/icons/MapIcon.png", ViewPanelImpl.class);
        ICON_TRANSECT = GuiUtils.getImageIcon("/auxdata/ui/icons/TransectIcon.png", ViewPanelImpl.class);
        ICON_GLOBE = GuiUtils.getImageIcon("/auxdata/ui/icons/GlobeIcon.png", ViewPanelImpl.class);
        ICON_DEFAULT = GuiUtils.getImageIcon("/auxdata/ui/icons/Host24.gif", ViewPanelImpl.class);
        headerPanelBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 2, 0, Color.black));
        headerPanelHighlightBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 2, 0, ViewManager.borderHighlightColor));
        BUTTONSTATE_MUTEX = new Object();
    }

    private static class ControlInfo {
        DisplayControl control;
        JButton expandButton;
        JComponent outer;
        JComponent inner;
        boolean expanded = false;
        Dimension innerSize;
        VMInfo vmInfo;
        JToggleButton button;
        String lastCategory = "";
        String label = null;

        public ControlInfo(DisplayControl control, JButton expandButton, JComponent outer, JComponent inner, VMInfo vmInfo) {
            this.vmInfo = vmInfo;
            this.control = control;
            if (control.getExpandedInTabs()) {
                this.expanded = false;
            }
            this.expandButton = expandButton;
            this.outer = outer;
            this.inner = inner;
            this.innerSize = inner.getSize();
            vmInfo.addControlInfo(this);
        }

        public String getLabel() {
            if (this.label == null) {
                this.label = this.control.getMenuLabel();
            }
            return this.label;
        }

        public void displayControlChanged() {
            String tmp = this.label;
            this.label = null;
            this.getLabel();
            if (!Misc.equals(tmp, this.label) && this.button != null) {
                this.button.setToolTipText(this.label);
                this.button.repaint();
            }
            this.vmInfo.changeControlInfo(this);
        }

        public void removeDisplayControl() {
            this.vmInfo.removeControlInfo(this);
        }

        public void expand() {
            this.outer.removeAll();
            this.outer.setLayout(new BorderLayout());
            if (!this.expanded) {
                this.outer.add("Center", this.inner);
                this.expandButton.setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/UpUp.gif"));
                this.innerSize = this.inner.getSize();
            } else {
                this.outer.add("North", this.inner);
                this.expandButton.setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/DownDown.gif"));
                this.inner.setSize(this.innerSize);
            }
            this.expanded = !this.expanded;
            this.control.setExpandedInTabs(this.expanded);
            Container parent = this.outer.getParent();
            JComponent comp = this.outer;
            this.outer.invalidate();
            parent.validate();
            parent.doLayout();
        }
    }

    public class VMInfo
    implements ImageObserver {
        Object obj;
        ViewManager viewManager;
        JButton popupButton;
        JComponent tabContents;
        JPanel headerPanel;
        List controlInfos = new ArrayList();
        boolean ignore = false;
        List buttons = new ArrayList();
        JComponent buttonPanel;
        JComponent contents;
        JLabel viewLabel;
        JButton categoryToggleBtn;
        boolean catOpen = true;
        private KeyListener keyListener;
        private List categories = new ArrayList();

        public VMInfo(Object obj) {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 38) {
                        ViewPanelImpl.this.selectNext(true);
                    } else if (e.getKeyCode() == 40) {
                        ViewPanelImpl.this.selectNext(false);
                    }
                }
            };
            ViewPanelImpl.initButtonState(ViewPanelImpl.this.getIdv());
            BUTTON_ICON.getWidth(this);
            this.obj = obj;
            this.tabContents = new JPanel(new BorderLayout());
            if (obj instanceof ViewManager) {
                this.viewManager = (ViewManager)obj;
            }
            ImageIcon icon = ICON_DEFAULT;
            if (obj instanceof MapViewManager) {
                icon = ((MapViewManager)obj).getUseGlobeDisplay() ? ICON_GLOBE : ICON_MAP;
            } else if (obj instanceof TransectViewManager) {
                icon = ICON_TRANSECT;
            }
            this.viewLabel = new JLabel(" " + this.getLabel());
            this.viewLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (VMInfo.this.viewManager != null) {
                        ViewPanelImpl.this.getVMManager().setLastActiveViewManager(VMInfo.this.viewManager);
                        if (evt.getClickCount() == 2) {
                            VMInfo.this.viewManager.toFront();
                        }
                    }
                }
            });
            this.categoryToggleBtn = GuiUtils.getImageButton(this.getCatOpen() ? CATEGORY_OPEN_ICON : CATEGORY_CLOSED_ICON);
            this.categoryToggleBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    VMInfo.this.setCatOpen(!VMInfo.this.getCatOpen());
                }
            });
            this.categoryToggleBtn.addKeyListener(this.keyListener);
            this.popupButton = new JButton(icon);
            this.popupButton.addKeyListener(this.keyListener);
            this.popupButton.setContentAreaFilled(false);
            this.popupButton.addActionListener(GuiUtils.makeActionListener(this, "showPopupMenu", null));
            this.popupButton.setToolTipText("Show View Menu");
            this.popupButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel = GuiUtils.leftCenter(GuiUtils.hbox((Component)GuiUtils.inset((Component)this.categoryToggleBtn, 1), this.popupButton), this.viewLabel);
            if (this.viewManager != null) {
                this.headerPanel = this.viewManager.makeDropPanel(this.headerPanel, true);
            }
            JPanel headerWrapper = GuiUtils.center(this.headerPanel);
            this.headerPanel.setBorder(headerPanelBorder);
            this.contents = GuiUtils.topCenter(headerWrapper, this.tabContents);
            ViewPanelImpl.this.viewContainer.add(this.contents);
            this.popupButton.setHorizontalAlignment(2);
            this.buttonsChanged();
            this.setCatOpen(this.getCatOpen());
            if (this.viewManager != null) {
                this.viewManagerChanged();
            }
        }

        private boolean getCatOpen() {
            Boolean b;
            if (this.viewManager != null && (b = (Boolean)this.viewManager.getProperty("viewpanel.catgegory.open")) != null) {
                return b;
            }
            return this.catOpen;
        }

        private void setCatOpen(boolean v) {
            if (this.viewManager != null) {
                this.viewManager.putProperty("viewpanel.catgegory.open", new Boolean(v));
            }
            this.catOpen = v;
            this.categoryToggleBtn.setIcon(v ? CATEGORY_OPEN_ICON : CATEGORY_CLOSED_ICON);
            this.tabContents.setVisible(v);
        }

        public void showPopupMenu() {
            ArrayList menuItems = new ArrayList();
            if (this.viewManager == null) {
                return;
            }
            this.viewManager.addContextMenuItems(menuItems);
            JPopupMenu popup = GuiUtils.makePopupMenu(menuItems);
            popup.show(this.popupButton, 0, (int)this.popupButton.getSize().getHeight());
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            if ((flags & 0x20) != 0) {
                ViewPanelImpl.this.leftPanel.repaint();
                return false;
            }
            return true;
        }

        public boolean holds(Object obj) {
            return this.obj == obj;
        }

        public void removeControlInfo(ControlInfo controlInfo) {
            int index = this.controlInfos.indexOf(controlInfo);
            if (index >= 0) {
                this.buttons.remove(controlInfo.button);
                this.controlInfos.remove(controlInfo);
                ViewPanelImpl.this.rightPanel.remove(controlInfo.outer);
                if (controlInfo.button.isSelected() && this.buttons.size() > 0) {
                    int btnIndex;
                    for (btnIndex = this.buttons.indexOf(controlInfo.button); btnIndex >= this.buttons.size() && btnIndex >= 0; --btnIndex) {
                    }
                    if (btnIndex >= 0) {
                        ((JToggleButton)this.buttons.get(btnIndex)).doClick();
                    }
                }
                GuiUtils.toggleHeavyWeightComponents(controlInfo.outer, true);
                this.buttonsChanged();
                this.ignore = true;
                ViewPanelImpl.this.buttonGroup.remove(controlInfo.button);
                this.ignore = false;
                if (this.controlInfos.size() == 0) {
                    ArrayList localVMInfos = new ArrayList(ViewPanelImpl.this.vmInfos);
                    for (int vmIdx = 0; vmIdx < localVMInfos.size(); ++vmIdx) {
                        VMInfo vmInfo = (VMInfo)localVMInfos.get(vmIdx);
                        if (vmInfo.controlInfos.size() <= 0) continue;
                        ControlInfo ci = (ControlInfo)vmInfo.controlInfos.get(0);
                        ci.button.doClick();
                    }
                }
            }
        }

        public void changeControlInfo(ControlInfo controlInfo) {
            if (!Misc.equals(controlInfo.lastCategory, controlInfo.control.getDisplayCategory())) {
                this.buttonsChanged();
            }
        }

        protected void paintButton(Graphics g, ControlInfo controlInfo) {
            int textPos;
            int textRight;
            int idx = this.controlInfos.indexOf(controlInfo);
            boolean isLast = idx == this.controlInfos.size() - 1;
            g.setFont(BUTTON_FONT);
            FontMetrics fm = g.getFontMetrics(g.getFont());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            JToggleButton btn = controlInfo.button;
            Rectangle b = btn.getBounds();
            String text = controlInfo.getLabel();
            int y = (btn.getHeight() + fm.getHeight()) / 2 - 2;
            int buttonWidth = BUTTON_ICON.getWidth(null);
            int offset = 2 + buttonWidth + 4;
            g.setColor(btn.getBackground());
            g.fillRect(0, 0, b.width, b.height);
            if (btn.isSelected()) {
                if (BUTTON_ON_COLOR == null) {
                    Color c = btn.getBackground();
                    BUTTON_ON_COLOR = new Color(Math.max(0, c.getRed() - 20), Math.max(0, c.getGreen() - 20), Math.max(0, c.getBlue() - 20));
                }
                g.setColor(BUTTON_ON_COLOR);
                g.fillRect(offset - 1, 0, b.width, b.height);
            }
            g.setColor(BUTTON_LINE_COLOR);
            if (isLast) {
                // empty if block
            }
            g.drawLine(offset - 1, b.height - 1, b.width, b.height - 1);
            g.setColor(BUTTON_FG_COLOR);
            int rightSide = b.width;
            if (btn.isSelected()) {
                rightSide = b.width - buttonWidth - 2;
            }
            if ((textRight = (textPos = offset) + fm.stringWidth(text)) >= rightSide) {
                while (text.length() > 5 && textRight >= rightSide) {
                    text = text.substring(0, text.length() - 2);
                    textRight = textPos + fm.stringWidth(text + ".");
                }
                text = text + ".";
            }
            g.drawString(text, offset, y);
            if (btn.isSelected()) {
                int imageHeight = BUTTON_ICON.getHeight(null);
                g.drawImage(BUTTON_ICON, b.width - 2 - buttonWidth, b.height / 2 - imageHeight / 2, null);
            }
        }

        public void addControlInfo(final ControlInfo controlInfo) {
            JToggleButton btn = controlInfo.button = new JToggleButton(StringUtil.padRight("", 20), true){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    VMInfo.this.paintButton(g, controlInfo);
                }
            };
            btn.addKeyListener(this.keyListener);
            btn.setCursor(Cursor.getPredefinedCursor(12));
            btn.setToolTipText(controlInfo.getLabel());
            btn.setFont(BUTTON_FONT);
            btn.setForeground(BUTTON_FG_COLOR);
            btn.setBorder(BUTTON_BORDER);
            controlInfo.button.setHorizontalAlignment(2);
            controlInfo.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ce) {
                    if (!VMInfo.this.ignore) {
                        GuiUtils.toggleHeavyWeightComponents(controlInfo.outer, true);
                        ViewPanelImpl.this.rightPanel.show(controlInfo.outer);
                    }
                }
            });
            this.buttons.add(controlInfo.button);
            this.controlInfos.add(controlInfo);
            ViewPanelImpl.this.rightPanel.addCard(controlInfo.outer);
            GuiUtils.toggleHeavyWeightComponents(controlInfo.outer, false);
            controlInfo.displayControlChanged();
            if (controlInfo.control.getExpandedInTabs()) {
                controlInfo.expand();
            }
            ViewPanelImpl.this.buttonGroup.add(controlInfo.button);
            this.buttonsChanged();
            this.setCatOpen(this.getCatOpen());
        }

        private void buttonsChanged() {
            int i;
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            Hashtable<String, ArrayList<JToggleButton>> catMap = new Hashtable<String, ArrayList<JToggleButton>>();
            int catCnt = 0;
            for (i = 0; i < this.controlInfos.size(); ++i) {
                ControlInfo controlInfo = (ControlInfo)this.controlInfos.get(i);
                String cat = controlInfo.control.getDisplayCategory();
                if (cat == null) {
                    cat = "Displays";
                }
                controlInfo.lastCategory = cat;
                if (!BUTTON_SHOWCATEGORIES) {
                    comps.add(controlInfo.button);
                    continue;
                }
                ArrayList<JToggleButton> catList = (ArrayList<JToggleButton>)catMap.get(cat);
                if (catList == null) {
                    if (!this.categories.contains(cat)) {
                        this.categories.add(cat);
                    }
                    catList = new ArrayList<JToggleButton>();
                    catMap.put(cat, catList);
                    JLabel catLabel = new JLabel(" " + cat);
                    catLabel.setFont(CATEGORY_FONT);
                    if (++catCnt > 1) {
                        // empty if block
                    }
                    catList.add((JToggleButton)((Object)catLabel));
                }
                catList.add(controlInfo.button);
            }
            if (BUTTON_SHOWCATEGORIES) {
                for (i = 0; i < this.categories.size(); ++i) {
                    List catList = (List)catMap.get(this.categories.get(i));
                    if (catList == null) continue;
                    comps.addAll(catList);
                }
            }
            if (comps.size() == 0) {
                JLabel noLbl = new JLabel("No Displays");
                noLbl.setFont(BUTTON_FONT);
                JPanel inset = GuiUtils.inset((Component)noLbl, new Insets(0, 10, 0, 0));
                inset.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
                comps.add(inset);
            }
            comps.add(GuiUtils.filler(10, 2));
            JPanel buttonPanel = GuiUtils.vbox(comps);
            this.tabContents.removeAll();
            this.tabContents.add("North", buttonPanel);
            this.tabContents.repaint();
        }

        public void viewManagerDestroyed() {
            ViewPanelImpl.this.viewContainer.remove(this.contents);
        }

        public void viewManagerChanged() {
            this.viewLabel.setText(this.getLabel());
            if (this.viewManager.showHighlight()) {
                headerPanelHighlightBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0), BorderFactory.createMatteBorder(0, 0, 2, 0, ViewPanelImpl.this.getStore().get("View.BorderHighlightColor", Color.blue)));
                this.headerPanel.setBorder(headerPanelHighlightBorder);
            } else {
                this.headerPanel.setBorder(headerPanelBorder);
            }
        }

        private String getLabel() {
            if (this.viewManager != null) {
                String name = this.viewManager.getName();
                if (name == null || name.trim().length() == 0) {
                    ArrayList localVMInfos = new ArrayList(ViewPanelImpl.this.vmInfos);
                    int idx = localVMInfos.indexOf(this);
                    if (idx == -1) {
                        idx = localVMInfos.size();
                    }
                    name = "View " + (idx + 1);
                }
                return name;
            }
            return this.obj.toString();
        }
    }
}

