/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Removable;

public class ValueSliderComponent
implements Removable {
    protected Object callingObject;
    private JTextField valueReadout;
    private JComponent[] sliderComps;
    private JSlider valueSlider;
    private String propertyName = null;
    private String labelText = null;
    private boolean ignoreUIEvents = false;
    private Method setMethod = null;
    private Method getMethod = null;
    private int sliderMin;
    private int sliderMax;
    private float scaleFactor = 1.0f;
    private boolean useSetMethod = true;
    private String toolTipText;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ValueSliderComponent.class.getName());

    public ValueSliderComponent(Object co, int min, int max, String property, String label) {
        this(co, min, max, property, label, 1.0f, true);
    }

    public ValueSliderComponent(Object co, int min, int max, String property, String label, float scale, boolean andSet) {
        this(co, min, max, property, label, scale, andSet, null);
    }

    public ValueSliderComponent(Object co, int min, int max, String property, String label, float scale, boolean andSet, String tip) {
        this.callingObject = co;
        this.propertyName = property;
        this.labelText = label;
        this.sliderMin = min;
        this.sliderMax = max;
        this.scaleFactor = scale;
        this.useSetMethod = andSet;
        this.toolTipText = tip;
        this.init();
    }

    private void init() {
        String methodBase = this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        String setMethodName = "set" + methodBase;
        String getMethodName = "get" + methodBase;
        this.getMethod = Misc.findMethod(this.callingObject.getClass(), getMethodName, null);
        this.setMethod = Misc.findMethod(this.callingObject.getClass(), setMethodName, null);
        if ((this.getMethod == null || this.setMethod == null) && this.useSetMethod) {
            this.logException("ValueSliderComponent.init", new IllegalArgumentException("Unable to find set or get methods for property " + this.propertyName));
        }
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (!ValueSliderComponent.this.getObjectHasInitialized() || ValueSliderComponent.this.ignoreUIEvents) {
                        return;
                    }
                    ValueSliderComponent.this.ignoreUIEvents = true;
                    int value = ValueSliderComponent.this.valueSlider.getValue();
                    if (ValueSliderComponent.this.valueSlider.getValueIsAdjusting()) {
                        if (ValueSliderComponent.this.valueReadout != null) {
                            ValueSliderComponent.this.valueReadout.setText(ValueSliderComponent.this.getDisplayConventions().format((float)value / ValueSliderComponent.this.scaleFactor));
                        }
                    } else {
                        ValueSliderComponent.this.handleValueChanged(value);
                    }
                    ValueSliderComponent.this.ignoreUIEvents = false;
                }
                catch (Exception exc) {
                    ValueSliderComponent.this.logException("adjust line width ", exc);
                }
            }
        };
        int initialValue = this.getInitialValue();
        if (this.sliderMax < initialValue) {
            this.sliderMax = initialValue;
        }
        if (this.sliderMin > initialValue) {
            this.sliderMin = initialValue;
        }
        this.sliderComps = GuiUtils.makeSliderPopup(this.sliderMin, this.sliderMax, initialValue, listener);
        this.sliderComps[0].setToolTipText("Change " + this.labelText);
        this.valueSlider = (JSlider)this.sliderComps[1];
        int tickSpacing = Math.max((this.sliderMax - this.sliderMin + 1) / 2, 1);
        int minorTickSpacing = Math.max((this.sliderMax - this.sliderMin + 1) / 10, 1);
        this.valueSlider.setMajorTickSpacing(tickSpacing);
        this.valueSlider.setMinorTickSpacing(minorTickSpacing);
        this.valueSlider.setSnapToTicks(true);
        this.valueSlider.setPaintTicks(true);
        this.valueSlider.setPaintLabels(true);
        if (this.scaleFactor != 1.0f) {
            this.valueSlider.setLabelTable(this.makeLabelTable());
        }
        this.valueReadout = new JTextField(this.getDisplayConventions().format((float)initialValue / this.scaleFactor), 3);
        if (this.toolTipText != null) {
            this.valueReadout.setToolTipText(this.toolTipText);
        }
        this.valueReadout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ValueSliderComponent.this.ignoreUIEvents) {
                    return;
                }
                try {
                    float value = (float)Misc.parseNumber(ValueSliderComponent.this.valueReadout.getText().trim());
                    int intValue = (int)(value * ValueSliderComponent.this.scaleFactor);
                    boolean lastIgnore = ValueSliderComponent.this.ignoreUIEvents;
                    ValueSliderComponent.this.ignoreUIEvents = true;
                    if (ValueSliderComponent.this.valueSlider != null) {
                        ValueSliderComponent.this.valueSlider.setValue(intValue);
                    }
                    ValueSliderComponent.this.handleValueChanged(intValue);
                    ValueSliderComponent.this.ignoreUIEvents = lastIgnore;
                }
                catch (NumberFormatException nfe) {
                    LogUtil.userMessage("Incorrect format: " + ValueSliderComponent.this.valueReadout.getText());
                }
                catch (Exception exc) {
                    ValueSliderComponent.this.logException("Setting line width", exc);
                }
            }
        });
    }

    public JComponent getContents(boolean withLabel) {
        JLabel label = GuiUtils.rLabel(this.labelText + ": ");
        JPanel p = withLabel ? GuiUtils.leftRight(label, GuiUtils.doLayout(new Component[]{this.valueReadout, GuiUtils.filler(), this.sliderComps[0]}, 3, GuiUtils.WT_N, GuiUtils.WT_N)) : GuiUtils.left(GuiUtils.doLayout(new Component[]{this.valueReadout, GuiUtils.filler(), this.sliderComps[0]}, 3, GuiUtils.WT_N, GuiUtils.WT_N));
        return p;
    }

    private int getInitialValue() {
        int value = 0;
        if (this.getMethod != null) {
            try {
                value = (int)(((Number)this.getMethod.invoke(this.callingObject, (Object[])null)).floatValue() * this.scaleFactor);
            }
            catch (Exception exc2) {
                this.logException("getInitialValue", exc2);
            }
        }
        return value;
    }

    private void handleValueChanged(int newValue) {
        if (this.setMethod != null && this.useSetMethod) {
            try {
                String floatString = this.getDisplayConventions().format((float)newValue / this.scaleFactor);
                Misc.setProperty(this.callingObject, this.setMethod, (Object)floatString, false);
            }
            catch (Exception exc2) {
                this.logException("propertyChange", exc2);
            }
        }
    }

    private DisplayConventions getDisplayConventions() {
        return DisplayConventions.getDisplayConventions();
    }

    public void setValue(int value) {
        this.setValue((float)value);
    }

    public void setValue(float value) {
        this.valueReadout.setText("" + value);
    }

    public float getValue() {
        return (float)GuiUtils.getValue(this.valueReadout);
    }

    public void setEnabled(boolean enable) {
        this.valueReadout.setEnabled(enable);
        this.sliderComps[0].setEnabled(enable);
    }

    private Hashtable<Integer, JLabel> makeLabelTable() {
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        float min = (float)this.sliderMin / this.scaleFactor;
        float max = (float)this.sliderMax / this.scaleFactor;
        float increment = (float)this.valueSlider.getMajorTickSpacing() / this.scaleFactor;
        if (min > max || increment > max - min) {
            return labelTable;
        }
        float[] values = Misc.computeTicks(max, min, 0.0f, increment);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                labelTable.put(new Integer((int)(values[i] * this.scaleFactor)), new JLabel(this.getDisplayConventions().format(values[i])));
            }
        }
        return labelTable;
    }

    public void setSnapToTicks(boolean value) {
        this.valueSlider.setSnapToTicks(value);
    }

    public void setPaintTicks(boolean value) {
        this.valueSlider.setPaintTicks(true);
    }

    public void setPaintLabels(boolean value) {
        this.valueSlider.setPaintLabels(true);
    }

    public boolean getObjectHasInitialized() {
        return true;
    }

    public void logException(String msg, Exception exc) {
        LogUtil.printException(log_, msg, exc);
    }

    @Override
    public void doRemove() {
        this.callingObject = null;
    }
}

