/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.ui.TwoListPanel;
import ucar.unidata.ui.XmlUi;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class ToolbarEditor
implements ActionListener {
    private static final String CMD_UP = "Up";
    private static final String CMD_DOWN = "Down";
    private static final String CMD_ADDSPACE = "Add Space";
    private static final String CMD_INSERT = "Insert";
    private static final String CMD_REMOVE = "Remove";
    private static final String CMD_RELOAD = "Reload Original";
    private static final String CMD_REMOVEWRITABLE = "Reload System";
    private static final String CMD_EXPORTPLUGIN = "Export Selected to Plugin";
    private static final String CMD_EXPORTMENUPLUGIN = "Export Selected to Menu Plugin";
    private static final String SPACE = "-space-";
    private int spaceCnt = 0;
    private IdvUIManager uiManager;
    private JComponent contents;
    private TwoListPanel twoListPanel;
    XmlResourceCollection resources;
    private JTextField menuNameFld;
    private JComboBox menuIdBox;
    private JCheckBox menuOverwriteCbx;

    public ToolbarEditor(IdvUIManager uiManager) {
        this.uiManager = uiManager;
        this.resources = uiManager.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_TOOLBAR);
        this.init();
    }

    private boolean isSpace(TwoFacedObject tfo) {
        return tfo.toString().equals(SPACE);
    }

    private Vector getCurrentList() {
        Vector<TwoFacedObject> icons = new Vector<TwoFacedObject>();
        Element root = this.uiManager.getToolbarRoot();
        if (root != null) {
            NodeList children = XmlUtil.getElements(root);
            for (int i = 0; i < children.getLength(); ++i) {
                Element node = (Element)children.item(i);
                if (node.getTagName().equals("button")) {
                    String action = XmlUtil.getAttribute(node, "action");
                    if (!this.uiManager.isAction(action)) continue;
                    String label = this.uiManager.getActionDescription(action = this.uiManager.stripAction(action));
                    if (label == null) {
                        label = action;
                    }
                    icons.add(new TwoFacedObject((Object)label, action));
                    continue;
                }
                if (node.getTagName().equals("filler")) {
                    icons.add(new TwoFacedObject((Object)SPACE, SPACE + this.spaceCnt++));
                    continue;
                }
                System.err.println("Unknown toobar tag:" + XmlUtil.toString(node));
            }
        }
        return icons;
    }

    private Vector getAllActions() {
        List allActions = this.uiManager.getActions();
        Vector<TwoFacedObject> actions = new Vector<TwoFacedObject>();
        for (int i = 0; i < allActions.size(); ++i) {
            String action = (String)allActions.get(i);
            String label = this.uiManager.getActionDescription(action = this.uiManager.stripAction(action));
            if (label == null) {
                label = action;
            }
            actions.add(new TwoFacedObject((Object)label, action));
        }
        return actions;
    }

    public JComponent getContents() {
        return this.contents;
    }

    private void init() {
        Vector currentIcons = this.getCurrentList();
        Vector actions = this.getAllActions();
        JButton addSpaceButton = new JButton("Add space");
        addSpaceButton.setActionCommand(CMD_ADDSPACE);
        addSpaceButton.addActionListener(this);
        JButton reloadButton = new JButton(CMD_RELOAD);
        reloadButton.setActionCommand(CMD_RELOAD);
        reloadButton.addActionListener(this);
        JButton removeButton = new JButton(CMD_REMOVEWRITABLE);
        removeButton.setActionCommand(CMD_REMOVEWRITABLE);
        removeButton.addActionListener(this);
        JButton export1Button = new JButton(CMD_EXPORTPLUGIN);
        export1Button.setToolTipText("Export the selected items to the plugin");
        export1Button.setActionCommand(CMD_EXPORTPLUGIN);
        export1Button.addActionListener(this);
        JButton export2Button = new JButton(CMD_EXPORTMENUPLUGIN);
        export2Button.setToolTipText("Export the selected items as a menu to the plugin");
        export2Button.setActionCommand(CMD_EXPORTMENUPLUGIN);
        export2Button.addActionListener(this);
        List buttons = Misc.newList(new JLabel(" "), addSpaceButton, reloadButton, removeButton);
        buttons.addAll(Misc.newList(new JLabel(" "), export1Button, export2Button));
        JPanel extra = GuiUtils.vbox(buttons);
        this.twoListPanel = new TwoListPanel(actions, "Actions", currentIcons, "Toolbar", extra);
        JLabel notice = GuiUtils.cLabel("Note: Toolbar changes will take effect with new windows");
        this.contents = GuiUtils.centerBottom(this.twoListPanel, notice);
    }

    private void doExportToMenu(Object[] tfos) {
        String menuName;
        if (this.menuNameFld == null) {
            this.menuNameFld = new JTextField("", 10);
            Hashtable menuIds = this.uiManager.getMenuIds();
            Vector<TwoFacedObject> menuIdItems = new Vector<TwoFacedObject>();
            menuIdItems.add(new TwoFacedObject((Object)"None", null));
            Enumeration keys = menuIds.keys();
            while (keys.hasMoreElements()) {
                String menuId = (String)keys.nextElement();
                if (!(menuIds.get(menuId) instanceof JMenu)) continue;
                JMenu menu = (JMenu)menuIds.get(menuId);
                String label = menu.getText();
                menuIdItems.add(new TwoFacedObject((Object)label, menuId));
            }
            this.menuIdBox = new JComboBox(menuIdItems);
            this.menuOverwriteCbx = new JCheckBox("Overwrite", false);
            this.menuOverwriteCbx.setToolTipText("Select this if you want to replace the selected menu with the new menu");
        }
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel dialogContents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Menu Name:"), this.menuNameFld, GuiUtils.rLabel("Add to Menu:"), GuiUtils.left(GuiUtils.hbox(this.menuIdBox, this.menuOverwriteCbx))}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        while (true) {
            if (!GuiUtils.askOkCancel("Export to Menu Plugin", dialogContents)) {
                return;
            }
            menuName = this.menuNameFld.getText().trim();
            if (menuName.length() != 0) break;
            LogUtil.userMessage("Please enter a menu name");
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        String idXml = "";
        TwoFacedObject menuIdTfo = (TwoFacedObject)this.menuIdBox.getSelectedItem();
        if (menuIdTfo.getId() != null) {
            idXml = XmlUtil.attr("id", menuIdTfo.getId().toString());
            if (this.menuOverwriteCbx.isSelected()) {
                idXml = idXml + XmlUtil.attr("replace", "true");
            }
        }
        xml.append("<menus>\n");
        xml.append("<menu label=\"" + menuName + "\" " + idXml + ">\n");
        for (int i = 0; i < tfos.length; ++i) {
            TwoFacedObject tfo = (TwoFacedObject)tfos[i];
            if (tfo.toString().equals(SPACE)) {
                xml.append("<separator/>\n");
                continue;
            }
            xml.append(XmlUtil.tag("menuitem", XmlUtil.attrs("label", tfo.toString(), "action", "action:" + tfo.getId().toString())));
        }
        xml.append("</menu></menus>\n");
        this.uiManager.getIdv().getPluginManager().addText(xml.toString(), "menubar.xml");
    }

    private void doExport(Object[] tfos) {
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < tfos.length; ++i) {
            TwoFacedObject tfo = (TwoFacedObject)tfos[i];
            if (tfo.toString().equals(SPACE)) {
                content.append("<filler/>\n");
                continue;
            }
            content.append(XmlUtil.tag("button", XmlUtil.attr("action", "action:" + tfo.getId().toString())));
        }
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        xml.append(XmlUtil.tag("panel", XmlUtil.attrs("layout", "flow", "margin", "4", "vspace", "0") + XmlUtil.attrs("hspace", "2", "i:space", "2", "i:width", "5"), content.toString()));
        LogUtil.userMessage("Note, if a user has changed their toolbar the plugin toolbar will be ignored");
        this.uiManager.getIdv().getPluginManager().addText(xml.toString(), "toolbar.xml");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CMD_EXPORTMENUPLUGIN) || cmd.equals(CMD_EXPORTPLUGIN)) {
            Object[] tfos = this.twoListPanel.getToList().getSelectedValues();
            if (tfos.length == 0) {
                LogUtil.userMessage("Please select entries in the Toolbar list");
                return;
            }
            if (cmd.equals(CMD_EXPORTMENUPLUGIN)) {
                this.doExportToMenu(tfos);
            } else {
                this.doExport(tfos);
            }
        }
        switch (cmd) {
            case "Reload System": {
                if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to remove any custom toolbar and revert to the system tolbar?", "Delete confirmation")) {
                    return;
                }
                this.resources.removeWritable();
                this.twoListPanel.reinitialize(this.getAllActions(), this.getCurrentList());
                break;
            }
            case "Reload Original": {
                this.twoListPanel.reload();
                break;
            }
            case "Add Space": {
                this.twoListPanel.insertEntry(new TwoFacedObject((Object)SPACE, SPACE + this.spaceCnt++));
            }
        }
    }

    public boolean anyChanges() {
        return this.twoListPanel.getChanged();
    }

    public void doApply() {
        Document doc = this.resources.getWritableDocument("<panel/>");
        Element root = this.resources.getWritableRoot("<panel/>");
        root.setAttribute("layout", "flow");
        root.setAttribute("margin", "4");
        root.setAttribute("vspace", "0");
        root.setAttribute("hspace", "2");
        root.setAttribute(XmlUi.inheritName("space"), "2");
        root.setAttribute(XmlUi.inheritName("width"), "5");
        XmlUtil.removeChildren(root);
        List icons = this.twoListPanel.getCurrentEntries();
        for (int i = 0; i < icons.size(); ++i) {
            Element element;
            TwoFacedObject tfo = (TwoFacedObject)icons.get(i);
            if (this.isSpace(tfo)) {
                element = doc.createElement("filler");
                element.setAttribute("width", "5");
            } else {
                element = doc.createElement("button");
                element.setAttribute("action", "action:" + tfo.getId().toString());
            }
            root.appendChild(element);
        }
        try {
            this.resources.writeWritable();
        }
        catch (Exception exc) {
            LogUtil.logException("Writing toolbar", exc);
        }
    }
}

