/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.ui.IdvLegend;
import ucar.unidata.idv.ui.LegendPanel;
import ucar.unidata.ui.DragPanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.ObjectListener;

public class SideLegend
extends IdvLegend {
    private JPanel legendsPanel;
    private Hashtable categoryToPanel = new Hashtable();
    private Hashtable categoryToPanelOpen = new Hashtable();
    private List categoryPanels = new ArrayList();

    public SideLegend() {
    }

    public SideLegend(ViewManager viewManager) {
        super(viewManager);
    }

    @Override
    protected JComponent doMakeContents() {
        this.legendsPanel = new JPanel();
        this.legendsPanel.setLayout(new BorderLayout());
        JLabel displaysLbl = GuiUtils.cLabel("Legend");
        Font font = displaysLbl.getFont();
        displaysLbl.setFont(font.deriveFont((float)font.getSize() + 3.0f).deriveFont(1));
        JButton floatComp = this.getFloatButton();
        JPanel outerPanel = GuiUtils.topCenter(GuiUtils.centerRight(displaysLbl, floatComp), this.legendsPanel);
        JScrollPane scroller = new JScrollPane(outerPanel, 20, 30);
        scroller.setPreferredSize(new Dimension(250, 500));
        return scroller;
    }

    public List<String> getDisplayCategories() {
        ArrayList<String> cats = new ArrayList<String>();
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            CategoryPanel categoryPanel = (CategoryPanel)this.categoryPanels.get(i);
            cats.add(categoryPanel.category);
        }
        return cats;
    }

    public void initWith(SideLegend that) {
        this.categoryToPanelOpen = new Hashtable();
        Hashtable thatMap = that.categoryToPanelOpen;
        if (thatMap != null) {
            for (int i = 0; i < this.categoryPanels.size(); ++i) {
                CategoryPanel categoryPanel = (CategoryPanel)this.categoryPanels.get(i);
                Boolean b = (Boolean)thatMap.get(categoryPanel.category);
                if (b == null) continue;
                categoryPanel.setInnerVisible(b);
            }
            this.categoryToPanelOpen.putAll(thatMap);
        }
    }

    @Override
    protected void fillLegendSafely() {
        IntegratedDataViewer idv;
        ViewManager theViewManager = this.viewManager;
        if (this.legendsPanel == null || theViewManager == null) {
            return;
        }
        List controls = theViewManager.getControlsForLegend();
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            CategoryPanel categoryPanel = (CategoryPanel)this.categoryPanels.get(i);
            categoryPanel.reInitialize();
            categoryPanel.getContents().setVisible(true);
        }
        boolean showIcons = true;
        if (theViewManager != null && (idv = theViewManager.getIdv()) != null) {
            showIcons = idv.getStateManager().getPreferenceOrProperty("idv.legend.showicons", false);
        }
        Hashtable<CategoryPanel, CategoryPanel> seen = new Hashtable<CategoryPanel, CategoryPanel>();
        for (int i = controls.size() - 1; i >= 0; --i) {
            CategoryPanel categoryPanel;
            DisplayControl control = (DisplayControl)controls.get(i);
            String category = control.getDisplayCategory();
            if (category == null || category.length() == 0) {
                category = "Displays";
            }
            if ((categoryPanel = (CategoryPanel)this.categoryToPanel.get(category)) == null) {
                categoryPanel = new CategoryPanel(this, category);
                this.categoryPanels.add(categoryPanel);
                this.categoryToPanel.put(category, categoryPanel);
                Boolean b = (Boolean)this.categoryToPanelOpen.get(category);
                if (b != null) {
                    categoryPanel.setInnerVisible(b);
                }
            }
            seen.put(categoryPanel, categoryPanel);
            DisplayControlLegendPanel legendPanel = (DisplayControlLegendPanel)control.getTransientProperty("SIDELEGEND");
            if (legendPanel == null) {
                JCheckBox visCbx = control.doMakeVisibilityControl("");
                ItemListener itemListener = event -> this.displayControlVisibilityChanged(control, event.getStateChange() == 1);
                visCbx.addItemListener(itemListener);
                visCbx.setBorder(BorderFactory.createEmptyBorder());
                JComponent sideLegendLabel = control.getLegendLabel(1);
                sideLegendLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 3));
                JComponent buttons = control.getLegendButtons(1);
                legendPanel = new DisplayControlLegendPanel(control, sideLegendLabel, false, GuiUtils.inset((Component)visCbx, new Insets(0, 0, 0, 2)), buttons);
                JComponent controlLegend = control.getLegendComponent(1);
                legendPanel.add(controlLegend, false);
                control.putTransientProperty("SIDELEGEND", legendPanel);
            }
            legendPanel.getExtraRight().setVisible(showIcons);
            categoryPanel.add(control, legendPanel.getContents());
        }
        ArrayList<JComponent> orderedCategoryPanels = new ArrayList<JComponent>();
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            CategoryPanel categoryPanel = (CategoryPanel)this.categoryPanels.get(i);
            if (seen.get(categoryPanel) != null) {
                orderedCategoryPanels.add(categoryPanel.getContents());
                continue;
            }
            categoryPanel.clear();
        }
        JPanel panels = GuiUtils.vbox(orderedCategoryPanels);
        this.legendsPanel.removeAll();
        this.legendsPanel.add((Component)panels, "North");
        this.legendsPanel.invalidate();
    }

    private void displayControlVisibilityChanged(DisplayControl control, boolean selected) {
        for (CategoryPanel panel : this.categoryPanels) {
            if (!panel.containsDisplayControl(control)) continue;
            control.setDisplayVisibility(selected);
            panel.controlVisibilityChanged(selected);
            break;
        }
    }

    public void setCategoryToPanelOpen(Hashtable value) {
        this.categoryToPanelOpen = value;
    }

    public Hashtable getCategoryToPanelOpen() {
        this.categoryToPanelOpen = new Hashtable();
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            CategoryPanel categoryPanel = (CategoryPanel)this.categoryPanels.get(i);
            this.categoryToPanelOpen.put(categoryPanel.category, new Boolean(categoryPanel.getInnerVisible()));
        }
        return this.categoryToPanelOpen;
    }

    public static class CategoryPanel
    extends LegendPanel {
        private SideLegend legend;
        String category;
        private List displayControls = new ArrayList();
        private JCheckBox visCbx;
        private boolean ignoreVisChanges = false;
        Hashtable previousVisibilities = new Hashtable();

        public CategoryPanel(SideLegend legend, String theCategory) {
            this.legend = legend;
            this.category = theCategory;
            this.visCbx = new JCheckBox("", true);
            this.visCbx.setBorder(BorderFactory.createEmptyBorder());
            this.visCbx.addActionListener(new ObjectListener(null){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (ignoreVisChanges) {
                        return;
                    }
                    ignoreVisChanges = true;
                    this.setDisplayVisiblity(visCbx.isSelected());
                    ignoreVisChanges = false;
                }
            });
            this.setComponents(new JLabel("  " + this.category), this.visCbx, null);
        }

        @Override
        public boolean makeDropPanel() {
            return true;
        }

        @Override
        public boolean dropOk(Object object) {
            return object instanceof DisplayControl;
        }

        @Override
        public void doDrop(Object object) {
            ((DisplayControl)object).setDisplayCategory(this.category);
            this.legend.viewManager.displayControlChanged((DisplayControl)object);
        }

        public void controlVisibilityChanged(boolean toWhat) {
            boolean anyOn = false;
            for (DisplayControl dc : this.displayControls) {
                if (!dc.getDisplayVisibility()) continue;
                anyOn = true;
                break;
            }
            this.visCbx.setSelected(anyOn);
        }

        public void add(DisplayControl control, JComponent comp) {
            this.displayControls.add(control);
            super.add(comp);
        }

        public boolean containsDisplayControl(DisplayControl control) {
            return this.displayControls.contains(control);
        }

        @Override
        public void reInitialize() {
            super.reInitialize();
            this.displayControls = new ArrayList();
        }

        @Override
        public void clear() {
            this.displayControls = new ArrayList();
        }

        private void setDisplayVisiblity(boolean on) {
            Boolean dflt = on ? Boolean.TRUE : Boolean.FALSE;
            for (int i = this.displayControls.size() - 1; i >= 0; --i) {
                DisplayControl control = (DisplayControl)this.displayControls.get(i);
                Boolean lastVisibility = (Boolean)this.previousVisibilities.get(control.getUniqueId());
                if (lastVisibility == null) {
                    lastVisibility = dflt;
                }
                control.setDisplayVisibility(on);
            }
        }
    }

    private static class DisplayControlLegendPanel
    extends LegendPanel {
        DisplayControl control;

        public DisplayControlLegendPanel(DisplayControl control, JComponent topLabel, boolean makeBorder, JComponent extraLeft, JComponent extraRight) {
            super(topLabel, makeBorder, extraLeft, extraRight);
            this.control = control;
            this.setInnerVisible(!control.getCollapseLegend());
        }

        @Override
        protected void doMakeContents() {
            super.doMakeContents();
            this.contents = new DragPanel(this.control, this.contents);
        }

        @Override
        protected void setInnerVisible(boolean b) {
            super.setInnerVisible(b);
            if (this.control != null) {
                this.control.setCollapseLegend(!b);
            }
        }
    }
}

