/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.ui.DndTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class SettingsTree
extends DndTree {
    private static ImageIcon settingsIcon;
    private IntegratedDataViewer idv;
    private long lastSettingsTimestamp = -1L;
    private DefaultMutableTreeNode settingsRoot;
    private DefaultTreeModel settingsModel;
    private JScrollPane settingsSP;
    private JCheckBox showAllCbx;
    private JComponent contents;
    private ControlDescriptor lastCD;

    public SettingsTree(IntegratedDataViewer theIdv) {
        this.idv = theIdv;
        this.settingsRoot = new DefaultMutableTreeNode("Settings");
        this.settingsModel = new DefaultTreeModel(this.settingsRoot);
        this.setModel(this.settingsModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                List selected = SettingsTree.this.getSelectedSettings();
                if (selected.size() == 0) {
                    return;
                }
                ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                if (selected.size() == 1) {
                    items.add(GuiUtils.makeMenuItem("Change Name", SettingsTree.this, "changeName", selected.get(0)));
                }
                items.add(GuiUtils.makeMenuItem("Write Selected to Plugin", SettingsTree.this.idv.getPluginManager(), "addObject", selected));
                items.add(GuiUtils.makeMenuItem("Delete Selected Settings", SettingsTree.this, "deleteSettings", selected));
                JPopupMenu popup = GuiUtils.makePopupMenu(items);
                popup.show(SettingsTree.this, e.getX(), e.getY());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                List selected = SettingsTree.this.getSelectedSettings();
                if (GuiUtils.isDeleteEvent(e)) {
                    SettingsTree.this.deleteSettings(selected);
                } else if (e.getKeyCode() == 83 && e.isControlDown() && selected.size() > 0) {
                    SettingsTree.this.idv.getPluginManager().addObject(selected);
                }
            }
        });
        this.setToolTipText("<html>Right click to show popu menu;<br>Control-S to save selected to plugin;<br>Delete key to delete selected settings</html>");
        this.settingsSP = new JScrollPane(this);
        this.showAllCbx = new JCheckBox("Show all", false);
        this.showAllCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SettingsTree.this.lastSettingsTimestamp = -1L;
                SettingsTree.this.updateSettings(SettingsTree.this.lastCD);
            }
        });
        this.contents = GuiUtils.topCenter(GuiUtils.right(this.showAllCbx), this.settingsSP);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(theTree, value, sel, expanded, leaf, row, hasFocus);
                if (leaf) {
                    if (settingsIcon == null) {
                        settingsIcon = GuiUtils.getImageIcon("/auxdata/ui/icons/Settings16.png", this.getClass());
                    }
                    this.setIcon(settingsIcon);
                } else {
                    this.setIcon(null);
                }
                return this;
            }
        };
        this.setCellRenderer(renderer);
        this.updateSettings(this.lastCD);
    }

    public void changeName(DisplaySetting displaySetting) {
        if (displaySetting.changeName(this.idv, null)) {
            this.updateSettings(this.lastCD);
        }
    }

    public void deleteSettings(List selected) {
        this.idv.getResourceManager().removeDisplaySettings(selected);
        this.updateSettings(this.lastCD);
    }

    protected JComponent getContents() {
        return this.contents;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.updateSettings(this.lastCD);
    }

    protected void updateSettings(ControlDescriptor cd) {
        if (this.lastSettingsTimestamp == this.idv.getResourceManager().getDisplaySettingsTimestamp()) {
            if (!this.showAllCbx.isSelected()) {
                if (Misc.equals(this.lastCD, cd)) {
                    return;
                }
            } else {
                return;
            }
        }
        this.lastCD = cd;
        this.lastSettingsTimestamp = this.idv.getResourceManager().getDisplaySettingsTimestamp();
        List<DisplaySetting> settings = this.idv.getResourceManager().getDisplaySettings();
        Hashtable paths = GuiUtils.initializeExpandedPathsBeforeChange(this, this.settingsRoot);
        this.settingsRoot.removeAllChildren();
        for (int i = 0; i < settings.size(); ++i) {
            DisplaySetting setting = settings.get(i);
            if (!this.showAllCbx.isSelected() && (cd == null || !setting.applicableTo(cd))) continue;
            List<String> cats = StringUtil.split(setting.getName(), ">", true, true);
            if (cats.size() == 0) {
                cats.add("");
            }
            DefaultMutableTreeNode parent = this.settingsRoot;
            String catSoFar = "";
            for (int catIdx = 0; catIdx < cats.size() - 1; ++catIdx) {
                String cat = cats.get(catIdx);
                catSoFar = catSoFar.length() == 0 ? cat : catSoFar + ">" + cat;
                DefaultMutableTreeNode nextParent = null;
                for (int nodeIdx = 0; nodeIdx < parent.getChildCount(); ++nodeIdx) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(nodeIdx);
                    if (!child.getUserObject().toString().equals(cat)) continue;
                    nextParent = child;
                    break;
                }
                if (nextParent == null) {
                    nextParent = new DefaultMutableTreeNode(new TwoFacedObject((Object)cat, catSoFar));
                    parent.add(nextParent);
                }
                parent = nextParent;
            }
            String name = cats.get(cats.size() - 1).toString();
            if (setting.getIsLocal()) {
                name = name + " <local>";
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new TwoFacedObject((Object)name, setting));
            parent.add(node);
        }
        this.settingsModel.nodeStructureChanged(this.settingsRoot);
        GuiUtils.expandPathsAfterChange(this, paths, this.settingsRoot);
    }

    protected List getSelectedSettings() {
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<Object> settings = new ArrayList<Object>();
        if (paths == null) {
            return settings;
        }
        for (int i = 0; i < paths.length; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            if (!(node.getUserObject() instanceof TwoFacedObject) || !(((TwoFacedObject)node.getUserObject()).getId() instanceof DisplaySetting)) continue;
            settings.add(((TwoFacedObject)node.getUserObject()).getId());
        }
        return settings;
    }

    @Override
    protected boolean okToDrag(DefaultMutableTreeNode sourceNode) {
        if (!(sourceNode.getUserObject() instanceof TwoFacedObject)) {
            return false;
        }
        TwoFacedObject tfo = (TwoFacedObject)sourceNode.getUserObject();
        return tfo.getId() instanceof DisplaySetting;
    }

    @Override
    protected boolean okToDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
        if (!(destNode.getUserObject() instanceof TwoFacedObject)) {
            return false;
        }
        TwoFacedObject tfo = (TwoFacedObject)destNode.getUserObject();
        return !(tfo.getId() instanceof DisplaySetting);
    }

    @Override
    protected void doDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode destNode) {
        DisplaySetting displaySetting = (DisplaySetting)((TwoFacedObject)sourceNode.getUserObject()).getId();
        String cat = (String)((TwoFacedObject)destNode.getUserObject()).getId();
        String name = displaySetting.getNameWithoutCategory();
        String newName = DisplaySetting.cleanName(cat + ">" + name);
        DisplaySetting existing = this.idv.getResourceManager().findDisplaySetting(newName);
        if (existing != null && existing != displaySetting) {
            if (!GuiUtils.askYesNo("Overwrite Display Setting", "<html>A display setting with the given category & name already exists.<br>Do you want to overwrite it?</html>")) {
                return;
            }
            this.idv.getResourceManager().removeDisplaySetting(existing);
        }
        displaySetting.setName(newName);
        this.idv.getResourceManager().displaySettingChanged(displaySetting);
        this.updateSettings(this.lastCD);
    }
}

