/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ucar.unidata.data.DerivedDataDescriptor;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class ResourceViewer
extends IdvManager {
    private JDialog dialog;
    private JTabbedPane tabbedPane;
    private JCheckBox localOnlyCbx;

    public ResourceViewer(IntegratedDataViewer idv) {
        super(idv);
        this.init();
    }

    private void init() {
        this.tabbedPane = new JTabbedPane();
        this.localOnlyCbx = new JCheckBox("Local Only", false);
        this.localOnlyCbx.setToolTipText("Only show local resources");
        this.localOnlyCbx.addActionListener(GuiUtils.makeActionListener(this, "updateTrees", null));
        JButton listResources = GuiUtils.makeButton("List Sources", this.getIdv().getResourceManager(), "showHtmlView", null);
        JPanel buttons = GuiUtils.leftCenter(this.localOnlyCbx, GuiUtils.wrap(GuiUtils.hbox((Component)GuiUtils.makeButton("Update", this, "updateTrees"), (Component)listResources, 5)));
        this.contents = GuiUtils.inset((Component)GuiUtils.centerBottom(this.tabbedPane, buttons), 3);
        this.updateTrees();
    }

    public void updateTrees() {
        int tabIdx = this.tabbedPane.getSelectedIndex();
        this.tabbedPane.removeAll();
        ArrayList<ResourceTree> trees = new ArrayList<ResourceTree>();
        trees.add(this.makeTree("Favorite Bundles", this.getPersistenceManager().getBundles(0)));
        trees.add(this.makeTree("Formulas", this.getIdv().getJythonManager().getDescriptors()));
        trees.add(this.makeTree("Color Tables", this.getIdv().getColorTableManager().getColorTables()));
        trees.add(this.makeTree("Layout Models", this.getIdv().getStationModelManager().getStationModels()));
        trees.add(this.makeTree("Param Defaults", this.getIdv().getParamDefaultsEditor().getResources()));
        trees.add(this.makeTree("Projections", this.getIdv().getIdvProjectionManager().getProjections()));
        trees.add(this.makeTree("Display Settings", this.getIdv().getResourceManager().getDisplaySettings()));
        for (ResourceTree tree : trees) {
            this.tabbedPane.addTab(tree.label, tree.getContents());
        }
        if (tabIdx >= 0) {
            this.tabbedPane.setSelectedIndex(tabIdx);
        }
        this.tabbedPane.invalidate();
        this.tabbedPane.repaint();
    }

    private ResourceTree makeTree(String label, List objects) {
        ArrayList<CategorizedThing> things = new ArrayList<CategorizedThing>();
        boolean localOnly = this.localOnlyCbx.isSelected();
        for (Object o : objects) {
            CategorizedThing thing = this.makeThing(o);
            if (localOnly) {
                if (thing.state == 1) continue;
            }
            if (thing == null) continue;
            things.add(thing);
        }
        return new ResourceTree(label, things);
    }

    private CategorizedThing makeThing(Object o) {
        if (o instanceof ResourceWrapper) {
            ResourceWrapper rw = (ResourceWrapper)o;
            return new CategorizedThing(o, rw.name, (List<String>)rw.categories, rw.local);
        }
        if (o instanceof SavedBundle) {
            SavedBundle b = (SavedBundle)o;
            return new CategorizedThing(o, b.getName(), (List<String>)b.getCategories(), b.getLocal());
        }
        if (o instanceof DisplaySetting) {
            DisplaySetting ds = (DisplaySetting)o;
            String cat = ds.getCategory();
            return new CategorizedThing(o, ds.getNameWithoutCategory(), cat != null ? StringUtil.split(cat, ">", true, true) : null, ds.getIsLocal());
        }
        if (o instanceof StationModel) {
            StationModel sm = (StationModel)o;
            boolean isLocal = this.getIdv().getStationModelManager().isUsers(sm);
            List<String> toks = StringUtil.split(sm.getName(), ">", true, true);
            String name = toks.get(toks.size() - 1);
            toks.remove(toks.size() - 1);
            return new CategorizedThing(o, name, toks, isLocal);
        }
        if (o instanceof ColorTable) {
            ColorTable ct = (ColorTable)o;
            boolean local = this.getIdv().getColorTableManager().isUsers(ct);
            return new CategorizedThing(o, ct.getName(), StringUtil.split(ct.getCategory(), ">", true, true), local);
        }
        if (o instanceof DerivedDataDescriptor) {
            DerivedDataDescriptor dds = (DerivedDataDescriptor)o;
            String cat = null;
            if (dds.getDisplayCategory() != null) {
                cat = "" + dds.getDisplayCategory();
            }
            return new CategorizedThing(o, dds.getDescription(), (List<String>)(cat != null ? Misc.newList(cat) : null), dds.getIsLocalUsers());
        }
        if (o instanceof ProjectionImpl) {
            ProjectionImpl p = (ProjectionImpl)o;
            List<String> names = StringUtil.split(p.getName(), ">", true, true);
            List<String> cats = null;
            String name = "";
            if (names.size() > 0) {
                name = names.get(names.size() - 1);
                names.remove(names.size() - 1);
                if (names.size() > 0) {
                    cats = names;
                }
            }
            return new CategorizedThing(o, name, cats);
        }
        return new CategorizedThing(o, o.toString(), null);
    }

    @Override
    public String getWindowTitle() {
        return GuiUtils.getApplicationTitle() + "Resource Viewer";
    }

    public class ResourceTree {
        String label;
        JTree tree;
        List<CategorizedThing> resources;
        JComponent contents;
        DefaultTreeModel treeModel;
        DefaultMutableTreeNode treeRoot;

        public ResourceTree(String label, List<CategorizedThing> resources) {
            this.label = label;
            this.resources = resources;
            this.treeRoot = new DefaultMutableTreeNode("");
            this.treeModel = new DefaultTreeModel(this.treeRoot);
            this.tree = new JTree(this.treeModel);
            this.tree.setRootVisible(false);
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.setShowsRootHandles(true);
            JScrollPane sp = new JScrollPane(this.tree);
            JButton button = GuiUtils.makeImageButton("/auxdata/ui/icons/Plus.gif", this, "addObjectsToPluginCreator");
            button.setToolTipText("Add Selected to Plugin Creator");
            JPanel buttons = GuiUtils.wrap(button);
            this.contents = GuiUtils.leftCenter(GuiUtils.inset((Component)GuiUtils.top(buttons), 3), sp);
            this.updateTree();
        }

        public boolean hasResources() {
            return this.resources.size() > 0;
        }

        public void updateTree() {
            this.treeRoot.removeAllChildren();
            Hashtable<String, DefaultMutableTreeNode> nodes = new Hashtable<String, DefaultMutableTreeNode>();
            if (this.resources.size() == 0) {
                this.treeRoot.add(new DefaultMutableTreeNode("None"));
            }
            for (CategorizedThing thing : this.resources) {
                DefaultMutableTreeNode parent = this.treeRoot;
                if (thing.hasCategory()) {
                    String catString = "";
                    for (String cat : thing.categories) {
                        DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)nodes.get(catString = catString + ">" + cat);
                        if (tmp == null) {
                            DefaultMutableTreeNode child;
                            tmp = new DefaultMutableTreeNode(cat);
                            nodes.put(catString, tmp);
                            int idx = 0;
                            for (idx = 0; idx < parent.getChildCount() && !((child = (DefaultMutableTreeNode)parent.getChildAt(idx)).getUserObject() instanceof TwoFacedObject); ++idx) {
                            }
                            parent.insert(tmp, idx);
                        }
                        parent = tmp;
                    }
                }
                String label = GuiUtils.getLocalName(thing.name, thing.isLocal(), true);
                parent.add(new DefaultMutableTreeNode(new TwoFacedObject((Object)label, thing)));
            }
            this.treeModel.nodeStructureChanged(this.treeRoot);
        }

        public JComponent getContents() {
            return this.contents;
        }

        public List getSelectedObjects() {
            TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
            ArrayList<Object> objects = new ArrayList<Object>();
            if (paths == null) {
                return objects;
            }
            for (int i = 0; i < paths.length; ++i) {
                Object object;
                Object last = paths[i].getLastPathComponent();
                if (last == null || (object = ((DefaultMutableTreeNode)last).getUserObject()) == null || !(object instanceof TwoFacedObject)) continue;
                CategorizedThing thing = (CategorizedThing)((TwoFacedObject)object).getId();
                objects.add(thing.thing);
            }
            return objects;
        }

        public void addObjectsToPluginCreator() {
            ResourceViewer.this.getIdv().getPluginManager().addObjects(this.getSelectedObjects());
        }
    }

    private static class CategorizedThing {
        public static final int STATE_LOCAL = 0;
        public static final int STATE_SYSTEM = 1;
        public static final int STATE_UNKNOWN = 2;
        String name;
        List<String> categories;
        Object thing;
        int state = 2;

        public CategorizedThing(Object thing, String name, List<String> categories) {
            this(thing, name, categories, 2);
        }

        public CategorizedThing(Object thing, String name, List<String> categories, boolean local) {
            this(thing, name, categories, local ? 0 : 1);
        }

        public CategorizedThing(Object thing, String name, List<String> categories, int state) {
            this.thing = thing;
            this.name = name;
            this.categories = categories;
            this.state = state;
        }

        public boolean isLocal() {
            return this.state == 0;
        }

        public boolean hasCategory() {
            return this.categories != null && this.categories.size() > 0;
        }
    }

    public static class ResourceWrapper {
        boolean local;
        List categories;
        String name;
        Object object;

        public ResourceWrapper(Object o, String name, String category, boolean local) {
            this.categories = category != null ? StringUtil.split(category, ">", true, true) : null;
            this.local = local;
            this.name = name;
            this.object = o;
        }
    }
}

