/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DataSourceHistory;
import ucar.unidata.idv.History;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.SavedBundle;
import ucar.unidata.ui.ButtonTabbedPane;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;

public abstract class QuicklinkPanel
extends JEditorPane
implements HyperlinkListener {
    private static final List editors = new ArrayList();
    private IntegratedDataViewer idv;
    JLabel label = new JLabel(" ");
    private Hashtable map = new Hashtable();
    private boolean amLoading = false;
    private String name;
    private int objectCnt = 0;
    protected Hashtable showMap = new Hashtable();

    public QuicklinkPanel(IntegratedDataViewer idv, String name) {
        this.idv = idv;
        this.name = name;
        this.setEditable(false);
        this.setContentType("text/html");
        this.addHyperlinkListener(this);
        editors.add(this);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Font f = GuiUtils.getDefaultFont();
        if (f != null) {
            this.setFont(f);
        }
    }

    public static void updateQuicklinks() {
        QuicklinkPanel.updateQuicklinks(editors);
    }

    public static void updateQuicklinks(List panels) {
        for (int i = 0; i < panels.size(); ++i) {
            ((QuicklinkPanel)panels.get(i)).doUpdate();
        }
    }

    public static void updateHistoryLinks() {
        for (int i = 0; i < editors.size(); ++i) {
            QuicklinkPanel editor = (QuicklinkPanel)editors.get(i);
            if (!(editor instanceof FileHistory)) continue;
            editor.doUpdate();
        }
    }

    public static JComponent createQuicklinksFromResources(IntegratedDataViewer idv) {
        int i;
        ArrayList<QuicklinkPanel> myEditors = new ArrayList<QuicklinkPanel>();
        ButtonTabbedPane tab = new ButtonTabbedPane(-1);
        String tabPrefix = "<html><body style=\"margin-top:5;margin-bottom:2;\">";
        String tabSuffix = "</body></html>";
        tabPrefix = "";
        tabSuffix = "";
        IdvResourceManager idvResourceManager = idv.getResourceManager();
        idv.getResourceManager();
        ResourceCollection rc = idvResourceManager.getResources(IdvResourceManager.RSC_QUICKLINKS);
        for (i = 0; i < rc.size(); ++i) {
            String resourcePath = (String)rc.get(i);
            if (resourcePath.endsWith(".class")) {
                Component comp = QuicklinkPanel.loadClass(resourcePath, idv);
                if (comp == null) continue;
                tab.add(comp.toString(), comp);
                continue;
            }
            String contents = rc.read(i);
            if (contents == null) continue;
            String name = StringUtil.findPattern(contents, "<tabtitle>(.*)</tabtitle>");
            name = name == null ? IOUtil.stripExtension(IOUtil.getFileTail((String)rc.get(i))) : StringUtil.stripTags(name);
            myEditors.add(new Html(idv, name, "", contents));
        }
        if (idv.getProperty("idv.quicklinks.show", true)) {
            if (idv.getProperty("idv.quicklinks.favorites.show", true)) {
                myEditors.add(new Bundle(idv, "Favorite Bundles", 0));
            }
            if (idv.getProperty("idv.quicklinks.datasources.show", true)) {
                myEditors.add(new Bundle(idv, "Data Favorites", 2));
            }
            if (idv.getProperty("idv.quicklinks.displaytemplates.show", true)) {
                myEditors.add(new Bundle(idv, "Display Templates", 1));
            }
            if (idv.getProperty("idv.quicklinks.history.show", true)) {
                myEditors.add(new FileHistory(idv, "History"));
            }
            if (idv.getProperty("idv.quicklinks.special.show", true)) {
                myEditors.add(new Control(idv, "Special Displays"));
            }
            if (idv.getProperty("idv.quicklinks.windows.show", true)) {
                myEditors.add(new Html(idv, "New Window", "Create New Window", idv.getIdvUIManager().getSkinHtml()));
            }
        }
        for (i = 0; i < myEditors.size(); ++i) {
            QuicklinkPanel editor = (QuicklinkPanel)myEditors.get(i);
            tab.addTab(editor.getName(), (Component)editor.getContents());
        }
        QuicklinkPanel.updateQuicklinks(myEditors);
        if (myEditors.size() > 0) {
            tab.setSelectedIndex(0);
        }
        return tab;
    }

    private static Component loadClass(String path, IntegratedDataViewer idv) {
        try {
            path = StringUtil.replace(path, ".class", "");
            Class c = Misc.findClass(path);
            Constructor ctor = Misc.findConstructor(c, new Class[]{idv.getClass()});
            Object o = ctor != null ? ctor.newInstance(idv) : c.newInstance();
            if (o instanceof Component) {
                return (Component)o;
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Loading class:" + path, exc);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IntegratedDataViewer getIdv() {
        return this.idv;
    }

    public JComponent getContents() {
        return GuiUtils.centerBottom(this.getScroller(), this.label);
    }

    public void logException(String msg, Exception exc) {
        LogUtil.logException(msg, exc);
    }

    public void showWaitCursor() {
        this.idv.getIdvUIManager().showWaitCursor();
    }

    public void showNormalCursor() {
        this.idv.getIdvUIManager().showNormalCursor();
    }

    protected JScrollPane getScroller() {
        int width = 400;
        int height = 400;
        this.setMinimumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
        JScrollPane scroller = GuiUtils.makeScrollPane(this, width, height);
        scroller.setPreferredSize(new Dimension(width, height));
        scroller.setMinimumSize(new Dimension(width, height));
        return scroller;
    }

    public void doUpdate() {
        this.map = new Hashtable();
        this.setText(this.getHtml());
    }

    protected String registerObject(Object object, String command) {
        String id = "qobject:" + command + ":" + this.objectCnt++;
        this.map.put(id, object);
        return id;
    }

    protected String getMouseOverString(String id) {
        return "Load";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        final String id = e.getDescription();
        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.label.setText(this.getMouseOverString(id));
        }
        if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
            this.label.setText(" ");
        }
        if (this.amLoading || e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        Misc.run(new Runnable(){

            @Override
            public void run() {
                QuicklinkPanel.this.amLoading = true;
                QuicklinkPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                QuicklinkPanel.this.setEnabled(false);
                try {
                    QuicklinkPanel.this.handleHyperLink(id);
                }
                catch (Exception exc) {
                    QuicklinkPanel.this.logException("Handling link:" + id, exc);
                }
                QuicklinkPanel.this.setCursor(Cursor.getDefaultCursor());
                QuicklinkPanel.this.setEnabled(true);
                QuicklinkPanel.this.amLoading = false;
            }
        });
    }

    protected String getHeader(String header) {
        return "<b>" + header + "</b><hr>";
    }

    protected boolean isOpen(String cat) {
        cat = cat.replace(">", "&gt;");
        return Misc.equals(this.showMap.get(cat), "open");
    }

    protected void handleHyperLink(String id) {
        if (id.startsWith("toggle:")) {
            String category = id.substring(7);
            if (this.isOpen(category = category.replace(">", "&gt;"))) {
                this.showMap.put(category, "closed");
            } else {
                this.showMap.put(category, "open");
            }
            this.doUpdate();
            return;
        }
        if (id.startsWith("qobject:")) {
            List<String> tokens = StringUtil.split(id, ":");
            if (tokens.size() != 3) {
                return;
            }
            final Object object = this.map.get(id);
            final String command = tokens.get(1);
            this.label.setText(" ");
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    QuicklinkPanel.this.objectClicked(command, object);
                    QuicklinkPanel.this.label.setText(" ");
                }
            });
            return;
        }
        if (this.getIdv().handleAction(id, null)) {
            return;
        }
        if (id.startsWith("jython:")) {
            this.getIdv().handleAction(id, null);
            return;
        }
        if (id.startsWith("http:")) {
            try {
                String html = IOUtil.readContents(id, this.getClass());
                GuiUtils.showHtmlDialog(html, null);
            }
            catch (Exception exc) {
                this.logException("Error loading html:" + id, exc);
            }
            return;
        }
    }

    protected abstract String getHtml();

    public abstract void objectClicked(String var1, Object var2);

    public static class Html
    extends QuicklinkPanel {
        String html;
        String mouseOverString;

        public Html(IntegratedDataViewer idv, String name, String mouseOverString, String html) {
            super(idv, name);
            this.html = html;
            this.mouseOverString = mouseOverString;
        }

        @Override
        protected String getHtml() {
            return this.html;
        }

        @Override
        public void objectClicked(String command, Object object) {
        }

        @Override
        protected String getMouseOverString(String id) {
            return this.mouseOverString;
        }
    }

    public static class Control
    extends QuicklinkPanel {
        public Control(IntegratedDataViewer idv, String name) {
            super(idv, name);
        }

        @Override
        protected String getHtml() {
            StringBuffer sb;
            String cat;
            StringBuffer html = new StringBuffer("<html><body>" + this.getHeader("Special Displays"));
            List controlDescriptors = this.getIdv().getIdvUIManager().getStandAloneControlDescriptors();
            ArrayList<String> cats = new ArrayList<String>();
            Hashtable<String, StringBuffer> catMap = new Hashtable<String, StringBuffer>();
            for (int i = 0; i < controlDescriptors.size(); ++i) {
                ControlDescriptor cd = (ControlDescriptor)controlDescriptors.get(i);
                cat = cd.getDisplayCategory();
                sb = (StringBuffer)catMap.get(cat);
                if (sb == null) {
                    sb = new StringBuffer();
                    catMap.put(cat, sb);
                    cats.add(cat);
                }
                String id = this.registerObject(cd, "control");
                String name = cd.getLabel().trim();
                sb.append("<li style=\"margin-top:5;margin-left:0\"> <a href=\"" + id + "\"> " + cd.getLabel() + "</a>");
            }
            int colCnt = 0;
            for (int i = 0; i < cats.size(); ++i) {
                cat = (String)cats.get(i);
                sb = (StringBuffer)catMap.get(cat);
                if (colCnt == 0 || colCnt == 2) {
                    // empty if block
                }
                ++colCnt;
                html.append("<b>&nbsp;&nbsp;&nbsp;&nbsp;" + cat + "</b>" + sb);
            }
            html.append("</body></html>");
            return html.toString();
        }

        @Override
        public void objectClicked(String command, Object object) {
            this.getIdv().doMakeControl(new ArrayList(), (ControlDescriptor)object);
        }
    }

    public static class FileHistory
    extends QuicklinkPanel {
        public FileHistory(IntegratedDataViewer idv, String name) {
            super(idv, name);
        }

        @Override
        protected String getHtml() {
            StringBuffer html = new StringBuffer("<html><body>");
            List histories = this.getIdv().getHistory();
            if (histories.size() == 0) {
                html.append(this.getHeader("No History"));
            } else {
                html.append(this.getHeader("History"));
            }
            StringBuffer dataSourceHtml = new StringBuffer();
            StringBuffer bundleHtml = new StringBuffer();
            for (int i = 0; i < histories.size(); ++i) {
                History history = (History)histories.get(i);
                String id = this.registerObject(history, "history");
                if (history instanceof ucar.unidata.idv.FileHistory) {
                    bundleHtml.append("<li style=\"margin-top:5;\"> <a href=\"" + id + "\"> " + history.getName() + "</a>\n");
                    continue;
                }
                if (!(history instanceof DataSourceHistory)) continue;
                dataSourceHtml.append("<li style=\"margin-top:5;\"> <a href=\"" + id + "\"> " + history.getName() + "</a>\n");
            }
            if (dataSourceHtml.length() > 0) {
                html.append("<b>Data Sources:</b><ul style=\"margin-top:0;\">");
                html.append(dataSourceHtml.toString());
                html.append("</ul>");
            }
            if (bundleHtml.length() > 0) {
                html.append("<p><b>Bundles:</b><ul style=\"margin-top:0;\">");
                html.append(bundleHtml.toString());
                html.append("</ul>");
            }
            html.append("</body></html>");
            return html.toString();
        }

        @Override
        public void objectClicked(String command, Object object) {
            History history = (History)object;
            this.showWaitCursor();
            LogUtil.message("Loading: " + history);
            if (history.process(this.getIdv())) {
                this.getIdv().getIdvUIManager().showDataSelector();
            }
            LogUtil.message(" ");
            this.showNormalCursor();
        }
    }

    public static class Bundle
    extends QuicklinkPanel {
        int type;
        String typeName;

        public Bundle(IntegratedDataViewer idv, String name, int type) {
            super(idv, name);
            this.type = type;
            this.typeName = name.toLowerCase();
            if (this.typeName.endsWith("s")) {
                this.typeName = this.typeName.substring(0, this.typeName.length() - 1);
            }
        }

        public void showManageDialog() {
            this.getIdv().getIdvUIManager().showBundleDialog(this.type);
        }

        @Override
        public JComponent getContents() {
            ArrayList<JButton> buttons = new ArrayList<JButton>();
            buttons.add(GuiUtils.makeButton("Manage...", this, "showManageDialog", null, "Show the saved bundle manager"));
            JPanel buttonPanel = GuiUtils.hbox(buttons, 5);
            Component top = null;
            JPanel bottom = GuiUtils.leftCenter(buttonPanel, this.label);
            return GuiUtils.topCenterBottom(top, this.getScroller(), bottom);
        }

        @Override
        protected String getMouseOverString(String id) {
            if (id.equals("manage")) {
                return "Manage the " + this.getIdv().getPersistenceManager().getBundleTitle(this.type).toLowerCase();
            }
            if (id.equals("save")) {
                return "Save the current state as a favorite";
            }
            return "Load in " + this.typeName.toLowerCase();
        }

        @Override
        protected String getHtml() {
            ArrayList<String> cats = new ArrayList<String>();
            Hashtable<String, StringBuffer> ht = new Hashtable<String, StringBuffer>();
            List<SavedBundle> bundles = this.getIdv().getPersistenceManager().getBundles(this.type);
            StringBuffer html = new StringBuffer("<html><body>");
            html.append(this.getHeader(this.getIdv().getPersistenceManager().getBundleTitle(this.type)));
            if (bundles.size() == 0) {
                html.append("<h2> No Saved " + this.getIdv().getPersistenceManager().getBundleTitle(this.type) + "</h2>");
            }
            int catCnt = 0;
            for (int bundleIdx = 0; bundleIdx < bundles.size(); ++bundleIdx) {
                SavedBundle bundle = bundles.get(bundleIdx);
                List categories = bundle.getCategories();
                String id = this.registerObject(bundle, "bundle");
                if (categories.size() > 0) {
                    String catString = StringUtil.join(" &gt; ", categories);
                    StringBuffer catBuffer = (StringBuffer)ht.get(catString);
                    boolean open = this.isOpen(catString);
                    if (catBuffer == null) {
                        String img = open ? "<img src=\"idvresource:/auxdata/ui/icons/CategoryOpen.gif\" border=\"0\">" : "<img src=\"idvresource:/auxdata/ui/icons/CategoryClosed.gif\" border=\"0\">";
                        catBuffer = new StringBuffer((catCnt > 0 ? "<br>" : "") + "&nbsp;&nbsp;" + "<a href=\"toggle:" + catString + "\">" + img + "</a> " + catString + (open ? "\n<ul style=\"margin-top:0;margin-bottom:0;\">\n" : ""));
                        ++catCnt;
                        ht.put(catString, catBuffer);
                        cats.add(catString);
                    }
                    if (!open) continue;
                    catBuffer.append("<li> <a href=\"" + id + "\"> " + GuiUtils.getLocalName(bundle.toString(), bundle.getLocal(), false) + "</a>\n");
                    continue;
                }
                html.append("<li> <a href=\"" + id + "\"> " + bundle + "</a>\n");
            }
            for (int i = 0; i < cats.size(); ++i) {
                String catString = (String)cats.get(i);
                StringBuffer sb = (StringBuffer)ht.get(catString);
                html.append(sb.toString());
                boolean open = this.isOpen(catString);
                if (!open) continue;
                html.append("</ul>");
            }
            html.append("</body></html>");
            return html.toString();
        }

        @Override
        public void objectClicked(String command, Object object) {
            if (command.startsWith("toggle:")) {
                return;
            }
            if (command.equals("manage")) {
                this.getIdv().getIdvUIManager().showBundleDialog(this.type);
                return;
            }
            if (command.equals("save")) {
                this.getIdv().getPersistenceManager().doSaveAsFavorite();
                return;
            }
            if (!this.getIdv().getPersistenceManager().open((SavedBundle)object, this.type == 0)) {
                return;
            }
            if (this.type != 1) {
                this.getIdv().getIdvUIManager().showDataSelector();
            }
        }
    }
}

