/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelCanvas;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;

public class PlotModelComponent
extends JPanel {
    IntegratedDataViewer idv;
    Object plotModelListener;
    Method method;
    private JButton changeButton;
    private JLabel label;
    StationModel plotModel;
    private boolean addNone = false;

    public PlotModelComponent(IntegratedDataViewer idv, Object plotModelListener, String methodName, StationModel plotModel) {
        this(idv, plotModelListener, methodName, plotModel, false);
    }

    public PlotModelComponent(IntegratedDataViewer idv, Object plotModelListener, String methodName, StationModel plotModel, boolean addNone) {
        this.idv = idv;
        this.addNone = addNone;
        this.setLayout(new BorderLayout());
        this.add(this.makeStationModelWidget());
        this.plotModelListener = plotModelListener;
        this.method = Misc.findMethod(plotModelListener.getClass(), methodName, new Class[]{StationModel.class});
        this.setPlotModel(plotModel);
    }

    private JComponent makeStationModelWidget() {
        JButton editButton = GuiUtils.getImageButton("/ucar/unidata/idv/images/edit.gif", this.getClass());
        editButton.setToolTipText("Show the plot model editor");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        this.label = new JLabel(" ");
        this.changeButton = GuiUtils.getImageButton("/auxdata/ui/icons/DownDown.gif", this.getClass());
        this.changeButton.setToolTipText("Click to change plot model");
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StationModelManager smm = PlotModelComponent.this.idv.getStationModelManager();
                ObjectListener listener = new ObjectListener(null){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Misc.run(new Runnable(){

                            @Override
                            public void run() {
                                PlotModelComponent.this.idv.showWaitCursor();
                                try {
                                    PlotModelComponent.this.plotModel = (StationModel)theObject;
                                    if (PlotModelComponent.this.plotModel != null) {
                                        PlotModelComponent.this.label.setText(PlotModelComponent.this.plotModel.getDisplayName());
                                    }
                                    PlotModelComponent.this.method.invoke(PlotModelComponent.this.plotModelListener, PlotModelComponent.this.plotModel);
                                }
                                catch (Exception exc) {
                                    PlotModelComponent.this.idv.logException("Changing plot model", exc);
                                }
                                PlotModelComponent.this.idv.showNormalCursor();
                            }
                        });
                    }
                };
                List items = StationModelCanvas.makeStationModelMenuItems(smm.getStationModels(), listener, smm);
                items.add(0, "separator");
                if (PlotModelComponent.this.addNone) {
                    items.add(0, GuiUtils.makeMenuItem("None", PlotModelComponent.this, "setNone"));
                }
                items.add(0, GuiUtils.makeMenuItem("Edit", PlotModelComponent.this, "editPlotModel"));
                JPopupMenu popup = GuiUtils.makePopupMenu(items);
                popup.show(PlotModelComponent.this.changeButton, ((PlotModelComponent)PlotModelComponent.this).changeButton.getSize().width / 2, ((PlotModelComponent)PlotModelComponent.this).changeButton.getSize().height);
            }
        });
        return GuiUtils.centerRight(this.label, GuiUtils.inset((Component)this.changeButton, new Insets(0, 4, 0, 0)));
    }

    public void setNone() {
        this.plotModel = null;
        this.label.setText("None");
        try {
            this.method.invoke(this.plotModelListener, this.plotModel);
        }
        catch (Exception exc) {
            this.idv.logException("Clearing plot model", exc);
        }
    }

    public void editPlotModel() {
        if (this.plotModel != null) {
            this.idv.getStationModelManager().show(this.plotModel);
        }
    }

    public StationModel getPlotModel() {
        return this.plotModel;
    }

    public void setPlotModelByName(String name) {
        this.setPlotModel(this.idv.getStationModelManager().getStationModel(name));
    }

    public void setPlotModel(StationModel sm) {
        this.plotModel = sm;
        if (sm != null) {
            this.label.setText(sm.getDisplayName());
        } else {
            this.label.setText("None");
        }
        this.label.repaint();
    }
}

