/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.flythrough.Flythrough;
import ucar.unidata.idv.flythrough.FlythroughPoint;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import ucar.unidata.view.geoloc.NavigatedPanel;
import ucar.visad.ProjectionCoordinateSystem;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.MapProjection;

public class PipPanel
extends NavigatedMapPanel {
    private static final double ZOOM_IN = 1.1;
    private static final double ZOOM_OUT = 0.9;
    private MapViewManager mapViewManager;
    List thePoints = new ArrayList();
    private ProjectionPointImpl deltaFromOrigin;
    private boolean pendingRedraw = false;

    public PipPanel(MapViewManager mapViewManager) {
        this(mapViewManager, null);
    }

    public PipPanel(MapViewManager mapViewManager, List defaultMaps) {
        super(defaultMaps, false);
        this.mapViewManager = mapViewManager;
        this.setProjectionImpl(mapViewManager.getDefaultProjection());
        this.navigatedPanel.setToolTipText("<html>Use arrow keys to scroll.<br>Shift-up: zoom in; Shift-down: zoom out<br>Control-r: reset;<br>Control-p: Use projection from display</html>");
        this.navigatedPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.navigatedPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PipPanel.this.keyPressedInMap(e);
            }
        });
        this.navigatedPanel.zoom(0.9);
        this.navigatedPanel.zoom(0.9);
    }

    @Override
    protected NavigatedPanel doMakeMapPanel() {
        return new MyMapPanel();
    }

    public void keyPressedInMap(KeyEvent e) {
        MapProjection proj;
        if (e.getKeyCode() == 38 && e.isShiftDown()) {
            this.navigatedPanel.zoom(1.1);
        } else if (e.getKeyCode() == 40 && e.isShiftDown()) {
            this.navigatedPanel.zoom(0.9);
        } else if (e.getKeyCode() == 40) {
            this.navigatedPanel.doMoveUp(5.0);
        } else if (e.getKeyCode() == 38) {
            this.navigatedPanel.doMoveDown(5.0);
        } else if (e.getKeyCode() == 37) {
            this.navigatedPanel.doMoveRight(5.0);
        } else if (e.getKeyCode() == 39) {
            this.navigatedPanel.doMoveLeft(5.0);
        } else if (e.getKeyCode() == 82 && e.isControlDown()) {
            this.navigatedPanel.resetZoom();
        } else if (e.getKeyCode() == 80 && e.isControlDown() && (proj = this.mapViewManager.getMainProjection()) instanceof ProjectionCoordinateSystem) {
            this.setProjectionImpl(((ProjectionCoordinateSystem)proj).getProjection());
            this.navigatedPanel.zoom(0.9);
            this.navigatedPanel.zoom(0.9);
        }
    }

    private LatLonPointImpl getPoint(visad.georef.LatLonPoint pt) {
        return new LatLonPointImpl(pt.getLatitude().getValue(), pt.getLongitude().getValue());
    }

    public void resetDrawBounds() throws RemoteException, VisADException {
        if (this.mapViewManager == null) {
            return;
        }
        NavigatedDisplay nav = (NavigatedDisplay)this.mapViewManager.getMaster();
        if (nav == null) {
            return;
        }
        ArrayList<LatLonPointImpl> points = new ArrayList<LatLonPointImpl>();
        points.add(this.getPoint(nav.getEarthLocation(nav.getScreenUpperLeft()).getLatLonPoint()));
        points.add(this.getPoint(nav.getEarthLocation(nav.getScreenUpperRight()).getLatLonPoint()));
        points.add(this.getPoint(nav.getEarthLocation(nav.getScreenLowerRight()).getLatLonPoint()));
        points.add(this.getPoint(nav.getEarthLocation(nav.getScreenLowerLeft()).getLatLonPoint()));
        this.thePoints = points;
        this.redrawInABit();
    }

    public void redrawInABit() {
        if (this.pendingRedraw) {
            return;
        }
        this.pendingRedraw = true;
        Misc.runInABit(100L, this, "doRedraw", null);
    }

    public void doRedraw() {
        if (!this.pendingRedraw) {
            return;
        }
        this.pendingRedraw = false;
        this.redraw();
    }

    @Override
    protected void annotateMap(Graphics2D gNP) {
        FlythroughPoint currentPoint;
        List points = this.thePoints;
        if (points.size() == 0) {
            return;
        }
        ProjectionImpl project = this.getProjection();
        GeneralPath path = new GeneralPath(0, points.size());
        for (int i = 0; i <= points.size(); ++i) {
            LatLonPoint llp = i >= points.size() ? (LatLonPoint)points.get(0) : (LatLonPoint)points.get(i);
            ProjectionPoint ppi = project.latLonToProj(llp, new ProjectionPointImpl());
            if (i == 0) {
                path.moveTo((float)ppi.getX(), (float)ppi.getY());
                continue;
            }
            path.lineTo((float)ppi.getX(), (float)ppi.getY());
        }
        gNP.setColor(Color.red);
        gNP.draw(path);
        Flythrough flythrough = this.mapViewManager.getFlythrough();
        if (flythrough != null && (currentPoint = flythrough.getCurrentPoint()) != null) {
            try {
                Real lat = currentPoint.getEarthLocation().getLatLonPoint().getLatitude();
                Real lon = currentPoint.getEarthLocation().getLatLonPoint().getLongitude();
                ProjectionPoint p = project.latLonToProj(new LatLonPointImpl(lat.getValue(CommonUnit.degree), lon.getValue(CommonUnit.degree)), new ProjectionPointImpl());
                gNP.setColor(Color.blue);
                GeneralPath path2 = new GeneralPath(0, points.size());
                double dx = 4.0;
                double dy = 4.0;
                AffineTransform transform = gNP.getTransform();
                if (transform != null) {
                    double sx = transform.getScaleX();
                    double sy = transform.getScaleX();
                    if (sx != 0.0) {
                        dx /= sx;
                    }
                    if (sy != 0.0) {
                        dy /= sy;
                    }
                }
                path2.moveTo((float)(p.getX() - dx), (float)(p.getY() - dy));
                path2.lineTo((float)(p.getX() + dx), (float)(p.getY() - dy));
                path2.lineTo((float)(p.getX() + dx), (float)(p.getY() + dy));
                path2.lineTo((float)(p.getX() - dx), (float)(p.getY() + dy));
                path2.lineTo((float)(p.getX() - dx), (float)(p.getY() - dy));
                gNP.fill(path2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LatLonPoint screenToLatLon(int x, int y) {
        ProjectionPointImpl point = this.navigatedPanel.getNavigation().screenToWorld(new Point2D.Double(x, y), new ProjectionPointImpl());
        return this.getProjection().projToLatLon(point);
    }

    private class MyMapPanel
    extends NavigatedPanel {
        private MyMapPanel() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || e.isShiftDown()) {
                super.mouseDragged(e);
                return;
            }
            try {
                List points = PipPanel.this.thePoints;
                if (points.size() == 0 || PipPanel.this.deltaFromOrigin == null) {
                    return;
                }
                ProjectionPointImpl current = PipPanel.this.navigatedPanel.getNavigation().screenToWorld(new Point2D.Double(e.getX(), e.getY()), new ProjectionPointImpl());
                ProjectionPointImpl newOrigin = new ProjectionPointImpl(current.getX() - PipPanel.this.deltaFromOrigin.getX(), current.getY() - PipPanel.this.deltaFromOrigin.getY());
                LatLonPoint llp = PipPanel.this.getProjection().projToLatLon(newOrigin);
                EarthLocationTuple el = new EarthLocationTuple(new Real(RealType.Latitude, llp.getLatitude()), new Real(RealType.Longitude, llp.getLongitude()), new Real(RealType.Altitude, 0.0));
                NavigatedDisplay nav = (NavigatedDisplay)PipPanel.this.mapViewManager.getMaster();
                double[] destXY = nav.getSpatialCoordinates(el, null);
                if (!PipPanel.this.mapViewManager.getUseGlobeDisplay()) {
                    nav.moveToScreen(destXY[0], destXY[1], 0, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.requestFocus();
            if (!SwingUtilities.isLeftMouseButton(e) || e.isShiftDown()) {
                super.mousePressed(e);
                return;
            }
            List points = PipPanel.this.thePoints;
            if (points.size() == 0) {
                return;
            }
            ProjectionPointImpl origin = (ProjectionPointImpl)PipPanel.this.getProjection().latLonToProj((LatLonPoint)points.get(0), new ProjectionPointImpl());
            ProjectionPointImpl pt = PipPanel.this.navigatedPanel.getNavigation().screenToWorld(new Point2D.Double(e.getX(), e.getY()), new ProjectionPointImpl());
            PipPanel.this.deltaFromOrigin = new ProjectionPointImpl(pt.getX() - origin.getX(), pt.getY() - origin.getY());
        }
    }
}

