/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import visad.Unit;

public class ParamInfo {
    private String name;
    private String colorTableName;
    private ColorTable colorTable;
    private Range range;
    private ContourInfo contourInfo;
    private Unit displayUnit;

    public ParamInfo() {
    }

    public ParamInfo(ParamInfo other) {
        this(other.name, other.colorTableName, other.range, other.contourInfo, other.displayUnit);
    }

    public ParamInfo(String name, String colorTableName, Range range, ContourInfo ci, Unit displayUnit) {
        this.name = name;
        this.colorTableName = colorTableName;
        this.range = range;
        this.contourInfo = ci;
        this.displayUnit = displayUnit;
    }

    public void initWith(ParamInfo that) {
        this.name = that.name;
        this.colorTableName = that.colorTableName;
        this.range = that.range;
        this.contourInfo = that.contourInfo;
        this.displayUnit = that.displayUnit;
    }

    public boolean hasRange() {
        return this.range != null;
    }

    public boolean hasContourInfo() {
        return this.contourInfo != null;
    }

    public boolean hasDisplayUnit() {
        return this.displayUnit != null;
    }

    public boolean hasColorTableName() {
        return this.colorTableName != null;
    }

    public void setMin(double m) {
        if (this.range == null) {
            this.range = new Range(m, m);
        } else {
            this.range.setMin(m);
        }
    }

    public void setMax(double m) {
        if (this.range == null) {
            this.range = new Range(m, m);
        } else {
            this.range.setMax(m);
        }
    }

    public double getMin() {
        if (this.range != null) {
            return this.range.getMin();
        }
        return 0.0;
    }

    public double getMax() {
        if (this.range != null) {
            return this.range.getMax();
        }
        return 0.0;
    }

    public void setRange(Range value) {
        this.range = new Range(value);
    }

    public Range getRange() {
        return this.range;
    }

    public void setContourInfo(ContourInfo value) {
        this.contourInfo = value == null ? null : new ContourInfo(value);
    }

    public ContourInfo getContourInfo() {
        return this.contourInfo;
    }

    public void setColorTableName(String value) {
        this.colorTableName = value;
    }

    public String getColorTableName() {
        return this.colorTableName;
    }

    public void clearColorTableName() {
        this.colorTableName = null;
    }

    public void clearDisplayUnit() {
        this.displayUnit = null;
    }

    public void clearRange() {
        this.range = null;
    }

    public void clearContourInfo() {
        this.contourInfo = null;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public Unit getDisplayUnit() {
        return this.displayUnit;
    }

    public void setDisplayUnit(Unit newUnit) {
        this.displayUnit = newUnit;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParamInfo)) {
            return false;
        }
        ParamInfo other = (ParamInfo)o;
        boolean ok = true;
        return Misc.equals(this.colorTableName, other.colorTableName) && Misc.equals(this.range, other.range) && Misc.equals(this.displayUnit, other.displayUnit) && Misc.equals(this.contourInfo, other.contourInfo);
    }
}

