/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.data.DataGroup;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Msg;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class ParamGroupsEditor
extends IdvManager
implements ActionListener {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ParamGroupsEditor.class.getName());
    public static final String TAG_PARAM = "param";
    public static final String TAG_PARAMGROUPS = "paramgroups";
    public static final String TAG_PARAMGROUP = "paramgroup";
    private static final String[] columns = new String[]{"Parameter Group", "Description", "Params"};
    XmlResourceCollection resources = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_PARAMGROUPS);
    ArrayList myTables;
    JTabbedPane tableTabbedPane;

    public ParamGroupsEditor(IntegratedDataViewer idv) {
        super(idv);
        if (this.resources.size() == 0) {
            this.contents = GuiUtils.top(new JLabel("No resources defined"));
        } else {
            this.resources.getWritableDocument("<paramgroups/>");
            this.init();
        }
    }

    private void init() {
        this.myTables = new ArrayList();
        this.tableTabbedPane = new JTabbedPane();
        this.tableTabbedPane.setPreferredSize(new Dimension(450, 200));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        fileMenu.add(GuiUtils.makeMenuItem("New Row", this, "addNewRow"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Open", this, "doOpen"));
        fileMenu.add(GuiUtils.makeMenuItem("Import", this, "doImport"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Export to File", this, "doSaveAs"));
        fileMenu.add(GuiUtils.makeMenuItem("Export to Plugin", this, "exportToPlugin"));
        fileMenu.add(GuiUtils.makeMenuItem("Export Selected to Plugin", this, "exportSelectedToPlugin"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Close", this, "close"));
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        helpMenu.add(GuiUtils.makeMenuItem("Parameter Defaults Help", this, "showHelp"));
        JPanel bottom = GuiUtils.wrap(GuiUtils.makeButton("Close", this, "close"));
        this.contents = GuiUtils.topCenterBottom(menuBar, GuiUtils.inset((Component)this.tableTabbedPane, 2), bottom);
        this.setMenuBar(menuBar);
        this.loadResources(this.resources);
    }

    private void loadResources(XmlResourceCollection resources) {
        for (int i = 0; i < resources.size(); ++i) {
            List groups;
            boolean isWritable = resources.isWritableResource(i);
            Element root = resources.getRoot(i);
            if (root != null) {
                groups = DataGroup.readGroups(root, new Hashtable(), false);
            } else {
                if (!isWritable) continue;
                groups = new ArrayList();
            }
            if (groups.size() == 0) {
                // empty if block
            }
            ParamGroupsTable table = new ParamGroupsTable(groups, isWritable);
            table.setAutoCreateRowSorter(true);
            table.getRowSorter().toggleSortOrder(0);
            table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            String editableStr = "";
            if (!isWritable) {
                editableStr = " (" + Msg.msg("non-editable") + ") ";
            }
            JLabel label = new JLabel("<html>" + Msg.msg("Path: ${param1}", resources.get(i) + editableStr) + "</html>");
            JPanel tablePanel = GuiUtils.topCenter(GuiUtils.inset((Component)label, 4), new JScrollPane(table));
            this.tableTabbedPane.add(resources.getShortName(i), tablePanel);
            this.myTables.add(table);
        }
    }

    public void exportSelectedToPlugin() {
        ParamGroupsTable table = this.getCurrentTable();
        List selected = table.getSelectedDataGroupList();
        System.err.println("selected:" + selected);
        if (selected.size() == 0) {
            LogUtil.userMessage("No rows selected");
            return;
        }
        this.getIdv().getPluginManager().addObject(selected);
    }

    public void exportToPlugin() {
        ParamGroupsTable table = this.getCurrentTable();
        List list = table.getDataGroupList();
        if (list.size() == 0) {
            LogUtil.userMessage("No rows selected");
            return;
        }
        this.getIdv().getPluginManager().addObject(list);
    }

    public void addNewRow() {
        if (this.myTables.size() > 0) {
            GuiUtils.showComponentInTabs((ParamGroupsTable)this.myTables.get(0));
            ((ParamGroupsTable)this.myTables.get(0)).addNewRow();
        }
    }

    public List getDataGroups(boolean justFirst) {
        ArrayList infos = new ArrayList();
        for (int i = 0; i < this.myTables.size(); ++i) {
            infos.addAll(((ParamGroupsTable)this.myTables.get(i)).getDataGroupList());
            if (justFirst) break;
        }
        return infos;
    }

    public ParamGroupsTable getCurrentTable() {
        int index = this.tableTabbedPane.getSelectedIndex();
        return (ParamGroupsTable)this.myTables.get(index);
    }

    public void doImport() {
        try {
            String filename = FileManager.getReadFile(FileManager.FILTER_XML);
            if (filename == null) {
                return;
            }
            Element root = XmlUtil.getRoot(IOUtil.readContents(filename));
            if (root == null) {
                return;
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Error importing file", exc);
        }
    }

    public void doOpen() {
        String filename = FileManager.getReadFile(FileManager.FILTER_XML);
        if (filename == null) {
            return;
        }
        this.resources.addResource(filename);
        int index = this.resources.size() - 1;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_CLOSE)) {
            this.close();
        } else if (cmd.equals(GuiUtils.CMD_NEW)) {
            if (this.myTables.size() > 0) {
                ((ParamGroupsTable)this.myTables.get(0)).addNewRow();
            }
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.saveData();
            this.close();
        } else if (cmd.equals(GuiUtils.CMD_HELP)) {
            this.showHelp();
        } else if (cmd.equals(GuiUtils.CMD_SAVEAS)) {
            this.doSaveAs(this.getCurrentTable().getDataGroupList());
        } else if (cmd.equals(GuiUtils.CMD_OPEN)) {
            this.doOpen();
        } else if (cmd.equals(GuiUtils.CMD_IMPORT)) {
            this.doImport();
        }
    }

    public void showHelp() {
        this.getIdv().getIdvUIManager().showHelp("idv.tools.parametergroupseditor");
    }

    @Override
    protected String getWindowTitle() {
        return GuiUtils.getApplicationTitle() + "Parameter Groups Editor";
    }

    public void doSave(List infoList, String filename) {
        try {
            Element root = this.createDom(XmlUtil.makeDocument(), infoList);
            IOUtil.writeFile(filename, XmlUtil.toString(root));
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Error writing file", exc);
        }
    }

    public void doSaveAs() {
        this.doSaveAs(this.getCurrentTable().getDataGroupList());
    }

    public void doSaveAs(List infoList) {
        String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
        if (filename == null) {
            return;
        }
        this.doSave(infoList, filename);
    }

    protected void copyToUsers(DataGroup i) {
        DataGroup copy = new DataGroup(i);
        ParamGroupsTable to = (ParamGroupsTable)this.myTables.get(0);
        to.add(copy);
        this.tableTabbedPane.setSelectedIndex(0);
        to.editRow(copy, true);
    }

    private Element createDom(Document doc, List paramGroups) {
        Element root = doc.createElement(TAG_PARAMGROUPS);
        for (int i = 0; i < paramGroups.size(); ++i) {
            DataGroup dataGroup = (DataGroup)paramGroups.get(i);
            root.appendChild(dataGroup.getElement(doc));
        }
        return root;
    }

    private ParamGroupsTable getFirstTable() {
        return (ParamGroupsTable)this.myTables.get(0);
    }

    private void saveData() {
        Document usersDoc = XmlUtil.makeDocument();
        Element usersRoot = this.createDom(usersDoc, this.getFirstTable().getDataGroupList());
        try {
            this.resources.setWritableDocument(usersDoc, usersRoot);
            this.resources.writeWritable();
            DataGroup.init(this.resources, true);
            this.getIdv().getJythonManager().dataGroupsChanged();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "writing aliases xml", exc);
        }
    }

    public class ParamGroupsTable
    extends JTable {
        List myDataGroups;
        boolean isEditable;
        AbstractTableModel tableModel;

        public ParamGroupsTable(List infos, boolean editable) {
            this.myDataGroups = infos;
            this.isEditable = editable;
            this.tableModel = new AbstractTableModel(){

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public String getColumnName(int col) {
                    return columns[col];
                }

                @Override
                public int getRowCount() {
                    return ParamGroupsTable.this.myDataGroups.size();
                }

                @Override
                public Object getValueAt(int row, int col) {
                    DataGroup dataGroup = ParamGroupsTable.this.getDataGroup(row);
                    if (col == 0) {
                        return dataGroup.getName();
                    }
                    if (col == 1) {
                        return dataGroup.getDescription();
                    }
                    if (col == 2) {
                        return StringUtil.join(", ", dataGroup.getParamSets());
                    }
                    return null;
                }

                @Override
                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                }
            };
            this.setModel(this.tableModel);
            this.initMouseListener();
        }

        public void selectDataGroup(DataGroup info) {
            int index = this.myDataGroups.indexOf(info);
            if (index >= 0) {
                this.getSelectionModel().setSelectionInterval(index, index);
            }
        }

        public List getDataGroupList() {
            return this.myDataGroups;
        }

        public List getSelectedDataGroupList() {
            int[] rows = this.getSelectedRows();
            ArrayList result = new ArrayList();
            for (int i = 0; i < rows.length; ++i) {
                result.add(this.myDataGroups.get(i));
            }
            return result;
        }

        public DataGroup getDataGroup(int row) {
            return (DataGroup)this.myDataGroups.get(row);
        }

        private void addEditComponents(List comps, String name, final JCheckBox cbx, final JComponent comp) {
            cbx.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    GuiUtils.enableTree(comp, cbx.isSelected());
                }
            });
            GuiUtils.enableTree(comp, cbx.isSelected());
            comps.add(GuiUtils.top(GuiUtils.inset((Component)cbx, 5)));
            comps.add(GuiUtils.top(GuiUtils.inset((Component)GuiUtils.rLabel(name), new Insets(8, 0, 0, 0))));
            JPanel right = GuiUtils.inset((Component)comp, new Insets(3, 5, 0, 0));
            comps.add(GuiUtils.topLeft(right));
        }

        public boolean editRow(DataGroup dataGroup) {
            return this.editRow(dataGroup, false);
        }

        public boolean editRow(DataGroup dataGroup, boolean removeOnCancel) {
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            JTextField nameFld = new JTextField(dataGroup.getName());
            JTextField descFld = new JTextField(dataGroup.getDescription());
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            JPanel topPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Name:"), nameFld, GuiUtils.rLabel("Description:"), descFld}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            StringBuffer paramSB = new StringBuffer();
            List paramSets = dataGroup.getParamSets();
            for (int i = 0; i < paramSets.size(); ++i) {
                List params = (List)paramSets.get(i);
                paramSB.append(StringUtil.join(", ", params));
                paramSB.append("\n");
            }
            topPanel = GuiUtils.inset((Component)topPanel, 5);
            comps.add(topPanel);
            final JTextArea paramsFld = new JTextArea(paramSB.toString(), 15, 10);
            paramsFld.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        IdvUIManager.showParamsPopup(paramsFld, e, ",", true);
                    }
                }
            });
            paramsFld.setToolTipText("<html>Enter parameter name<br>Right mouse to add current parameters</html>");
            JScrollPane sp = new JScrollPane(paramsFld, 20, 30);
            comps.add(new JLabel("Parameters - One group per line, comma separated"));
            comps.add(sp);
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            JPanel contents = GuiUtils.doLayout(comps, 1, GuiUtils.WT_Y, GuiUtils.WT_NY);
            contents = GuiUtils.topCenter(topPanel, contents);
            contents = GuiUtils.inset((Component)contents, 5);
            if (!GuiUtils.showOkCancelDialog(null, "Parameter Group", contents, null)) {
                if (removeOnCancel) {
                    this.myDataGroups.remove(dataGroup);
                    this.tableChanged();
                }
                return false;
            }
            dataGroup.setName(nameFld.getText().trim());
            dataGroup.setDescription(descFld.getText().trim());
            List<String> lines = StringUtil.split(paramsFld.getText(), "\n", true, true);
            ArrayList<List<String>> paramList = new ArrayList<List<String>>();
            for (int i = 0; i < lines.size(); ++i) {
                List<String> toks = StringUtil.split(lines.get(i).toString(), ",", true, true);
                if (toks.size() <= 0) continue;
                paramList.add(toks);
            }
            dataGroup.setParamSets(paramList);
            this.repaint();
            ParamGroupsEditor.this.saveData();
            return true;
        }

        protected void errorMsg(String msg) {
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return "Right-click to show popup menu, double click to edit row";
        }

        private void initMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    int origRow = ParamGroupsTable.this.rowAtPoint(e.getPoint());
                    int row = ParamGroupsTable.this.convertRowIndexToModel(origRow);
                    DataGroup dataGroup = ParamGroupsTable.this.getDataGroup(row);
                    if (!SwingUtilities.isRightMouseButton(e)) {
                        if (e.getClickCount() > 1 && dataGroup != null) {
                            if (ParamGroupsTable.this.isEditable) {
                                ParamGroupsTable.this.editRow(dataGroup);
                            } else {
                                ParamGroupsEditor.this.copyToUsers(dataGroup);
                            }
                        }
                        return;
                    }
                    ParamGroupsTable.this.getSelectionModel().setSelectionInterval(origRow, origRow);
                    JPopupMenu popup = new JPopupMenu();
                    ParamGroupsTable.this.makePopupMenu(popup, row);
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            });
        }

        void makePopupMenu(JPopupMenu popup, final int row) {
            DataGroup info = this.getDataGroup(row);
            if (this.isEditable) {
                this.makeEditableMenu(popup, row);
            } else {
                JMenuItem mi = new JMenuItem("Copy Row to Users Defaults");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            ParamGroupsEditor.this.copyToUsers(ParamGroupsTable.this.getDataGroup(row));
                        }
                        catch (Exception exc) {
                            LogUtil.printException(log_, "Copying row: " + row + " to users table.", exc);
                        }
                    }
                });
                popup.add(mi);
            }
            if (info != null) {
                popup.add(GuiUtils.makeMenuItem("Export to Plugin", ParamGroupsEditor.this.getIdv().getPluginManager(), "addObject", info));
            }
        }

        public DataGroup findByName(String name) {
            name = name.trim();
            for (int i = 0; i < this.myDataGroups.size(); ++i) {
                DataGroup dataGroup = (DataGroup)this.myDataGroups.get(i);
                if (!dataGroup.getName().equals(name)) continue;
                return dataGroup;
            }
            return null;
        }

        public void add(DataGroup i) {
            if (!this.myDataGroups.contains(i)) {
                this.myDataGroups.add(i);
            }
            this.tableChanged();
        }

        public void addBeginning(DataGroup i) {
            this.myDataGroups.add(0, i);
            this.tableChanged();
        }

        void makeEditableMenu(JPopupMenu popup, final int row) {
            popup.add(GuiUtils.makeMenuItem("Add New Field", this, "addNewRow"));
            DataGroup dataGroup = this.getDataGroup(row);
            if (dataGroup == null) {
                return;
            }
            popup.add(GuiUtils.makeMenuItem("Edit Settings", this, "editRow", dataGroup));
            JMenuItem mi = new JMenuItem("Delete Parameter Group");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ParamGroupsTable.this.removeRow(row);
                }
            });
            popup.add(mi);
        }

        public void addNewRow() {
            DataGroup dataGroup = new DataGroup("");
            this.myDataGroups.add(dataGroup);
            this.tableChanged();
            this.editRow(dataGroup, true);
        }

        protected void removeRow(int row) {
            if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to delete this parameter group?", "Delete Confirmation")) {
                return;
            }
            this.myDataGroups.remove(row);
            this.tableChanged();
            ParamGroupsEditor.this.saveData();
        }

        public void tableChanged() {
            this.tableModel.fireTableStructureChanged();
        }
    }
}

