/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.ui.ContourInfoDialog;
import ucar.unidata.idv.ui.ParamInfo;
import ucar.unidata.idv.ui.ResourceViewer;
import ucar.unidata.ui.ParamField;
import ucar.unidata.ui.colortable.ColorTableCanvas;
import ucar.unidata.ui.colortable.ColorTableEditor;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.Unit;

public class ParamDefaultsEditor
extends IdvManager
implements ActionListener {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ParamDefaultsEditor.class.getName());
    public static final String TAG_PARAM = "param";
    public static final String TAG_PARAMS = "params";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_COLORTABLE = "table";
    public static final String ATTR_RANGE_MIN = "range_min";
    public static final String ATTR_RANGE_MAX = "range_max";
    public static final String ATTR_CI_INTERVAL = "ci_interval";
    public static final String ATTR_CI_BASE = "ci_base";
    public static final String ATTR_CI_MIN = "ci_min";
    public static final String ATTR_CI_MAX = "ci_max";
    public static final String ATTR_CI_DASH = "ci_dash";
    public static final String ATTR_CI_LABEL = "ci_label";
    public static final String ATTR_CI_WIDTH = "ci_width";
    public static final boolean DFLT_CI_DASH = false;
    public static final boolean DFLT_CI_LABEL = true;
    public static final int DFLT_CI_WIDTH = 1;
    private static final String[] columns = new String[]{"Parameter", "Color table", "Range", "Contours (interval,base,min,max)", "Display unit"};
    XmlResourceCollection resources;
    ArrayList myTables;
    JTabbedPane tableTabbedPane;
    private ColorTableEditor colorTableEditor;
    private List paramInfos = new ArrayList();
    private Hashtable paramToInfo = new Hashtable();

    public ParamDefaultsEditor(IntegratedDataViewer idv) {
        super(idv);
        this.resources = this.getResourceManager().getXmlResources(IdvResourceManager.RSC_PARAMDEFAULTS);
        this.init(this.resources);
        if (this.resources.size() == 0) {
            this.contents = GuiUtils.top(new JLabel("No resources defined"));
        } else {
            this.resources.getWritableDocument("<params/>");
            this.init();
        }
    }

    private void addList(Element root, int i) {
        ArrayList infos;
        boolean isWritable = this.resources.isWritableResource(i);
        if (root != null) {
            infos = this.createParamInfoList(root);
        } else {
            if (!isWritable) {
                return;
            }
            infos = new ArrayList();
        }
        if (infos.size() == 0) {
            // empty if block
        }
        ParamDefaultsTable table = new ParamDefaultsTable(infos, isWritable);
        table.setAutoCreateRowSorter(true);
        table.getRowSorter().toggleSortOrder(0);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        String editableStr = "";
        if (!isWritable) {
            editableStr = " (" + Msg.msg("non-editable") + ") ";
        }
        JLabel label = new JLabel("<html>" + Msg.msg("Path: ${param1}", this.resources.get(i) + editableStr) + "</html>");
        JPanel tablePanel = GuiUtils.topCenter(GuiUtils.inset((Component)label, 4), new JScrollPane(table));
        table.label = this.resources.getShortName(i);
        this.tableTabbedPane.add(this.resources.getShortName(i), tablePanel);
        this.myTables.add(table);
    }

    private void init() {
        this.myTables = new ArrayList();
        this.tableTabbedPane = new JTabbedPane();
        this.tableTabbedPane.setPreferredSize(new Dimension(450, 200));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        fileMenu.add(GuiUtils.makeMenuItem("New Row", this, "addNewRow"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Open", this, "doOpen"));
        fileMenu.add(GuiUtils.makeMenuItem("Import", this, "doImport"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Export to File", this, "doSaveAs"));
        fileMenu.add(GuiUtils.makeMenuItem("Export to Plugin", this, "exportToPlugin"));
        fileMenu.add(GuiUtils.makeMenuItem("Export Selected to Plugin", this, "exportSelectedToPlugin"));
        fileMenu.addSeparator();
        fileMenu.add(GuiUtils.makeMenuItem("Close", this, "doClose"));
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        helpMenu.add(GuiUtils.makeMenuItem("Parameter Defaults Help", this, "showHelp"));
        JPanel bottom = GuiUtils.wrap(GuiUtils.makeButton("Close", this, "doClose"));
        this.contents = GuiUtils.topCenterBottom(menuBar, GuiUtils.inset((Component)this.tableTabbedPane, 2), bottom);
        this.setMenuBar(menuBar);
        this.loadResources(this.resources);
    }

    public void exportSelectedToPlugin() {
        ParamDefaultsTable table = this.getCurrentTable();
        List selected = table.getSelectedParamInfoList();
        if (selected.size() == 0) {
            LogUtil.userMessage("No rows selected");
            return;
        }
        this.getIdv().getPluginManager().addObject(selected);
    }

    public void exportToPlugin() {
        ParamDefaultsTable table = this.getCurrentTable();
        List list = table.getParamInfoList();
        if (list.size() == 0) {
            LogUtil.userMessage("No rows selected");
            return;
        }
        this.getIdv().getPluginManager().addObject(list);
    }

    public void addNewRow() {
        if (this.myTables.size() > 0) {
            GuiUtils.showComponentInTabs((ParamDefaultsTable)this.myTables.get(0));
            ((ParamDefaultsTable)this.myTables.get(0)).addNewRow();
        }
    }

    public List getParamInfos(boolean justFirst) {
        ArrayList infos = new ArrayList();
        for (int i = 0; i < this.myTables.size(); ++i) {
            infos.addAll(((ParamDefaultsTable)this.myTables.get(i)).getParamInfoList());
            if (justFirst) break;
        }
        return infos;
    }

    public List getResources() {
        ArrayList<ResourceViewer.ResourceWrapper> infos = new ArrayList<ResourceViewer.ResourceWrapper>();
        for (int i = 0; i < this.myTables.size(); ++i) {
            ParamDefaultsTable paramDefaultsTable = (ParamDefaultsTable)this.myTables.get(i);
            for (ParamInfo paramInfo : paramDefaultsTable.getParamInfoList()) {
                infos.add(new ResourceViewer.ResourceWrapper(paramInfo, paramInfo.toString(), paramDefaultsTable.label, paramDefaultsTable.isEditable));
            }
        }
        return infos;
    }

    public void loadResources(XmlResourceCollection resources) {
        for (int i = 0; i < resources.size(); ++i) {
            Element root = resources.getRoot(i);
            this.addList(root, i);
        }
    }

    public ParamDefaultsTable getCurrentTable() {
        int index = this.tableTabbedPane.getSelectedIndex();
        return (ParamDefaultsTable)this.myTables.get(index);
    }

    public void doImport() {
        try {
            String filename = FileManager.getReadFile(FileManager.FILTER_XML);
            if (filename == null) {
                return;
            }
            Element root = XmlUtil.getRoot(IOUtil.readContents(filename));
            if (root == null) {
                return;
            }
            List infos = this.createParamInfoList(root);
            ParamDefaultsTable table = this.getCurrentTable();
            table.getParamInfoList().addAll(infos);
            table.tableChanged();
            this.saveData();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Error importing file", exc);
        }
    }

    public void doOpen() {
        String filename = FileManager.getReadFile(FileManager.FILTER_XML);
        if (filename == null) {
            return;
        }
        this.resources.addResource(filename);
        int index = this.resources.size() - 1;
        this.addList(this.resources.getRoot(index), index);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_CLOSE)) {
            this.doClose();
        } else if (cmd.equals(GuiUtils.CMD_NEW)) {
            if (this.myTables.size() > 0) {
                ((ParamDefaultsTable)this.myTables.get(0)).addNewRow();
            }
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.saveData();
            this.doClose();
        } else if (cmd.equals(GuiUtils.CMD_HELP)) {
            this.showHelp();
        } else if (cmd.equals(GuiUtils.CMD_SAVEAS)) {
            this.doSaveAs(this.getCurrentTable().getParamInfoList());
        } else if (cmd.equals(GuiUtils.CMD_OPEN)) {
            this.doOpen();
        } else if (cmd.equals(GuiUtils.CMD_IMPORT)) {
            this.doImport();
        }
    }

    public void showHelp() {
        this.getIdv().getIdvUIManager().showHelp("idv.tools.parameterdefaultseditor");
    }

    public void doClose() {
        if (this.colorTableEditor != null) {
            this.colorTableEditor.setVisible(false);
        }
        super.close();
    }

    @Override
    protected String getWindowTitle() {
        return GuiUtils.getApplicationTitle() + "Parameter Defaults Editor";
    }

    public void doSave(List infoList, String filename) {
        try {
            Element root = this.createDom(XmlUtil.makeDocument(), infoList);
            IOUtil.writeFile(filename, XmlUtil.toString(root));
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Error writing file", exc);
        }
    }

    public void doSaveAs() {
        this.doSaveAs(this.getCurrentTable().getParamInfoList());
    }

    public void doSaveAs(List infoList) {
        String filename = FileManager.getWriteFile(FileManager.FILTER_XML, ".xml");
        if (filename == null) {
            return;
        }
        this.doSave(infoList, filename);
    }

    protected void copyToUsers(ParamInfo i) {
        ParamInfo copy = new ParamInfo(i);
        ParamDefaultsTable to = (ParamDefaultsTable)this.myTables.get(0);
        to.add(copy);
        this.tableTabbedPane.setSelectedIndex(0);
        to.editRow(copy, true);
    }

    private Element createDom(Document doc, List paramInfos) {
        Element root = doc.createElement(TAG_PARAMS);
        for (int i = 0; i < paramInfos.size(); ++i) {
            ParamInfo paramInfo = (ParamInfo)paramInfos.get(i);
            if (paramInfo.getName().trim().length() == 0) continue;
            Element node = doc.createElement(TAG_PARAM);
            node.setAttribute(ATTR_NAME, paramInfo.getName());
            if (paramInfo.hasColorTableName()) {
                node.setAttribute(ATTR_COLORTABLE, paramInfo.getColorTableName());
            }
            if (paramInfo.hasRange()) {
                node.setAttribute(ATTR_RANGE_MIN, "" + paramInfo.getRange().getMin());
                node.setAttribute(ATTR_RANGE_MAX, "" + paramInfo.getRange().getMax());
            }
            if (paramInfo.hasDisplayUnit()) {
                node.setAttribute(ATTR_UNIT, "" + paramInfo.getDisplayUnit());
            }
            if (paramInfo.hasContourInfo()) {
                ContourInfo ci = paramInfo.getContourInfo();
                node.setAttribute(ATTR_CI_INTERVAL, "" + ci.getIntervalString(true));
                node.setAttribute(ATTR_CI_BASE, "" + ci.getBase());
                node.setAttribute(ATTR_CI_MIN, "" + ci.getMin());
                node.setAttribute(ATTR_CI_MAX, "" + ci.getMax());
                if (ci.getDashOn()) {
                    node.setAttribute(ATTR_CI_DASH, "" + ci.getDashOn());
                }
                if (!ci.getIsLabeled()) {
                    node.setAttribute(ATTR_CI_LABEL, "" + ci.getIsLabeled());
                }
                node.setAttribute(ATTR_CI_WIDTH, "" + ci.getLineWidth());
            }
            root.appendChild(node);
        }
        return root;
    }

    public void saveDefaults(DisplayControlImpl displayControl) {
        try {
            List choices = displayControl.getMyDataChoices();
            if (choices.size() != 1) {
                return;
            }
            DataChoice dc = (DataChoice)choices.get(0);
            String name = dc.getName();
            String ctName = displayControl.getColorTable() != null ? displayControl.getColorTable().getName() : null;
            ParamInfo newParamInfo = new ParamInfo(name, ctName, displayControl.getRange(), displayControl.getContourInfo(), displayControl.getDisplayUnit());
            ParamDefaultsTable firstTable = this.getFirstTable();
            if (!firstTable.editRow(newParamInfo, false)) {
                return;
            }
            ParamInfo origParamInfo = firstTable.findByName(dc.getName());
            if (origParamInfo == null) {
                firstTable.addBeginning(newParamInfo);
                firstTable.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                origParamInfo.initWith(newParamInfo);
                firstTable.tableChanged();
                firstTable.selectParamInfo(origParamInfo);
            }
            this.saveData();
            this.show();
            GuiUtils.showComponentInTabs(firstTable);
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "copying defaults", exc);
        }
    }

    private ParamDefaultsTable getFirstTable() {
        return (ParamDefaultsTable)this.myTables.get(0);
    }

    private void saveData() {
        Document usersDoc = XmlUtil.makeDocument();
        Element usersRoot = this.createDom(usersDoc, this.getFirstTable().getParamInfoList());
        try {
            this.resources.setWritableDocument(usersDoc, usersRoot);
            this.resources.writeWritable();
            this.paramInfos = new ArrayList();
            this.paramToInfo = new Hashtable();
            this.init(this.resources);
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "writing aliases xml", exc);
        }
    }

    private void loadParamDefaults(Element root, boolean overwriteOk) {
        List listOfInfos = this.createParamInfoList(root);
        for (int i = 0; i < listOfInfos.size(); ++i) {
            ParamInfo newParamInfo = (ParamInfo)listOfInfos.get(i);
            String paramName = newParamInfo.getName();
            if (!overwriteOk && this.paramToInfo.get(paramName) != null) continue;
            ParamInfo oldParamInfo = (ParamInfo)this.paramToInfo.get(paramName);
            if (oldParamInfo == null) {
                this.paramToInfo.put(paramName, newParamInfo);
                this.paramInfos.add(newParamInfo);
                continue;
            }
            if (!oldParamInfo.hasColorTableName()) {
                oldParamInfo.setColorTableName(newParamInfo.getColorTableName());
            }
            if (oldParamInfo.hasRange()) continue;
            oldParamInfo.setRange(newParamInfo.getRange());
        }
    }

    private List createParamInfoList(Element root) {
        ArrayList<ParamInfo> infos = new ArrayList<ParamInfo>();
        if (!root.getTagName().equals(TAG_PARAMS)) {
            try {
                Object obj = this.getIdv().getEncoderForRead().toObject(root);
                if (obj instanceof List) {
                    infos.addAll((List)obj);
                } else {
                    System.err.println("Unknown object type: " + obj.getClass().getName());
                }
            }
            catch (Exception exc) {
                System.err.println("Error reading param defaults");
            }
            return infos;
        }
        List nodes = XmlUtil.findChildren(root, TAG_PARAM);
        for (int i = 0; i < nodes.size(); ++i) {
            Element child = (Element)nodes.get(i);
            Range range = null;
            Unit displayUnit = null;
            ContourInfo contourInfo = null;
            String paramName = XmlUtil.getAttribute(child, ATTR_NAME);
            String colorTableName = XmlUtil.getAttribute((Node)child, ATTR_COLORTABLE, (String)null);
            String range_min = XmlUtil.getAttribute((Node)child, ATTR_RANGE_MIN, (String)null);
            String range_max = XmlUtil.getAttribute((Node)child, ATTR_RANGE_MAX, (String)null);
            String unitName = XmlUtil.getAttribute((Node)child, ATTR_UNIT, (String)null);
            String ci_interval = XmlUtil.getAttribute((Node)child, ATTR_CI_INTERVAL, (String)null);
            String ci_base = XmlUtil.getAttribute((Node)child, ATTR_CI_BASE, (String)null);
            String ci_min = XmlUtil.getAttribute((Node)child, ATTR_CI_MIN, range_min);
            String ci_max = XmlUtil.getAttribute((Node)child, ATTR_CI_MAX, range_max);
            boolean ci_dash = XmlUtil.getAttribute((Node)child, ATTR_CI_DASH, false);
            boolean ci_label = XmlUtil.getAttribute((Node)child, ATTR_CI_LABEL, true);
            String ci_width = XmlUtil.getAttribute((Node)child, ATTR_CI_WIDTH, String.valueOf(1));
            if (unitName != null) {
                try {
                    displayUnit = Util.parseUnit(unitName);
                }
                catch (Exception e) {
                    LogUtil.printException(log_, "Creating unit: " + unitName, e);
                }
            }
            if (ci_interval != null || ci_base != null) {
                if (ci_interval == null) {
                    ci_interval = "NaN";
                }
                if (ci_base == null) {
                    ci_base = "NaN";
                }
                if (ci_min == null) {
                    ci_min = "NaN";
                }
                if (ci_max == null) {
                    ci_max = "NaN";
                }
                if (ci_width == null) {
                    ci_width = "1";
                }
                contourInfo = new ContourInfo(ci_interval, Misc.parseDouble(ci_base), Misc.parseDouble(ci_min), Misc.parseDouble(ci_max), ci_label, ci_dash, false, Misc.parseDouble(ci_width));
            }
            if ((ci_dash || !ci_label) && contourInfo == null) {
                contourInfo = new ContourInfo(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
                contourInfo.setIsLabeled(ci_label);
                contourInfo.setDashOn(ci_dash);
            }
            if (range_min != null && range_max != null) {
                range = new Range(Misc.parseDouble(range_min), Misc.parseDouble(range_max));
            }
            ParamInfo paramInfo = new ParamInfo(paramName, colorTableName, range, contourInfo, displayUnit);
            infos.add(paramInfo);
        }
        return infos;
    }

    private void init(XmlResourceCollection resources) {
        try {
            for (int i = 0; i < resources.size(); ++i) {
                Element root = resources.getRoot(i, false);
                if (root == null) continue;
                this.loadParamDefaults(root, false);
            }
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Loading  parameter to color table properties ", exc);
        }
    }

    private ParamInfo getParamInfo(String paramName) {
        String canonicalName;
        if (paramName == null) {
            return null;
        }
        ParamInfo info = (ParamInfo)StringUtil.findMatch(paramName, this.paramInfos, null);
        if (info == null) {
            info = (ParamInfo)StringUtil.findMatch(paramName.toLowerCase(), this.paramInfos, null);
        }
        if (info == null && (canonicalName = DataAlias.aliasToCanonical(paramName)) != null && (info = (ParamInfo)StringUtil.findMatch(canonicalName.toLowerCase(), this.paramInfos, null)) == null) {
            info = (ParamInfo)StringUtil.findMatch(canonicalName, this.paramInfos, null);
        }
        return info;
    }

    private ColorTable getColorTable(String paramName) {
        ParamInfo paramInfo = this.getParamInfo(paramName);
        if (paramInfo != null) {
            return this.getColorTable(paramInfo);
        }
        return null;
    }

    private ColorTable getColorTable(ParamInfo info) {
        if (info.getColorTableName() != null) {
            return this.getIdv().getColorTableManager().getColorTable(info.getColorTableName());
        }
        return null;
    }

    public Range getParamRange(String paramName) {
        ParamInfo paramInfo = this.getParamInfo(paramName);
        return paramInfo != null ? paramInfo.getRange() : null;
    }

    public ContourInfo getParamContourInfo(String paramName) {
        ParamInfo paramInfo = this.getParamInfo(paramName);
        return paramInfo != null ? paramInfo.getContourInfo() : null;
    }

    public Unit getParamDisplayUnit(String paramName) {
        ParamInfo paramInfo = this.getParamInfo(paramName);
        return paramInfo != null ? paramInfo.getDisplayUnit() : null;
    }

    public ColorTable getParamColorTable(String paramName) {
        return this.getParamColorTable(paramName, true);
    }

    public ColorTable getParamColorTable(String paramName, boolean useDefault) {
        ColorTable vc = this.getColorTable(paramName);
        if (vc == null) {
            vc = this.getColorTable(DataAlias.aliasToCanonical(paramName));
        }
        if (vc == null && useDefault) {
            vc = this.getIdv().getColorTableManager().getDefaultColorTable();
        }
        return vc;
    }

    public class ParamDefaultsTable
    extends JTable {
        String label;
        List myParamInfos;
        boolean isEditable;
        AbstractTableModel tableModel;

        public ParamDefaultsTable(List infos, boolean editable) {
            this.myParamInfos = infos;
            this.isEditable = editable;
            this.tableModel = new AbstractTableModel(){

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public String getColumnName(int col) {
                    return columns[col];
                }

                @Override
                public int getRowCount() {
                    return ParamDefaultsTable.this.myParamInfos.size();
                }

                @Override
                public Object getValueAt(int row, int col) {
                    ParamInfo paramInfo = ParamDefaultsTable.this.getInfo(row);
                    if (col == 0) {
                        return paramInfo.getName();
                    }
                    if (col == 1) {
                        if (paramInfo.hasColorTableName()) {
                            return paramInfo.getColorTableName();
                        }
                        return "";
                    }
                    if (col == 2) {
                        if (paramInfo.hasRange()) {
                            return paramInfo.getMin() + " - " + paramInfo.getMax();
                        }
                        return "";
                    }
                    if (col == 3) {
                        if (paramInfo.hasContourInfo()) {
                            ContourInfo ci = paramInfo.getContourInfo();
                            return "" + (ci.getIntervalDefined() ? String.valueOf(ci.getInterval()) : ci.getLevelsString()) + ", " + ci.getBase() + ", " + ci.getMin() + ", " + ci.getMax();
                        }
                        return "";
                    }
                    if (col == 4) {
                        if (paramInfo.hasDisplayUnit()) {
                            return paramInfo.getDisplayUnit().toString();
                        }
                        return "";
                    }
                    return null;
                }

                @Override
                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                    ParamInfo paramInfo = ParamDefaultsTable.this.getInfo(rowIndex);
                    if (columnIndex == 0) {
                        paramInfo.setName(aValue.toString());
                    }
                }
            };
            this.setModel(this.tableModel);
            this.initMouseListener();
        }

        public void selectParamInfo(ParamInfo info) {
            int index = this.myParamInfos.indexOf(info);
            if (index >= 0) {
                this.getSelectionModel().setSelectionInterval(index, index);
            }
        }

        public List getParamInfoList() {
            return this.myParamInfos;
        }

        public List getSelectedParamInfoList() {
            int[] rows = this.getSelectedRows();
            ArrayList result = new ArrayList();
            for (int i = 0; i < rows.length; ++i) {
                result.add(this.myParamInfos.get(i));
            }
            return result;
        }

        public ParamInfo getInfo(int row) {
            return (ParamInfo)this.myParamInfos.get(row);
        }

        private void addEditComponents(List comps, String name, final JCheckBox cbx, final JComponent comp) {
            cbx.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    GuiUtils.enableTree(comp, cbx.isSelected());
                }
            });
            GuiUtils.enableTree(comp, cbx.isSelected());
            comps.add(GuiUtils.top(GuiUtils.inset((Component)cbx, 5)));
            comps.add(GuiUtils.top(GuiUtils.inset((Component)GuiUtils.rLabel(name), new Insets(8, 0, 0, 0))));
            JPanel right = GuiUtils.inset((Component)comp, new Insets(3, 5, 0, 0));
            comps.add(GuiUtils.topLeft(right));
        }

        public boolean editRow(ParamInfo paramInfo) {
            return this.editRow(paramInfo, false);
        }

        public boolean editRow(ParamInfo paramInfo, boolean removeOnCancel) {
            ArrayList<Component> comps = new ArrayList<Component>();
            ParamField nameFld = new ParamField(null, true);
            nameFld.setText(paramInfo.getName());
            JPanel topPanel = GuiUtils.hbox(GuiUtils.lLabel("Parameter:  "), nameFld);
            topPanel = GuiUtils.inset((Component)topPanel, 5);
            comps.add(GuiUtils.inset((Component)new JLabel("Defined"), new Insets(5, 0, 0, 0)));
            comps.add(GuiUtils.filler());
            comps.add(GuiUtils.filler());
            final JLabel ctPreviewLbl = new JLabel("");
            final JLabel ctLbl = new JLabel("");
            if (paramInfo.hasColorTableName()) {
                ctLbl.setText(paramInfo.getColorTableName());
                ColorTable ct = ParamDefaultsEditor.this.getIdv().getColorTableManager().getColorTable(paramInfo.getColorTableName());
                if (ct != null) {
                    ctPreviewLbl.setIcon(ColorTableCanvas.getIcon(ct));
                } else {
                    ctPreviewLbl.setIcon(null);
                }
            }
            String cbxLabel = "";
            final ArrayList menus = new ArrayList();
            ParamDefaultsEditor.this.getIdv().getColorTableManager().makeColorTableMenu(new ObjectListener(null){

                @Override
                public void actionPerformed(ActionEvent ae, Object data) {
                    ctLbl.setText(data.toString());
                    ColorTable ct = ParamDefaultsEditor.this.getIdv().getColorTableManager().getColorTable(ctLbl.getText());
                    if (ct != null) {
                        ctPreviewLbl.setIcon(ColorTableCanvas.getIcon(ct));
                    } else {
                        ctPreviewLbl.setIcon(null);
                    }
                }
            }, menus);
            JCheckBox ctUseCbx = new JCheckBox(cbxLabel, paramInfo.hasColorTableName());
            final JButton ctPopup = new JButton("Change");
            ctPopup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GuiUtils.showPopupMenu(menus, ctPopup);
                }
            });
            this.addEditComponents(comps, "Color Table:", ctUseCbx, GuiUtils.hbox((Component)ctPopup, (Component)GuiUtils.vbox(ctLbl, ctPreviewLbl), 5));
            JCheckBox rangeUseCbx = new JCheckBox(cbxLabel, paramInfo.hasRange());
            JTextField minFld = new JTextField("" + paramInfo.getMin(), 4);
            JTextField maxFld = new JTextField("" + paramInfo.getMax(), 4);
            JPanel rangePanel = GuiUtils.hbox((Component)minFld, (Component)maxFld, 5);
            this.addEditComponents(comps, "Range:", rangeUseCbx, rangePanel);
            JCheckBox unitUseCbx = new JCheckBox(cbxLabel, paramInfo.hasDisplayUnit());
            String unitLabel = "";
            Unit unit = null;
            if (paramInfo.hasDisplayUnit()) {
                unit = paramInfo.getDisplayUnit();
            }
            JComboBox unitFld = ParamDefaultsEditor.this.getIdv().getDisplayConventions().makeUnitBox(unit, null);
            this.addEditComponents(comps, "Unit:", unitUseCbx, unitFld);
            ContourInfo ci = paramInfo.getContourInfo();
            JCheckBox contourUseCbx = new JCheckBox(cbxLabel, ci != null);
            if (ci == null) {
                ci = new ContourInfo();
            }
            ContourInfoDialog contDialog = new ContourInfoDialog("Edit Contour Defaults", false, null, false);
            contDialog.setState(ci);
            this.addEditComponents(comps, "Contour:", contourUseCbx, contDialog.getContents());
            GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
            JPanel contents = GuiUtils.doLayout(comps, 3, GuiUtils.WT_NNY, GuiUtils.WT_N);
            contents = GuiUtils.topCenter(topPanel, contents);
            contents = GuiUtils.inset((Component)contents, 5);
            while (true) {
                if (!GuiUtils.showOkCancelDialog(null, "Parameter Defaults", contents, null)) {
                    if (removeOnCancel) {
                        this.myParamInfos.remove(paramInfo);
                        this.tableChanged();
                    }
                    return false;
                }
                String what = "";
                try {
                    if (contourUseCbx.isSelected()) {
                        what = "setting contour defaults";
                        contDialog.doApply();
                        ci.set(contDialog.getInfo());
                        paramInfo.setContourInfo(ci);
                    } else {
                        paramInfo.clearContourInfo();
                    }
                    if (unitUseCbx.isSelected()) {
                        what = "setting display unit";
                        Object selected = unitFld.getSelectedItem();
                        String unitName = TwoFacedObject.getIdString(selected);
                        if (unitName == null || unitName.trim().equals("")) {
                            paramInfo.setDisplayUnit(null);
                        } else {
                            paramInfo.setDisplayUnit(Util.parseUnit(unitName));
                        }
                    } else {
                        paramInfo.setDisplayUnit(null);
                    }
                    if (ctUseCbx.isSelected()) {
                        paramInfo.setColorTableName(ctLbl.getText());
                    } else {
                        paramInfo.clearColorTableName();
                    }
                    if (rangeUseCbx.isSelected()) {
                        what = "setting range";
                        paramInfo.setRange(new Range(Misc.parseNumber(minFld.getText()), Misc.parseNumber(maxFld.getText())));
                    } else {
                        paramInfo.clearRange();
                    }
                    paramInfo.setName(nameFld.getText().trim());
                }
                catch (Exception exc) {
                    this.errorMsg("An error occurred " + what + "\n " + exc.getMessage());
                    continue;
                }
                break;
            }
            this.repaint();
            ParamDefaultsEditor.this.saveData();
            return true;
        }

        protected void viewColorTable(int row) {
            ColorTable ct = ParamDefaultsEditor.this.getColorTable(this.getInfo(row));
            if (ParamDefaultsEditor.this.colorTableEditor == null) {
                ParamDefaultsEditor.this.colorTableEditor = new ColorTableEditor(ParamDefaultsEditor.this.getIdv().getColorTableManager(), ct);
            } else {
                ParamDefaultsEditor.this.colorTableEditor.setColorTable(ct);
            }
            ParamDefaultsEditor.this.colorTableEditor.show();
        }

        protected void errorMsg(String msg) {
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return "Right-click to show popup menu, double click to edit row";
        }

        private void initMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    int origRow = ParamDefaultsTable.this.rowAtPoint(e.getPoint());
                    int row = ParamDefaultsTable.this.convertRowIndexToModel(origRow);
                    ParamInfo paramInfo = ParamDefaultsTable.this.getInfo(row);
                    if (!SwingUtilities.isRightMouseButton(e)) {
                        if (e.getClickCount() > 1 && paramInfo != null) {
                            if (ParamDefaultsTable.this.isEditable) {
                                ParamDefaultsTable.this.editRow(paramInfo);
                            } else {
                                ParamDefaultsEditor.this.copyToUsers(paramInfo);
                            }
                        }
                        return;
                    }
                    ParamDefaultsTable.this.getSelectionModel().setSelectionInterval(origRow, origRow);
                    JPopupMenu popup = new JPopupMenu();
                    ParamDefaultsTable.this.makePopupMenu(popup, row);
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            });
        }

        void makePopupMenu(JPopupMenu popup, final int row) {
            ParamInfo info = this.getInfo(row);
            if (this.isEditable) {
                this.makeEditableMenu(popup, row);
            } else {
                JMenuItem mi = new JMenuItem("Copy Row to Users Defaults");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            ParamDefaultsEditor.this.copyToUsers(ParamDefaultsTable.this.getInfo(row));
                        }
                        catch (Exception exc) {
                            LogUtil.printException(log_, "Copying row: " + row + " to users table.", exc);
                        }
                    }
                });
                popup.add(mi);
            }
            if (info != null) {
                popup.add(GuiUtils.makeMenuItem("Export to Plugin", ParamDefaultsEditor.this.getIdv().getPluginManager(), "addObject", info));
            }
        }

        public ParamInfo findByName(String name) {
            name = name.trim();
            for (int i = 0; i < this.myParamInfos.size(); ++i) {
                ParamInfo paramInfo = (ParamInfo)this.myParamInfos.get(i);
                if (!paramInfo.getName().equals(name)) continue;
                return paramInfo;
            }
            return null;
        }

        public void add(ParamInfo i) {
            if (!this.myParamInfos.contains(i)) {
                this.myParamInfos.add(i);
            }
            this.tableChanged();
        }

        public void addBeginning(ParamInfo i) {
            this.myParamInfos.add(0, i);
            this.tableChanged();
        }

        void makeEditableMenu(JPopupMenu popup, final int row) {
            popup.add(GuiUtils.makeMenuItem("Add New Field", this, "addNewRow"));
            ParamInfo paramInfo = this.getInfo(row);
            if (paramInfo == null) {
                return;
            }
            popup.add(GuiUtils.makeMenuItem("Edit Settings", this, "editRow", paramInfo));
            JMenuItem mi = new JMenuItem("Delete Settings For Parameter");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ParamDefaultsTable.this.removeRow(row);
                }
            });
            popup.add(mi);
        }

        public void addNewRow() {
            ParamInfo paramInfo = new ParamInfo("", null, null, null, null);
            this.myParamInfos.add(paramInfo);
            this.tableChanged();
            this.editRow(paramInfo, true);
        }

        protected void removeRow(int row) {
            if (!GuiUtils.showYesNoDialog(null, "Are you sure you want to delete this row?", "Delete Confirmation")) {
                return;
            }
            this.myParamInfos.remove(row);
            this.tableChanged();
            ParamDefaultsEditor.this.saveData();
        }

        public ArrayList makeCTMenuItems(final int row) {
            ArrayList menus = new ArrayList();
            ParamDefaultsEditor.this.getIdv().getColorTableManager().makeColorTableMenu(new ObjectListener(null){

                @Override
                public void actionPerformed(ActionEvent ae, Object data) {
                    ParamDefaultsTable.this.getInfo(row).setColorTableName(data.toString());
                    ParamDefaultsTable.this.tableChanged();
                }
            }, menus);
            return menus;
        }

        public void tableChanged() {
            this.tableModel.fireTableStructureChanged();
        }

        protected ColorTable getColorTableFromName(String name) {
            ColorTable ct = ParamDefaultsEditor.this.getIdv().getColorTableManager().getColorTable(name);
            if (ct == null) {
                ct = ParamDefaultsEditor.this.getIdv().getColorTableManager().getDefaultColorTable();
            }
            return ct;
        }
    }
}

