/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvPersistenceManager;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.ui.RovingProgress;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;

public class LoadBundleDialog {
    private static final String CMD_CANCELANDREMOVE = "Cancel & Remove";
    private JLabel msgLabel1;
    private JLabel msgLabel2;
    private JDialog dialog;
    private JPanel contents;
    private boolean okToRun = true;
    private RovingProgress progressBar;
    private IdvPersistenceManager persistenceManager;
    private List dataSources = new ArrayList();
    private List displayControls = new ArrayList();
    private boolean removeItems = false;
    private String dialogTitle;

    public LoadBundleDialog(IdvPersistenceManager persistenceManager, String label) {
        this.dialogTitle = label;
        label = null;
        this.persistenceManager = persistenceManager;
        this.msgLabel1 = new JLabel(" ");
        this.msgLabel1.setMinimumSize(new Dimension(250, 20));
        this.msgLabel1.setPreferredSize(new Dimension(250, 20));
        this.msgLabel2 = new JLabel(" ");
        this.msgLabel2.setMinimumSize(new Dimension(250, 20));
        this.msgLabel2.setPreferredSize(new Dimension(250, 20));
        this.progressBar = new RovingProgress();
        this.progressBar.start();
        this.progressBar.setBorder(BorderFactory.createLineBorder(Color.gray));
        JLabel waitLbl = new JLabel(IdvWindow.getWaitIcon());
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoadBundleDialog.this.removeItems = true;
                LoadBundleDialog.this.okToRun = false;
                LoadBundleDialog.this.setMessage("Cancelling load. Please wait...");
                Misc.runInABit(2000L, new Runnable(){

                    @Override
                    public void run() {
                        LoadBundleDialog.this.dispose();
                    }
                });
            }
        };
        String[] cmds = new String[]{GuiUtils.CMD_CANCEL};
        String[] tts = new String[]{"Press to cancel and remove loaded items"};
        JPanel buttonPanel = GuiUtils.makeButtons(buttonListener, cmds, cmds, tts, null);
        GuiUtils.tmpInsets = GuiUtils.INSETS_2;
        JPanel labelComp = GuiUtils.doLayout(new Component[]{new JLabel("Status:"), this.msgLabel1, waitLbl, GuiUtils.filler(), this.msgLabel2, GuiUtils.filler()}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        this.contents = GuiUtils.inset((Component)labelComp, 5);
        if (label != null) {
            this.contents = GuiUtils.topCenter(GuiUtils.cLabel("Loading: " + label), this.contents);
        }
        this.contents = GuiUtils.vbox((Component)this.contents, buttonPanel);
    }

    public void clear() {
        this.dataSources = null;
        this.displayControls = null;
    }

    public void dispose() {
        this.progressBar.stop();
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void setMessage(String msg) {
        this.msgLabel1.setText(msg + " ");
        this.msgLabel2.setText(" ");
    }

    public void setMessage1(String msg) {
        this.msgLabel1.setText(msg + " ");
    }

    public void setMessage2(String msg) {
        this.msgLabel2.setText(msg + " ");
    }

    public void appendMessage(String msg) {
        this.msgLabel1.setText(this.msgLabel1.getText() + msg);
    }

    public boolean okToRun() {
        return this.okToRun;
    }

    public void showDialog() {
        if (this.dialog == null) {
            JFrame parentFrame = this.persistenceManager.getIdv().getIdvUIManager().getFrame();
            this.dialog = new JDialog((Frame)parentFrame, "Loading Bundle");
            if (this.dialogTitle != null) {
                this.dialog.setTitle("Loading Bundle: " + this.dialogTitle);
            }
            this.dialog.getContentPane().add(this.contents);
        }
        this.dialog.pack();
        Point center = GuiUtils.getLocation(null);
        if (this.persistenceManager.getIdv().okToShowWindows()) {
            this.dialog.setLocation(20, 20);
            this.dialog.setVisible(true);
        }
    }

    public void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    public void addDisplayControl(DisplayControl displayControl) {
        this.displayControls.add(displayControl);
    }

    public List getDataSources() {
        return this.dataSources;
    }

    public List getDisplayControls() {
        return this.displayControls;
    }

    public boolean getShouldRemoveItems() {
        return this.removeItems;
    }
}

